/*
  Copyright (C) 2000-2007

  Code contributed by Greg Collecutt, Joseph Hope and the xmds-devel team

  This file is part of xmds.

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
  $Id: xmds_vector_element.h 1507 2007-08-15 09:47:34Z paultcochrane $
*/

/*! @file xmds_vector_element.h
  @brief 

  More detailed explanation...
*/

#ifndef XMDS_VECTOR_ELEMENT_H
#define XMDS_VECTOR_ELEMENT_H

#include <xmds_element.h>
#include <xmds_vector.h>
#include <string>

// *****************************************************************************
// *****************************************************************************
//                              xmdsVectorElement
// *****************************************************************************
// *****************************************************************************

//! xmds vector element class
class xmdsVectorElement :       public xmdsVector,
                                public xmdsElement {

  public :

    //! Constructor for the xmdsVectorElement object
    xmdsVectorElement(
          const xmdsSimulation *const yourSimulation,
          const bool& yourVerboseMode,
          const xmdsField *const yourField);

  //! Destructor
  ~xmdsVectorElement();

  //! Processes an element of an xmds vector element
  void processElement(
                      const Element *const yourElement);

  private :

    XMLString     myFileName;            //!< The input filename of the initialisation vector
  int           myInputFileFormat;     //!< The input file format
  list<XMLString> myVectorNamesList;   //!< The list of vector names
  XMLString     myCode;                //!< The string of code for initialisation of the vector(s)
  string    myInitialisationMomentGroupName;  //!< The moment group number in the XSIL file that will be used for initialisation
  bool      isGeometryMatchingModeStrict;   //!< True if the XSIL input geometry must exactly match the field geometry

  //! Write the initialisation routine to file
  void writeInitialiseRoutine(
                              FILE *const outfile) const;
};


#endif // XMDS_VECTOR_ELEMENT_H
