/*
 *========================================================================
 * $Id: loadavg.c 88 2004-09-28 22:49:38Z rgb $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

#include <wulfware/libwulf.h>

/*
 * <loadavg> tag init and update (same thing)
 */
void init_loadavg(Host *hostptr)
{

 /* 
  * scratch: current timestamp and delta (to microsecond resolution) 
  */
 unsigned long seconds,useconds;

 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: Starting init_loadavg() on %s.  Use -v %d to focus.\n",hostptr->hostname,D_VALUES);
 }

 /* 
  * loadavg - tv_sec and tv_usec timestamps.
  */
 /* <loadavg tv_sec=?> */
 if(xtract_attribute(UNSIGNED_LONG,&seconds,value_xpath[LOADAVG],
                      "tv_sec",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[LOADAVG]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: seconds = %d\n",seconds);
 }
 hostptr->val.loadavg_tv_sec = seconds;

 /* <loadavg tv_usec=?> */
 if(xtract_attribute(UNSIGNED_LONG,&useconds,value_xpath[LOADAVG],
                      "tv_usec",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[LOADAVG]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: useconds = %d\n",useconds);
 }
 hostptr->val.loadavg_tv_usec = useconds;
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: loadavg_tv_sec = %ul loadavg_tv_usec = %ul\n",hostptr->val.loadavg_tv_sec,hostptr->val.loadavg_tv_usec);
 }

 /*
  * Extract all load averages.
  */
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: extracting and filling values for load averages.\n");
 }
 /* load1, load5, load15 */
 if(xtract(DOUBLE,&hostptr->val.load1,value_xpath[LOAD1],hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
      value_xpath[LOAD1]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: load1 = %f\n",hostptr->val.load1);
 }

 if(xtract(DOUBLE,&hostptr->val.load5,value_xpath[LOAD5],hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
       value_xpath[LOAD5]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: load5 = %f\n",hostptr->val.load5);
 }

 if(xtract(DOUBLE,&hostptr->val.load15,value_xpath[LOAD15],hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
       value_xpath[LOAD15]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: load15 = %f\n",hostptr->val.load15);
 }

}


void update_loadavg(Host *hostptr)
{

 /* 
  * scratch: current timestamp and delta (to microsecond resolution) 
  */
 unsigned long seconds,useconds;

 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: Starting update_loadavg() on %s.  Use -v %d to focus.\n",hostptr->hostname,D_VALUES);
 }

 /* 
  * loadavg - tv_sec and tv_usec timestamps.
  */
 /* <loadavg tv_sec=?> */
 if(xtract_attribute(UNSIGNED_LONG,&seconds,value_xpath[LOADAVG],
                      "tv_sec",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[LOADAVG]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: seconds = %d\n",seconds);
 }
 hostptr->val.loadavg_tv_sec = seconds;

 /* <loadavg tv_usec=?> */
 if(xtract_attribute(UNSIGNED_LONG,&useconds,value_xpath[LOADAVG],
                      "tv_usec",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[LOADAVG]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: useconds = %d\n",useconds);
 }
 hostptr->val.loadavg_tv_usec = useconds;
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: loadavg_tv_sec = %ul loadavg_tv_usec = %ul\n",hostptr->val.loadavg_tv_sec,hostptr->val.loadavg_tv_usec);
 }

 /*
  * Extract all load averages.
  */
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: extracting and filling values for load averages.\n");
 }
 /* load1, load5, load15 */
 if(xtract(DOUBLE,&hostptr->val.load1,value_xpath[LOAD1],hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
      value_xpath[LOAD1]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: load1 = %f\n",hostptr->val.load1);
 }

 if(xtract(DOUBLE,&hostptr->val.load5,value_xpath[LOAD5],hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
       value_xpath[LOAD5]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: load5 = %f\n",hostptr->val.load5);
 }

 if(xtract(DOUBLE,&hostptr->val.load15,value_xpath[LOAD15],hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
       value_xpath[LOAD15]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: load15 = %f\n",hostptr->val.load15);
 }

}
