// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_ASSEMBLER_COND_RD_RN_OPERAND_RM_LSLS_A32_H_
#define VIXL_ASSEMBLER_COND_RD_RN_OPERAND_RM_LSLS_A32_H_

const byte kInstruction_lsls_le_r4_r5_r14[] = {
  0x15, 0x4e, 0xb0, 0xd1 // lsls le r4 r5 r14
};
const byte kInstruction_lsls_ge_r5_r11_r10[] = {
  0x1b, 0x5a, 0xb0, 0xa1 // lsls ge r5 r11 r10
};
const byte kInstruction_lsls_ls_r0_r9_r9[] = {
  0x19, 0x09, 0xb0, 0x91 // lsls ls r0 r9 r9
};
const byte kInstruction_lsls_le_r8_r7_r2[] = {
  0x17, 0x82, 0xb0, 0xd1 // lsls le r8 r7 r2
};
const byte kInstruction_lsls_eq_r1_r10_r13[] = {
  0x1a, 0x1d, 0xb0, 0x01 // lsls eq r1 r10 r13
};
const byte kInstruction_lsls_le_r9_r12_r2[] = {
  0x1c, 0x92, 0xb0, 0xd1 // lsls le r9 r12 r2
};
const byte kInstruction_lsls_pl_r6_r1_r5[] = {
  0x11, 0x65, 0xb0, 0x51 // lsls pl r6 r1 r5
};
const byte kInstruction_lsls_ge_r1_r12_r6[] = {
  0x1c, 0x16, 0xb0, 0xa1 // lsls ge r1 r12 r6
};
const byte kInstruction_lsls_cc_r13_r12_r3[] = {
  0x1c, 0xd3, 0xb0, 0x31 // lsls cc r13 r12 r3
};
const byte kInstruction_lsls_gt_r2_r4_r9[] = {
  0x14, 0x29, 0xb0, 0xc1 // lsls gt r2 r4 r9
};
const byte kInstruction_lsls_le_r3_r9_r10[] = {
  0x19, 0x3a, 0xb0, 0xd1 // lsls le r3 r9 r10
};
const byte kInstruction_lsls_gt_r11_r1_r9[] = {
  0x11, 0xb9, 0xb0, 0xc1 // lsls gt r11 r1 r9
};
const byte kInstruction_lsls_cc_r8_r6_r11[] = {
  0x16, 0x8b, 0xb0, 0x31 // lsls cc r8 r6 r11
};
const byte kInstruction_lsls_cs_r12_r9_r3[] = {
  0x19, 0xc3, 0xb0, 0x21 // lsls cs r12 r9 r3
};
const byte kInstruction_lsls_eq_r9_r14_r10[] = {
  0x1e, 0x9a, 0xb0, 0x01 // lsls eq r9 r14 r10
};
const byte kInstruction_lsls_gt_r9_r0_r1[] = {
  0x10, 0x91, 0xb0, 0xc1 // lsls gt r9 r0 r1
};
const byte kInstruction_lsls_pl_r11_r8_r2[] = {
  0x18, 0xb2, 0xb0, 0x51 // lsls pl r11 r8 r2
};
const byte kInstruction_lsls_mi_r7_r1_r2[] = {
  0x11, 0x72, 0xb0, 0x41 // lsls mi r7 r1 r2
};
const byte kInstruction_lsls_vs_r8_r6_r7[] = {
  0x16, 0x87, 0xb0, 0x61 // lsls vs r8 r6 r7
};
const byte kInstruction_lsls_ne_r14_r2_r13[] = {
  0x12, 0xed, 0xb0, 0x11 // lsls ne r14 r2 r13
};
const byte kInstruction_lsls_hi_r3_r3_r8[] = {
  0x13, 0x38, 0xb0, 0x81 // lsls hi r3 r3 r8
};
const byte kInstruction_lsls_vc_r10_r8_r14[] = {
  0x18, 0xae, 0xb0, 0x71 // lsls vc r10 r8 r14
};
const byte kInstruction_lsls_ls_r2_r11_r0[] = {
  0x1b, 0x20, 0xb0, 0x91 // lsls ls r2 r11 r0
};
const byte kInstruction_lsls_ge_r8_r10_r0[] = {
  0x1a, 0x80, 0xb0, 0xa1 // lsls ge r8 r10 r0
};
const byte kInstruction_lsls_mi_r8_r10_r5[] = {
  0x1a, 0x85, 0xb0, 0x41 // lsls mi r8 r10 r5
};
const byte kInstruction_lsls_pl_r1_r0_r9[] = {
  0x10, 0x19, 0xb0, 0x51 // lsls pl r1 r0 r9
};
const byte kInstruction_lsls_gt_r6_r7_r3[] = {
  0x17, 0x63, 0xb0, 0xc1 // lsls gt r6 r7 r3
};
const byte kInstruction_lsls_vs_r7_r9_r9[] = {
  0x19, 0x79, 0xb0, 0x61 // lsls vs r7 r9 r9
};
const byte kInstruction_lsls_al_r9_r4_r2[] = {
  0x14, 0x92, 0xb0, 0xe1 // lsls al r9 r4 r2
};
const byte kInstruction_lsls_le_r3_r1_r2[] = {
  0x11, 0x32, 0xb0, 0xd1 // lsls le r3 r1 r2
};
const byte kInstruction_lsls_mi_r6_r14_r0[] = {
  0x1e, 0x60, 0xb0, 0x41 // lsls mi r6 r14 r0
};
const byte kInstruction_lsls_vc_r7_r10_r11[] = {
  0x1a, 0x7b, 0xb0, 0x71 // lsls vc r7 r10 r11
};
const byte kInstruction_lsls_hi_r13_r2_r10[] = {
  0x12, 0xda, 0xb0, 0x81 // lsls hi r13 r2 r10
};
const byte kInstruction_lsls_cs_r5_r4_r12[] = {
  0x14, 0x5c, 0xb0, 0x21 // lsls cs r5 r4 r12
};
const byte kInstruction_lsls_ls_r13_r9_r11[] = {
  0x19, 0xdb, 0xb0, 0x91 // lsls ls r13 r9 r11
};
const byte kInstruction_lsls_ne_r2_r10_r12[] = {
  0x1a, 0x2c, 0xb0, 0x11 // lsls ne r2 r10 r12
};
const byte kInstruction_lsls_vc_r4_r6_r8[] = {
  0x16, 0x48, 0xb0, 0x71 // lsls vc r4 r6 r8
};
const byte kInstruction_lsls_lt_r13_r0_r13[] = {
  0x10, 0xdd, 0xb0, 0xb1 // lsls lt r13 r0 r13
};
const byte kInstruction_lsls_pl_r11_r14_r5[] = {
  0x1e, 0xb5, 0xb0, 0x51 // lsls pl r11 r14 r5
};
const byte kInstruction_lsls_cs_r8_r11_r3[] = {
  0x1b, 0x83, 0xb0, 0x21 // lsls cs r8 r11 r3
};
const byte kInstruction_lsls_cs_r4_r1_r7[] = {
  0x11, 0x47, 0xb0, 0x21 // lsls cs r4 r1 r7
};
const byte kInstruction_lsls_al_r0_r12_r13[] = {
  0x1c, 0x0d, 0xb0, 0xe1 // lsls al r0 r12 r13
};
const byte kInstruction_lsls_gt_r3_r6_r0[] = {
  0x16, 0x30, 0xb0, 0xc1 // lsls gt r3 r6 r0
};
const byte kInstruction_lsls_vc_r6_r9_r0[] = {
  0x19, 0x60, 0xb0, 0x71 // lsls vc r6 r9 r0
};
const byte kInstruction_lsls_cc_r2_r2_r12[] = {
  0x12, 0x2c, 0xb0, 0x31 // lsls cc r2 r2 r12
};
const byte kInstruction_lsls_cs_r4_r13_r1[] = {
  0x1d, 0x41, 0xb0, 0x21 // lsls cs r4 r13 r1
};
const byte kInstruction_lsls_mi_r12_r12_r10[] = {
  0x1c, 0xca, 0xb0, 0x41 // lsls mi r12 r12 r10
};
const byte kInstruction_lsls_hi_r8_r9_r14[] = {
  0x19, 0x8e, 0xb0, 0x81 // lsls hi r8 r9 r14
};
const byte kInstruction_lsls_hi_r4_r3_r7[] = {
  0x13, 0x47, 0xb0, 0x81 // lsls hi r4 r3 r7
};
const byte kInstruction_lsls_ne_r11_r10_r1[] = {
  0x1a, 0xb1, 0xb0, 0x11 // lsls ne r11 r10 r1
};
const byte kInstruction_lsls_cc_r2_r6_r3[] = {
  0x16, 0x23, 0xb0, 0x31 // lsls cc r2 r6 r3
};
const byte kInstruction_lsls_cs_r6_r6_r0[] = {
  0x16, 0x60, 0xb0, 0x21 // lsls cs r6 r6 r0
};
const byte kInstruction_lsls_vc_r13_r2_r9[] = {
  0x12, 0xd9, 0xb0, 0x71 // lsls vc r13 r2 r9
};
const byte kInstruction_lsls_vc_r7_r13_r14[] = {
  0x1d, 0x7e, 0xb0, 0x71 // lsls vc r7 r13 r14
};
const byte kInstruction_lsls_pl_r11_r14_r4[] = {
  0x1e, 0xb4, 0xb0, 0x51 // lsls pl r11 r14 r4
};
const byte kInstruction_lsls_lt_r12_r14_r8[] = {
  0x1e, 0xc8, 0xb0, 0xb1 // lsls lt r12 r14 r8
};
const byte kInstruction_lsls_cs_r2_r11_r14[] = {
  0x1b, 0x2e, 0xb0, 0x21 // lsls cs r2 r11 r14
};
const byte kInstruction_lsls_le_r12_r13_r2[] = {
  0x1d, 0xc2, 0xb0, 0xd1 // lsls le r12 r13 r2
};
const byte kInstruction_lsls_le_r5_r6_r14[] = {
  0x16, 0x5e, 0xb0, 0xd1 // lsls le r5 r6 r14
};
const byte kInstruction_lsls_vc_r3_r14_r8[] = {
  0x1e, 0x38, 0xb0, 0x71 // lsls vc r3 r14 r8
};
const byte kInstruction_lsls_lt_r7_r6_r14[] = {
  0x16, 0x7e, 0xb0, 0xb1 // lsls lt r7 r6 r14
};
const byte kInstruction_lsls_ls_r0_r13_r12[] = {
  0x1d, 0x0c, 0xb0, 0x91 // lsls ls r0 r13 r12
};
const byte kInstruction_lsls_ge_r10_r9_r14[] = {
  0x19, 0xae, 0xb0, 0xa1 // lsls ge r10 r9 r14
};
const byte kInstruction_lsls_le_r11_r12_r1[] = {
  0x1c, 0xb1, 0xb0, 0xd1 // lsls le r11 r12 r1
};
const byte kInstruction_lsls_al_r2_r12_r14[] = {
  0x1c, 0x2e, 0xb0, 0xe1 // lsls al r2 r12 r14
};
const byte kInstruction_lsls_cs_r6_r4_r0[] = {
  0x14, 0x60, 0xb0, 0x21 // lsls cs r6 r4 r0
};
const byte kInstruction_lsls_vs_r5_r0_r3[] = {
  0x10, 0x53, 0xb0, 0x61 // lsls vs r5 r0 r3
};
const byte kInstruction_lsls_le_r8_r8_r0[] = {
  0x18, 0x80, 0xb0, 0xd1 // lsls le r8 r8 r0
};
const byte kInstruction_lsls_gt_r1_r5_r4[] = {
  0x15, 0x14, 0xb0, 0xc1 // lsls gt r1 r5 r4
};
const byte kInstruction_lsls_le_r4_r3_r4[] = {
  0x13, 0x44, 0xb0, 0xd1 // lsls le r4 r3 r4
};
const byte kInstruction_lsls_pl_r9_r7_r10[] = {
  0x17, 0x9a, 0xb0, 0x51 // lsls pl r9 r7 r10
};
const byte kInstruction_lsls_ls_r8_r7_r14[] = {
  0x17, 0x8e, 0xb0, 0x91 // lsls ls r8 r7 r14
};
const byte kInstruction_lsls_vc_r9_r10_r6[] = {
  0x1a, 0x96, 0xb0, 0x71 // lsls vc r9 r10 r6
};
const byte kInstruction_lsls_hi_r2_r4_r9[] = {
  0x14, 0x29, 0xb0, 0x81 // lsls hi r2 r4 r9
};
const byte kInstruction_lsls_cs_r0_r2_r13[] = {
  0x12, 0x0d, 0xb0, 0x21 // lsls cs r0 r2 r13
};
const byte kInstruction_lsls_vs_r3_r6_r12[] = {
  0x16, 0x3c, 0xb0, 0x61 // lsls vs r3 r6 r12
};
const byte kInstruction_lsls_cc_r14_r14_r7[] = {
  0x1e, 0xe7, 0xb0, 0x31 // lsls cc r14 r14 r7
};
const byte kInstruction_lsls_vc_r10_r6_r4[] = {
  0x16, 0xa4, 0xb0, 0x71 // lsls vc r10 r6 r4
};
const byte kInstruction_lsls_cc_r1_r6_r10[] = {
  0x16, 0x1a, 0xb0, 0x31 // lsls cc r1 r6 r10
};
const byte kInstruction_lsls_vs_r13_r10_r11[] = {
  0x1a, 0xdb, 0xb0, 0x61 // lsls vs r13 r10 r11
};
const byte kInstruction_lsls_ls_r5_r7_r12[] = {
  0x17, 0x5c, 0xb0, 0x91 // lsls ls r5 r7 r12
};
const byte kInstruction_lsls_eq_r6_r4_r3[] = {
  0x14, 0x63, 0xb0, 0x01 // lsls eq r6 r4 r3
};
const byte kInstruction_lsls_mi_r5_r9_r2[] = {
  0x19, 0x52, 0xb0, 0x41 // lsls mi r5 r9 r2
};
const byte kInstruction_lsls_lt_r7_r1_r9[] = {
  0x11, 0x79, 0xb0, 0xb1 // lsls lt r7 r1 r9
};
const byte kInstruction_lsls_ne_r12_r7_r0[] = {
  0x17, 0xc0, 0xb0, 0x11 // lsls ne r12 r7 r0
};
const byte kInstruction_lsls_eq_r0_r6_r7[] = {
  0x16, 0x07, 0xb0, 0x01 // lsls eq r0 r6 r7
};
const byte kInstruction_lsls_pl_r7_r3_r9[] = {
  0x13, 0x79, 0xb0, 0x51 // lsls pl r7 r3 r9
};
const byte kInstruction_lsls_pl_r11_r11_r13[] = {
  0x1b, 0xbd, 0xb0, 0x51 // lsls pl r11 r11 r13
};
const byte kInstruction_lsls_gt_r0_r10_r5[] = {
  0x1a, 0x05, 0xb0, 0xc1 // lsls gt r0 r10 r5
};
const byte kInstruction_lsls_mi_r14_r1_r10[] = {
  0x11, 0xea, 0xb0, 0x41 // lsls mi r14 r1 r10
};
const byte kInstruction_lsls_mi_r5_r14_r0[] = {
  0x1e, 0x50, 0xb0, 0x41 // lsls mi r5 r14 r0
};
const byte kInstruction_lsls_ne_r12_r9_r13[] = {
  0x19, 0xcd, 0xb0, 0x11 // lsls ne r12 r9 r13
};
const byte kInstruction_lsls_hi_r8_r5_r11[] = {
  0x15, 0x8b, 0xb0, 0x81 // lsls hi r8 r5 r11
};
const byte kInstruction_lsls_ls_r7_r0_r5[] = {
  0x10, 0x75, 0xb0, 0x91 // lsls ls r7 r0 r5
};
const byte kInstruction_lsls_lt_r5_r1_r7[] = {
  0x11, 0x57, 0xb0, 0xb1 // lsls lt r5 r1 r7
};
const byte kInstruction_lsls_cc_r2_r8_r4[] = {
  0x18, 0x24, 0xb0, 0x31 // lsls cc r2 r8 r4
};
const byte kInstruction_lsls_lt_r3_r0_r5[] = {
  0x10, 0x35, 0xb0, 0xb1 // lsls lt r3 r0 r5
};
const byte kInstruction_lsls_pl_r4_r9_r7[] = {
  0x19, 0x47, 0xb0, 0x51 // lsls pl r4 r9 r7
};
const byte kInstruction_lsls_eq_r13_r8_r10[] = {
  0x18, 0xda, 0xb0, 0x01 // lsls eq r13 r8 r10
};
const byte kInstruction_lsls_ge_r6_r10_r10[] = {
  0x1a, 0x6a, 0xb0, 0xa1 // lsls ge r6 r10 r10
};
const byte kInstruction_lsls_lt_r5_r5_r7[] = {
  0x15, 0x57, 0xb0, 0xb1 // lsls lt r5 r5 r7
};
const byte kInstruction_lsls_hi_r6_r3_r9[] = {
  0x13, 0x69, 0xb0, 0x81 // lsls hi r6 r3 r9
};
const byte kInstruction_lsls_hi_r14_r12_r10[] = {
  0x1c, 0xea, 0xb0, 0x81 // lsls hi r14 r12 r10
};
const byte kInstruction_lsls_lt_r9_r13_r14[] = {
  0x1d, 0x9e, 0xb0, 0xb1 // lsls lt r9 r13 r14
};
const byte kInstruction_lsls_al_r0_r12_r7[] = {
  0x1c, 0x07, 0xb0, 0xe1 // lsls al r0 r12 r7
};
const byte kInstruction_lsls_eq_r14_r8_r11[] = {
  0x18, 0xeb, 0xb0, 0x01 // lsls eq r14 r8 r11
};
const byte kInstruction_lsls_ne_r9_r11_r1[] = {
  0x1b, 0x91, 0xb0, 0x11 // lsls ne r9 r11 r1
};
const byte kInstruction_lsls_ge_r5_r0_r3[] = {
  0x10, 0x53, 0xb0, 0xa1 // lsls ge r5 r0 r3
};
const byte kInstruction_lsls_pl_r12_r0_r1[] = {
  0x10, 0xc1, 0xb0, 0x51 // lsls pl r12 r0 r1
};
const byte kInstruction_lsls_lt_r13_r7_r11[] = {
  0x17, 0xdb, 0xb0, 0xb1 // lsls lt r13 r7 r11
};
const byte kInstruction_lsls_eq_r4_r6_r6[] = {
  0x16, 0x46, 0xb0, 0x01 // lsls eq r4 r6 r6
};
const byte kInstruction_lsls_cs_r1_r14_r0[] = {
  0x1e, 0x10, 0xb0, 0x21 // lsls cs r1 r14 r0
};
const byte kInstruction_lsls_hi_r7_r7_r6[] = {
  0x17, 0x76, 0xb0, 0x81 // lsls hi r7 r7 r6
};
const byte kInstruction_lsls_hi_r1_r0_r3[] = {
  0x10, 0x13, 0xb0, 0x81 // lsls hi r1 r0 r3
};
const byte kInstruction_lsls_pl_r12_r2_r0[] = {
  0x12, 0xc0, 0xb0, 0x51 // lsls pl r12 r2 r0
};
const byte kInstruction_lsls_mi_r3_r0_r3[] = {
  0x10, 0x33, 0xb0, 0x41 // lsls mi r3 r0 r3
};
const byte kInstruction_lsls_al_r14_r4_r3[] = {
  0x14, 0xe3, 0xb0, 0xe1 // lsls al r14 r4 r3
};
const byte kInstruction_lsls_vs_r4_r2_r9[] = {
  0x12, 0x49, 0xb0, 0x61 // lsls vs r4 r2 r9
};
const byte kInstruction_lsls_vs_r1_r9_r12[] = {
  0x19, 0x1c, 0xb0, 0x61 // lsls vs r1 r9 r12
};
const byte kInstruction_lsls_vs_r3_r6_r9[] = {
  0x16, 0x39, 0xb0, 0x61 // lsls vs r3 r6 r9
};
const byte kInstruction_lsls_cc_r4_r1_r8[] = {
  0x11, 0x48, 0xb0, 0x31 // lsls cc r4 r1 r8
};
const byte kInstruction_lsls_ls_r10_r11_r14[] = {
  0x1b, 0xae, 0xb0, 0x91 // lsls ls r10 r11 r14
};
const byte kInstruction_lsls_le_r11_r7_r2[] = {
  0x17, 0xb2, 0xb0, 0xd1 // lsls le r11 r7 r2
};
const byte kInstruction_lsls_le_r6_r9_r14[] = {
  0x19, 0x6e, 0xb0, 0xd1 // lsls le r6 r9 r14
};
const byte kInstruction_lsls_al_r1_r3_r11[] = {
  0x13, 0x1b, 0xb0, 0xe1 // lsls al r1 r3 r11
};
const byte kInstruction_lsls_lt_r0_r2_r2[] = {
  0x12, 0x02, 0xb0, 0xb1 // lsls lt r0 r2 r2
};
const byte kInstruction_lsls_eq_r11_r6_r8[] = {
  0x16, 0xb8, 0xb0, 0x01 // lsls eq r11 r6 r8
};
const byte kInstruction_lsls_ls_r7_r12_r5[] = {
  0x1c, 0x75, 0xb0, 0x91 // lsls ls r7 r12 r5
};
const byte kInstruction_lsls_vc_r4_r11_r0[] = {
  0x1b, 0x40, 0xb0, 0x71 // lsls vc r4 r11 r0
};
const byte kInstruction_lsls_ls_r7_r14_r2[] = {
  0x1e, 0x72, 0xb0, 0x91 // lsls ls r7 r14 r2
};
const byte kInstruction_lsls_le_r7_r12_r1[] = {
  0x1c, 0x71, 0xb0, 0xd1 // lsls le r7 r12 r1
};
const byte kInstruction_lsls_le_r1_r14_r13[] = {
  0x1e, 0x1d, 0xb0, 0xd1 // lsls le r1 r14 r13
};
const byte kInstruction_lsls_le_r11_r3_r9[] = {
  0x13, 0xb9, 0xb0, 0xd1 // lsls le r11 r3 r9
};
const byte kInstruction_lsls_ne_r14_r13_r1[] = {
  0x1d, 0xe1, 0xb0, 0x11 // lsls ne r14 r13 r1
};
const byte kInstruction_lsls_ne_r5_r1_r10[] = {
  0x11, 0x5a, 0xb0, 0x11 // lsls ne r5 r1 r10
};
const byte kInstruction_lsls_cc_r7_r4_r3[] = {
  0x14, 0x73, 0xb0, 0x31 // lsls cc r7 r4 r3
};
const byte kInstruction_lsls_lt_r8_r1_r1[] = {
  0x11, 0x81, 0xb0, 0xb1 // lsls lt r8 r1 r1
};
const byte kInstruction_lsls_al_r5_r0_r1[] = {
  0x10, 0x51, 0xb0, 0xe1 // lsls al r5 r0 r1
};
const byte kInstruction_lsls_ge_r11_r13_r9[] = {
  0x1d, 0xb9, 0xb0, 0xa1 // lsls ge r11 r13 r9
};
const byte kInstruction_lsls_gt_r5_r9_r5[] = {
  0x19, 0x55, 0xb0, 0xc1 // lsls gt r5 r9 r5
};
const byte kInstruction_lsls_cc_r2_r8_r3[] = {
  0x18, 0x23, 0xb0, 0x31 // lsls cc r2 r8 r3
};
const byte kInstruction_lsls_eq_r6_r6_r12[] = {
  0x16, 0x6c, 0xb0, 0x01 // lsls eq r6 r6 r12
};
const byte kInstruction_lsls_vc_r3_r10_r13[] = {
  0x1a, 0x3d, 0xb0, 0x71 // lsls vc r3 r10 r13
};
const byte kInstruction_lsls_vc_r9_r13_r1[] = {
  0x1d, 0x91, 0xb0, 0x71 // lsls vc r9 r13 r1
};
const byte kInstruction_lsls_lt_r7_r0_r0[] = {
  0x10, 0x70, 0xb0, 0xb1 // lsls lt r7 r0 r0
};
const byte kInstruction_lsls_cc_r6_r6_r1[] = {
  0x16, 0x61, 0xb0, 0x31 // lsls cc r6 r6 r1
};
const byte kInstruction_lsls_mi_r8_r1_r9[] = {
  0x11, 0x89, 0xb0, 0x41 // lsls mi r8 r1 r9
};
const byte kInstruction_lsls_ls_r14_r10_r10[] = {
  0x1a, 0xea, 0xb0, 0x91 // lsls ls r14 r10 r10
};
const byte kInstruction_lsls_ge_r7_r13_r1[] = {
  0x1d, 0x71, 0xb0, 0xa1 // lsls ge r7 r13 r1
};
const byte kInstruction_lsls_le_r0_r4_r3[] = {
  0x14, 0x03, 0xb0, 0xd1 // lsls le r0 r4 r3
};
const byte kInstruction_lsls_cc_r12_r10_r10[] = {
  0x1a, 0xca, 0xb0, 0x31 // lsls cc r12 r10 r10
};
const byte kInstruction_lsls_ge_r5_r0_r10[] = {
  0x10, 0x5a, 0xb0, 0xa1 // lsls ge r5 r0 r10
};
const byte kInstruction_lsls_vs_r8_r3_r10[] = {
  0x13, 0x8a, 0xb0, 0x61 // lsls vs r8 r3 r10
};
const byte kInstruction_lsls_ge_r11_r12_r2[] = {
  0x1c, 0xb2, 0xb0, 0xa1 // lsls ge r11 r12 r2
};
const byte kInstruction_lsls_ne_r14_r4_r8[] = {
  0x14, 0xe8, 0xb0, 0x11 // lsls ne r14 r4 r8
};
const byte kInstruction_lsls_mi_r3_r0_r4[] = {
  0x10, 0x34, 0xb0, 0x41 // lsls mi r3 r0 r4
};
const byte kInstruction_lsls_gt_r13_r9_r6[] = {
  0x19, 0xd6, 0xb0, 0xc1 // lsls gt r13 r9 r6
};
const byte kInstruction_lsls_ls_r1_r14_r2[] = {
  0x1e, 0x12, 0xb0, 0x91 // lsls ls r1 r14 r2
};
const byte kInstruction_lsls_eq_r11_r3_r12[] = {
  0x13, 0xbc, 0xb0, 0x01 // lsls eq r11 r3 r12
};
const byte kInstruction_lsls_ge_r4_r13_r4[] = {
  0x1d, 0x44, 0xb0, 0xa1 // lsls ge r4 r13 r4
};
const byte kInstruction_lsls_al_r5_r9_r7[] = {
  0x19, 0x57, 0xb0, 0xe1 // lsls al r5 r9 r7
};
const byte kInstruction_lsls_le_r11_r9_r0[] = {
  0x19, 0xb0, 0xb0, 0xd1 // lsls le r11 r9 r0
};
const byte kInstruction_lsls_mi_r13_r10_r12[] = {
  0x1a, 0xdc, 0xb0, 0x41 // lsls mi r13 r10 r12
};
const byte kInstruction_lsls_hi_r5_r5_r10[] = {
  0x15, 0x5a, 0xb0, 0x81 // lsls hi r5 r5 r10
};
const byte kInstruction_lsls_ge_r4_r6_r14[] = {
  0x16, 0x4e, 0xb0, 0xa1 // lsls ge r4 r6 r14
};
const byte kInstruction_lsls_le_r5_r5_r7[] = {
  0x15, 0x57, 0xb0, 0xd1 // lsls le r5 r5 r7
};
const byte kInstruction_lsls_pl_r12_r2_r8[] = {
  0x12, 0xc8, 0xb0, 0x51 // lsls pl r12 r2 r8
};
const byte kInstruction_lsls_al_r7_r8_r10[] = {
  0x18, 0x7a, 0xb0, 0xe1 // lsls al r7 r8 r10
};
const byte kInstruction_lsls_vc_r8_r11_r13[] = {
  0x1b, 0x8d, 0xb0, 0x71 // lsls vc r8 r11 r13
};
const byte kInstruction_lsls_ne_r14_r2_r12[] = {
  0x12, 0xec, 0xb0, 0x11 // lsls ne r14 r2 r12
};
const byte kInstruction_lsls_eq_r10_r4_r2[] = {
  0x14, 0xa2, 0xb0, 0x01 // lsls eq r10 r4 r2
};
const byte kInstruction_lsls_al_r6_r2_r5[] = {
  0x12, 0x65, 0xb0, 0xe1 // lsls al r6 r2 r5
};
const byte kInstruction_lsls_al_r1_r6_r2[] = {
  0x16, 0x12, 0xb0, 0xe1 // lsls al r1 r6 r2
};
const byte kInstruction_lsls_vs_r0_r7_r14[] = {
  0x17, 0x0e, 0xb0, 0x61 // lsls vs r0 r7 r14
};
const byte kInstruction_lsls_hi_r9_r7_r0[] = {
  0x17, 0x90, 0xb0, 0x81 // lsls hi r9 r7 r0
};
const byte kInstruction_lsls_ne_r8_r11_r13[] = {
  0x1b, 0x8d, 0xb0, 0x11 // lsls ne r8 r11 r13
};
const byte kInstruction_lsls_ne_r9_r8_r12[] = {
  0x18, 0x9c, 0xb0, 0x11 // lsls ne r9 r8 r12
};
const byte kInstruction_lsls_al_r14_r8_r6[] = {
  0x18, 0xe6, 0xb0, 0xe1 // lsls al r14 r8 r6
};
const byte kInstruction_lsls_vc_r8_r0_r3[] = {
  0x10, 0x83, 0xb0, 0x71 // lsls vc r8 r0 r3
};
const byte kInstruction_lsls_pl_r11_r9_r0[] = {
  0x19, 0xb0, 0xb0, 0x51 // lsls pl r11 r9 r0
};
const byte kInstruction_lsls_al_r7_r9_r9[] = {
  0x19, 0x79, 0xb0, 0xe1 // lsls al r7 r9 r9
};
const byte kInstruction_lsls_ls_r0_r8_r3[] = {
  0x18, 0x03, 0xb0, 0x91 // lsls ls r0 r8 r3
};
const byte kInstruction_lsls_lt_r5_r13_r6[] = {
  0x1d, 0x56, 0xb0, 0xb1 // lsls lt r5 r13 r6
};
const byte kInstruction_lsls_ge_r6_r5_r13[] = {
  0x15, 0x6d, 0xb0, 0xa1 // lsls ge r6 r5 r13
};
const byte kInstruction_lsls_cs_r11_r7_r3[] = {
  0x17, 0xb3, 0xb0, 0x21 // lsls cs r11 r7 r3
};
const byte kInstruction_lsls_vs_r8_r0_r6[] = {
  0x10, 0x86, 0xb0, 0x61 // lsls vs r8 r0 r6
};
const byte kInstruction_lsls_hi_r0_r12_r6[] = {
  0x1c, 0x06, 0xb0, 0x81 // lsls hi r0 r12 r6
};
const byte kInstruction_lsls_eq_r14_r5_r12[] = {
  0x15, 0xec, 0xb0, 0x01 // lsls eq r14 r5 r12
};
const byte kInstruction_lsls_lt_r1_r4_r13[] = {
  0x14, 0x1d, 0xb0, 0xb1 // lsls lt r1 r4 r13
};
const byte kInstruction_lsls_hi_r6_r4_r2[] = {
  0x14, 0x62, 0xb0, 0x81 // lsls hi r6 r4 r2
};
const byte kInstruction_lsls_lt_r10_r10_r9[] = {
  0x1a, 0xa9, 0xb0, 0xb1 // lsls lt r10 r10 r9
};
const byte kInstruction_lsls_pl_r14_r7_r4[] = {
  0x17, 0xe4, 0xb0, 0x51 // lsls pl r14 r7 r4
};
const byte kInstruction_lsls_ge_r8_r3_r4[] = {
  0x13, 0x84, 0xb0, 0xa1 // lsls ge r8 r3 r4
};
const byte kInstruction_lsls_al_r11_r1_r14[] = {
  0x11, 0xbe, 0xb0, 0xe1 // lsls al r11 r1 r14
};
const byte kInstruction_lsls_ge_r7_r8_r9[] = {
  0x18, 0x79, 0xb0, 0xa1 // lsls ge r7 r8 r9
};
const byte kInstruction_lsls_le_r10_r10_r8[] = {
  0x1a, 0xa8, 0xb0, 0xd1 // lsls le r10 r10 r8
};
const byte kInstruction_lsls_hi_r3_r3_r7[] = {
  0x13, 0x37, 0xb0, 0x81 // lsls hi r3 r3 r7
};
const byte kInstruction_lsls_cc_r3_r0_r14[] = {
  0x10, 0x3e, 0xb0, 0x31 // lsls cc r3 r0 r14
};
const byte kInstruction_lsls_al_r8_r9_r1[] = {
  0x19, 0x81, 0xb0, 0xe1 // lsls al r8 r9 r1
};
const byte kInstruction_lsls_gt_r6_r13_r7[] = {
  0x1d, 0x67, 0xb0, 0xc1 // lsls gt r6 r13 r7
};
const byte kInstruction_lsls_ls_r11_r3_r1[] = {
  0x13, 0xb1, 0xb0, 0x91 // lsls ls r11 r3 r1
};
const byte kInstruction_lsls_cc_r14_r0_r13[] = {
  0x10, 0xed, 0xb0, 0x31 // lsls cc r14 r0 r13
};
const byte kInstruction_lsls_gt_r4_r4_r4[] = {
  0x14, 0x44, 0xb0, 0xc1 // lsls gt r4 r4 r4
};
const byte kInstruction_lsls_al_r8_r13_r1[] = {
  0x1d, 0x81, 0xb0, 0xe1 // lsls al r8 r13 r1
};
const byte kInstruction_lsls_mi_r8_r4_r6[] = {
  0x14, 0x86, 0xb0, 0x41 // lsls mi r8 r4 r6
};
const byte kInstruction_lsls_vc_r12_r7_r11[] = {
  0x17, 0xcb, 0xb0, 0x71 // lsls vc r12 r7 r11
};
const byte kInstruction_lsls_cs_r0_r1_r0[] = {
  0x11, 0x00, 0xb0, 0x21 // lsls cs r0 r1 r0
};
const byte kInstruction_lsls_cc_r13_r14_r0[] = {
  0x1e, 0xd0, 0xb0, 0x31 // lsls cc r13 r14 r0
};
const byte kInstruction_lsls_eq_r4_r7_r11[] = {
  0x17, 0x4b, 0xb0, 0x01 // lsls eq r4 r7 r11
};
const byte kInstruction_lsls_ls_r11_r2_r0[] = {
  0x12, 0xb0, 0xb0, 0x91 // lsls ls r11 r2 r0
};
const byte kInstruction_lsls_gt_r10_r2_r3[] = {
  0x12, 0xa3, 0xb0, 0xc1 // lsls gt r10 r2 r3
};
const byte kInstruction_lsls_al_r6_r1_r7[] = {
  0x11, 0x67, 0xb0, 0xe1 // lsls al r6 r1 r7
};
const byte kInstruction_lsls_cs_r10_r13_r0[] = {
  0x1d, 0xa0, 0xb0, 0x21 // lsls cs r10 r13 r0
};
const byte kInstruction_lsls_lt_r11_r2_r6[] = {
  0x12, 0xb6, 0xb0, 0xb1 // lsls lt r11 r2 r6
};
const byte kInstruction_lsls_pl_r4_r13_r6[] = {
  0x1d, 0x46, 0xb0, 0x51 // lsls pl r4 r13 r6
};
const byte kInstruction_lsls_cs_r3_r0_r9[] = {
  0x10, 0x39, 0xb0, 0x21 // lsls cs r3 r0 r9
};
const byte kInstruction_lsls_gt_r4_r6_r14[] = {
  0x16, 0x4e, 0xb0, 0xc1 // lsls gt r4 r6 r14
};
const byte kInstruction_lsls_eq_r6_r8_r0[] = {
  0x18, 0x60, 0xb0, 0x01 // lsls eq r6 r8 r0
};
const byte kInstruction_lsls_cc_r5_r5_r2[] = {
  0x15, 0x52, 0xb0, 0x31 // lsls cc r5 r5 r2
};
const byte kInstruction_lsls_al_r9_r3_r7[] = {
  0x13, 0x97, 0xb0, 0xe1 // lsls al r9 r3 r7
};
const byte kInstruction_lsls_cc_r12_r0_r8[] = {
  0x10, 0xc8, 0xb0, 0x31 // lsls cc r12 r0 r8
};
const byte kInstruction_lsls_le_r4_r1_r7[] = {
  0x11, 0x47, 0xb0, 0xd1 // lsls le r4 r1 r7
};
const byte kInstruction_lsls_gt_r3_r12_r7[] = {
  0x1c, 0x37, 0xb0, 0xc1 // lsls gt r3 r12 r7
};
const byte kInstruction_lsls_vc_r4_r3_r14[] = {
  0x13, 0x4e, 0xb0, 0x71 // lsls vc r4 r3 r14
};
const byte kInstruction_lsls_le_r0_r7_r10[] = {
  0x17, 0x0a, 0xb0, 0xd1 // lsls le r0 r7 r10
};
const byte kInstruction_lsls_vs_r14_r8_r13[] = {
  0x18, 0xed, 0xb0, 0x61 // lsls vs r14 r8 r13
};
const byte kInstruction_lsls_hi_r9_r0_r11[] = {
  0x10, 0x9b, 0xb0, 0x81 // lsls hi r9 r0 r11
};
const byte kInstruction_lsls_eq_r8_r13_r0[] = {
  0x1d, 0x80, 0xb0, 0x01 // lsls eq r8 r13 r0
};
const byte kInstruction_lsls_vc_r10_r9_r2[] = {
  0x19, 0xa2, 0xb0, 0x71 // lsls vc r10 r9 r2
};
const byte kInstruction_lsls_al_r0_r13_r10[] = {
  0x1d, 0x0a, 0xb0, 0xe1 // lsls al r0 r13 r10
};
const byte kInstruction_lsls_ne_r5_r4_r6[] = {
  0x14, 0x56, 0xb0, 0x11 // lsls ne r5 r4 r6
};
const byte kInstruction_lsls_cc_r7_r13_r1[] = {
  0x1d, 0x71, 0xb0, 0x31 // lsls cc r7 r13 r1
};
const byte kInstruction_lsls_lt_r1_r14_r11[] = {
  0x1e, 0x1b, 0xb0, 0xb1 // lsls lt r1 r14 r11
};
const byte kInstruction_lsls_vc_r13_r10_r14[] = {
  0x1a, 0xde, 0xb0, 0x71 // lsls vc r13 r10 r14
};
const byte kInstruction_lsls_le_r3_r0_r4[] = {
  0x10, 0x34, 0xb0, 0xd1 // lsls le r3 r0 r4
};
const byte kInstruction_lsls_al_r11_r4_r5[] = {
  0x14, 0xb5, 0xb0, 0xe1 // lsls al r11 r4 r5
};
const byte kInstruction_lsls_lt_r0_r8_r8[] = {
  0x18, 0x08, 0xb0, 0xb1 // lsls lt r0 r8 r8
};
const byte kInstruction_lsls_al_r13_r12_r7[] = {
  0x1c, 0xd7, 0xb0, 0xe1 // lsls al r13 r12 r7
};
const byte kInstruction_lsls_ls_r12_r13_r13[] = {
  0x1d, 0xcd, 0xb0, 0x91 // lsls ls r12 r13 r13
};
const byte kInstruction_lsls_vc_r8_r2_r9[] = {
  0x12, 0x89, 0xb0, 0x71 // lsls vc r8 r2 r9
};
const byte kInstruction_lsls_ne_r14_r9_r3[] = {
  0x19, 0xe3, 0xb0, 0x11 // lsls ne r14 r9 r3
};
const byte kInstruction_lsls_pl_r12_r11_r6[] = {
  0x1b, 0xc6, 0xb0, 0x51 // lsls pl r12 r11 r6
};
const byte kInstruction_lsls_eq_r0_r3_r5[] = {
  0x13, 0x05, 0xb0, 0x01 // lsls eq r0 r3 r5
};
const byte kInstruction_lsls_hi_r11_r3_r14[] = {
  0x13, 0xbe, 0xb0, 0x81 // lsls hi r11 r3 r14
};
const byte kInstruction_lsls_le_r3_r7_r4[] = {
  0x17, 0x34, 0xb0, 0xd1 // lsls le r3 r7 r4
};
const byte kInstruction_lsls_ne_r6_r9_r8[] = {
  0x19, 0x68, 0xb0, 0x11 // lsls ne r6 r9 r8
};
const byte kInstruction_lsls_vc_r11_r11_r11[] = {
  0x1b, 0xbb, 0xb0, 0x71 // lsls vc r11 r11 r11
};
const byte kInstruction_lsls_ge_r3_r1_r10[] = {
  0x11, 0x3a, 0xb0, 0xa1 // lsls ge r3 r1 r10
};
const byte kInstruction_lsls_gt_r5_r14_r13[] = {
  0x1e, 0x5d, 0xb0, 0xc1 // lsls gt r5 r14 r13
};
const byte kInstruction_lsls_le_r7_r0_r13[] = {
  0x10, 0x7d, 0xb0, 0xd1 // lsls le r7 r0 r13
};
const byte kInstruction_lsls_lt_r8_r5_r1[] = {
  0x15, 0x81, 0xb0, 0xb1 // lsls lt r8 r5 r1
};
const byte kInstruction_lsls_le_r3_r4_r8[] = {
  0x14, 0x38, 0xb0, 0xd1 // lsls le r3 r4 r8
};
const byte kInstruction_lsls_ne_r5_r11_r13[] = {
  0x1b, 0x5d, 0xb0, 0x11 // lsls ne r5 r11 r13
};
const byte kInstruction_lsls_ge_r9_r8_r2[] = {
  0x18, 0x92, 0xb0, 0xa1 // lsls ge r9 r8 r2
};
const byte kInstruction_lsls_gt_r9_r5_r12[] = {
  0x15, 0x9c, 0xb0, 0xc1 // lsls gt r9 r5 r12
};
const byte kInstruction_lsls_pl_r9_r8_r1[] = {
  0x18, 0x91, 0xb0, 0x51 // lsls pl r9 r8 r1
};
const byte kInstruction_lsls_le_r3_r12_r4[] = {
  0x1c, 0x34, 0xb0, 0xd1 // lsls le r3 r12 r4
};
const byte kInstruction_lsls_eq_r5_r6_r9[] = {
  0x16, 0x59, 0xb0, 0x01 // lsls eq r5 r6 r9
};
const byte kInstruction_lsls_ne_r14_r4_r13[] = {
  0x14, 0xed, 0xb0, 0x11 // lsls ne r14 r4 r13
};
const byte kInstruction_lsls_ge_r3_r9_r2[] = {
  0x19, 0x32, 0xb0, 0xa1 // lsls ge r3 r9 r2
};
const byte kInstruction_lsls_ls_r13_r0_r10[] = {
  0x10, 0xda, 0xb0, 0x91 // lsls ls r13 r0 r10
};
const byte kInstruction_lsls_mi_r14_r0_r2[] = {
  0x10, 0xe2, 0xb0, 0x41 // lsls mi r14 r0 r2
};
const byte kInstruction_lsls_cs_r11_r1_r3[] = {
  0x11, 0xb3, 0xb0, 0x21 // lsls cs r11 r1 r3
};
const byte kInstruction_lsls_ne_r8_r9_r10[] = {
  0x19, 0x8a, 0xb0, 0x11 // lsls ne r8 r9 r10
};
const byte kInstruction_lsls_gt_r9_r10_r4[] = {
  0x1a, 0x94, 0xb0, 0xc1 // lsls gt r9 r10 r4
};
const byte kInstruction_lsls_le_r2_r8_r4[] = {
  0x18, 0x24, 0xb0, 0xd1 // lsls le r2 r8 r4
};
const byte kInstruction_lsls_al_r6_r14_r11[] = {
  0x1e, 0x6b, 0xb0, 0xe1 // lsls al r6 r14 r11
};
const byte kInstruction_lsls_eq_r3_r14_r14[] = {
  0x1e, 0x3e, 0xb0, 0x01 // lsls eq r3 r14 r14
};
const byte kInstruction_lsls_pl_r9_r9_r3[] = {
  0x19, 0x93, 0xb0, 0x51 // lsls pl r9 r9 r3
};
const byte kInstruction_lsls_ge_r5_r13_r12[] = {
  0x1d, 0x5c, 0xb0, 0xa1 // lsls ge r5 r13 r12
};
const byte kInstruction_lsls_mi_r10_r6_r5[] = {
  0x16, 0xa5, 0xb0, 0x41 // lsls mi r10 r6 r5
};
const byte kInstruction_lsls_ls_r14_r13_r12[] = {
  0x1d, 0xec, 0xb0, 0x91 // lsls ls r14 r13 r12
};
const byte kInstruction_lsls_lt_r10_r9_r10[] = {
  0x19, 0xaa, 0xb0, 0xb1 // lsls lt r10 r9 r10
};
const byte kInstruction_lsls_ls_r7_r4_r9[] = {
  0x14, 0x79, 0xb0, 0x91 // lsls ls r7 r4 r9
};
const byte kInstruction_lsls_cs_r9_r10_r7[] = {
  0x1a, 0x97, 0xb0, 0x21 // lsls cs r9 r10 r7
};
const byte kInstruction_lsls_eq_r4_r2_r2[] = {
  0x12, 0x42, 0xb0, 0x01 // lsls eq r4 r2 r2
};
const byte kInstruction_lsls_lt_r14_r13_r4[] = {
  0x1d, 0xe4, 0xb0, 0xb1 // lsls lt r14 r13 r4
};
const byte kInstruction_lsls_al_r0_r3_r5[] = {
  0x13, 0x05, 0xb0, 0xe1 // lsls al r0 r3 r5
};
const byte kInstruction_lsls_vs_r9_r6_r7[] = {
  0x16, 0x97, 0xb0, 0x61 // lsls vs r9 r6 r7
};
const byte kInstruction_lsls_ls_r0_r6_r4[] = {
  0x16, 0x04, 0xb0, 0x91 // lsls ls r0 r6 r4
};
const byte kInstruction_lsls_ne_r7_r10_r14[] = {
  0x1a, 0x7e, 0xb0, 0x11 // lsls ne r7 r10 r14
};
const byte kInstruction_lsls_le_r2_r12_r1[] = {
  0x1c, 0x21, 0xb0, 0xd1 // lsls le r2 r12 r1
};
const byte kInstruction_lsls_cs_r1_r5_r0[] = {
  0x15, 0x10, 0xb0, 0x21 // lsls cs r1 r5 r0
};
const byte kInstruction_lsls_pl_r0_r9_r1[] = {
  0x19, 0x01, 0xb0, 0x51 // lsls pl r0 r9 r1
};
const byte kInstruction_lsls_mi_r2_r2_r5[] = {
  0x12, 0x25, 0xb0, 0x41 // lsls mi r2 r2 r5
};
const byte kInstruction_lsls_hi_r5_r1_r12[] = {
  0x11, 0x5c, 0xb0, 0x81 // lsls hi r5 r1 r12
};
const byte kInstruction_lsls_ls_r13_r14_r7[] = {
  0x1e, 0xd7, 0xb0, 0x91 // lsls ls r13 r14 r7
};
const byte kInstruction_lsls_lt_r0_r4_r3[] = {
  0x14, 0x03, 0xb0, 0xb1 // lsls lt r0 r4 r3
};
const byte kInstruction_lsls_cc_r8_r13_r2[] = {
  0x1d, 0x82, 0xb0, 0x31 // lsls cc r8 r13 r2
};
const byte kInstruction_lsls_ls_r7_r8_r14[] = {
  0x18, 0x7e, 0xb0, 0x91 // lsls ls r7 r8 r14
};
const byte kInstruction_lsls_hi_r13_r11_r13[] = {
  0x1b, 0xdd, 0xb0, 0x81 // lsls hi r13 r11 r13
};
const byte kInstruction_lsls_ge_r13_r7_r6[] = {
  0x17, 0xd6, 0xb0, 0xa1 // lsls ge r13 r7 r6
};
const byte kInstruction_lsls_mi_r3_r2_r0[] = {
  0x12, 0x30, 0xb0, 0x41 // lsls mi r3 r2 r0
};
const byte kInstruction_lsls_cs_r12_r0_r10[] = {
  0x10, 0xca, 0xb0, 0x21 // lsls cs r12 r0 r10
};
const byte kInstruction_lsls_vs_r9_r10_r8[] = {
  0x1a, 0x98, 0xb0, 0x61 // lsls vs r9 r10 r8
};
const byte kInstruction_lsls_ls_r2_r8_r8[] = {
  0x18, 0x28, 0xb0, 0x91 // lsls ls r2 r8 r8
};
const byte kInstruction_lsls_ge_r1_r11_r3[] = {
  0x1b, 0x13, 0xb0, 0xa1 // lsls ge r1 r11 r3
};
const byte kInstruction_lsls_ge_r12_r3_r3[] = {
  0x13, 0xc3, 0xb0, 0xa1 // lsls ge r12 r3 r3
};
const byte kInstruction_lsls_gt_r3_r8_r6[] = {
  0x18, 0x36, 0xb0, 0xc1 // lsls gt r3 r8 r6
};
const byte kInstruction_lsls_ne_r13_r2_r9[] = {
  0x12, 0xd9, 0xb0, 0x11 // lsls ne r13 r2 r9
};
const byte kInstruction_lsls_ls_r14_r9_r1[] = {
  0x19, 0xe1, 0xb0, 0x91 // lsls ls r14 r9 r1
};
const byte kInstruction_lsls_cc_r2_r10_r2[] = {
  0x1a, 0x22, 0xb0, 0x31 // lsls cc r2 r10 r2
};
const byte kInstruction_lsls_le_r9_r12_r1[] = {
  0x1c, 0x91, 0xb0, 0xd1 // lsls le r9 r12 r1
};
const byte kInstruction_lsls_cs_r11_r10_r0[] = {
  0x1a, 0xb0, 0xb0, 0x21 // lsls cs r11 r10 r0
};
const byte kInstruction_lsls_eq_r7_r0_r5[] = {
  0x10, 0x75, 0xb0, 0x01 // lsls eq r7 r0 r5
};
const byte kInstruction_lsls_ne_r10_r4_r4[] = {
  0x14, 0xa4, 0xb0, 0x11 // lsls ne r10 r4 r4
};
const byte kInstruction_lsls_pl_r13_r9_r6[] = {
  0x19, 0xd6, 0xb0, 0x51 // lsls pl r13 r9 r6
};
const byte kInstruction_lsls_vc_r11_r3_r3[] = {
  0x13, 0xb3, 0xb0, 0x71 // lsls vc r11 r3 r3
};
const byte kInstruction_lsls_al_r1_r13_r9[] = {
  0x1d, 0x19, 0xb0, 0xe1 // lsls al r1 r13 r9
};
const byte kInstruction_lsls_cc_r13_r9_r14[] = {
  0x19, 0xde, 0xb0, 0x31 // lsls cc r13 r9 r14
};
const byte kInstruction_lsls_vc_r5_r2_r3[] = {
  0x12, 0x53, 0xb0, 0x71 // lsls vc r5 r2 r3
};
const byte kInstruction_lsls_ne_r12_r8_r10[] = {
  0x18, 0xca, 0xb0, 0x11 // lsls ne r12 r8 r10
};
const byte kInstruction_lsls_cs_r11_r13_r6[] = {
  0x1d, 0xb6, 0xb0, 0x21 // lsls cs r11 r13 r6
};
const byte kInstruction_lsls_al_r1_r11_r10[] = {
  0x1b, 0x1a, 0xb0, 0xe1 // lsls al r1 r11 r10
};
const byte kInstruction_lsls_ne_r14_r6_r11[] = {
  0x16, 0xeb, 0xb0, 0x11 // lsls ne r14 r6 r11
};
const byte kInstruction_lsls_cs_r1_r14_r5[] = {
  0x1e, 0x15, 0xb0, 0x21 // lsls cs r1 r14 r5
};
const byte kInstruction_lsls_al_r11_r11_r6[] = {
  0x1b, 0xb6, 0xb0, 0xe1 // lsls al r11 r11 r6
};
const byte kInstruction_lsls_pl_r3_r6_r2[] = {
  0x16, 0x32, 0xb0, 0x51 // lsls pl r3 r6 r2
};
const byte kInstruction_lsls_ne_r3_r9_r4[] = {
  0x19, 0x34, 0xb0, 0x11 // lsls ne r3 r9 r4
};
const byte kInstruction_lsls_mi_r11_r4_r9[] = {
  0x14, 0xb9, 0xb0, 0x41 // lsls mi r11 r4 r9
};
const byte kInstruction_lsls_al_r10_r1_r3[] = {
  0x11, 0xa3, 0xb0, 0xe1 // lsls al r10 r1 r3
};
const byte kInstruction_lsls_vc_r2_r14_r11[] = {
  0x1e, 0x2b, 0xb0, 0x71 // lsls vc r2 r14 r11
};
const byte kInstruction_lsls_mi_r9_r3_r0[] = {
  0x13, 0x90, 0xb0, 0x41 // lsls mi r9 r3 r0
};
const byte kInstruction_lsls_vs_r9_r8_r1[] = {
  0x18, 0x91, 0xb0, 0x61 // lsls vs r9 r8 r1
};
const byte kInstruction_lsls_lt_r2_r12_r5[] = {
  0x1c, 0x25, 0xb0, 0xb1 // lsls lt r2 r12 r5
};
const byte kInstruction_lsls_al_r9_r8_r12[] = {
  0x18, 0x9c, 0xb0, 0xe1 // lsls al r9 r8 r12
};
const byte kInstruction_lsls_vc_r3_r8_r0[] = {
  0x18, 0x30, 0xb0, 0x71 // lsls vc r3 r8 r0
};
const byte kInstruction_lsls_mi_r10_r5_r1[] = {
  0x15, 0xa1, 0xb0, 0x41 // lsls mi r10 r5 r1
};
const byte kInstruction_lsls_vc_r7_r14_r2[] = {
  0x1e, 0x72, 0xb0, 0x71 // lsls vc r7 r14 r2
};
const byte kInstruction_lsls_ls_r0_r9_r7[] = {
  0x19, 0x07, 0xb0, 0x91 // lsls ls r0 r9 r7
};
const byte kInstruction_lsls_cs_r3_r0_r10[] = {
  0x10, 0x3a, 0xb0, 0x21 // lsls cs r3 r0 r10
};
const byte kInstruction_lsls_cc_r10_r8_r10[] = {
  0x18, 0xaa, 0xb0, 0x31 // lsls cc r10 r8 r10
};
const byte kInstruction_lsls_eq_r5_r4_r1[] = {
  0x14, 0x51, 0xb0, 0x01 // lsls eq r5 r4 r1
};
const byte kInstruction_lsls_vc_r11_r13_r1[] = {
  0x1d, 0xb1, 0xb0, 0x71 // lsls vc r11 r13 r1
};
const byte kInstruction_lsls_hi_r6_r5_r8[] = {
  0x15, 0x68, 0xb0, 0x81 // lsls hi r6 r5 r8
};
const byte kInstruction_lsls_ne_r10_r5_r6[] = {
  0x15, 0xa6, 0xb0, 0x11 // lsls ne r10 r5 r6
};
const byte kInstruction_lsls_al_r10_r12_r9[] = {
  0x1c, 0xa9, 0xb0, 0xe1 // lsls al r10 r12 r9
};
const byte kInstruction_lsls_eq_r5_r1_r12[] = {
  0x11, 0x5c, 0xb0, 0x01 // lsls eq r5 r1 r12
};
const byte kInstruction_lsls_le_r0_r14_r10[] = {
  0x1e, 0x0a, 0xb0, 0xd1 // lsls le r0 r14 r10
};
const byte kInstruction_lsls_eq_r4_r2_r5[] = {
  0x12, 0x45, 0xb0, 0x01 // lsls eq r4 r2 r5
};
const byte kInstruction_lsls_pl_r5_r8_r2[] = {
  0x18, 0x52, 0xb0, 0x51 // lsls pl r5 r8 r2
};
const byte kInstruction_lsls_hi_r5_r14_r4[] = {
  0x1e, 0x54, 0xb0, 0x81 // lsls hi r5 r14 r4
};
const byte kInstruction_lsls_le_r2_r7_r9[] = {
  0x17, 0x29, 0xb0, 0xd1 // lsls le r2 r7 r9
};
const byte kInstruction_lsls_pl_r5_r12_r6[] = {
  0x1c, 0x56, 0xb0, 0x51 // lsls pl r5 r12 r6
};
const byte kInstruction_lsls_vs_r11_r4_r14[] = {
  0x14, 0xbe, 0xb0, 0x61 // lsls vs r11 r4 r14
};
const byte kInstruction_lsls_eq_r0_r7_r14[] = {
  0x17, 0x0e, 0xb0, 0x01 // lsls eq r0 r7 r14
};
const byte kInstruction_lsls_pl_r5_r2_r5[] = {
  0x12, 0x55, 0xb0, 0x51 // lsls pl r5 r2 r5
};
const byte kInstruction_lsls_ne_r5_r11_r7[] = {
  0x1b, 0x57, 0xb0, 0x11 // lsls ne r5 r11 r7
};
const byte kInstruction_lsls_pl_r7_r9_r10[] = {
  0x19, 0x7a, 0xb0, 0x51 // lsls pl r7 r9 r10
};
const byte kInstruction_lsls_hi_r4_r2_r2[] = {
  0x12, 0x42, 0xb0, 0x81 // lsls hi r4 r2 r2
};
const byte kInstruction_lsls_pl_r14_r9_r2[] = {
  0x19, 0xe2, 0xb0, 0x51 // lsls pl r14 r9 r2
};
const byte kInstruction_lsls_le_r4_r11_r13[] = {
  0x1b, 0x4d, 0xb0, 0xd1 // lsls le r4 r11 r13
};
const byte kInstruction_lsls_pl_r8_r8_r8[] = {
  0x18, 0x88, 0xb0, 0x51 // lsls pl r8 r8 r8
};
const byte kInstruction_lsls_ge_r0_r6_r10[] = {
  0x16, 0x0a, 0xb0, 0xa1 // lsls ge r0 r6 r10
};
const byte kInstruction_lsls_vc_r4_r4_r10[] = {
  0x14, 0x4a, 0xb0, 0x71 // lsls vc r4 r4 r10
};
const byte kInstruction_lsls_cc_r11_r9_r12[] = {
  0x19, 0xbc, 0xb0, 0x31 // lsls cc r11 r9 r12
};
const byte kInstruction_lsls_pl_r14_r4_r12[] = {
  0x14, 0xec, 0xb0, 0x51 // lsls pl r14 r4 r12
};
const byte kInstruction_lsls_vs_r8_r8_r8[] = {
  0x18, 0x88, 0xb0, 0x61 // lsls vs r8 r8 r8
};
const byte kInstruction_lsls_ge_r14_r2_r12[] = {
  0x12, 0xec, 0xb0, 0xa1 // lsls ge r14 r2 r12
};
const byte kInstruction_lsls_ge_r8_r2_r13[] = {
  0x12, 0x8d, 0xb0, 0xa1 // lsls ge r8 r2 r13
};
const byte kInstruction_lsls_vs_r10_r0_r11[] = {
  0x10, 0xab, 0xb0, 0x61 // lsls vs r10 r0 r11
};
const byte kInstruction_lsls_eq_r5_r1_r2[] = {
  0x11, 0x52, 0xb0, 0x01 // lsls eq r5 r1 r2
};
const byte kInstruction_lsls_vs_r10_r11_r3[] = {
  0x1b, 0xa3, 0xb0, 0x61 // lsls vs r10 r11 r3
};
const byte kInstruction_lsls_lt_r13_r13_r7[] = {
  0x1d, 0xd7, 0xb0, 0xb1 // lsls lt r13 r13 r7
};
const byte kInstruction_lsls_le_r12_r7_r6[] = {
  0x17, 0xc6, 0xb0, 0xd1 // lsls le r12 r7 r6
};
const byte kInstruction_lsls_eq_r4_r3_r3[] = {
  0x13, 0x43, 0xb0, 0x01 // lsls eq r4 r3 r3
};
const byte kInstruction_lsls_pl_r0_r5_r8[] = {
  0x15, 0x08, 0xb0, 0x51 // lsls pl r0 r5 r8
};
const byte kInstruction_lsls_vs_r10_r5_r3[] = {
  0x15, 0xa3, 0xb0, 0x61 // lsls vs r10 r5 r3
};
const byte kInstruction_lsls_gt_r0_r11_r9[] = {
  0x1b, 0x09, 0xb0, 0xc1 // lsls gt r0 r11 r9
};
const byte kInstruction_lsls_cc_r8_r5_r9[] = {
  0x15, 0x89, 0xb0, 0x31 // lsls cc r8 r5 r9
};
const byte kInstruction_lsls_cs_r9_r12_r11[] = {
  0x1c, 0x9b, 0xb0, 0x21 // lsls cs r9 r12 r11
};
const byte kInstruction_lsls_gt_r3_r4_r8[] = {
  0x14, 0x38, 0xb0, 0xc1 // lsls gt r3 r4 r8
};
const byte kInstruction_lsls_ls_r8_r3_r10[] = {
  0x13, 0x8a, 0xb0, 0x91 // lsls ls r8 r3 r10
};
const byte kInstruction_lsls_eq_r8_r14_r12[] = {
  0x1e, 0x8c, 0xb0, 0x01 // lsls eq r8 r14 r12
};
const byte kInstruction_lsls_gt_r7_r1_r3[] = {
  0x11, 0x73, 0xb0, 0xc1 // lsls gt r7 r1 r3
};
const byte kInstruction_lsls_al_r4_r4_r8[] = {
  0x14, 0x48, 0xb0, 0xe1 // lsls al r4 r4 r8
};
const byte kInstruction_lsls_gt_r9_r14_r10[] = {
  0x1e, 0x9a, 0xb0, 0xc1 // lsls gt r9 r14 r10
};
const byte kInstruction_lsls_lt_r3_r13_r2[] = {
  0x1d, 0x32, 0xb0, 0xb1 // lsls lt r3 r13 r2
};
const byte kInstruction_lsls_le_r4_r11_r14[] = {
  0x1b, 0x4e, 0xb0, 0xd1 // lsls le r4 r11 r14
};
const byte kInstruction_lsls_ge_r2_r14_r0[] = {
  0x1e, 0x20, 0xb0, 0xa1 // lsls ge r2 r14 r0
};
const byte kInstruction_lsls_pl_r1_r8_r8[] = {
  0x18, 0x18, 0xb0, 0x51 // lsls pl r1 r8 r8
};
const byte kInstruction_lsls_pl_r9_r2_r5[] = {
  0x12, 0x95, 0xb0, 0x51 // lsls pl r9 r2 r5
};
const byte kInstruction_lsls_vs_r13_r13_r1[] = {
  0x1d, 0xd1, 0xb0, 0x61 // lsls vs r13 r13 r1
};
const byte kInstruction_lsls_ge_r12_r14_r3[] = {
  0x1e, 0xc3, 0xb0, 0xa1 // lsls ge r12 r14 r3
};
const byte kInstruction_lsls_vc_r0_r11_r4[] = {
  0x1b, 0x04, 0xb0, 0x71 // lsls vc r0 r11 r4
};
const byte kInstruction_lsls_ge_r0_r2_r9[] = {
  0x12, 0x09, 0xb0, 0xa1 // lsls ge r0 r2 r9
};
const byte kInstruction_lsls_vc_r12_r1_r6[] = {
  0x11, 0xc6, 0xb0, 0x71 // lsls vc r12 r1 r6
};
const byte kInstruction_lsls_ne_r1_r3_r7[] = {
  0x13, 0x17, 0xb0, 0x11 // lsls ne r1 r3 r7
};
const byte kInstruction_lsls_vs_r10_r3_r9[] = {
  0x13, 0xa9, 0xb0, 0x61 // lsls vs r10 r3 r9
};
const byte kInstruction_lsls_cc_r14_r4_r1[] = {
  0x14, 0xe1, 0xb0, 0x31 // lsls cc r14 r4 r1
};
const byte kInstruction_lsls_le_r9_r3_r7[] = {
  0x13, 0x97, 0xb0, 0xd1 // lsls le r9 r3 r7
};
const byte kInstruction_lsls_le_r1_r0_r14[] = {
  0x10, 0x1e, 0xb0, 0xd1 // lsls le r1 r0 r14
};
const byte kInstruction_lsls_le_r0_r14_r4[] = {
  0x1e, 0x04, 0xb0, 0xd1 // lsls le r0 r14 r4
};
const byte kInstruction_lsls_hi_r13_r8_r11[] = {
  0x18, 0xdb, 0xb0, 0x81 // lsls hi r13 r8 r11
};
const byte kInstruction_lsls_cc_r10_r6_r11[] = {
  0x16, 0xab, 0xb0, 0x31 // lsls cc r10 r6 r11
};
const byte kInstruction_lsls_cc_r0_r10_r14[] = {
  0x1a, 0x0e, 0xb0, 0x31 // lsls cc r0 r10 r14
};
const byte kInstruction_lsls_le_r4_r4_r0[] = {
  0x14, 0x40, 0xb0, 0xd1 // lsls le r4 r4 r0
};
const byte kInstruction_lsls_pl_r8_r14_r12[] = {
  0x1e, 0x8c, 0xb0, 0x51 // lsls pl r8 r14 r12
};
const byte kInstruction_lsls_ge_r13_r12_r2[] = {
  0x1c, 0xd2, 0xb0, 0xa1 // lsls ge r13 r12 r2
};
const byte kInstruction_lsls_al_r11_r11_r7[] = {
  0x1b, 0xb7, 0xb0, 0xe1 // lsls al r11 r11 r7
};
const byte kInstruction_lsls_ls_r11_r12_r1[] = {
  0x1c, 0xb1, 0xb0, 0x91 // lsls ls r11 r12 r1
};
const byte kInstruction_lsls_vs_r10_r14_r14[] = {
  0x1e, 0xae, 0xb0, 0x61 // lsls vs r10 r14 r14
};
const byte kInstruction_lsls_pl_r2_r8_r12[] = {
  0x18, 0x2c, 0xb0, 0x51 // lsls pl r2 r8 r12
};
const byte kInstruction_lsls_pl_r12_r7_r11[] = {
  0x17, 0xcb, 0xb0, 0x51 // lsls pl r12 r7 r11
};
const byte kInstruction_lsls_eq_r5_r8_r13[] = {
  0x18, 0x5d, 0xb0, 0x01 // lsls eq r5 r8 r13
};
const byte kInstruction_lsls_vc_r6_r6_r6[] = {
  0x16, 0x66, 0xb0, 0x71 // lsls vc r6 r6 r6
};
const byte kInstruction_lsls_vs_r0_r12_r1[] = {
  0x1c, 0x01, 0xb0, 0x61 // lsls vs r0 r12 r1
};
const byte kInstruction_lsls_cs_r6_r0_r8[] = {
  0x10, 0x68, 0xb0, 0x21 // lsls cs r6 r0 r8
};
const byte kInstruction_lsls_cc_r3_r4_r1[] = {
  0x14, 0x31, 0xb0, 0x31 // lsls cc r3 r4 r1
};
const byte kInstruction_lsls_lt_r1_r10_r14[] = {
  0x1a, 0x1e, 0xb0, 0xb1 // lsls lt r1 r10 r14
};
const byte kInstruction_lsls_le_r1_r3_r5[] = {
  0x13, 0x15, 0xb0, 0xd1 // lsls le r1 r3 r5
};
const byte kInstruction_lsls_cc_r11_r1_r1[] = {
  0x11, 0xb1, 0xb0, 0x31 // lsls cc r11 r1 r1
};
const byte kInstruction_lsls_vc_r1_r8_r7[] = {
  0x18, 0x17, 0xb0, 0x71 // lsls vc r1 r8 r7
};
const byte kInstruction_lsls_eq_r3_r10_r13[] = {
  0x1a, 0x3d, 0xb0, 0x01 // lsls eq r3 r10 r13
};
const byte kInstruction_lsls_hi_r14_r12_r12[] = {
  0x1c, 0xec, 0xb0, 0x81 // lsls hi r14 r12 r12
};
const byte kInstruction_lsls_eq_r10_r1_r14[] = {
  0x11, 0xae, 0xb0, 0x01 // lsls eq r10 r1 r14
};
const byte kInstruction_lsls_lt_r3_r1_r6[] = {
  0x11, 0x36, 0xb0, 0xb1 // lsls lt r3 r1 r6
};
const byte kInstruction_lsls_cc_r9_r12_r10[] = {
  0x1c, 0x9a, 0xb0, 0x31 // lsls cc r9 r12 r10
};
const byte kInstruction_lsls_lt_r13_r14_r14[] = {
  0x1e, 0xde, 0xb0, 0xb1 // lsls lt r13 r14 r14
};
const byte kInstruction_lsls_ge_r2_r6_r9[] = {
  0x16, 0x29, 0xb0, 0xa1 // lsls ge r2 r6 r9
};
const byte kInstruction_lsls_vs_r3_r9_r1[] = {
  0x19, 0x31, 0xb0, 0x61 // lsls vs r3 r9 r1
};
const byte kInstruction_lsls_cc_r1_r9_r12[] = {
  0x19, 0x1c, 0xb0, 0x31 // lsls cc r1 r9 r12
};
const byte kInstruction_lsls_ls_r5_r0_r6[] = {
  0x10, 0x56, 0xb0, 0x91 // lsls ls r5 r0 r6
};
const byte kInstruction_lsls_hi_r6_r14_r10[] = {
  0x1e, 0x6a, 0xb0, 0x81 // lsls hi r6 r14 r10
};
const byte kInstruction_lsls_al_r11_r10_r3[] = {
  0x1a, 0xb3, 0xb0, 0xe1 // lsls al r11 r10 r3
};
const byte kInstruction_lsls_ne_r13_r4_r1[] = {
  0x14, 0xd1, 0xb0, 0x11 // lsls ne r13 r4 r1
};
const byte kInstruction_lsls_hi_r13_r5_r14[] = {
  0x15, 0xde, 0xb0, 0x81 // lsls hi r13 r5 r14
};
const byte kInstruction_lsls_ne_r8_r9_r11[] = {
  0x19, 0x8b, 0xb0, 0x11 // lsls ne r8 r9 r11
};
const byte kInstruction_lsls_eq_r0_r13_r13[] = {
  0x1d, 0x0d, 0xb0, 0x01 // lsls eq r0 r13 r13
};
const byte kInstruction_lsls_ne_r14_r11_r0[] = {
  0x1b, 0xe0, 0xb0, 0x11 // lsls ne r14 r11 r0
};
const byte kInstruction_lsls_mi_r6_r8_r7[] = {
  0x18, 0x67, 0xb0, 0x41 // lsls mi r6 r8 r7
};
const byte kInstruction_lsls_eq_r1_r7_r5[] = {
  0x17, 0x15, 0xb0, 0x01 // lsls eq r1 r7 r5
};
const byte kInstruction_lsls_pl_r12_r9_r12[] = {
  0x19, 0xcc, 0xb0, 0x51 // lsls pl r12 r9 r12
};
const byte kInstruction_lsls_al_r4_r5_r14[] = {
  0x15, 0x4e, 0xb0, 0xe1 // lsls al r4 r5 r14
};
const byte kInstruction_lsls_pl_r7_r0_r12[] = {
  0x10, 0x7c, 0xb0, 0x51 // lsls pl r7 r0 r12
};
const byte kInstruction_lsls_mi_r5_r0_r13[] = {
  0x10, 0x5d, 0xb0, 0x41 // lsls mi r5 r0 r13
};
const byte kInstruction_lsls_al_r10_r7_r11[] = {
  0x17, 0xab, 0xb0, 0xe1 // lsls al r10 r7 r11
};
const byte kInstruction_lsls_gt_r2_r10_r0[] = {
  0x1a, 0x20, 0xb0, 0xc1 // lsls gt r2 r10 r0
};
const byte kInstruction_lsls_ge_r11_r11_r8[] = {
  0x1b, 0xb8, 0xb0, 0xa1 // lsls ge r11 r11 r8
};
const byte kInstruction_lsls_eq_r14_r7_r3[] = {
  0x17, 0xe3, 0xb0, 0x01 // lsls eq r14 r7 r3
};
const byte kInstruction_lsls_ls_r0_r12_r4[] = {
  0x1c, 0x04, 0xb0, 0x91 // lsls ls r0 r12 r4
};
const byte kInstruction_lsls_ne_r10_r1_r7[] = {
  0x11, 0xa7, 0xb0, 0x11 // lsls ne r10 r1 r7
};
const byte kInstruction_lsls_hi_r14_r3_r13[] = {
  0x13, 0xed, 0xb0, 0x81 // lsls hi r14 r3 r13
};
const byte kInstruction_lsls_le_r1_r5_r12[] = {
  0x15, 0x1c, 0xb0, 0xd1 // lsls le r1 r5 r12
};
const byte kInstruction_lsls_ne_r8_r5_r11[] = {
  0x15, 0x8b, 0xb0, 0x11 // lsls ne r8 r5 r11
};
const byte kInstruction_lsls_le_r5_r13_r0[] = {
  0x1d, 0x50, 0xb0, 0xd1 // lsls le r5 r13 r0
};
const byte kInstruction_lsls_gt_r8_r12_r7[] = {
  0x1c, 0x87, 0xb0, 0xc1 // lsls gt r8 r12 r7
};
const byte kInstruction_lsls_eq_r9_r14_r3[] = {
  0x1e, 0x93, 0xb0, 0x01 // lsls eq r9 r14 r3
};
const byte kInstruction_lsls_cs_r10_r9_r9[] = {
  0x19, 0xa9, 0xb0, 0x21 // lsls cs r10 r9 r9
};
const byte kInstruction_lsls_vc_r5_r13_r8[] = {
  0x1d, 0x58, 0xb0, 0x71 // lsls vc r5 r13 r8
};
const byte kInstruction_lsls_eq_r4_r1_r8[] = {
  0x11, 0x48, 0xb0, 0x01 // lsls eq r4 r1 r8
};
const byte kInstruction_lsls_lt_r12_r14_r9[] = {
  0x1e, 0xc9, 0xb0, 0xb1 // lsls lt r12 r14 r9
};
const byte kInstruction_lsls_cc_r8_r8_r0[] = {
  0x18, 0x80, 0xb0, 0x31 // lsls cc r8 r8 r0
};
const byte kInstruction_lsls_hi_r0_r14_r12[] = {
  0x1e, 0x0c, 0xb0, 0x81 // lsls hi r0 r14 r12
};
const byte kInstruction_lsls_hi_r4_r1_r10[] = {
  0x11, 0x4a, 0xb0, 0x81 // lsls hi r4 r1 r10
};
const byte kInstruction_lsls_gt_r2_r14_r12[] = {
  0x1e, 0x2c, 0xb0, 0xc1 // lsls gt r2 r14 r12
};
const byte kInstruction_lsls_vs_r1_r8_r14[] = {
  0x18, 0x1e, 0xb0, 0x61 // lsls vs r1 r8 r14
};
const byte kInstruction_lsls_cs_r4_r1_r6[] = {
  0x11, 0x46, 0xb0, 0x21 // lsls cs r4 r1 r6
};
const byte kInstruction_lsls_hi_r7_r8_r7[] = {
  0x18, 0x77, 0xb0, 0x81 // lsls hi r7 r8 r7
};
const byte kInstruction_lsls_hi_r3_r11_r8[] = {
  0x1b, 0x38, 0xb0, 0x81 // lsls hi r3 r11 r8
};
const byte kInstruction_lsls_lt_r1_r12_r9[] = {
  0x1c, 0x19, 0xb0, 0xb1 // lsls lt r1 r12 r9
};
const byte kInstruction_lsls_cs_r13_r4_r12[] = {
  0x14, 0xdc, 0xb0, 0x21 // lsls cs r13 r4 r12
};
const byte kInstruction_lsls_eq_r10_r10_r5[] = {
  0x1a, 0xa5, 0xb0, 0x01 // lsls eq r10 r10 r5
};
const byte kInstruction_lsls_ge_r10_r14_r0[] = {
  0x1e, 0xa0, 0xb0, 0xa1 // lsls ge r10 r14 r0
};
const byte kInstruction_lsls_lt_r3_r3_r2[] = {
  0x13, 0x32, 0xb0, 0xb1 // lsls lt r3 r3 r2
};
const byte kInstruction_lsls_vs_r2_r13_r2[] = {
  0x1d, 0x22, 0xb0, 0x61 // lsls vs r2 r13 r2
};
const byte kInstruction_lsls_ls_r6_r2_r12[] = {
  0x12, 0x6c, 0xb0, 0x91 // lsls ls r6 r2 r12
};
const byte kInstruction_lsls_gt_r5_r11_r12[] = {
  0x1b, 0x5c, 0xb0, 0xc1 // lsls gt r5 r11 r12
};
const byte kInstruction_lsls_al_r11_r10_r6[] = {
  0x1a, 0xb6, 0xb0, 0xe1 // lsls al r11 r10 r6
};
const byte kInstruction_lsls_hi_r12_r14_r14[] = {
  0x1e, 0xce, 0xb0, 0x81 // lsls hi r12 r14 r14
};
const byte kInstruction_lsls_ge_r12_r10_r6[] = {
  0x1a, 0xc6, 0xb0, 0xa1 // lsls ge r12 r10 r6
};
const byte kInstruction_lsls_eq_r8_r3_r9[] = {
  0x13, 0x89, 0xb0, 0x01 // lsls eq r8 r3 r9
};
const byte kInstruction_lsls_cc_r7_r5_r1[] = {
  0x15, 0x71, 0xb0, 0x31 // lsls cc r7 r5 r1
};
const byte kInstruction_lsls_lt_r3_r0_r6[] = {
  0x10, 0x36, 0xb0, 0xb1 // lsls lt r3 r0 r6
};
const byte kInstruction_lsls_le_r14_r4_r12[] = {
  0x14, 0xec, 0xb0, 0xd1 // lsls le r14 r4 r12
};
const byte kInstruction_lsls_le_r9_r6_r4[] = {
  0x16, 0x94, 0xb0, 0xd1 // lsls le r9 r6 r4
};
const byte kInstruction_lsls_hi_r6_r11_r0[] = {
  0x1b, 0x60, 0xb0, 0x81 // lsls hi r6 r11 r0
};
const byte kInstruction_lsls_al_r3_r7_r6[] = {
  0x17, 0x36, 0xb0, 0xe1 // lsls al r3 r7 r6
};
const byte kInstruction_lsls_lt_r10_r9_r12[] = {
  0x19, 0xac, 0xb0, 0xb1 // lsls lt r10 r9 r12
};
const byte kInstruction_lsls_al_r14_r8_r4[] = {
  0x18, 0xe4, 0xb0, 0xe1 // lsls al r14 r8 r4
};
const byte kInstruction_lsls_le_r14_r11_r14[] = {
  0x1b, 0xee, 0xb0, 0xd1 // lsls le r14 r11 r14
};
const byte kInstruction_lsls_al_r14_r13_r8[] = {
  0x1d, 0xe8, 0xb0, 0xe1 // lsls al r14 r13 r8
};
const byte kInstruction_lsls_ge_r5_r9_r10[] = {
  0x19, 0x5a, 0xb0, 0xa1 // lsls ge r5 r9 r10
};
const byte kInstruction_lsls_eq_r1_r9_r4[] = {
  0x19, 0x14, 0xb0, 0x01 // lsls eq r1 r9 r4
};
const byte kInstruction_lsls_cc_r5_r13_r8[] = {
  0x1d, 0x58, 0xb0, 0x31 // lsls cc r5 r13 r8
};
const byte kInstruction_lsls_ne_r10_r0_r14[] = {
  0x10, 0xae, 0xb0, 0x11 // lsls ne r10 r0 r14
};
const byte kInstruction_lsls_al_r2_r0_r10[] = {
  0x10, 0x2a, 0xb0, 0xe1 // lsls al r2 r0 r10
};
const byte kInstruction_lsls_pl_r4_r0_r11[] = {
  0x10, 0x4b, 0xb0, 0x51 // lsls pl r4 r0 r11
};
const byte kInstruction_lsls_gt_r13_r5_r12[] = {
  0x15, 0xdc, 0xb0, 0xc1 // lsls gt r13 r5 r12
};
const byte kInstruction_lsls_al_r2_r13_r8[] = {
  0x1d, 0x28, 0xb0, 0xe1 // lsls al r2 r13 r8
};
const byte kInstruction_lsls_mi_r11_r3_r4[] = {
  0x13, 0xb4, 0xb0, 0x41 // lsls mi r11 r3 r4
};
const byte kInstruction_lsls_le_r11_r8_r1[] = {
  0x18, 0xb1, 0xb0, 0xd1 // lsls le r11 r8 r1
};
const byte kInstruction_lsls_hi_r12_r11_r1[] = {
  0x1b, 0xc1, 0xb0, 0x81 // lsls hi r12 r11 r1
};
const byte kInstruction_lsls_ls_r6_r7_r2[] = {
  0x17, 0x62, 0xb0, 0x91 // lsls ls r6 r7 r2
};
const byte kInstruction_lsls_cs_r7_r11_r2[] = {
  0x1b, 0x72, 0xb0, 0x21 // lsls cs r7 r11 r2
};
const byte kInstruction_lsls_vc_r11_r13_r7[] = {
  0x1d, 0xb7, 0xb0, 0x71 // lsls vc r11 r13 r7
};
const byte kInstruction_lsls_cs_r13_r0_r1[] = {
  0x10, 0xd1, 0xb0, 0x21 // lsls cs r13 r0 r1
};
const byte kInstruction_lsls_cc_r5_r4_r6[] = {
  0x14, 0x56, 0xb0, 0x31 // lsls cc r5 r4 r6
};
const byte kInstruction_lsls_gt_r4_r4_r13[] = {
  0x14, 0x4d, 0xb0, 0xc1 // lsls gt r4 r4 r13
};
const byte kInstruction_lsls_al_r14_r8_r2[] = {
  0x18, 0xe2, 0xb0, 0xe1 // lsls al r14 r8 r2
};
const TestResult kReferencelsls[] = {
  {
    ARRAY_SIZE(kInstruction_lsls_le_r4_r5_r14),
    kInstruction_lsls_le_r4_r5_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ge_r5_r11_r10),
    kInstruction_lsls_ge_r5_r11_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ls_r0_r9_r9),
    kInstruction_lsls_ls_r0_r9_r9,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r8_r7_r2),
    kInstruction_lsls_le_r8_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_eq_r1_r10_r13),
    kInstruction_lsls_eq_r1_r10_r13,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r9_r12_r2),
    kInstruction_lsls_le_r9_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_pl_r6_r1_r5),
    kInstruction_lsls_pl_r6_r1_r5,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ge_r1_r12_r6),
    kInstruction_lsls_ge_r1_r12_r6,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cc_r13_r12_r3),
    kInstruction_lsls_cc_r13_r12_r3,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_gt_r2_r4_r9),
    kInstruction_lsls_gt_r2_r4_r9,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r3_r9_r10),
    kInstruction_lsls_le_r3_r9_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_gt_r11_r1_r9),
    kInstruction_lsls_gt_r11_r1_r9,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cc_r8_r6_r11),
    kInstruction_lsls_cc_r8_r6_r11,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cs_r12_r9_r3),
    kInstruction_lsls_cs_r12_r9_r3,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_eq_r9_r14_r10),
    kInstruction_lsls_eq_r9_r14_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_gt_r9_r0_r1),
    kInstruction_lsls_gt_r9_r0_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_pl_r11_r8_r2),
    kInstruction_lsls_pl_r11_r8_r2,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_mi_r7_r1_r2),
    kInstruction_lsls_mi_r7_r1_r2,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vs_r8_r6_r7),
    kInstruction_lsls_vs_r8_r6_r7,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ne_r14_r2_r13),
    kInstruction_lsls_ne_r14_r2_r13,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_hi_r3_r3_r8),
    kInstruction_lsls_hi_r3_r3_r8,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vc_r10_r8_r14),
    kInstruction_lsls_vc_r10_r8_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ls_r2_r11_r0),
    kInstruction_lsls_ls_r2_r11_r0,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ge_r8_r10_r0),
    kInstruction_lsls_ge_r8_r10_r0,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_mi_r8_r10_r5),
    kInstruction_lsls_mi_r8_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_pl_r1_r0_r9),
    kInstruction_lsls_pl_r1_r0_r9,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_gt_r6_r7_r3),
    kInstruction_lsls_gt_r6_r7_r3,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vs_r7_r9_r9),
    kInstruction_lsls_vs_r7_r9_r9,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r9_r4_r2),
    kInstruction_lsls_al_r9_r4_r2,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r3_r1_r2),
    kInstruction_lsls_le_r3_r1_r2,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_mi_r6_r14_r0),
    kInstruction_lsls_mi_r6_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vc_r7_r10_r11),
    kInstruction_lsls_vc_r7_r10_r11,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_hi_r13_r2_r10),
    kInstruction_lsls_hi_r13_r2_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cs_r5_r4_r12),
    kInstruction_lsls_cs_r5_r4_r12,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ls_r13_r9_r11),
    kInstruction_lsls_ls_r13_r9_r11,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ne_r2_r10_r12),
    kInstruction_lsls_ne_r2_r10_r12,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vc_r4_r6_r8),
    kInstruction_lsls_vc_r4_r6_r8,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_lt_r13_r0_r13),
    kInstruction_lsls_lt_r13_r0_r13,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_pl_r11_r14_r5),
    kInstruction_lsls_pl_r11_r14_r5,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cs_r8_r11_r3),
    kInstruction_lsls_cs_r8_r11_r3,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cs_r4_r1_r7),
    kInstruction_lsls_cs_r4_r1_r7,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r0_r12_r13),
    kInstruction_lsls_al_r0_r12_r13,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_gt_r3_r6_r0),
    kInstruction_lsls_gt_r3_r6_r0,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vc_r6_r9_r0),
    kInstruction_lsls_vc_r6_r9_r0,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cc_r2_r2_r12),
    kInstruction_lsls_cc_r2_r2_r12,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cs_r4_r13_r1),
    kInstruction_lsls_cs_r4_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_mi_r12_r12_r10),
    kInstruction_lsls_mi_r12_r12_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_hi_r8_r9_r14),
    kInstruction_lsls_hi_r8_r9_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_hi_r4_r3_r7),
    kInstruction_lsls_hi_r4_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ne_r11_r10_r1),
    kInstruction_lsls_ne_r11_r10_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cc_r2_r6_r3),
    kInstruction_lsls_cc_r2_r6_r3,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cs_r6_r6_r0),
    kInstruction_lsls_cs_r6_r6_r0,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vc_r13_r2_r9),
    kInstruction_lsls_vc_r13_r2_r9,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vc_r7_r13_r14),
    kInstruction_lsls_vc_r7_r13_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_pl_r11_r14_r4),
    kInstruction_lsls_pl_r11_r14_r4,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_lt_r12_r14_r8),
    kInstruction_lsls_lt_r12_r14_r8,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cs_r2_r11_r14),
    kInstruction_lsls_cs_r2_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r12_r13_r2),
    kInstruction_lsls_le_r12_r13_r2,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r5_r6_r14),
    kInstruction_lsls_le_r5_r6_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vc_r3_r14_r8),
    kInstruction_lsls_vc_r3_r14_r8,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_lt_r7_r6_r14),
    kInstruction_lsls_lt_r7_r6_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ls_r0_r13_r12),
    kInstruction_lsls_ls_r0_r13_r12,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ge_r10_r9_r14),
    kInstruction_lsls_ge_r10_r9_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r11_r12_r1),
    kInstruction_lsls_le_r11_r12_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r2_r12_r14),
    kInstruction_lsls_al_r2_r12_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cs_r6_r4_r0),
    kInstruction_lsls_cs_r6_r4_r0,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vs_r5_r0_r3),
    kInstruction_lsls_vs_r5_r0_r3,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r8_r8_r0),
    kInstruction_lsls_le_r8_r8_r0,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_gt_r1_r5_r4),
    kInstruction_lsls_gt_r1_r5_r4,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r4_r3_r4),
    kInstruction_lsls_le_r4_r3_r4,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_pl_r9_r7_r10),
    kInstruction_lsls_pl_r9_r7_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ls_r8_r7_r14),
    kInstruction_lsls_ls_r8_r7_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vc_r9_r10_r6),
    kInstruction_lsls_vc_r9_r10_r6,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_hi_r2_r4_r9),
    kInstruction_lsls_hi_r2_r4_r9,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cs_r0_r2_r13),
    kInstruction_lsls_cs_r0_r2_r13,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vs_r3_r6_r12),
    kInstruction_lsls_vs_r3_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cc_r14_r14_r7),
    kInstruction_lsls_cc_r14_r14_r7,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vc_r10_r6_r4),
    kInstruction_lsls_vc_r10_r6_r4,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cc_r1_r6_r10),
    kInstruction_lsls_cc_r1_r6_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vs_r13_r10_r11),
    kInstruction_lsls_vs_r13_r10_r11,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ls_r5_r7_r12),
    kInstruction_lsls_ls_r5_r7_r12,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_eq_r6_r4_r3),
    kInstruction_lsls_eq_r6_r4_r3,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_mi_r5_r9_r2),
    kInstruction_lsls_mi_r5_r9_r2,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_lt_r7_r1_r9),
    kInstruction_lsls_lt_r7_r1_r9,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ne_r12_r7_r0),
    kInstruction_lsls_ne_r12_r7_r0,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_eq_r0_r6_r7),
    kInstruction_lsls_eq_r0_r6_r7,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_pl_r7_r3_r9),
    kInstruction_lsls_pl_r7_r3_r9,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_pl_r11_r11_r13),
    kInstruction_lsls_pl_r11_r11_r13,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_gt_r0_r10_r5),
    kInstruction_lsls_gt_r0_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_mi_r14_r1_r10),
    kInstruction_lsls_mi_r14_r1_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_mi_r5_r14_r0),
    kInstruction_lsls_mi_r5_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ne_r12_r9_r13),
    kInstruction_lsls_ne_r12_r9_r13,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_hi_r8_r5_r11),
    kInstruction_lsls_hi_r8_r5_r11,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ls_r7_r0_r5),
    kInstruction_lsls_ls_r7_r0_r5,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_lt_r5_r1_r7),
    kInstruction_lsls_lt_r5_r1_r7,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cc_r2_r8_r4),
    kInstruction_lsls_cc_r2_r8_r4,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_lt_r3_r0_r5),
    kInstruction_lsls_lt_r3_r0_r5,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_pl_r4_r9_r7),
    kInstruction_lsls_pl_r4_r9_r7,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_eq_r13_r8_r10),
    kInstruction_lsls_eq_r13_r8_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ge_r6_r10_r10),
    kInstruction_lsls_ge_r6_r10_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_lt_r5_r5_r7),
    kInstruction_lsls_lt_r5_r5_r7,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_hi_r6_r3_r9),
    kInstruction_lsls_hi_r6_r3_r9,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_hi_r14_r12_r10),
    kInstruction_lsls_hi_r14_r12_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_lt_r9_r13_r14),
    kInstruction_lsls_lt_r9_r13_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r0_r12_r7),
    kInstruction_lsls_al_r0_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_eq_r14_r8_r11),
    kInstruction_lsls_eq_r14_r8_r11,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ne_r9_r11_r1),
    kInstruction_lsls_ne_r9_r11_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ge_r5_r0_r3),
    kInstruction_lsls_ge_r5_r0_r3,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_pl_r12_r0_r1),
    kInstruction_lsls_pl_r12_r0_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_lt_r13_r7_r11),
    kInstruction_lsls_lt_r13_r7_r11,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_eq_r4_r6_r6),
    kInstruction_lsls_eq_r4_r6_r6,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cs_r1_r14_r0),
    kInstruction_lsls_cs_r1_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_hi_r7_r7_r6),
    kInstruction_lsls_hi_r7_r7_r6,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_hi_r1_r0_r3),
    kInstruction_lsls_hi_r1_r0_r3,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_pl_r12_r2_r0),
    kInstruction_lsls_pl_r12_r2_r0,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_mi_r3_r0_r3),
    kInstruction_lsls_mi_r3_r0_r3,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r14_r4_r3),
    kInstruction_lsls_al_r14_r4_r3,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vs_r4_r2_r9),
    kInstruction_lsls_vs_r4_r2_r9,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vs_r1_r9_r12),
    kInstruction_lsls_vs_r1_r9_r12,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vs_r3_r6_r9),
    kInstruction_lsls_vs_r3_r6_r9,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cc_r4_r1_r8),
    kInstruction_lsls_cc_r4_r1_r8,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ls_r10_r11_r14),
    kInstruction_lsls_ls_r10_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r11_r7_r2),
    kInstruction_lsls_le_r11_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r6_r9_r14),
    kInstruction_lsls_le_r6_r9_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r1_r3_r11),
    kInstruction_lsls_al_r1_r3_r11,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_lt_r0_r2_r2),
    kInstruction_lsls_lt_r0_r2_r2,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_eq_r11_r6_r8),
    kInstruction_lsls_eq_r11_r6_r8,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ls_r7_r12_r5),
    kInstruction_lsls_ls_r7_r12_r5,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vc_r4_r11_r0),
    kInstruction_lsls_vc_r4_r11_r0,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ls_r7_r14_r2),
    kInstruction_lsls_ls_r7_r14_r2,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r7_r12_r1),
    kInstruction_lsls_le_r7_r12_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r1_r14_r13),
    kInstruction_lsls_le_r1_r14_r13,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r11_r3_r9),
    kInstruction_lsls_le_r11_r3_r9,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ne_r14_r13_r1),
    kInstruction_lsls_ne_r14_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ne_r5_r1_r10),
    kInstruction_lsls_ne_r5_r1_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cc_r7_r4_r3),
    kInstruction_lsls_cc_r7_r4_r3,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_lt_r8_r1_r1),
    kInstruction_lsls_lt_r8_r1_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r5_r0_r1),
    kInstruction_lsls_al_r5_r0_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ge_r11_r13_r9),
    kInstruction_lsls_ge_r11_r13_r9,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_gt_r5_r9_r5),
    kInstruction_lsls_gt_r5_r9_r5,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cc_r2_r8_r3),
    kInstruction_lsls_cc_r2_r8_r3,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_eq_r6_r6_r12),
    kInstruction_lsls_eq_r6_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vc_r3_r10_r13),
    kInstruction_lsls_vc_r3_r10_r13,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vc_r9_r13_r1),
    kInstruction_lsls_vc_r9_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_lt_r7_r0_r0),
    kInstruction_lsls_lt_r7_r0_r0,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cc_r6_r6_r1),
    kInstruction_lsls_cc_r6_r6_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_mi_r8_r1_r9),
    kInstruction_lsls_mi_r8_r1_r9,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ls_r14_r10_r10),
    kInstruction_lsls_ls_r14_r10_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ge_r7_r13_r1),
    kInstruction_lsls_ge_r7_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r0_r4_r3),
    kInstruction_lsls_le_r0_r4_r3,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cc_r12_r10_r10),
    kInstruction_lsls_cc_r12_r10_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ge_r5_r0_r10),
    kInstruction_lsls_ge_r5_r0_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vs_r8_r3_r10),
    kInstruction_lsls_vs_r8_r3_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ge_r11_r12_r2),
    kInstruction_lsls_ge_r11_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ne_r14_r4_r8),
    kInstruction_lsls_ne_r14_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_mi_r3_r0_r4),
    kInstruction_lsls_mi_r3_r0_r4,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_gt_r13_r9_r6),
    kInstruction_lsls_gt_r13_r9_r6,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ls_r1_r14_r2),
    kInstruction_lsls_ls_r1_r14_r2,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_eq_r11_r3_r12),
    kInstruction_lsls_eq_r11_r3_r12,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ge_r4_r13_r4),
    kInstruction_lsls_ge_r4_r13_r4,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r5_r9_r7),
    kInstruction_lsls_al_r5_r9_r7,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r11_r9_r0),
    kInstruction_lsls_le_r11_r9_r0,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_mi_r13_r10_r12),
    kInstruction_lsls_mi_r13_r10_r12,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_hi_r5_r5_r10),
    kInstruction_lsls_hi_r5_r5_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ge_r4_r6_r14),
    kInstruction_lsls_ge_r4_r6_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r5_r5_r7),
    kInstruction_lsls_le_r5_r5_r7,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_pl_r12_r2_r8),
    kInstruction_lsls_pl_r12_r2_r8,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r7_r8_r10),
    kInstruction_lsls_al_r7_r8_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vc_r8_r11_r13),
    kInstruction_lsls_vc_r8_r11_r13,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ne_r14_r2_r12),
    kInstruction_lsls_ne_r14_r2_r12,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_eq_r10_r4_r2),
    kInstruction_lsls_eq_r10_r4_r2,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r6_r2_r5),
    kInstruction_lsls_al_r6_r2_r5,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r1_r6_r2),
    kInstruction_lsls_al_r1_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vs_r0_r7_r14),
    kInstruction_lsls_vs_r0_r7_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_hi_r9_r7_r0),
    kInstruction_lsls_hi_r9_r7_r0,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ne_r8_r11_r13),
    kInstruction_lsls_ne_r8_r11_r13,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ne_r9_r8_r12),
    kInstruction_lsls_ne_r9_r8_r12,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r14_r8_r6),
    kInstruction_lsls_al_r14_r8_r6,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vc_r8_r0_r3),
    kInstruction_lsls_vc_r8_r0_r3,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_pl_r11_r9_r0),
    kInstruction_lsls_pl_r11_r9_r0,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r7_r9_r9),
    kInstruction_lsls_al_r7_r9_r9,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ls_r0_r8_r3),
    kInstruction_lsls_ls_r0_r8_r3,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_lt_r5_r13_r6),
    kInstruction_lsls_lt_r5_r13_r6,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ge_r6_r5_r13),
    kInstruction_lsls_ge_r6_r5_r13,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cs_r11_r7_r3),
    kInstruction_lsls_cs_r11_r7_r3,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vs_r8_r0_r6),
    kInstruction_lsls_vs_r8_r0_r6,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_hi_r0_r12_r6),
    kInstruction_lsls_hi_r0_r12_r6,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_eq_r14_r5_r12),
    kInstruction_lsls_eq_r14_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_lt_r1_r4_r13),
    kInstruction_lsls_lt_r1_r4_r13,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_hi_r6_r4_r2),
    kInstruction_lsls_hi_r6_r4_r2,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_lt_r10_r10_r9),
    kInstruction_lsls_lt_r10_r10_r9,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_pl_r14_r7_r4),
    kInstruction_lsls_pl_r14_r7_r4,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ge_r8_r3_r4),
    kInstruction_lsls_ge_r8_r3_r4,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r11_r1_r14),
    kInstruction_lsls_al_r11_r1_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ge_r7_r8_r9),
    kInstruction_lsls_ge_r7_r8_r9,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r10_r10_r8),
    kInstruction_lsls_le_r10_r10_r8,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_hi_r3_r3_r7),
    kInstruction_lsls_hi_r3_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cc_r3_r0_r14),
    kInstruction_lsls_cc_r3_r0_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r8_r9_r1),
    kInstruction_lsls_al_r8_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_gt_r6_r13_r7),
    kInstruction_lsls_gt_r6_r13_r7,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ls_r11_r3_r1),
    kInstruction_lsls_ls_r11_r3_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cc_r14_r0_r13),
    kInstruction_lsls_cc_r14_r0_r13,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_gt_r4_r4_r4),
    kInstruction_lsls_gt_r4_r4_r4,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r8_r13_r1),
    kInstruction_lsls_al_r8_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_mi_r8_r4_r6),
    kInstruction_lsls_mi_r8_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vc_r12_r7_r11),
    kInstruction_lsls_vc_r12_r7_r11,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cs_r0_r1_r0),
    kInstruction_lsls_cs_r0_r1_r0,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cc_r13_r14_r0),
    kInstruction_lsls_cc_r13_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_eq_r4_r7_r11),
    kInstruction_lsls_eq_r4_r7_r11,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ls_r11_r2_r0),
    kInstruction_lsls_ls_r11_r2_r0,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_gt_r10_r2_r3),
    kInstruction_lsls_gt_r10_r2_r3,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r6_r1_r7),
    kInstruction_lsls_al_r6_r1_r7,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cs_r10_r13_r0),
    kInstruction_lsls_cs_r10_r13_r0,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_lt_r11_r2_r6),
    kInstruction_lsls_lt_r11_r2_r6,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_pl_r4_r13_r6),
    kInstruction_lsls_pl_r4_r13_r6,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cs_r3_r0_r9),
    kInstruction_lsls_cs_r3_r0_r9,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_gt_r4_r6_r14),
    kInstruction_lsls_gt_r4_r6_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_eq_r6_r8_r0),
    kInstruction_lsls_eq_r6_r8_r0,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cc_r5_r5_r2),
    kInstruction_lsls_cc_r5_r5_r2,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r9_r3_r7),
    kInstruction_lsls_al_r9_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cc_r12_r0_r8),
    kInstruction_lsls_cc_r12_r0_r8,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r4_r1_r7),
    kInstruction_lsls_le_r4_r1_r7,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_gt_r3_r12_r7),
    kInstruction_lsls_gt_r3_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vc_r4_r3_r14),
    kInstruction_lsls_vc_r4_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r0_r7_r10),
    kInstruction_lsls_le_r0_r7_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vs_r14_r8_r13),
    kInstruction_lsls_vs_r14_r8_r13,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_hi_r9_r0_r11),
    kInstruction_lsls_hi_r9_r0_r11,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_eq_r8_r13_r0),
    kInstruction_lsls_eq_r8_r13_r0,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vc_r10_r9_r2),
    kInstruction_lsls_vc_r10_r9_r2,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r0_r13_r10),
    kInstruction_lsls_al_r0_r13_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ne_r5_r4_r6),
    kInstruction_lsls_ne_r5_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cc_r7_r13_r1),
    kInstruction_lsls_cc_r7_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_lt_r1_r14_r11),
    kInstruction_lsls_lt_r1_r14_r11,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vc_r13_r10_r14),
    kInstruction_lsls_vc_r13_r10_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r3_r0_r4),
    kInstruction_lsls_le_r3_r0_r4,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r11_r4_r5),
    kInstruction_lsls_al_r11_r4_r5,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_lt_r0_r8_r8),
    kInstruction_lsls_lt_r0_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r13_r12_r7),
    kInstruction_lsls_al_r13_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ls_r12_r13_r13),
    kInstruction_lsls_ls_r12_r13_r13,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vc_r8_r2_r9),
    kInstruction_lsls_vc_r8_r2_r9,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ne_r14_r9_r3),
    kInstruction_lsls_ne_r14_r9_r3,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_pl_r12_r11_r6),
    kInstruction_lsls_pl_r12_r11_r6,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_eq_r0_r3_r5),
    kInstruction_lsls_eq_r0_r3_r5,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_hi_r11_r3_r14),
    kInstruction_lsls_hi_r11_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r3_r7_r4),
    kInstruction_lsls_le_r3_r7_r4,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ne_r6_r9_r8),
    kInstruction_lsls_ne_r6_r9_r8,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vc_r11_r11_r11),
    kInstruction_lsls_vc_r11_r11_r11,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ge_r3_r1_r10),
    kInstruction_lsls_ge_r3_r1_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_gt_r5_r14_r13),
    kInstruction_lsls_gt_r5_r14_r13,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r7_r0_r13),
    kInstruction_lsls_le_r7_r0_r13,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_lt_r8_r5_r1),
    kInstruction_lsls_lt_r8_r5_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r3_r4_r8),
    kInstruction_lsls_le_r3_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ne_r5_r11_r13),
    kInstruction_lsls_ne_r5_r11_r13,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ge_r9_r8_r2),
    kInstruction_lsls_ge_r9_r8_r2,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_gt_r9_r5_r12),
    kInstruction_lsls_gt_r9_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_pl_r9_r8_r1),
    kInstruction_lsls_pl_r9_r8_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r3_r12_r4),
    kInstruction_lsls_le_r3_r12_r4,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_eq_r5_r6_r9),
    kInstruction_lsls_eq_r5_r6_r9,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ne_r14_r4_r13),
    kInstruction_lsls_ne_r14_r4_r13,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ge_r3_r9_r2),
    kInstruction_lsls_ge_r3_r9_r2,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ls_r13_r0_r10),
    kInstruction_lsls_ls_r13_r0_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_mi_r14_r0_r2),
    kInstruction_lsls_mi_r14_r0_r2,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cs_r11_r1_r3),
    kInstruction_lsls_cs_r11_r1_r3,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ne_r8_r9_r10),
    kInstruction_lsls_ne_r8_r9_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_gt_r9_r10_r4),
    kInstruction_lsls_gt_r9_r10_r4,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r2_r8_r4),
    kInstruction_lsls_le_r2_r8_r4,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r6_r14_r11),
    kInstruction_lsls_al_r6_r14_r11,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_eq_r3_r14_r14),
    kInstruction_lsls_eq_r3_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_pl_r9_r9_r3),
    kInstruction_lsls_pl_r9_r9_r3,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ge_r5_r13_r12),
    kInstruction_lsls_ge_r5_r13_r12,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_mi_r10_r6_r5),
    kInstruction_lsls_mi_r10_r6_r5,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ls_r14_r13_r12),
    kInstruction_lsls_ls_r14_r13_r12,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_lt_r10_r9_r10),
    kInstruction_lsls_lt_r10_r9_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ls_r7_r4_r9),
    kInstruction_lsls_ls_r7_r4_r9,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cs_r9_r10_r7),
    kInstruction_lsls_cs_r9_r10_r7,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_eq_r4_r2_r2),
    kInstruction_lsls_eq_r4_r2_r2,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_lt_r14_r13_r4),
    kInstruction_lsls_lt_r14_r13_r4,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r0_r3_r5),
    kInstruction_lsls_al_r0_r3_r5,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vs_r9_r6_r7),
    kInstruction_lsls_vs_r9_r6_r7,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ls_r0_r6_r4),
    kInstruction_lsls_ls_r0_r6_r4,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ne_r7_r10_r14),
    kInstruction_lsls_ne_r7_r10_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r2_r12_r1),
    kInstruction_lsls_le_r2_r12_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cs_r1_r5_r0),
    kInstruction_lsls_cs_r1_r5_r0,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_pl_r0_r9_r1),
    kInstruction_lsls_pl_r0_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_mi_r2_r2_r5),
    kInstruction_lsls_mi_r2_r2_r5,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_hi_r5_r1_r12),
    kInstruction_lsls_hi_r5_r1_r12,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ls_r13_r14_r7),
    kInstruction_lsls_ls_r13_r14_r7,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_lt_r0_r4_r3),
    kInstruction_lsls_lt_r0_r4_r3,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cc_r8_r13_r2),
    kInstruction_lsls_cc_r8_r13_r2,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ls_r7_r8_r14),
    kInstruction_lsls_ls_r7_r8_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_hi_r13_r11_r13),
    kInstruction_lsls_hi_r13_r11_r13,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ge_r13_r7_r6),
    kInstruction_lsls_ge_r13_r7_r6,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_mi_r3_r2_r0),
    kInstruction_lsls_mi_r3_r2_r0,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cs_r12_r0_r10),
    kInstruction_lsls_cs_r12_r0_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vs_r9_r10_r8),
    kInstruction_lsls_vs_r9_r10_r8,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ls_r2_r8_r8),
    kInstruction_lsls_ls_r2_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ge_r1_r11_r3),
    kInstruction_lsls_ge_r1_r11_r3,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ge_r12_r3_r3),
    kInstruction_lsls_ge_r12_r3_r3,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_gt_r3_r8_r6),
    kInstruction_lsls_gt_r3_r8_r6,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ne_r13_r2_r9),
    kInstruction_lsls_ne_r13_r2_r9,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ls_r14_r9_r1),
    kInstruction_lsls_ls_r14_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cc_r2_r10_r2),
    kInstruction_lsls_cc_r2_r10_r2,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r9_r12_r1),
    kInstruction_lsls_le_r9_r12_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cs_r11_r10_r0),
    kInstruction_lsls_cs_r11_r10_r0,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_eq_r7_r0_r5),
    kInstruction_lsls_eq_r7_r0_r5,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ne_r10_r4_r4),
    kInstruction_lsls_ne_r10_r4_r4,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_pl_r13_r9_r6),
    kInstruction_lsls_pl_r13_r9_r6,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vc_r11_r3_r3),
    kInstruction_lsls_vc_r11_r3_r3,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r1_r13_r9),
    kInstruction_lsls_al_r1_r13_r9,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cc_r13_r9_r14),
    kInstruction_lsls_cc_r13_r9_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vc_r5_r2_r3),
    kInstruction_lsls_vc_r5_r2_r3,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ne_r12_r8_r10),
    kInstruction_lsls_ne_r12_r8_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cs_r11_r13_r6),
    kInstruction_lsls_cs_r11_r13_r6,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r1_r11_r10),
    kInstruction_lsls_al_r1_r11_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ne_r14_r6_r11),
    kInstruction_lsls_ne_r14_r6_r11,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cs_r1_r14_r5),
    kInstruction_lsls_cs_r1_r14_r5,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r11_r11_r6),
    kInstruction_lsls_al_r11_r11_r6,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_pl_r3_r6_r2),
    kInstruction_lsls_pl_r3_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ne_r3_r9_r4),
    kInstruction_lsls_ne_r3_r9_r4,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_mi_r11_r4_r9),
    kInstruction_lsls_mi_r11_r4_r9,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r10_r1_r3),
    kInstruction_lsls_al_r10_r1_r3,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vc_r2_r14_r11),
    kInstruction_lsls_vc_r2_r14_r11,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_mi_r9_r3_r0),
    kInstruction_lsls_mi_r9_r3_r0,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vs_r9_r8_r1),
    kInstruction_lsls_vs_r9_r8_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_lt_r2_r12_r5),
    kInstruction_lsls_lt_r2_r12_r5,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r9_r8_r12),
    kInstruction_lsls_al_r9_r8_r12,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vc_r3_r8_r0),
    kInstruction_lsls_vc_r3_r8_r0,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_mi_r10_r5_r1),
    kInstruction_lsls_mi_r10_r5_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vc_r7_r14_r2),
    kInstruction_lsls_vc_r7_r14_r2,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ls_r0_r9_r7),
    kInstruction_lsls_ls_r0_r9_r7,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cs_r3_r0_r10),
    kInstruction_lsls_cs_r3_r0_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cc_r10_r8_r10),
    kInstruction_lsls_cc_r10_r8_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_eq_r5_r4_r1),
    kInstruction_lsls_eq_r5_r4_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vc_r11_r13_r1),
    kInstruction_lsls_vc_r11_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_hi_r6_r5_r8),
    kInstruction_lsls_hi_r6_r5_r8,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ne_r10_r5_r6),
    kInstruction_lsls_ne_r10_r5_r6,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r10_r12_r9),
    kInstruction_lsls_al_r10_r12_r9,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_eq_r5_r1_r12),
    kInstruction_lsls_eq_r5_r1_r12,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r0_r14_r10),
    kInstruction_lsls_le_r0_r14_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_eq_r4_r2_r5),
    kInstruction_lsls_eq_r4_r2_r5,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_pl_r5_r8_r2),
    kInstruction_lsls_pl_r5_r8_r2,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_hi_r5_r14_r4),
    kInstruction_lsls_hi_r5_r14_r4,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r2_r7_r9),
    kInstruction_lsls_le_r2_r7_r9,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_pl_r5_r12_r6),
    kInstruction_lsls_pl_r5_r12_r6,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vs_r11_r4_r14),
    kInstruction_lsls_vs_r11_r4_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_eq_r0_r7_r14),
    kInstruction_lsls_eq_r0_r7_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_pl_r5_r2_r5),
    kInstruction_lsls_pl_r5_r2_r5,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ne_r5_r11_r7),
    kInstruction_lsls_ne_r5_r11_r7,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_pl_r7_r9_r10),
    kInstruction_lsls_pl_r7_r9_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_hi_r4_r2_r2),
    kInstruction_lsls_hi_r4_r2_r2,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_pl_r14_r9_r2),
    kInstruction_lsls_pl_r14_r9_r2,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r4_r11_r13),
    kInstruction_lsls_le_r4_r11_r13,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_pl_r8_r8_r8),
    kInstruction_lsls_pl_r8_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ge_r0_r6_r10),
    kInstruction_lsls_ge_r0_r6_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vc_r4_r4_r10),
    kInstruction_lsls_vc_r4_r4_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cc_r11_r9_r12),
    kInstruction_lsls_cc_r11_r9_r12,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_pl_r14_r4_r12),
    kInstruction_lsls_pl_r14_r4_r12,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vs_r8_r8_r8),
    kInstruction_lsls_vs_r8_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ge_r14_r2_r12),
    kInstruction_lsls_ge_r14_r2_r12,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ge_r8_r2_r13),
    kInstruction_lsls_ge_r8_r2_r13,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vs_r10_r0_r11),
    kInstruction_lsls_vs_r10_r0_r11,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_eq_r5_r1_r2),
    kInstruction_lsls_eq_r5_r1_r2,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vs_r10_r11_r3),
    kInstruction_lsls_vs_r10_r11_r3,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_lt_r13_r13_r7),
    kInstruction_lsls_lt_r13_r13_r7,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r12_r7_r6),
    kInstruction_lsls_le_r12_r7_r6,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_eq_r4_r3_r3),
    kInstruction_lsls_eq_r4_r3_r3,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_pl_r0_r5_r8),
    kInstruction_lsls_pl_r0_r5_r8,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vs_r10_r5_r3),
    kInstruction_lsls_vs_r10_r5_r3,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_gt_r0_r11_r9),
    kInstruction_lsls_gt_r0_r11_r9,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cc_r8_r5_r9),
    kInstruction_lsls_cc_r8_r5_r9,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cs_r9_r12_r11),
    kInstruction_lsls_cs_r9_r12_r11,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_gt_r3_r4_r8),
    kInstruction_lsls_gt_r3_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ls_r8_r3_r10),
    kInstruction_lsls_ls_r8_r3_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_eq_r8_r14_r12),
    kInstruction_lsls_eq_r8_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_gt_r7_r1_r3),
    kInstruction_lsls_gt_r7_r1_r3,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r4_r4_r8),
    kInstruction_lsls_al_r4_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_gt_r9_r14_r10),
    kInstruction_lsls_gt_r9_r14_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_lt_r3_r13_r2),
    kInstruction_lsls_lt_r3_r13_r2,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r4_r11_r14),
    kInstruction_lsls_le_r4_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ge_r2_r14_r0),
    kInstruction_lsls_ge_r2_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_pl_r1_r8_r8),
    kInstruction_lsls_pl_r1_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_pl_r9_r2_r5),
    kInstruction_lsls_pl_r9_r2_r5,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vs_r13_r13_r1),
    kInstruction_lsls_vs_r13_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ge_r12_r14_r3),
    kInstruction_lsls_ge_r12_r14_r3,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vc_r0_r11_r4),
    kInstruction_lsls_vc_r0_r11_r4,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ge_r0_r2_r9),
    kInstruction_lsls_ge_r0_r2_r9,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vc_r12_r1_r6),
    kInstruction_lsls_vc_r12_r1_r6,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ne_r1_r3_r7),
    kInstruction_lsls_ne_r1_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vs_r10_r3_r9),
    kInstruction_lsls_vs_r10_r3_r9,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cc_r14_r4_r1),
    kInstruction_lsls_cc_r14_r4_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r9_r3_r7),
    kInstruction_lsls_le_r9_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r1_r0_r14),
    kInstruction_lsls_le_r1_r0_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r0_r14_r4),
    kInstruction_lsls_le_r0_r14_r4,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_hi_r13_r8_r11),
    kInstruction_lsls_hi_r13_r8_r11,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cc_r10_r6_r11),
    kInstruction_lsls_cc_r10_r6_r11,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cc_r0_r10_r14),
    kInstruction_lsls_cc_r0_r10_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r4_r4_r0),
    kInstruction_lsls_le_r4_r4_r0,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_pl_r8_r14_r12),
    kInstruction_lsls_pl_r8_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ge_r13_r12_r2),
    kInstruction_lsls_ge_r13_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r11_r11_r7),
    kInstruction_lsls_al_r11_r11_r7,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ls_r11_r12_r1),
    kInstruction_lsls_ls_r11_r12_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vs_r10_r14_r14),
    kInstruction_lsls_vs_r10_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_pl_r2_r8_r12),
    kInstruction_lsls_pl_r2_r8_r12,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_pl_r12_r7_r11),
    kInstruction_lsls_pl_r12_r7_r11,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_eq_r5_r8_r13),
    kInstruction_lsls_eq_r5_r8_r13,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vc_r6_r6_r6),
    kInstruction_lsls_vc_r6_r6_r6,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vs_r0_r12_r1),
    kInstruction_lsls_vs_r0_r12_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cs_r6_r0_r8),
    kInstruction_lsls_cs_r6_r0_r8,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cc_r3_r4_r1),
    kInstruction_lsls_cc_r3_r4_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_lt_r1_r10_r14),
    kInstruction_lsls_lt_r1_r10_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r1_r3_r5),
    kInstruction_lsls_le_r1_r3_r5,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cc_r11_r1_r1),
    kInstruction_lsls_cc_r11_r1_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vc_r1_r8_r7),
    kInstruction_lsls_vc_r1_r8_r7,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_eq_r3_r10_r13),
    kInstruction_lsls_eq_r3_r10_r13,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_hi_r14_r12_r12),
    kInstruction_lsls_hi_r14_r12_r12,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_eq_r10_r1_r14),
    kInstruction_lsls_eq_r10_r1_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_lt_r3_r1_r6),
    kInstruction_lsls_lt_r3_r1_r6,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cc_r9_r12_r10),
    kInstruction_lsls_cc_r9_r12_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_lt_r13_r14_r14),
    kInstruction_lsls_lt_r13_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ge_r2_r6_r9),
    kInstruction_lsls_ge_r2_r6_r9,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vs_r3_r9_r1),
    kInstruction_lsls_vs_r3_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cc_r1_r9_r12),
    kInstruction_lsls_cc_r1_r9_r12,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ls_r5_r0_r6),
    kInstruction_lsls_ls_r5_r0_r6,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_hi_r6_r14_r10),
    kInstruction_lsls_hi_r6_r14_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r11_r10_r3),
    kInstruction_lsls_al_r11_r10_r3,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ne_r13_r4_r1),
    kInstruction_lsls_ne_r13_r4_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_hi_r13_r5_r14),
    kInstruction_lsls_hi_r13_r5_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ne_r8_r9_r11),
    kInstruction_lsls_ne_r8_r9_r11,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_eq_r0_r13_r13),
    kInstruction_lsls_eq_r0_r13_r13,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ne_r14_r11_r0),
    kInstruction_lsls_ne_r14_r11_r0,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_mi_r6_r8_r7),
    kInstruction_lsls_mi_r6_r8_r7,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_eq_r1_r7_r5),
    kInstruction_lsls_eq_r1_r7_r5,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_pl_r12_r9_r12),
    kInstruction_lsls_pl_r12_r9_r12,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r4_r5_r14),
    kInstruction_lsls_al_r4_r5_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_pl_r7_r0_r12),
    kInstruction_lsls_pl_r7_r0_r12,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_mi_r5_r0_r13),
    kInstruction_lsls_mi_r5_r0_r13,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r10_r7_r11),
    kInstruction_lsls_al_r10_r7_r11,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_gt_r2_r10_r0),
    kInstruction_lsls_gt_r2_r10_r0,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ge_r11_r11_r8),
    kInstruction_lsls_ge_r11_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_eq_r14_r7_r3),
    kInstruction_lsls_eq_r14_r7_r3,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ls_r0_r12_r4),
    kInstruction_lsls_ls_r0_r12_r4,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ne_r10_r1_r7),
    kInstruction_lsls_ne_r10_r1_r7,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_hi_r14_r3_r13),
    kInstruction_lsls_hi_r14_r3_r13,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r1_r5_r12),
    kInstruction_lsls_le_r1_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ne_r8_r5_r11),
    kInstruction_lsls_ne_r8_r5_r11,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r5_r13_r0),
    kInstruction_lsls_le_r5_r13_r0,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_gt_r8_r12_r7),
    kInstruction_lsls_gt_r8_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_eq_r9_r14_r3),
    kInstruction_lsls_eq_r9_r14_r3,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cs_r10_r9_r9),
    kInstruction_lsls_cs_r10_r9_r9,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vc_r5_r13_r8),
    kInstruction_lsls_vc_r5_r13_r8,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_eq_r4_r1_r8),
    kInstruction_lsls_eq_r4_r1_r8,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_lt_r12_r14_r9),
    kInstruction_lsls_lt_r12_r14_r9,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cc_r8_r8_r0),
    kInstruction_lsls_cc_r8_r8_r0,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_hi_r0_r14_r12),
    kInstruction_lsls_hi_r0_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_hi_r4_r1_r10),
    kInstruction_lsls_hi_r4_r1_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_gt_r2_r14_r12),
    kInstruction_lsls_gt_r2_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vs_r1_r8_r14),
    kInstruction_lsls_vs_r1_r8_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cs_r4_r1_r6),
    kInstruction_lsls_cs_r4_r1_r6,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_hi_r7_r8_r7),
    kInstruction_lsls_hi_r7_r8_r7,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_hi_r3_r11_r8),
    kInstruction_lsls_hi_r3_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_lt_r1_r12_r9),
    kInstruction_lsls_lt_r1_r12_r9,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cs_r13_r4_r12),
    kInstruction_lsls_cs_r13_r4_r12,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_eq_r10_r10_r5),
    kInstruction_lsls_eq_r10_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ge_r10_r14_r0),
    kInstruction_lsls_ge_r10_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_lt_r3_r3_r2),
    kInstruction_lsls_lt_r3_r3_r2,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vs_r2_r13_r2),
    kInstruction_lsls_vs_r2_r13_r2,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ls_r6_r2_r12),
    kInstruction_lsls_ls_r6_r2_r12,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_gt_r5_r11_r12),
    kInstruction_lsls_gt_r5_r11_r12,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r11_r10_r6),
    kInstruction_lsls_al_r11_r10_r6,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_hi_r12_r14_r14),
    kInstruction_lsls_hi_r12_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ge_r12_r10_r6),
    kInstruction_lsls_ge_r12_r10_r6,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_eq_r8_r3_r9),
    kInstruction_lsls_eq_r8_r3_r9,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cc_r7_r5_r1),
    kInstruction_lsls_cc_r7_r5_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_lt_r3_r0_r6),
    kInstruction_lsls_lt_r3_r0_r6,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r14_r4_r12),
    kInstruction_lsls_le_r14_r4_r12,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r9_r6_r4),
    kInstruction_lsls_le_r9_r6_r4,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_hi_r6_r11_r0),
    kInstruction_lsls_hi_r6_r11_r0,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r3_r7_r6),
    kInstruction_lsls_al_r3_r7_r6,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_lt_r10_r9_r12),
    kInstruction_lsls_lt_r10_r9_r12,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r14_r8_r4),
    kInstruction_lsls_al_r14_r8_r4,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r14_r11_r14),
    kInstruction_lsls_le_r14_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r14_r13_r8),
    kInstruction_lsls_al_r14_r13_r8,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ge_r5_r9_r10),
    kInstruction_lsls_ge_r5_r9_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_eq_r1_r9_r4),
    kInstruction_lsls_eq_r1_r9_r4,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cc_r5_r13_r8),
    kInstruction_lsls_cc_r5_r13_r8,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ne_r10_r0_r14),
    kInstruction_lsls_ne_r10_r0_r14,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r2_r0_r10),
    kInstruction_lsls_al_r2_r0_r10,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_pl_r4_r0_r11),
    kInstruction_lsls_pl_r4_r0_r11,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_gt_r13_r5_r12),
    kInstruction_lsls_gt_r13_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r2_r13_r8),
    kInstruction_lsls_al_r2_r13_r8,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_mi_r11_r3_r4),
    kInstruction_lsls_mi_r11_r3_r4,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_le_r11_r8_r1),
    kInstruction_lsls_le_r11_r8_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_hi_r12_r11_r1),
    kInstruction_lsls_hi_r12_r11_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_ls_r6_r7_r2),
    kInstruction_lsls_ls_r6_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cs_r7_r11_r2),
    kInstruction_lsls_cs_r7_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_vc_r11_r13_r7),
    kInstruction_lsls_vc_r11_r13_r7,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cs_r13_r0_r1),
    kInstruction_lsls_cs_r13_r0_r1,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_cc_r5_r4_r6),
    kInstruction_lsls_cc_r5_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_gt_r4_r4_r13),
    kInstruction_lsls_gt_r4_r4_r13,
  },
  {
    ARRAY_SIZE(kInstruction_lsls_al_r14_r8_r2),
    kInstruction_lsls_al_r14_r8_r2,
  },
};

#endif  // VIXL_ASSEMBLER_COND_RD_RN_OPERAND_RM_LSLS_A32_H_
