/***************************************************************************
                          dcedittransfer.cpp  -  description
                             -------------------
    begin                : Don Dez 5 2002
    copyright            : (C) 2002 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dcedittransfer.h"

#include <qlineedit.h>
#include <qcombobox.h>

#include <dclib/dcobject.h>

/** */
DCEditTransfer::DCEditTransfer( QWidget * parent ) : QDialog( parent )
{
	setupUi(this);
	
	m_pHubObjectList = 0;

	connect( ComboBox_KNOWNHUBS, SIGNAL(activated( const QString & )), this, SLOT(slotKnownHubsChange( const QString &)) );
}

/** */
DCEditTransfer::~DCEditTransfer()
{
}

/** */
void DCEditTransfer::slotKnownHubsChange( const QString & s )
{
	DCHubObject * HubObject=0;

	while( (HubObject=m_pHubObjectList->Next(HubObject)) != 0 )
	{
		if ( s == QString::fromAscii(HubObject->m_sHubName.Data()) )
		{
			LineEdit_HUBNAME->setText(HubObject->m_sHubName.Data());
			LineEdit_HUBHOST->setText(HubObject->m_sHubHost.Data());
			break;
		}
	}
}

/** */
void DCEditTransfer::Init(QString & nick, QString & hubname, QString & hubhost, CList<DCHubObject> * list )
{
	DCHubObject * HubObject;

	m_pHubObjectList = list;

	LineEdit_NICK->setText(nick);
	LineEdit_HUBNAME->setText(hubname);
	LineEdit_HUBHOST->setText(hubhost);

	HubObject = 0;

	while( (HubObject=m_pHubObjectList->Next(HubObject)) != 0 )
	{
		ComboBox_KNOWNHUBS->addItem(QString::fromAscii(HubObject->m_sHubName.Data()));
	}
}
