/* errorreporter.c generated by valac, the Vala compiler
 * generated from errorreporter.vala, do not modify */

/* errorreporter.vala
 *
 * Copyright (C) 2008-2011 Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Brosch Florian <flo.brosch@gmail.com>
 */


#include <glib.h>
#include <glib-object.h>
#include "valadoc.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gmodule.h>
#include <stdarg.h>

enum  {
	VALADOC_ERROR_REPORTER_0_PROPERTY,
	VALADOC_ERROR_REPORTER_WARNINGS_OFFSET_PROPERTY,
	VALADOC_ERROR_REPORTER_ERRORS_OFFSET_PROPERTY,
	VALADOC_ERROR_REPORTER_STREAM_PROPERTY,
	VALADOC_ERROR_REPORTER_SETTINGS_PROPERTY,
	VALADOC_ERROR_REPORTER_ERRORS_PROPERTY,
	VALADOC_ERROR_REPORTER_WARNINGS_PROPERTY,
	VALADOC_ERROR_REPORTER_NUM_PROPERTIES
};
static GParamSpec* valadoc_error_reporter_properties[VALADOC_ERROR_REPORTER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_module_close0(var) ((var == NULL) ? NULL : (var = (g_module_close (var), NULL)))
typedef gint (*ValadocErrorReporterAttyFunc) (gint fd);

struct _ValadocErrorReporterPrivate {
	gint _warnings;
	gint _errors;
	gchar* locus_color_start;
	const gchar* locus_color_end;
	gchar* warning_color_start;
	const gchar* warning_color_end;
	gchar* error_color_start;
	const gchar* error_color_end;
	gchar* note_color_start;
	const gchar* note_color_end;
	gchar* caret_color_start;
	const gchar* caret_color_end;
	gchar* quote_color_start;
	const gchar* quote_color_end;
	gint _warnings_offset;
	gint _errors_offset;
	FILE* _stream;
	ValadocSettings* _settings;
};


static gpointer valadoc_error_reporter_parent_class = NULL;

#define VALADOC_ERROR_REPORTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALADOC_TYPE_ERROR_REPORTER, ValadocErrorReporterPrivate))
#define VALADOC_ERROR_REPORTER_ANSI_COLOR_END "\x1b[0m"
static gboolean valadoc_error_reporter_is_atty (ValadocErrorReporter* self,
                                         gint fd);
static inline void valadoc_error_reporter_msg (ValadocErrorReporter* self,
                                 const gchar* type,
                                 const gchar* type_color_start,
                                 const gchar* type_color_end,
                                 const gchar* file,
                                 glong line,
                                 glong startpos,
                                 glong endpos,
                                 const gchar* errline,
                                 const gchar* msg_format,
                                 va_list args) G_GNUC_PRINTF(10,0);
static void valadoc_error_reporter_print_highlighted_message (ValadocErrorReporter* self,
                                                       const gchar* message);
static void valadoc_error_reporter_finalize (GObject * obj);
static void _vala_valadoc_error_reporter_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_valadoc_error_reporter_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


ValadocErrorReporter*
valadoc_error_reporter_construct (GType object_type,
                                  ValadocSettings* settings)
{
	ValadocErrorReporter * self = NULL;
	FILE* _tmp0_;
	self = (ValadocErrorReporter*) g_object_new (object_type, NULL);
	_tmp0_ = stderr;
	valadoc_error_reporter_set_stream (self, _tmp0_);
	valadoc_error_reporter_set_settings (self, settings);
	return self;
}


ValadocErrorReporter*
valadoc_error_reporter_new (ValadocSettings* settings)
{
	return valadoc_error_reporter_construct (VALADOC_TYPE_ERROR_REPORTER, settings);
}


/**
 * Set all colors by string
 *
 * {{{
 *   "error=01;31:warning=01;35:note=01;36:caret=01;32:locus=01:quote=01"
 * }}}
 */
gboolean
valadoc_error_reporter_set_colors (ValadocErrorReporter* self,
                                   const gchar* str)
{
	gboolean result = FALSE;
	GRegex* val_regex = NULL;
	gchar* error_color = NULL;
	gchar* warning_color = NULL;
	gchar* note_color = NULL;
	gchar* caret_color = NULL;
	gchar* locus_color = NULL;
	gchar* quote_color = NULL;
	gchar** fragments = NULL;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint fragments_length1;
	gint _fragments_size_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	FILE* _tmp36_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (str != NULL, FALSE);
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_;
		GRegex* _tmp3_;
		_tmp1_ = g_regex_new ("^\\s*[0-9]+(;[0-9]*)*\\s*$", 0, 0, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp2_ = FALSE;
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			_g_regex_unref0 (val_regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_regex_unref0 (val_regex);
		val_regex = _tmp3_;
		_g_regex_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp4_ = FALSE;
		_g_regex_unref0 (val_regex);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
	error_color = NULL;
	warning_color = NULL;
	note_color = NULL;
	caret_color = NULL;
	locus_color = NULL;
	quote_color = NULL;
	_tmp6_ = _tmp5_ = g_strsplit (str, ":", 0);
	fragments = _tmp6_;
	fragments_length1 = _vala_array_length (_tmp5_);
	_fragments_size_ = fragments_length1;
	_tmp7_ = fragments;
	_tmp7__length1 = fragments_length1;
	{
		gchar** fragment_collection = NULL;
		gint fragment_collection_length1 = 0;
		gint _fragment_collection_size_ = 0;
		gint fragment_it = 0;
		fragment_collection = _tmp7_;
		fragment_collection_length1 = _tmp7__length1;
		for (fragment_it = 0; fragment_it < fragment_collection_length1; fragment_it = fragment_it + 1) {
			const gchar* fragment = NULL;
			fragment = fragment_collection[fragment_it];
			{
				gchar** eq = NULL;
				const gchar* _tmp8_;
				gchar** _tmp9_;
				gchar** _tmp10_;
				gint eq_length1;
				gint _eq_size_;
				gchar** _tmp11_;
				gint _tmp11__length1;
				GRegex* _tmp12_;
				gchar** _tmp13_;
				gint _tmp13__length1;
				const gchar* _tmp14_;
				const gchar* checked_value = NULL;
				gchar** _tmp15_;
				gint _tmp15__length1;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				gchar** _tmp18_;
				gint _tmp18__length1;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				GQuark _tmp23_ = 0U;
				static GQuark _tmp22_label0 = 0;
				static GQuark _tmp22_label1 = 0;
				static GQuark _tmp22_label2 = 0;
				static GQuark _tmp22_label3 = 0;
				static GQuark _tmp22_label4 = 0;
				static GQuark _tmp22_label5 = 0;
				_tmp8_ = fragment;
				_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, "=", 2);
				eq = _tmp10_;
				eq_length1 = _vala_array_length (_tmp9_);
				_eq_size_ = eq_length1;
				_tmp11_ = eq;
				_tmp11__length1 = eq_length1;
				if (_tmp11__length1 != 2) {
					result = FALSE;
					eq = (_vala_array_free (eq, eq_length1, (GDestroyNotify) g_free), NULL);
					fragments = (_vala_array_free (fragments, fragments_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (quote_color);
					_g_free0 (locus_color);
					_g_free0 (caret_color);
					_g_free0 (note_color);
					_g_free0 (warning_color);
					_g_free0 (error_color);
					_g_regex_unref0 (val_regex);
					return result;
				}
				_tmp12_ = val_regex;
				_tmp13_ = eq;
				_tmp13__length1 = eq_length1;
				_tmp14_ = _tmp13_[1];
				if (!g_regex_match (_tmp12_, _tmp14_, 0, NULL)) {
					result = FALSE;
					eq = (_vala_array_free (eq, eq_length1, (GDestroyNotify) g_free), NULL);
					fragments = (_vala_array_free (fragments, fragments_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (quote_color);
					_g_free0 (locus_color);
					_g_free0 (caret_color);
					_g_free0 (note_color);
					_g_free0 (warning_color);
					_g_free0 (error_color);
					_g_regex_unref0 (val_regex);
					return result;
				}
				_tmp15_ = eq;
				_tmp15__length1 = eq_length1;
				_tmp16_ = _tmp15_[1];
				_tmp17_ = g_strstrip (_tmp16_);
				checked_value = _tmp17_;
				_tmp18_ = eq;
				_tmp18__length1 = eq_length1;
				_tmp19_ = _tmp18_[0];
				_tmp20_ = g_strstrip (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp23_ = (NULL == _tmp21_) ? 0 : g_quark_from_string (_tmp21_);
				if (_tmp23_ == ((0 != _tmp22_label0) ? _tmp22_label0 : (_tmp22_label0 = g_quark_from_static_string ("error")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp24_;
							gchar* _tmp25_;
							_tmp24_ = checked_value;
							_tmp25_ = g_strdup (_tmp24_);
							_g_free0 (error_color);
							error_color = _tmp25_;
							break;
						}
					}
				} else if (_tmp23_ == ((0 != _tmp22_label1) ? _tmp22_label1 : (_tmp22_label1 = g_quark_from_static_string ("warning")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp26_;
							gchar* _tmp27_;
							_tmp26_ = checked_value;
							_tmp27_ = g_strdup (_tmp26_);
							_g_free0 (warning_color);
							warning_color = _tmp27_;
							break;
						}
					}
				} else if (_tmp23_ == ((0 != _tmp22_label2) ? _tmp22_label2 : (_tmp22_label2 = g_quark_from_static_string ("note")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp28_;
							gchar* _tmp29_;
							_tmp28_ = checked_value;
							_tmp29_ = g_strdup (_tmp28_);
							_g_free0 (note_color);
							note_color = _tmp29_;
							break;
						}
					}
				} else if (_tmp23_ == ((0 != _tmp22_label3) ? _tmp22_label3 : (_tmp22_label3 = g_quark_from_static_string ("caret")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp30_;
							gchar* _tmp31_;
							_tmp30_ = checked_value;
							_tmp31_ = g_strdup (_tmp30_);
							_g_free0 (caret_color);
							caret_color = _tmp31_;
							break;
						}
					}
				} else if (_tmp23_ == ((0 != _tmp22_label4) ? _tmp22_label4 : (_tmp22_label4 = g_quark_from_static_string ("locus")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp32_;
							gchar* _tmp33_;
							_tmp32_ = checked_value;
							_tmp33_ = g_strdup (_tmp32_);
							_g_free0 (locus_color);
							locus_color = _tmp33_;
							break;
						}
					}
				} else if (_tmp23_ == ((0 != _tmp22_label5) ? _tmp22_label5 : (_tmp22_label5 = g_quark_from_static_string ("quote")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp34_;
							gchar* _tmp35_;
							_tmp34_ = checked_value;
							_tmp35_ = g_strdup (_tmp34_);
							_g_free0 (quote_color);
							quote_color = _tmp35_;
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							result = FALSE;
							eq = (_vala_array_free (eq, eq_length1, (GDestroyNotify) g_free), NULL);
							fragments = (_vala_array_free (fragments, fragments_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (quote_color);
							_g_free0 (locus_color);
							_g_free0 (caret_color);
							_g_free0 (note_color);
							_g_free0 (warning_color);
							_g_free0 (error_color);
							_g_regex_unref0 (val_regex);
							return result;
						}
					}
				}
				eq = (_vala_array_free (eq, eq_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	_tmp36_ = self->priv->_stream;
	if (valadoc_error_reporter_is_atty (self, fileno (_tmp36_))) {
		const gchar* _tmp37_;
		const gchar* _tmp42_;
		const gchar* _tmp47_;
		const gchar* _tmp52_;
		const gchar* _tmp57_;
		const gchar* _tmp62_;
		_tmp37_ = error_color;
		if (_tmp37_ != NULL) {
			const gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			_tmp38_ = error_color;
			_tmp39_ = g_strconcat ("\x1b[0", _tmp38_, NULL);
			_tmp40_ = _tmp39_;
			_tmp41_ = g_strconcat (_tmp40_, "m", NULL);
			_g_free0 (self->priv->error_color_start);
			self->priv->error_color_start = _tmp41_;
			_g_free0 (_tmp40_);
			self->priv->error_color_end = VALADOC_ERROR_REPORTER_ANSI_COLOR_END;
		}
		_tmp42_ = warning_color;
		if (_tmp42_ != NULL) {
			const gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			_tmp43_ = warning_color;
			_tmp44_ = g_strconcat ("\x1b[0", _tmp43_, NULL);
			_tmp45_ = _tmp44_;
			_tmp46_ = g_strconcat (_tmp45_, "m", NULL);
			_g_free0 (self->priv->warning_color_start);
			self->priv->warning_color_start = _tmp46_;
			_g_free0 (_tmp45_);
			self->priv->warning_color_end = VALADOC_ERROR_REPORTER_ANSI_COLOR_END;
		}
		_tmp47_ = note_color;
		if (_tmp47_ != NULL) {
			const gchar* _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			gchar* _tmp51_;
			_tmp48_ = note_color;
			_tmp49_ = g_strconcat ("\x1b[0", _tmp48_, NULL);
			_tmp50_ = _tmp49_;
			_tmp51_ = g_strconcat (_tmp50_, "m", NULL);
			_g_free0 (self->priv->note_color_start);
			self->priv->note_color_start = _tmp51_;
			_g_free0 (_tmp50_);
			self->priv->note_color_end = VALADOC_ERROR_REPORTER_ANSI_COLOR_END;
		}
		_tmp52_ = caret_color;
		if (_tmp52_ != NULL) {
			const gchar* _tmp53_;
			gchar* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			_tmp53_ = caret_color;
			_tmp54_ = g_strconcat ("\x1b[0", _tmp53_, NULL);
			_tmp55_ = _tmp54_;
			_tmp56_ = g_strconcat (_tmp55_, "m", NULL);
			_g_free0 (self->priv->caret_color_start);
			self->priv->caret_color_start = _tmp56_;
			_g_free0 (_tmp55_);
			self->priv->caret_color_end = VALADOC_ERROR_REPORTER_ANSI_COLOR_END;
		}
		_tmp57_ = locus_color;
		if (_tmp57_ != NULL) {
			const gchar* _tmp58_;
			gchar* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			_tmp58_ = locus_color;
			_tmp59_ = g_strconcat ("\x1b[0", _tmp58_, NULL);
			_tmp60_ = _tmp59_;
			_tmp61_ = g_strconcat (_tmp60_, "m", NULL);
			_g_free0 (self->priv->locus_color_start);
			self->priv->locus_color_start = _tmp61_;
			_g_free0 (_tmp60_);
			self->priv->locus_color_end = VALADOC_ERROR_REPORTER_ANSI_COLOR_END;
		}
		_tmp62_ = quote_color;
		if (_tmp62_ != NULL) {
			const gchar* _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
			gchar* _tmp66_;
			_tmp63_ = quote_color;
			_tmp64_ = g_strconcat ("\x1b[0", _tmp63_, NULL);
			_tmp65_ = _tmp64_;
			_tmp66_ = g_strconcat (_tmp65_, "m", NULL);
			_g_free0 (self->priv->quote_color_start);
			self->priv->quote_color_start = _tmp66_;
			_g_free0 (_tmp65_);
			self->priv->quote_color_end = VALADOC_ERROR_REPORTER_ANSI_COLOR_END;
		}
	}
	result = TRUE;
	fragments = (_vala_array_free (fragments, fragments_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (quote_color);
	_g_free0 (locus_color);
	_g_free0 (caret_color);
	_g_free0 (note_color);
	_g_free0 (warning_color);
	_g_free0 (error_color);
	_g_regex_unref0 (val_regex);
	return result;
}


static gboolean
valadoc_error_reporter_is_atty (ValadocErrorReporter* self,
                                gint fd)
{
	gboolean result = FALSE;
	GModule* module = NULL;
	GModule* _tmp0_;
	GModule* _tmp1_;
	void* _func = NULL;
	GModule* _tmp2_;
	void* _tmp3_ = NULL;
	void* _tmp4_;
	ValadocErrorReporterAttyFunc func = NULL;
	void* _tmp5_;
	ValadocErrorReporterAttyFunc _tmp6_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_module_open (NULL, G_MODULE_BIND_LAZY);
	module = _tmp0_;
	_tmp1_ = module;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_module_close0 (module);
		return result;
	}
	_tmp2_ = module;
	g_module_symbol (_tmp2_, "isatty", &_tmp3_);
	_func = _tmp3_;
	_tmp4_ = _func;
	if (_tmp4_ == NULL) {
		result = FALSE;
		_g_module_close0 (module);
		return result;
	}
	_tmp5_ = _func;
	func = (ValadocErrorReporterAttyFunc) _tmp5_;
	_tmp6_ = func;
	result = _tmp6_ (fd) == 1;
	_g_module_close0 (module);
	return result;
}


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}


static inline void
valadoc_error_reporter_msg (ValadocErrorReporter* self,
                            const gchar* type,
                            const gchar* type_color_start,
                            const gchar* type_color_end,
                            const gchar* file,
                            glong line,
                            glong startpos,
                            glong endpos,
                            const gchar* errline,
                            const gchar* msg_format,
                            va_list args)
{
	FILE* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	FILE* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (type_color_start != NULL);
	g_return_if_fail (type_color_end != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (errline != NULL);
	g_return_if_fail (msg_format != NULL);
	_tmp0_ = self->priv->_stream;
	_tmp1_ = self->priv->locus_color_start;
	_tmp2_ = self->priv->locus_color_end;
	fprintf (_tmp0_, "%s%s:%lu.%lu-%lu.%lu:%s %s%s:%s ", _tmp1_, file, (gulong) line, (gulong) startpos, (gulong) line, (gulong) endpos, _tmp2_, type_color_start, type, type_color_end);
	_tmp3_ = g_strdup_vprintf (msg_format, args);
	_tmp4_ = _tmp3_;
	valadoc_error_reporter_print_highlighted_message (self, _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = self->priv->_stream;
	fputc ('\n', _tmp5_);
	if (startpos <= endpos) {
		FILE* _tmp6_;
		FILE* _tmp7_;
		const gchar* _tmp8_;
		FILE* _tmp19_;
		const gchar* _tmp20_;
		FILE* _tmp21_;
		_tmp6_ = self->priv->_stream;
		fprintf (_tmp6_, "%s\n", errline);
		_tmp7_ = self->priv->_stream;
		_tmp8_ = self->priv->caret_color_start;
		fputs (_tmp8_, _tmp7_);
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp9_ = FALSE;
				_tmp9_ = TRUE;
				while (TRUE) {
					gint _tmp11_;
					gint _tmp12_;
					if (!_tmp9_) {
						gint _tmp10_;
						_tmp10_ = i;
						i = _tmp10_ + 1;
					}
					_tmp9_ = FALSE;
					_tmp11_ = i;
					if (!(_tmp11_ < (g_utf8_strlen (errline, (gssize) -1) + 1))) {
						break;
					}
					_tmp12_ = i;
					if (string_get (errline, (glong) _tmp12_) == '\t') {
						FILE* _tmp13_;
						_tmp13_ = self->priv->_stream;
						fprintf (_tmp13_, "\t");
					} else {
						gboolean _tmp14_ = FALSE;
						gint _tmp15_;
						_tmp15_ = i;
						if (((glong) _tmp15_) >= (startpos - 1)) {
							gint _tmp16_;
							_tmp16_ = i;
							_tmp14_ = ((glong) _tmp16_) < (endpos - 1);
						} else {
							_tmp14_ = FALSE;
						}
						if (_tmp14_) {
							FILE* _tmp17_;
							_tmp17_ = self->priv->_stream;
							fprintf (_tmp17_, "^");
						} else {
							FILE* _tmp18_;
							_tmp18_ = self->priv->_stream;
							fprintf (_tmp18_, " ");
						}
					}
				}
			}
		}
		_tmp19_ = self->priv->_stream;
		_tmp20_ = self->priv->caret_color_end;
		fputs (_tmp20_, _tmp19_);
		_tmp21_ = self->priv->_stream;
		fprintf (_tmp21_, "\n");
	}
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static const gchar*
string_offset (const gchar* self,
               glong offset)
{
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = (const gchar*) (((gchar*) self) + offset);
	return result;
}


static void
valadoc_error_reporter_print_highlighted_message (ValadocErrorReporter* self,
                                                  const gchar* message)
{
	gint start = 0;
	gint cur = 0;
	FILE* _tmp38_;
	gint _tmp39_;
	const gchar* _tmp40_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	start = 0;
	cur = 0;
	while (TRUE) {
		gint _tmp0_;
		gboolean _tmp1_ = FALSE;
		gint _tmp2_;
		_tmp0_ = cur;
		if (!(string_get (message, (glong) _tmp0_) != '\0')) {
			break;
		}
		_tmp2_ = cur;
		if (string_get (message, (glong) _tmp2_) == '\'') {
			_tmp1_ = TRUE;
		} else {
			gint _tmp3_;
			_tmp3_ = cur;
			_tmp1_ = string_get (message, (glong) _tmp3_) == '`';
		}
		if (_tmp1_) {
			const gchar* _tmp4_ = NULL;
			gint _tmp5_;
			const gchar* end_chars = NULL;
			FILE* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			gint _tmp19_;
			_tmp5_ = cur;
			if (string_get (message, (glong) _tmp5_) == '`') {
				_tmp4_ = "`'";
			} else {
				_tmp4_ = "'";
			}
			end_chars = _tmp4_;
			_tmp6_ = self->priv->_stream;
			_tmp7_ = start;
			_tmp8_ = cur;
			_tmp9_ = start;
			_tmp10_ = string_substring (message, (glong) _tmp7_, (glong) (_tmp8_ - _tmp9_));
			_tmp11_ = _tmp10_;
			fputs (_tmp11_, _tmp6_);
			_g_free0 (_tmp11_);
			_tmp12_ = cur;
			start = _tmp12_;
			_tmp13_ = cur;
			cur = _tmp13_ + 1;
			while (TRUE) {
				gboolean _tmp14_ = FALSE;
				gint _tmp15_;
				gint _tmp18_;
				_tmp15_ = cur;
				if (string_get (message, (glong) _tmp15_) != '\0') {
					const gchar* _tmp16_;
					gint _tmp17_;
					_tmp16_ = end_chars;
					_tmp17_ = cur;
					_tmp14_ = string_index_of_char (_tmp16_, (gunichar) string_get (message, (glong) _tmp17_), 0) < 0;
				} else {
					_tmp14_ = FALSE;
				}
				if (!_tmp14_) {
					break;
				}
				_tmp18_ = cur;
				cur = _tmp18_ + 1;
			}
			_tmp19_ = cur;
			if (string_get (message, (glong) _tmp19_) == '\0') {
				FILE* _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				gint _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gint _tmp26_;
				_tmp20_ = self->priv->_stream;
				_tmp21_ = start;
				_tmp22_ = cur;
				_tmp23_ = start;
				_tmp24_ = string_substring (message, (glong) _tmp21_, (glong) (_tmp22_ - _tmp23_));
				_tmp25_ = _tmp24_;
				fputs (_tmp25_, _tmp20_);
				_g_free0 (_tmp25_);
				_tmp26_ = cur;
				start = _tmp26_;
			} else {
				gint _tmp27_;
				FILE* _tmp28_;
				const gchar* _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				const gchar* _tmp35_;
				gint _tmp36_;
				_tmp27_ = cur;
				cur = _tmp27_ + 1;
				_tmp28_ = self->priv->_stream;
				_tmp29_ = self->priv->quote_color_start;
				_tmp30_ = start;
				_tmp31_ = cur;
				_tmp32_ = start;
				_tmp33_ = string_substring (message, (glong) _tmp30_, (glong) (_tmp31_ - _tmp32_));
				_tmp34_ = _tmp33_;
				_tmp35_ = self->priv->quote_color_end;
				fprintf (_tmp28_, "%s%s%s", _tmp29_, _tmp34_, _tmp35_);
				_g_free0 (_tmp34_);
				_tmp36_ = cur;
				start = _tmp36_;
			}
		} else {
			gint _tmp37_;
			_tmp37_ = cur;
			cur = _tmp37_ + 1;
		}
	}
	_tmp38_ = self->priv->_stream;
	_tmp39_ = start;
	_tmp40_ = string_offset (message, (glong) _tmp39_);
	fputs (_tmp40_, _tmp38_);
}


void
valadoc_error_reporter_simple_warning (ValadocErrorReporter* self,
                                       const gchar* location,
                                       const gchar* msg_format,
                                       ...)
{
	va_list args = {0};
	FILE* _tmp6_;
	const gchar* _tmp7_;
	FILE* _tmp8_;
	FILE* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	FILE* _tmp13_;
	gint _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg_format != NULL);
	va_start (args, msg_format);
	if (location != NULL) {
		FILE* _tmp0_;
		const gchar* _tmp1_;
		FILE* _tmp2_;
		FILE* _tmp3_;
		FILE* _tmp4_;
		const gchar* _tmp5_;
		_tmp0_ = self->priv->_stream;
		_tmp1_ = self->priv->locus_color_start;
		fputs (_tmp1_, _tmp0_);
		_tmp2_ = self->priv->_stream;
		fputs (location, _tmp2_);
		_tmp3_ = self->priv->_stream;
		fputs (": ", _tmp3_);
		_tmp4_ = self->priv->_stream;
		_tmp5_ = self->priv->locus_color_end;
		fputs (_tmp5_, _tmp4_);
	}
	_tmp6_ = self->priv->_stream;
	_tmp7_ = self->priv->warning_color_start;
	fputs (_tmp7_, _tmp6_);
	_tmp8_ = self->priv->_stream;
	fputs ("warning: ", _tmp8_);
	_tmp9_ = self->priv->_stream;
	_tmp10_ = self->priv->warning_color_end;
	fputs (_tmp10_, _tmp9_);
	_tmp11_ = g_strdup_vprintf (msg_format, args);
	_tmp12_ = _tmp11_;
	valadoc_error_reporter_print_highlighted_message (self, _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = self->priv->_stream;
	fputc ('\n', _tmp13_);
	_tmp14_ = self->priv->_warnings;
	self->priv->_warnings = _tmp14_ + 1;
	va_end (args);
}


void
valadoc_error_reporter_simple_error (ValadocErrorReporter* self,
                                     const gchar* location,
                                     const gchar* msg_format,
                                     ...)
{
	va_list args = {0};
	FILE* _tmp7_;
	const gchar* _tmp8_;
	FILE* _tmp9_;
	FILE* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	FILE* _tmp14_;
	gint _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg_format != NULL);
	va_start (args, msg_format);
	if (location != NULL) {
		FILE* _tmp0_;
		const gchar* _tmp1_;
		FILE* _tmp2_;
		FILE* _tmp3_;
		FILE* _tmp4_;
		const gchar* _tmp5_;
		FILE* _tmp6_;
		_tmp0_ = self->priv->_stream;
		_tmp1_ = self->priv->locus_color_start;
		fputs (_tmp1_, _tmp0_);
		_tmp2_ = self->priv->_stream;
		fputs (location, _tmp2_);
		_tmp3_ = self->priv->_stream;
		fputs (": ", _tmp3_);
		_tmp4_ = self->priv->_stream;
		_tmp5_ = self->priv->locus_color_end;
		fputs (_tmp5_, _tmp4_);
		_tmp6_ = self->priv->_stream;
		fputc (' ', _tmp6_);
	}
	_tmp7_ = self->priv->_stream;
	_tmp8_ = self->priv->error_color_start;
	fputs (_tmp8_, _tmp7_);
	_tmp9_ = self->priv->_stream;
	fputs ("error: ", _tmp9_);
	_tmp10_ = self->priv->_stream;
	_tmp11_ = self->priv->error_color_end;
	fputs (_tmp11_, _tmp10_);
	_tmp12_ = g_strdup_vprintf (msg_format, args);
	_tmp13_ = _tmp12_;
	valadoc_error_reporter_print_highlighted_message (self, _tmp13_);
	_g_free0 (_tmp13_);
	_tmp14_ = self->priv->_stream;
	fputc ('\n', _tmp14_);
	_tmp15_ = self->priv->_errors;
	self->priv->_errors = _tmp15_ + 1;
	va_end (args);
}


void
valadoc_error_reporter_simple_note (ValadocErrorReporter* self,
                                    const gchar* location,
                                    const gchar* msg_format,
                                    ...)
{
	gboolean _tmp0_ = FALSE;
	ValadocSettings* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg_format != NULL);
	_tmp1_ = self->priv->_settings;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValadocSettings* _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = self->priv->_settings;
		_tmp3_ = _tmp2_->verbose;
		_tmp0_ = _tmp3_;
	}
	if (_tmp0_) {
		va_list args = {0};
		FILE* _tmp11_;
		const gchar* _tmp12_;
		FILE* _tmp13_;
		FILE* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		FILE* _tmp18_;
		gint _tmp19_;
		va_start (args, msg_format);
		if (location != NULL) {
			FILE* _tmp4_;
			const gchar* _tmp5_;
			FILE* _tmp6_;
			FILE* _tmp7_;
			FILE* _tmp8_;
			const gchar* _tmp9_;
			FILE* _tmp10_;
			_tmp4_ = self->priv->_stream;
			_tmp5_ = self->priv->locus_color_start;
			fputs (_tmp5_, _tmp4_);
			_tmp6_ = self->priv->_stream;
			fputs (location, _tmp6_);
			_tmp7_ = self->priv->_stream;
			fputs (": ", _tmp7_);
			_tmp8_ = self->priv->_stream;
			_tmp9_ = self->priv->locus_color_end;
			fputs (_tmp9_, _tmp8_);
			_tmp10_ = self->priv->_stream;
			fputc (' ', _tmp10_);
		}
		_tmp11_ = self->priv->_stream;
		_tmp12_ = self->priv->note_color_start;
		fputs (_tmp12_, _tmp11_);
		_tmp13_ = self->priv->_stream;
		fputs ("note: ", _tmp13_);
		_tmp14_ = self->priv->_stream;
		_tmp15_ = self->priv->note_color_end;
		fputs (_tmp15_, _tmp14_);
		_tmp16_ = g_strdup_vprintf (msg_format, args);
		_tmp17_ = _tmp16_;
		valadoc_error_reporter_print_highlighted_message (self, _tmp17_);
		_g_free0 (_tmp17_);
		_tmp18_ = self->priv->_stream;
		fputc ('\n', _tmp18_);
		_tmp19_ = self->priv->_warnings;
		self->priv->_warnings = _tmp19_ + 1;
		va_end (args);
	}
}


void
valadoc_error_reporter_error (ValadocErrorReporter* self,
                              const gchar* file,
                              glong line,
                              glong startpos,
                              glong endpos,
                              const gchar* errline,
                              const gchar* msg_format,
                              ...)
{
	va_list args = {0};
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (errline != NULL);
	g_return_if_fail (msg_format != NULL);
	va_start (args, msg_format);
	_tmp0_ = self->priv->error_color_start;
	_tmp1_ = self->priv->error_color_end;
	valadoc_error_reporter_msg (self, "error", _tmp0_, _tmp1_, file, line, startpos, endpos, errline, msg_format, args);
	_tmp2_ = self->priv->_errors;
	self->priv->_errors = _tmp2_ + 1;
	va_end (args);
}


void
valadoc_error_reporter_warning (ValadocErrorReporter* self,
                                const gchar* file,
                                glong line,
                                glong startpos,
                                glong endpos,
                                const gchar* errline,
                                const gchar* msg_format,
                                ...)
{
	va_list args = {0};
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (errline != NULL);
	g_return_if_fail (msg_format != NULL);
	va_start (args, msg_format);
	_tmp0_ = self->priv->warning_color_start;
	_tmp1_ = self->priv->warning_color_end;
	valadoc_error_reporter_msg (self, "warning", _tmp0_, _tmp1_, file, line, startpos, endpos, errline, msg_format, args);
	_tmp2_ = self->priv->_warnings;
	self->priv->_warnings = _tmp2_ + 1;
	va_end (args);
}


gint
valadoc_error_reporter_get_warnings_offset (ValadocErrorReporter* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_warnings_offset;
	result = _tmp0_;
	return result;
}


void
valadoc_error_reporter_set_warnings_offset (ValadocErrorReporter* self,
                                            gint value)
{
	g_return_if_fail (self != NULL);
	if (valadoc_error_reporter_get_warnings_offset (self) != value) {
		self->priv->_warnings_offset = value;
		g_object_notify_by_pspec ((GObject *) self, valadoc_error_reporter_properties[VALADOC_ERROR_REPORTER_WARNINGS_OFFSET_PROPERTY]);
	}
}


gint
valadoc_error_reporter_get_errors_offset (ValadocErrorReporter* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_errors_offset;
	result = _tmp0_;
	return result;
}


void
valadoc_error_reporter_set_errors_offset (ValadocErrorReporter* self,
                                          gint value)
{
	g_return_if_fail (self != NULL);
	if (valadoc_error_reporter_get_errors_offset (self) != value) {
		self->priv->_errors_offset = value;
		g_object_notify_by_pspec ((GObject *) self, valadoc_error_reporter_properties[VALADOC_ERROR_REPORTER_ERRORS_OFFSET_PROPERTY]);
	}
}


FILE*
valadoc_error_reporter_get_stream (ValadocErrorReporter* self)
{
	FILE* result;
	FILE* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_stream;
	result = _tmp0_;
	return result;
}


void
valadoc_error_reporter_set_stream (ValadocErrorReporter* self,
                                   FILE* value)
{
	g_return_if_fail (self != NULL);
	if (valadoc_error_reporter_get_stream (self) != value) {
		self->priv->_stream = value;
		g_object_notify_by_pspec ((GObject *) self, valadoc_error_reporter_properties[VALADOC_ERROR_REPORTER_STREAM_PROPERTY]);
	}
}


ValadocSettings*
valadoc_error_reporter_get_settings (ValadocErrorReporter* self)
{
	ValadocSettings* result;
	ValadocSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	result = _tmp0_;
	return result;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


void
valadoc_error_reporter_set_settings (ValadocErrorReporter* self,
                                     ValadocSettings* value)
{
	g_return_if_fail (self != NULL);
	if (valadoc_error_reporter_get_settings (self) != value) {
		ValadocSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_settings);
		self->priv->_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_error_reporter_properties[VALADOC_ERROR_REPORTER_SETTINGS_PROPERTY]);
	}
}


gint
valadoc_error_reporter_get_errors (ValadocErrorReporter* self)
{
	gint result;
	gint _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_errors;
	_tmp1_ = self->priv->_errors_offset;
	result = _tmp0_ + _tmp1_;
	return result;
}


gint
valadoc_error_reporter_get_warnings (ValadocErrorReporter* self)
{
	gint result;
	gint _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_warnings;
	_tmp1_ = self->priv->_warnings_offset;
	result = _tmp0_ + _tmp1_;
	return result;
}


static void
valadoc_error_reporter_class_init (ValadocErrorReporterClass * klass)
{
	valadoc_error_reporter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValadocErrorReporterPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_valadoc_error_reporter_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_valadoc_error_reporter_set_property;
	G_OBJECT_CLASS (klass)->finalize = valadoc_error_reporter_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_ERROR_REPORTER_WARNINGS_OFFSET_PROPERTY, valadoc_error_reporter_properties[VALADOC_ERROR_REPORTER_WARNINGS_OFFSET_PROPERTY] = g_param_spec_int ("warnings-offset", "warnings-offset", "warnings-offset", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_ERROR_REPORTER_ERRORS_OFFSET_PROPERTY, valadoc_error_reporter_properties[VALADOC_ERROR_REPORTER_ERRORS_OFFSET_PROPERTY] = g_param_spec_int ("errors-offset", "errors-offset", "errors-offset", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_ERROR_REPORTER_STREAM_PROPERTY, valadoc_error_reporter_properties[VALADOC_ERROR_REPORTER_STREAM_PROPERTY] = g_param_spec_pointer ("stream", "stream", "stream", G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_ERROR_REPORTER_SETTINGS_PROPERTY, valadoc_error_reporter_properties[VALADOC_ERROR_REPORTER_SETTINGS_PROPERTY] = g_param_spec_object ("settings", "settings", "settings", VALADOC_TYPE_SETTINGS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_ERROR_REPORTER_ERRORS_PROPERTY, valadoc_error_reporter_properties[VALADOC_ERROR_REPORTER_ERRORS_PROPERTY] = g_param_spec_int ("errors", "errors", "errors", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_ERROR_REPORTER_WARNINGS_PROPERTY, valadoc_error_reporter_properties[VALADOC_ERROR_REPORTER_WARNINGS_PROPERTY] = g_param_spec_int ("warnings", "warnings", "warnings", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}


static void
valadoc_error_reporter_instance_init (ValadocErrorReporter * self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	self->priv = VALADOC_ERROR_REPORTER_GET_PRIVATE (self);
	self->priv->_warnings = 0;
	self->priv->_errors = 0;
	_tmp0_ = g_strdup ("");
	self->priv->locus_color_start = _tmp0_;
	self->priv->locus_color_end = "";
	_tmp1_ = g_strdup ("");
	self->priv->warning_color_start = _tmp1_;
	self->priv->warning_color_end = "";
	_tmp2_ = g_strdup ("");
	self->priv->error_color_start = _tmp2_;
	self->priv->error_color_end = "";
	_tmp3_ = g_strdup ("");
	self->priv->note_color_start = _tmp3_;
	self->priv->note_color_end = "";
	_tmp4_ = g_strdup ("");
	self->priv->caret_color_start = _tmp4_;
	self->priv->caret_color_end = "";
	_tmp5_ = g_strdup ("");
	self->priv->quote_color_start = _tmp5_;
	self->priv->quote_color_end = "";
}


static void
valadoc_error_reporter_finalize (GObject * obj)
{
	ValadocErrorReporter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_TYPE_ERROR_REPORTER, ValadocErrorReporter);
	_g_free0 (self->priv->locus_color_start);
	_g_free0 (self->priv->warning_color_start);
	_g_free0 (self->priv->error_color_start);
	_g_free0 (self->priv->note_color_start);
	_g_free0 (self->priv->caret_color_start);
	_g_free0 (self->priv->quote_color_start);
	_g_object_unref0 (self->priv->_settings);
	G_OBJECT_CLASS (valadoc_error_reporter_parent_class)->finalize (obj);
}


GType
valadoc_error_reporter_get_type (void)
{
	static volatile gsize valadoc_error_reporter_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_error_reporter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValadocErrorReporterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_error_reporter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocErrorReporter), 0, (GInstanceInitFunc) valadoc_error_reporter_instance_init, NULL };
		GType valadoc_error_reporter_type_id;
		valadoc_error_reporter_type_id = g_type_register_static (G_TYPE_OBJECT, "ValadocErrorReporter", &g_define_type_info, 0);
		g_once_init_leave (&valadoc_error_reporter_type_id__volatile, valadoc_error_reporter_type_id);
	}
	return valadoc_error_reporter_type_id__volatile;
}


static void
_vala_valadoc_error_reporter_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	ValadocErrorReporter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_TYPE_ERROR_REPORTER, ValadocErrorReporter);
	switch (property_id) {
		case VALADOC_ERROR_REPORTER_WARNINGS_OFFSET_PROPERTY:
		g_value_set_int (value, valadoc_error_reporter_get_warnings_offset (self));
		break;
		case VALADOC_ERROR_REPORTER_ERRORS_OFFSET_PROPERTY:
		g_value_set_int (value, valadoc_error_reporter_get_errors_offset (self));
		break;
		case VALADOC_ERROR_REPORTER_STREAM_PROPERTY:
		g_value_set_pointer (value, valadoc_error_reporter_get_stream (self));
		break;
		case VALADOC_ERROR_REPORTER_SETTINGS_PROPERTY:
		g_value_set_object (value, valadoc_error_reporter_get_settings (self));
		break;
		case VALADOC_ERROR_REPORTER_ERRORS_PROPERTY:
		g_value_set_int (value, valadoc_error_reporter_get_errors (self));
		break;
		case VALADOC_ERROR_REPORTER_WARNINGS_PROPERTY:
		g_value_set_int (value, valadoc_error_reporter_get_warnings (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_valadoc_error_reporter_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	ValadocErrorReporter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_TYPE_ERROR_REPORTER, ValadocErrorReporter);
	switch (property_id) {
		case VALADOC_ERROR_REPORTER_WARNINGS_OFFSET_PROPERTY:
		valadoc_error_reporter_set_warnings_offset (self, g_value_get_int (value));
		break;
		case VALADOC_ERROR_REPORTER_ERRORS_OFFSET_PROPERTY:
		valadoc_error_reporter_set_errors_offset (self, g_value_get_int (value));
		break;
		case VALADOC_ERROR_REPORTER_STREAM_PROPERTY:
		valadoc_error_reporter_set_stream (self, g_value_get_pointer (value));
		break;
		case VALADOC_ERROR_REPORTER_SETTINGS_PROPERTY:
		valadoc_error_reporter_set_settings (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



