/* valaccodefile.c generated by valac, the Vala compiler
 * generated from valaccodefile.vala, do not modify */

/* valaccodefile.vala
 *
 * Copyright (C) 2009-2011  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "valaccode.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <vala.h>
#include <gobject/gvaluecollector.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_ccode_writer_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_writer_unref (var), NULL)))
typedef struct _ValaParamSpecCCodeFile ValaParamSpecCCodeFile;

struct _ValaCCodeFilePrivate {
	gboolean _is_header;
	ValaSet* features;
	ValaSet* declarations;
	ValaSet* definitions;
	ValaSet* includes;
	ValaCCodeFragment* comments;
	ValaCCodeFragment* feature_test_macros;
	ValaCCodeFragment* include_directives;
	ValaCCodeFragment* type_declaration;
	ValaCCodeFragment* type_definition;
	ValaCCodeFragment* type_member_declaration;
	ValaCCodeFragment* constant_declaration;
	ValaCCodeFragment* type_member_definition;
};

struct _ValaParamSpecCCodeFile {
	GParamSpec parent_instance;
};


static gpointer vala_ccode_file_parent_class = NULL;

#define VALA_CCODE_FILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_FILE, ValaCCodeFilePrivate))
static void vala_ccode_file_get_symbols_from_fragment (ValaCCodeFile* self,
                                                ValaList* symbols,
                                                ValaCCodeFragment* fragment);
static gchar* vala_ccode_file_get_define_for_filename (const gchar* filename);
static void vala_ccode_file_finalize (ValaCCodeFile * obj);


gboolean
vala_ccode_file_add_declaration (ValaCCodeFile* self,
                                 const gchar* name)
{
	gboolean result = FALSE;
	ValaSet* _tmp0_;
	ValaSet* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = self->priv->declarations;
	if (vala_collection_contains ((ValaCollection*) _tmp0_, name)) {
		result = TRUE;
		return result;
	}
	_tmp1_ = self->priv->declarations;
	vala_collection_add ((ValaCollection*) _tmp1_, name);
	result = FALSE;
	return result;
}


void
vala_ccode_file_add_comment (ValaCCodeFile* self,
                             ValaCCodeComment* comment)
{
	ValaCCodeFragment* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (comment != NULL);
	_tmp0_ = self->priv->comments;
	vala_ccode_fragment_append (_tmp0_, (ValaCCodeNode*) comment);
}


void
vala_ccode_file_add_feature_test_macro (ValaCCodeFile* self,
                                        const gchar* feature_test_macro)
{
	ValaSet* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (feature_test_macro != NULL);
	_tmp0_ = self->priv->features;
	if (!vala_collection_contains ((ValaCollection*) _tmp0_, feature_test_macro)) {
		ValaCCodeFragment* _tmp1_;
		ValaCCodeFeatureTestMacro* _tmp2_;
		ValaCCodeFeatureTestMacro* _tmp3_;
		ValaSet* _tmp4_;
		_tmp1_ = self->priv->feature_test_macros;
		_tmp2_ = vala_ccode_feature_test_macro_new (feature_test_macro);
		_tmp3_ = _tmp2_;
		vala_ccode_fragment_append (_tmp1_, (ValaCCodeNode*) _tmp3_);
		_vala_ccode_node_unref0 (_tmp3_);
		_tmp4_ = self->priv->features;
		vala_collection_add ((ValaCollection*) _tmp4_, feature_test_macro);
	}
}


void
vala_ccode_file_add_include (ValaCCodeFile* self,
                             const gchar* filename,
                             gboolean local)
{
	ValaSet* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_tmp0_ = self->priv->includes;
	if (!vala_collection_contains ((ValaCollection*) _tmp0_, filename)) {
		ValaCCodeFragment* _tmp1_;
		ValaCCodeIncludeDirective* _tmp2_;
		ValaCCodeIncludeDirective* _tmp3_;
		ValaSet* _tmp4_;
		_tmp1_ = self->priv->include_directives;
		_tmp2_ = vala_ccode_include_directive_new (filename, local);
		_tmp3_ = _tmp2_;
		vala_ccode_fragment_append (_tmp1_, (ValaCCodeNode*) _tmp3_);
		_vala_ccode_node_unref0 (_tmp3_);
		_tmp4_ = self->priv->includes;
		vala_collection_add ((ValaCollection*) _tmp4_, filename);
	}
}


void
vala_ccode_file_add_type_declaration (ValaCCodeFile* self,
                                      ValaCCodeNode* node)
{
	ValaCCodeFragment* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->priv->type_declaration;
	vala_ccode_fragment_append (_tmp0_, node);
}


void
vala_ccode_file_add_type_definition (ValaCCodeFile* self,
                                     ValaCCodeNode* node)
{
	ValaCCodeFragment* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->priv->type_definition;
	vala_ccode_fragment_append (_tmp0_, node);
}


void
vala_ccode_file_add_type_member_declaration (ValaCCodeFile* self,
                                             ValaCCodeNode* node)
{
	ValaCCodeFragment* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->priv->type_member_declaration;
	vala_ccode_fragment_append (_tmp0_, node);
}


void
vala_ccode_file_add_constant_declaration (ValaCCodeFile* self,
                                          ValaCCodeNode* node)
{
	ValaCCodeFragment* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->priv->constant_declaration;
	vala_ccode_fragment_append (_tmp0_, node);
}


void
vala_ccode_file_add_type_member_definition (ValaCCodeFile* self,
                                            ValaCCodeNode* node)
{
	ValaCCodeFragment* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->priv->type_member_definition;
	vala_ccode_fragment_append (_tmp0_, node);
}


void
vala_ccode_file_add_function_declaration (ValaCCodeFile* self,
                                          ValaCCodeFunction* func)
{
	ValaSet* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	ValaCCodeFunction* decl = NULL;
	ValaCCodeFunction* _tmp3_;
	ValaCCodeFragment* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (func != NULL);
	_tmp0_ = self->priv->declarations;
	_tmp1_ = vala_ccode_function_get_name (func);
	_tmp2_ = _tmp1_;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp2_);
	_tmp3_ = vala_ccode_function_copy (func);
	decl = _tmp3_;
	vala_ccode_function_set_is_declaration (decl, TRUE);
	_tmp4_ = self->priv->type_member_declaration;
	vala_ccode_fragment_append (_tmp4_, (ValaCCodeNode*) decl);
	_vala_ccode_node_unref0 (decl);
}


void
vala_ccode_file_add_function (ValaCCodeFile* self,
                              ValaCCodeFunction* func)
{
	ValaSet* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	ValaCCodeFragment* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (func != NULL);
	_tmp0_ = self->priv->definitions;
	_tmp1_ = vala_ccode_function_get_name (func);
	_tmp2_ = _tmp1_;
	if (!vala_collection_add ((ValaCollection*) _tmp0_, _tmp2_)) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp3_ = vala_ccode_function_get_name (func);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("internal: Redefinition of `%s'", _tmp4_);
		_tmp6_ = _tmp5_;
		vala_report_error (NULL, _tmp6_);
		_g_free0 (_tmp6_);
		return;
	}
	_tmp7_ = self->priv->type_member_definition;
	vala_ccode_fragment_append (_tmp7_, (ValaCCodeNode*) func);
}


ValaList*
vala_ccode_file_get_symbols (ValaCCodeFile* self)
{
	ValaList* result = NULL;
	ValaArrayList* symbols = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	ValaCCodeFragment* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp0_);
	symbols = _tmp1_;
	_tmp2_ = self->priv->type_member_declaration;
	vala_ccode_file_get_symbols_from_fragment (self, (ValaList*) symbols, _tmp2_);
	result = (ValaList*) symbols;
	return result;
}


static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}


static void
vala_ccode_file_get_symbols_from_fragment (ValaCCodeFile* self,
                                           ValaList* symbols,
                                           ValaCCodeFragment* fragment)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbols != NULL);
	g_return_if_fail (fragment != NULL);
	{
		ValaList* _node_list = NULL;
		ValaList* _tmp0_;
		gint _node_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _node_index = 0;
		_tmp0_ = vala_ccode_fragment_get_children (fragment);
		_node_list = _tmp0_;
		_tmp1_ = _node_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_node_size = _tmp3_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaCCodeNode* node = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaCCodeNode* _tmp10_;
			_tmp4_ = _node_index;
			_node_index = _tmp4_ + 1;
			_tmp5_ = _node_index;
			_tmp6_ = _node_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _node_list;
			_tmp8_ = _node_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			node = (ValaCCodeNode*) _tmp9_;
			_tmp10_ = node;
			if (VALA_IS_CCODE_FRAGMENT (_tmp10_)) {
				ValaCCodeNode* _tmp11_;
				_tmp11_ = node;
				vala_ccode_file_get_symbols_from_fragment (self, symbols, G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALA_TYPE_CCODE_FRAGMENT, ValaCCodeFragment));
			} else {
				ValaCCodeFunction* func = NULL;
				ValaCCodeNode* _tmp12_;
				ValaCCodeFunction* _tmp13_;
				ValaCCodeFunction* _tmp14_;
				_tmp12_ = node;
				_tmp13_ = _vala_ccode_node_ref0 (VALA_IS_CCODE_FUNCTION (_tmp12_) ? ((ValaCCodeFunction*) _tmp12_) : NULL);
				func = _tmp13_;
				_tmp14_ = func;
				if (_tmp14_ != NULL) {
					ValaCCodeFunction* _tmp15_;
					const gchar* _tmp16_;
					const gchar* _tmp17_;
					_tmp15_ = func;
					_tmp16_ = vala_ccode_function_get_name (_tmp15_);
					_tmp17_ = _tmp16_;
					vala_collection_add ((ValaCollection*) symbols, _tmp17_);
				}
				_vala_ccode_node_unref0 (func);
			}
			_vala_ccode_node_unref0 (node);
		}
		_vala_iterable_unref0 (_node_list);
	}
}


static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}


static gchar*
vala_ccode_file_get_define_for_filename (const gchar* filename)
{
	gchar* result = NULL;
	GString* define = NULL;
	GString* _tmp0_;
	gchar* i = NULL;
	gchar* _tmp1_;
	GString* _tmp15_;
	GString* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp0_ = g_string_new ("__");
	define = _tmp0_;
	_tmp1_ = g_strdup (filename);
	i = _tmp1_;
	while (TRUE) {
		const gchar* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gunichar c = 0U;
		const gchar* _tmp5_;
		gboolean _tmp6_ = FALSE;
		gunichar _tmp7_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp2_ = i;
		_tmp3_ = strlen (_tmp2_);
		_tmp4_ = _tmp3_;
		if (!(_tmp4_ > 0)) {
			break;
		}
		_tmp5_ = i;
		c = string_get_char (_tmp5_, (glong) 0);
		_tmp7_ = c;
		if (g_unichar_isalnum (_tmp7_)) {
			gunichar _tmp8_;
			_tmp8_ = c;
			_tmp6_ = _tmp8_ < ((gunichar) 0x80);
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			GString* _tmp9_;
			gunichar _tmp10_;
			_tmp9_ = define;
			_tmp10_ = c;
			g_string_append_unichar (_tmp9_, g_unichar_toupper (_tmp10_));
		} else {
			GString* _tmp11_;
			_tmp11_ = define;
			g_string_append_c (_tmp11_, '_');
		}
		_tmp12_ = i;
		_tmp13_ = g_utf8_next_char (_tmp12_);
		_tmp14_ = g_strdup (_tmp13_);
		_g_free0 (i);
		i = _tmp14_;
	}
	_tmp15_ = define;
	g_string_append (_tmp15_, "__");
	_tmp16_ = define;
	_tmp17_ = _tmp16_->str;
	_tmp18_ = g_strdup (_tmp17_);
	result = _tmp18_;
	_g_free0 (i);
	_g_string_free0 (define);
	return result;
}


gboolean
vala_ccode_file_store (ValaCCodeFile* self,
                       const gchar* filename,
                       const gchar* source_filename,
                       gboolean write_version,
                       gboolean line_directives,
                       const gchar* begin_decls,
                       const gchar* end_decls)
{
	gboolean result = FALSE;
	ValaCCodeWriter* writer = NULL;
	ValaCCodeWriter* _tmp0_;
	ValaCCodeWriter* _tmp1_;
	gboolean _tmp2_;
	ValaCCodeWriter* _tmp87_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (filename != NULL, FALSE);
	_tmp0_ = vala_ccode_writer_new (filename, source_filename);
	writer = _tmp0_;
	_tmp1_ = writer;
	if (!vala_ccode_writer_open (_tmp1_, write_version)) {
		result = FALSE;
		_vala_ccode_writer_unref0 (writer);
		return result;
	}
	_tmp2_ = self->priv->_is_header;
	if (!_tmp2_) {
		ValaCCodeWriter* _tmp3_;
		ValaCCodeFragment* _tmp4_;
		ValaCCodeWriter* _tmp5_;
		ValaCCodeWriter* _tmp6_;
		ValaCCodeFragment* _tmp7_;
		ValaCCodeWriter* _tmp8_;
		ValaCCodeWriter* _tmp9_;
		ValaCCodeFragment* _tmp10_;
		ValaCCodeWriter* _tmp11_;
		ValaCCodeWriter* _tmp12_;
		ValaCCodeFragment* _tmp13_;
		ValaCCodeWriter* _tmp14_;
		ValaCCodeWriter* _tmp15_;
		ValaCCodeFragment* _tmp16_;
		ValaCCodeWriter* _tmp17_;
		ValaCCodeWriter* _tmp18_;
		ValaCCodeFragment* _tmp19_;
		ValaCCodeWriter* _tmp20_;
		ValaCCodeWriter* _tmp21_;
		ValaCCodeFragment* _tmp22_;
		ValaCCodeWriter* _tmp23_;
		ValaCCodeWriter* _tmp24_;
		ValaCCodeFragment* _tmp25_;
		ValaCCodeWriter* _tmp26_;
		ValaCCodeWriter* _tmp27_;
		ValaCCodeFragment* _tmp28_;
		ValaCCodeWriter* _tmp29_;
		ValaCCodeWriter* _tmp30_;
		_tmp3_ = writer;
		vala_ccode_writer_set_line_directives (_tmp3_, line_directives);
		_tmp4_ = self->priv->comments;
		_tmp5_ = writer;
		vala_ccode_node_write ((ValaCCodeNode*) _tmp4_, _tmp5_);
		_tmp6_ = writer;
		vala_ccode_writer_write_newline (_tmp6_);
		_tmp7_ = self->priv->feature_test_macros;
		_tmp8_ = writer;
		vala_ccode_node_write ((ValaCCodeNode*) _tmp7_, _tmp8_);
		_tmp9_ = writer;
		vala_ccode_writer_write_newline (_tmp9_);
		_tmp10_ = self->priv->include_directives;
		_tmp11_ = writer;
		vala_ccode_node_write ((ValaCCodeNode*) _tmp10_, _tmp11_);
		_tmp12_ = writer;
		vala_ccode_writer_write_newline (_tmp12_);
		_tmp13_ = self->priv->type_declaration;
		_tmp14_ = writer;
		vala_ccode_node_write_combined ((ValaCCodeNode*) _tmp13_, _tmp14_);
		_tmp15_ = writer;
		vala_ccode_writer_write_newline (_tmp15_);
		_tmp16_ = self->priv->type_definition;
		_tmp17_ = writer;
		vala_ccode_node_write_combined ((ValaCCodeNode*) _tmp16_, _tmp17_);
		_tmp18_ = writer;
		vala_ccode_writer_write_newline (_tmp18_);
		_tmp19_ = self->priv->type_member_declaration;
		_tmp20_ = writer;
		vala_ccode_node_write_declaration ((ValaCCodeNode*) _tmp19_, _tmp20_);
		_tmp21_ = writer;
		vala_ccode_writer_write_newline (_tmp21_);
		_tmp22_ = self->priv->type_member_declaration;
		_tmp23_ = writer;
		vala_ccode_node_write ((ValaCCodeNode*) _tmp22_, _tmp23_);
		_tmp24_ = writer;
		vala_ccode_writer_write_newline (_tmp24_);
		_tmp25_ = self->priv->constant_declaration;
		_tmp26_ = writer;
		vala_ccode_node_write_combined ((ValaCCodeNode*) _tmp25_, _tmp26_);
		_tmp27_ = writer;
		vala_ccode_writer_write_newline (_tmp27_);
		_tmp28_ = self->priv->type_member_definition;
		_tmp29_ = writer;
		vala_ccode_node_write ((ValaCCodeNode*) _tmp28_, _tmp29_);
		_tmp30_ = writer;
		vala_ccode_writer_write_newline (_tmp30_);
	} else {
		ValaCCodeWriter* _tmp31_;
		ValaCCodeOnceSection* once = NULL;
		ValaCCodeWriter* _tmp32_;
		const gchar* _tmp33_;
		const gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		ValaCCodeOnceSection* _tmp37_;
		ValaCCodeOnceSection* _tmp38_;
		ValaCCodeOnceSection* _tmp39_;
		ValaCCodeNewline* _tmp40_;
		ValaCCodeNewline* _tmp41_;
		ValaCCodeOnceSection* _tmp42_;
		ValaCCodeFragment* _tmp43_;
		ValaCCodeOnceSection* _tmp44_;
		ValaCCodeNewline* _tmp45_;
		ValaCCodeNewline* _tmp46_;
		ValaCCodeOnceSection* _tmp53_;
		ValaCCodeNewline* _tmp54_;
		ValaCCodeNewline* _tmp55_;
		ValaCCodeOnceSection* _tmp56_;
		ValaCCodeFragment* _tmp57_;
		ValaCCodeOnceSection* _tmp58_;
		ValaCCodeNewline* _tmp59_;
		ValaCCodeNewline* _tmp60_;
		ValaCCodeOnceSection* _tmp61_;
		ValaCCodeFragment* _tmp62_;
		ValaCCodeOnceSection* _tmp63_;
		ValaCCodeNewline* _tmp64_;
		ValaCCodeNewline* _tmp65_;
		ValaCCodeOnceSection* _tmp66_;
		ValaCCodeFragment* _tmp67_;
		ValaCCodeOnceSection* _tmp68_;
		ValaCCodeNewline* _tmp69_;
		ValaCCodeNewline* _tmp70_;
		ValaCCodeOnceSection* _tmp71_;
		ValaCCodeFragment* _tmp72_;
		ValaCCodeOnceSection* _tmp73_;
		ValaCCodeNewline* _tmp74_;
		ValaCCodeNewline* _tmp75_;
		ValaCCodeOnceSection* _tmp82_;
		ValaCCodeNewline* _tmp83_;
		ValaCCodeNewline* _tmp84_;
		ValaCCodeOnceSection* _tmp85_;
		ValaCCodeWriter* _tmp86_;
		_tmp31_ = writer;
		vala_ccode_writer_write_newline (_tmp31_);
		_tmp32_ = writer;
		_tmp33_ = vala_ccode_writer_get_filename (_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = vala_ccode_file_get_define_for_filename (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = vala_ccode_once_section_new (_tmp36_);
		_tmp38_ = _tmp37_;
		_g_free0 (_tmp36_);
		once = _tmp38_;
		_tmp39_ = once;
		_tmp40_ = vala_ccode_newline_new ();
		_tmp41_ = _tmp40_;
		vala_ccode_fragment_append ((ValaCCodeFragment*) _tmp39_, (ValaCCodeNode*) _tmp41_);
		_vala_ccode_node_unref0 (_tmp41_);
		_tmp42_ = once;
		_tmp43_ = self->priv->include_directives;
		vala_ccode_fragment_append ((ValaCCodeFragment*) _tmp42_, (ValaCCodeNode*) _tmp43_);
		_tmp44_ = once;
		_tmp45_ = vala_ccode_newline_new ();
		_tmp46_ = _tmp45_;
		vala_ccode_fragment_append ((ValaCCodeFragment*) _tmp44_, (ValaCCodeNode*) _tmp46_);
		_vala_ccode_node_unref0 (_tmp46_);
		if (begin_decls != NULL) {
			ValaCCodeOnceSection* _tmp47_;
			ValaCCodeIdentifier* _tmp48_;
			ValaCCodeIdentifier* _tmp49_;
			ValaCCodeOnceSection* _tmp50_;
			ValaCCodeNewline* _tmp51_;
			ValaCCodeNewline* _tmp52_;
			_tmp47_ = once;
			_tmp48_ = vala_ccode_identifier_new (begin_decls);
			_tmp49_ = _tmp48_;
			vala_ccode_fragment_append ((ValaCCodeFragment*) _tmp47_, (ValaCCodeNode*) _tmp49_);
			_vala_ccode_node_unref0 (_tmp49_);
			_tmp50_ = once;
			_tmp51_ = vala_ccode_newline_new ();
			_tmp52_ = _tmp51_;
			vala_ccode_fragment_append ((ValaCCodeFragment*) _tmp50_, (ValaCCodeNode*) _tmp52_);
			_vala_ccode_node_unref0 (_tmp52_);
		}
		_tmp53_ = once;
		_tmp54_ = vala_ccode_newline_new ();
		_tmp55_ = _tmp54_;
		vala_ccode_fragment_append ((ValaCCodeFragment*) _tmp53_, (ValaCCodeNode*) _tmp55_);
		_vala_ccode_node_unref0 (_tmp55_);
		_tmp56_ = once;
		_tmp57_ = self->priv->type_declaration;
		vala_ccode_fragment_append ((ValaCCodeFragment*) _tmp56_, (ValaCCodeNode*) _tmp57_);
		_tmp58_ = once;
		_tmp59_ = vala_ccode_newline_new ();
		_tmp60_ = _tmp59_;
		vala_ccode_fragment_append ((ValaCCodeFragment*) _tmp58_, (ValaCCodeNode*) _tmp60_);
		_vala_ccode_node_unref0 (_tmp60_);
		_tmp61_ = once;
		_tmp62_ = self->priv->type_definition;
		vala_ccode_fragment_append ((ValaCCodeFragment*) _tmp61_, (ValaCCodeNode*) _tmp62_);
		_tmp63_ = once;
		_tmp64_ = vala_ccode_newline_new ();
		_tmp65_ = _tmp64_;
		vala_ccode_fragment_append ((ValaCCodeFragment*) _tmp63_, (ValaCCodeNode*) _tmp65_);
		_vala_ccode_node_unref0 (_tmp65_);
		_tmp66_ = once;
		_tmp67_ = self->priv->type_member_declaration;
		vala_ccode_fragment_append ((ValaCCodeFragment*) _tmp66_, (ValaCCodeNode*) _tmp67_);
		_tmp68_ = once;
		_tmp69_ = vala_ccode_newline_new ();
		_tmp70_ = _tmp69_;
		vala_ccode_fragment_append ((ValaCCodeFragment*) _tmp68_, (ValaCCodeNode*) _tmp70_);
		_vala_ccode_node_unref0 (_tmp70_);
		_tmp71_ = once;
		_tmp72_ = self->priv->constant_declaration;
		vala_ccode_fragment_append ((ValaCCodeFragment*) _tmp71_, (ValaCCodeNode*) _tmp72_);
		_tmp73_ = once;
		_tmp74_ = vala_ccode_newline_new ();
		_tmp75_ = _tmp74_;
		vala_ccode_fragment_append ((ValaCCodeFragment*) _tmp73_, (ValaCCodeNode*) _tmp75_);
		_vala_ccode_node_unref0 (_tmp75_);
		if (end_decls != NULL) {
			ValaCCodeOnceSection* _tmp76_;
			ValaCCodeIdentifier* _tmp77_;
			ValaCCodeIdentifier* _tmp78_;
			ValaCCodeOnceSection* _tmp79_;
			ValaCCodeNewline* _tmp80_;
			ValaCCodeNewline* _tmp81_;
			_tmp76_ = once;
			_tmp77_ = vala_ccode_identifier_new (end_decls);
			_tmp78_ = _tmp77_;
			vala_ccode_fragment_append ((ValaCCodeFragment*) _tmp76_, (ValaCCodeNode*) _tmp78_);
			_vala_ccode_node_unref0 (_tmp78_);
			_tmp79_ = once;
			_tmp80_ = vala_ccode_newline_new ();
			_tmp81_ = _tmp80_;
			vala_ccode_fragment_append ((ValaCCodeFragment*) _tmp79_, (ValaCCodeNode*) _tmp81_);
			_vala_ccode_node_unref0 (_tmp81_);
		}
		_tmp82_ = once;
		_tmp83_ = vala_ccode_newline_new ();
		_tmp84_ = _tmp83_;
		vala_ccode_fragment_append ((ValaCCodeFragment*) _tmp82_, (ValaCCodeNode*) _tmp84_);
		_vala_ccode_node_unref0 (_tmp84_);
		_tmp85_ = once;
		_tmp86_ = writer;
		vala_ccode_node_write ((ValaCCodeNode*) _tmp85_, _tmp86_);
		_vala_ccode_node_unref0 (once);
	}
	_tmp87_ = writer;
	vala_ccode_writer_close (_tmp87_);
	result = TRUE;
	_vala_ccode_writer_unref0 (writer);
	return result;
}


ValaCCodeFile*
vala_ccode_file_construct (GType object_type)
{
	ValaCCodeFile* self = NULL;
	self = (ValaCCodeFile*) g_type_create_instance (object_type);
	return self;
}


ValaCCodeFile*
vala_ccode_file_new (void)
{
	return vala_ccode_file_construct (VALA_TYPE_CCODE_FILE);
}


gboolean
vala_ccode_file_get_is_header (ValaCCodeFile* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_header;
	result = _tmp0_;
	return result;
}


void
vala_ccode_file_set_is_header (ValaCCodeFile* self,
                               gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_header = value;
}


static void
vala_value_ccode_file_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
vala_value_ccode_file_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_ccode_file_unref (value->data[0].v_pointer);
	}
}


static void
vala_value_ccode_file_copy_value (const GValue* src_value,
                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_ccode_file_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
vala_value_ccode_file_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
vala_value_ccode_file_collect_value (GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaCCodeFile * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_ccode_file_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
vala_value_ccode_file_lcopy_value (const GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	ValaCCodeFile ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_ccode_file_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec*
vala_param_spec_ccode_file (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags)
{
	ValaParamSpecCCodeFile* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_CCODE_FILE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer
vala_value_get_ccode_file (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_FILE), NULL);
	return value->data[0].v_pointer;
}


void
vala_value_set_ccode_file (GValue* value,
                           gpointer v_object)
{
	ValaCCodeFile * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_FILE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CCODE_FILE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_ccode_file_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_ccode_file_unref (old);
	}
}


void
vala_value_take_ccode_file (GValue* value,
                            gpointer v_object)
{
	ValaCCodeFile * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_FILE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CCODE_FILE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_ccode_file_unref (old);
	}
}


static void
vala_ccode_file_class_init (ValaCCodeFileClass * klass)
{
	vala_ccode_file_parent_class = g_type_class_peek_parent (klass);
	((ValaCCodeFileClass *) klass)->finalize = vala_ccode_file_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeFilePrivate));
}


static void
vala_ccode_file_instance_init (ValaCCodeFile * self)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	ValaHashSet* _tmp2_;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	ValaHashSet* _tmp5_;
	GHashFunc _tmp6_;
	GEqualFunc _tmp7_;
	ValaHashSet* _tmp8_;
	GHashFunc _tmp9_;
	GEqualFunc _tmp10_;
	ValaHashSet* _tmp11_;
	ValaCCodeFragment* _tmp12_;
	ValaCCodeFragment* _tmp13_;
	ValaCCodeFragment* _tmp14_;
	ValaCCodeFragment* _tmp15_;
	ValaCCodeFragment* _tmp16_;
	ValaCCodeFragment* _tmp17_;
	ValaCCodeFragment* _tmp18_;
	ValaCCodeFragment* _tmp19_;
	self->priv = VALA_CCODE_FILE_GET_PRIVATE (self);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp0_, _tmp1_);
	self->priv->features = (ValaSet*) _tmp2_;
	_tmp3_ = g_str_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp3_, _tmp4_);
	self->priv->declarations = (ValaSet*) _tmp5_;
	_tmp6_ = g_str_hash;
	_tmp7_ = g_str_equal;
	_tmp8_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp6_, _tmp7_);
	self->priv->definitions = (ValaSet*) _tmp8_;
	_tmp9_ = g_str_hash;
	_tmp10_ = g_str_equal;
	_tmp11_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp9_, _tmp10_);
	self->priv->includes = (ValaSet*) _tmp11_;
	_tmp12_ = vala_ccode_fragment_new ();
	self->priv->comments = _tmp12_;
	_tmp13_ = vala_ccode_fragment_new ();
	self->priv->feature_test_macros = _tmp13_;
	_tmp14_ = vala_ccode_fragment_new ();
	self->priv->include_directives = _tmp14_;
	_tmp15_ = vala_ccode_fragment_new ();
	self->priv->type_declaration = _tmp15_;
	_tmp16_ = vala_ccode_fragment_new ();
	self->priv->type_definition = _tmp16_;
	_tmp17_ = vala_ccode_fragment_new ();
	self->priv->type_member_declaration = _tmp17_;
	_tmp18_ = vala_ccode_fragment_new ();
	self->priv->constant_declaration = _tmp18_;
	_tmp19_ = vala_ccode_fragment_new ();
	self->priv->type_member_definition = _tmp19_;
	self->ref_count = 1;
}


static void
vala_ccode_file_finalize (ValaCCodeFile * obj)
{
	ValaCCodeFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CCODE_FILE, ValaCCodeFile);
	g_signal_handlers_destroy (self);
	_vala_iterable_unref0 (self->priv->features);
	_vala_iterable_unref0 (self->priv->declarations);
	_vala_iterable_unref0 (self->priv->definitions);
	_vala_iterable_unref0 (self->priv->includes);
	_vala_ccode_node_unref0 (self->priv->comments);
	_vala_ccode_node_unref0 (self->priv->feature_test_macros);
	_vala_ccode_node_unref0 (self->priv->include_directives);
	_vala_ccode_node_unref0 (self->priv->type_declaration);
	_vala_ccode_node_unref0 (self->priv->type_definition);
	_vala_ccode_node_unref0 (self->priv->type_member_declaration);
	_vala_ccode_node_unref0 (self->priv->constant_declaration);
	_vala_ccode_node_unref0 (self->priv->type_member_definition);
}


GType
vala_ccode_file_get_type (void)
{
	static volatile gsize vala_ccode_file_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_file_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_ccode_file_init, vala_value_ccode_file_free_value, vala_value_ccode_file_copy_value, vala_value_ccode_file_peek_pointer, "p", vala_value_ccode_file_collect_value, "p", vala_value_ccode_file_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeFile), 0, (GInstanceInitFunc) vala_ccode_file_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_ccode_file_type_id;
		vala_ccode_file_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCCodeFile", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_ccode_file_type_id__volatile, vala_ccode_file_type_id);
	}
	return vala_ccode_file_type_id__volatile;
}


gpointer
vala_ccode_file_ref (gpointer instance)
{
	ValaCCodeFile * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void
vala_ccode_file_unref (gpointer instance)
{
	ValaCCodeFile * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_CCODE_FILE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



