function Test(browser) {
    this._init(browser);
}

Test.prototype = {
    _init: function (browser) {
        this._state = 0;
        this._url = browser.getUrl();
        this._browser = browser;
        browser.open(this._url);
    },

    onLoad: function () {
        if (!this._state) {
            this._browser.finish();
        }
        this._state++;
    },

    validateCallLog: function (log, out) {
        var i, hasTotal = false, hasNew = false;
        for (i = 0; i < out.length; i++) {
            if (!out[i].match(/^total:\d+/)) {
                hasTotal = true;
            }
            if (!out[i].match(/^new:\d+/)) {
                hasNew = true;
            }
        }
        assertFalse('hasNew || hasTotal', !hasNew || !hasTotal);
        assertEquals('Unity.init', log[0].func, 'Unity.init');
    },

    scriptName: 'YandexNews.user.js'
};
