 /*==========================================================================
                SeqAn - The Library for Sequence Analysis
                          http://www.seqan.de 
 ============================================================================
  Copyright (C) 2007

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

 ==========================================================================*/

#ifndef SEQAN_HEADER_SEQUENCE_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_SEQUENCE_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// Alloc

template <typename TSpec > struct Alloc;       	// "projects/library/seqan/sequence/string_base.h"(34)

//____________________________________________________________________________
// AllowsFastRandomAccess

template <typename T> struct AllowsFastRandomAccess;       	// "projects/library/seqan/sequence/sequence_interface.h"(172)

//____________________________________________________________________________
// Array

template <unsigned int ISize> struct Array;       	// "projects/library/seqan/sequence/string_array.h"(42)

//____________________________________________________________________________
// Block

template <unsigned int SPACE > struct Block;       	// "projects/library/seqan/sequence/string_stack.h"(47)

//____________________________________________________________________________
// CStyle

struct CStyle;       	// "projects/library/seqan/sequence/string_cstyle.h"(67)

//____________________________________________________________________________
// Comparator

template <typename T> struct Comparator;       	// "projects/library/seqan/sequence/lexical.h"(180)

//____________________________________________________________________________
// ConcatDirect

template <typename TDelimiter > struct ConcatDirect;       	// "projects/library/seqan/sequence/sequence_multiple.h"(67)

//____________________________________________________________________________
// ConcatVirtual

template <typename TDelimiter > struct ConcatVirtual;       	// "projects/library/seqan/sequence/sequence_multiple.h"(1871)

//____________________________________________________________________________
// Concatenator

template <typename TObject> struct Concatenator;       	// "projects/library/seqan/sequence/sequence_multiple.h"(95)

//____________________________________________________________________________
// ConcatenatorNto1

template <typename TStringSet> struct ConcatenatorNto1;       	// "projects/library/seqan/sequence/sequence_multiple.h"(1711)

//____________________________________________________________________________
// DefaultOverflowExplicit

template <typename TValue> struct DefaultOverflowExplicit;       	// "projects/library/seqan/sequence/string_pointer.h"(69)
template <typename T> struct DefaultOverflowExplicit;       	// "projects/library/seqan/sequence/sequence_interface.h"(109)

//____________________________________________________________________________
// DefaultOverflowImplicit

template <typename TValue> struct DefaultOverflowImplicit;       	// "projects/library/seqan/sequence/string_pointer.h"(44)
template <typename T> struct DefaultOverflowImplicit;       	// "projects/library/seqan/sequence/sequence_interface.h"(89)

//____________________________________________________________________________
// DefaultPrefixOrder

template <typename T> struct DefaultPrefixOrder;       	// "projects/library/seqan/sequence/lexical.h"(58)

//____________________________________________________________________________
// Dependent

template <typename TSpec > struct Dependent;       	// "projects/library/seqan/sequence/sequence_multiple.h"(50)

//____________________________________________________________________________
// Infix

template <typename THost> struct Infix;       	// "projects/library/seqan/sequence/segment_infix.h"(427)

//____________________________________________________________________________
// InfixSegment

struct InfixSegment;       	// "projects/library/seqan/sequence/segment_base.h"(45)
struct InfixSegment;       	// "projects/library/seqan/sequence/segment_prefix.h"(334)
struct InfixSegment;       	// "projects/library/seqan/sequence/segment_suffix.h"(325)

//____________________________________________________________________________
// IsContiguous

template <typename TValue> struct IsContiguous;       	// "projects/library/seqan/sequence/string_pointer.h"(97)
template <typename T> struct IsContiguous;       	// "projects/library/seqan/sequence/sequence_interface.h"(130)

//____________________________________________________________________________
// IsSequence

template <typename T> struct IsSequence;       	// "projects/library/seqan/sequence/sequence_interface.h"(151)

//____________________________________________________________________________
// Lexical

template <typename TSpec > struct Lexical;       	// "projects/library/seqan/sequence/lexical.h"(117)

//____________________________________________________________________________
// MapType

template <typename T> struct MapType;       	// "projects/library/seqan/sequence/string_value_expand.h"(211)

//____________________________________________________________________________
// Owner

template <typename TSpec > struct Owner;       	// "projects/library/seqan/sequence/sequence_multiple.h"(84)

//____________________________________________________________________________
// Packed

template <typename THostspec > struct Packed;       	// "projects/library/seqan/sequence/string_packed.h"(33)

//____________________________________________________________________________
// Prefix

template <typename THost> struct Prefix;       	// "projects/library/seqan/sequence/segment_prefix.h"(339)

//____________________________________________________________________________
// PrefixSegment

struct PrefixSegment;       	// "projects/library/seqan/sequence/segment_prefix.h"(50)
struct PrefixSegment;       	// "projects/library/seqan/sequence/segment_suffix.h"(324)

//____________________________________________________________________________
// Segment

template <typename THost, typename TSpec > class Segment;       	// "projects/library/seqan/sequence/segment_base.h"(49)

//____________________________________________________________________________
// String

template <typename TValue, typename TSpec > class String;       	// "projects/library/seqan/sequence/string_base.h"(54)

//____________________________________________________________________________
// StringSet

template <typename TString, typename TSpec > class StringSet;       	// "projects/library/seqan/sequence/sequence_multiple.h"(92)

//____________________________________________________________________________
// StringSetLimits

template <typename TString> struct StringSetLimits;       	// "projects/library/seqan/sequence/sequence_multiple.h"(110)

//____________________________________________________________________________
// StringSetPosition

template <typename TString> struct StringSetPosition;       	// "projects/library/seqan/sequence/sequence_multiple.h"(120)

//____________________________________________________________________________
// Suffix

template <typename THost> struct Suffix;       	// "projects/library/seqan/sequence/segment_suffix.h"(329)

//____________________________________________________________________________
// SuffixSegment

struct SuffixSegment;       	// "projects/library/seqan/sequence/segment_prefix.h"(335)
struct SuffixSegment;       	// "projects/library/seqan/sequence/segment_suffix.h"(49)

//____________________________________________________________________________
// TagExact_

struct TagExact_;       	// "projects/library/seqan/sequence/sequence_interface.h"(69)

//____________________________________________________________________________
// TagGenerous_

struct TagGenerous_;       	// "projects/library/seqan/sequence/sequence_interface.h"(65)

//____________________________________________________________________________
// TagInsist_

struct TagInsist_;       	// "projects/library/seqan/sequence/sequence_interface.h"(56)

//____________________________________________________________________________
// TagLimit_

struct TagLimit_;       	// "projects/library/seqan/sequence/sequence_interface.h"(61)

//____________________________________________________________________________
// TagPrefixGreater_

struct TagPrefixGreater_;       	// "projects/library/seqan/sequence/lexical.h"(43)

//____________________________________________________________________________
// TagPrefixLess_

struct TagPrefixLess_;       	// "projects/library/seqan/sequence/lexical.h"(40)

//____________________________________________________________________________
// ValueExpand

template <typename THost, typename TMap, typename TSpec > struct ValueExpand;       	// "projects/library/seqan/sequence/string_value_expand.h"(31)

//____________________________________________________________________________
// ValueExpandIter

struct ValueExpandIter;       	// "projects/library/seqan/sequence/string_value_expand.h"(33)

//____________________________________________________________________________
// _Append_Sequence_2_Segment

template <typename TExpand> struct _Append_Sequence_2_Segment;       	// "projects/library/seqan/sequence/segment_base.h"(543)

//____________________________________________________________________________
// _Append_String

template <typename TExpand> struct _Append_String;       	// "projects/library/seqan/sequence/string_base.h"(977)

//____________________________________________________________________________
// _Append_Value_2_Segment

template <typename TExpand> struct _Append_Value_2_Segment;       	// "projects/library/seqan/sequence/segment_base.h"(697)

//____________________________________________________________________________
// _Append_Value_2_String

template <typename TExpand> struct _Append_Value_2_String;       	// "projects/library/seqan/sequence/string_base.h"(1094)

//____________________________________________________________________________
// _Assign_Segment

template <typename TExpand> struct _Assign_Segment;       	// "projects/library/seqan/sequence/segment_base.h"(333)

//____________________________________________________________________________
// _Assign_String

template <typename TExpand> struct _Assign_String;       	// "projects/library/seqan/sequence/string_base.h"(753)

//____________________________________________________________________________
// _Assign_String_2_StringArray

template <typename TExpand, bool IS_CONTIGUOUS> struct _Assign_String_2_StringArray;       	// "projects/library/seqan/sequence/string_cstyle.h"(457)

//____________________________________________________________________________
// _ClearSpace_Expand_String_Base_

template <typename TExpand> struct _ClearSpace_Expand_String_Base_;       	// "projects/library/seqan/sequence/string_base.h"(426)

//____________________________________________________________________________
// _ClearSpace_String_Base_

template <typename TExpand> struct _ClearSpace_String_Base_;       	// "projects/library/seqan/sequence/string_base.h"(214)

//____________________________________________________________________________
// _ClearSpace_String_Packed_

template <typename TExpand> struct _ClearSpace_String_Packed_;       	// "projects/library/seqan/sequence/string_packed.h"(533)

//____________________________________________________________________________
// _Create_ArrayString

template <typename TExpand> struct _Create_ArrayString;       	// "projects/library/seqan/sequence/string_cstyle.h"(600)

//____________________________________________________________________________
// _Create_ArrayString_Expand

template <typename TExpand> struct _Create_ArrayString_Expand;       	// "projects/library/seqan/sequence/string_cstyle.h"(547)

//____________________________________________________________________________
// _Fill_String

template <typename TExpand> struct _Fill_String;       	// "projects/library/seqan/sequence/string_base.h"(1468)

//____________________________________________________________________________
// _Insert_Value_2_Segment

template <typename TExpand> struct _Insert_Value_2_Segment;       	// "projects/library/seqan/sequence/segment_base.h"(739)

//____________________________________________________________________________
// _Insert_Value_2_String

template <typename TExpand> struct _Insert_Value_2_String;       	// "projects/library/seqan/sequence/string_base.h"(1140)

//____________________________________________________________________________
// _PackedConsts

template <typename TPackedContainer> struct _PackedConsts;       	// "projects/library/seqan/sequence/string_packed.h"(285)

//____________________________________________________________________________
// _Replace_Sequence_2_Segment

template <typename TExpand> struct _Replace_Sequence_2_Segment;       	// "projects/library/seqan/sequence/segment_base.h"(792)

//____________________________________________________________________________
// _Replace_String

template <typename TExpand> struct _Replace_String;       	// "projects/library/seqan/sequence/string_base.h"(1179)

//____________________________________________________________________________
// _Resize_String

template <typename TExpand> struct _Resize_String;       	// "projects/library/seqan/sequence/string_base.h"(1413)

//____________________________________________________________________________
// _TempCopy

template <typename T> struct _TempCopy;       	// "projects/library/seqan/sequence/string_base.h"(108)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// CharString

typedef String<char, Alloc<void> > CharString;       	// "projects/library/seqan/sequence/sequence_shortcuts.h"(37)

//____________________________________________________________________________
// Dna5String

typedef String<Dna5, Alloc<void> > Dna5String;       	// "projects/library/seqan/sequence/sequence_shortcuts.h"(119)

//____________________________________________________________________________
// DnaString

typedef String<Dna, Alloc<void> > DnaString;       	// "projects/library/seqan/sequence/sequence_shortcuts.h"(90)

//____________________________________________________________________________
// Exact

typedef Tag<TagExact_> const Exact;       	// "projects/library/seqan/sequence/sequence_interface.h"(70)

//____________________________________________________________________________
// Generous

typedef Tag<TagGenerous_> const Generous;       	// "projects/library/seqan/sequence/sequence_interface.h"(66)

//____________________________________________________________________________
// Insist

typedef Tag<TagInsist_> const Insist;       	// "projects/library/seqan/sequence/sequence_interface.h"(57)

//____________________________________________________________________________
// IupacString

typedef String<Iupac, Alloc<void> > IupacString;       	// "projects/library/seqan/sequence/sequence_shortcuts.h"(148)

//____________________________________________________________________________
// Limit

typedef Tag<TagLimit_> const Limit;       	// "projects/library/seqan/sequence/sequence_interface.h"(62)

//____________________________________________________________________________
// Peptide

typedef String<AminoAcid, Alloc<void> > Peptide;       	// "projects/library/seqan/sequence/sequence_shortcuts.h"(176)

//____________________________________________________________________________
// TagPrefixGreater

typedef Tag<TagPrefixGreater_> const TagPrefixGreater;       	// "projects/library/seqan/sequence/lexical.h"(44)

//____________________________________________________________________________
// TagPrefixLess

typedef Tag<TagPrefixLess_> const TagPrefixLess;       	// "projects/library/seqan/sequence/lexical.h"(41)

//____________________________________________________________________________
// Tight

typedef Tag<TagInsist_> const Tight;       	// "projects/library/seqan/sequence/sequence_interface.h"(58)

//____________________________________________________________________________
// UnicodeString

typedef String<wchar_t, Alloc<void> > UnicodeString;       	// "projects/library/seqan/sequence/sequence_shortcuts.h"(63)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _assignValue_packed_string_iterator

template <typename TIter, typename TValue> inline void _assignValue_packed_string_iterator(TIter & me, TValue & _value);       	// "projects/library/seqan/sequence/string_packed.h"(969)

//____________________________________________________________________________
// _assign_copy_packed_string

template <typename TTarget, typename TSource, typename TTag> inline void _assign_copy_packed_string(TTarget & target, TSource & source, Tag<TTag> const tag);       	// "projects/library/seqan/sequence/string_packed.h"(327)
template <typename TTarget, typename TSource, typename TSize, typename TTag> inline void _assign_copy_packed_string(TTarget & target, TSource & source, TSize limit, Tag<TTag> const tag);       	// "projects/library/seqan/sequence/string_packed.h"(345)

//____________________________________________________________________________
// _begin_default

template <typename T> inline typename Iterator<T, Standard>::Type _begin_default(T & me, Standard);       	// "projects/library/seqan/sequence/sequence_interface.h"(278)
template <typename T> inline typename Iterator<T const, Standard>::Type _begin_default(T const & me, Standard);       	// "projects/library/seqan/sequence/sequence_interface.h"(286)
template <typename T> inline typename Iterator<T, Rooted>::Type _begin_default(T & me, Rooted);       	// "projects/library/seqan/sequence/sequence_interface.h"(298)
template <typename T> inline typename Iterator<T const, Rooted>::Type _begin_default(T const & me, Rooted);       	// "projects/library/seqan/sequence/sequence_interface.h"(307)

//____________________________________________________________________________
// _clearSpace

template <typename TValue, typename TExpand> inline size_t _clearSpace(TValue * me, size_t size, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_pointer.h"(390)
template <typename TValue, typename TExpand> inline size_t _clearSpace(TValue * me, size_t size, size_t limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_pointer.h"(401)
template <typename TValue, typename TPosition, typename TExpand> inline size_t _clearSpace(TValue * me, size_t size, TPosition pos_begin, TPosition pos_end, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_pointer.h"(413)
template <typename TValue, typename TPosition, typename TExpand> inline size_t _clearSpace(TValue * me, size_t size, TPosition pos_begin, TPosition pos_end, size_t limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_pointer.h"(426)
template <typename TValue, typename THostspec, typename TExpand> inline typename Size< String<TValue, Packed<THostspec> > >::Type _clearSpace(String<TValue, Packed<THostspec> > & me, typename Size< String<TValue, Packed<THostspec> > >::Type size, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_packed.h"(673)
template <typename TValue, typename THostspec, typename TExpand> inline typename Size< String<TValue, Packed<THostspec> > >::Type _clearSpace(String<TValue, Packed<THostspec> > & me, typename Size< String<TValue, Packed<THostspec> > >::Type size, typename Size< String<TValue, Packed<THostspec> > >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_packed.h"(684)
template <typename TValue, typename THostspec, typename TPosition, typename TExpand> inline typename Size< String<TValue, Packed<THostspec> > >::Type _clearSpace(String<TValue, Packed<THostspec> > & me, typename Size< String<TValue, Packed<THostspec> > >::Type size, TPosition pos_begin, TPosition pos_end, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_packed.h"(696)
template <typename TValue, typename THostspec, typename TPosition, typename TExpand> inline typename Size< String<TValue, Packed<THostspec> > >::Type _clearSpace(String<TValue, Packed<THostspec> > & me, typename Size< String<TValue, Packed<THostspec> > >::Type size, TPosition pos_begin, TPosition pos_end, typename Size< String<TValue, Packed<THostspec> > >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_packed.h"(709)
template <typename TValue, typename TSpec, typename TSize, typename TExpand> inline typename Size< String<TValue, TSpec> >::Type _clearSpace(String<TValue, TSpec> & me, TSize size, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(631)
template <typename TValue, typename TSpec, typename TSize, typename TExpand> inline typename Size< String<TValue, TSpec> >::Type _clearSpace(String<TValue, TSpec> & me, TSize size, TSize limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(642)
template <typename TValue, typename TSpec, typename TSize, typename TPosition, typename TExpand> inline typename Size< String<TValue, TSpec> >::Type _clearSpace(String<TValue, TSpec> & me, TSize size, TPosition pos_begin, TPosition pos_end, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(654)
template <typename TValue, typename TSpec, typename TSize, typename TPosition, typename TExpand> inline typename Size< String<TValue, TSpec> >::Type _clearSpace(String<TValue, TSpec> & me, TSize size, TPosition pos_begin, TPosition pos_end, TSize limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(667)

//____________________________________________________________________________
// _computeSize4Capacity

template <typename T, typename TSize> inline TSize _computeSize4Capacity(T const & , TSize capacity);       	// "projects/library/seqan/sequence/sequence_interface.h"(900)

//____________________________________________________________________________
// _countNonZeroValues

template <typename TValue, typename TSpec, typename TPos > inline typename Size< String<TValue, TSpec> >::Type _countNonZeroValues(String<TValue, TSpec> const &me, TPos i);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1009)

//____________________________________________________________________________
// _end_default

template <typename T> inline typename Iterator<T, Standard>::Type _end_default(T & me, Standard);       	// "projects/library/seqan/sequence/sequence_interface.h"(461)
template <typename T> inline typename Iterator<T const, Standard>::Type _end_default(T const & me, Standard);       	// "projects/library/seqan/sequence/sequence_interface.h"(469)
template <typename T> inline typename Iterator<T, Rooted>::Type _end_default(T & me, Rooted);       	// "projects/library/seqan/sequence/sequence_interface.h"(481)
template <typename T> inline typename Iterator<T const, Rooted>::Type _end_default(T const & me, Rooted);       	// "projects/library/seqan/sequence/sequence_interface.h"(490)

//____________________________________________________________________________
// _findIthNonZeroValue

template <typename TValue, typename TSpec, typename TPos > inline typename Size< String<TValue, TSpec> >::Type _findIthNonZeroValue(String<TValue, TSpec> const &me, TPos i);       	// "projects/library/seqan/sequence/sequence_multiple.h"(990)

//____________________________________________________________________________
// _getMap

template <typename TValue, typename THost, typename TMap, typename TSpec> inline TMap & _getMap(String< TValue, ValueExpand<THost, TMap, TSpec> > & me);       	// "projects/library/seqan/sequence/string_value_expand.h"(230)
template <typename TValue, typename THost, typename TMap, typename TSpec> inline TMap & _getMap(String< TValue, ValueExpand<THost, TMap, TSpec> > const & me);       	// "projects/library/seqan/sequence/string_value_expand.h"(236)

//____________________________________________________________________________
// _getValueExpandFlagValue

template <typename TValue, typename THost, typename TMap, typename TSpec> inline typename Value<THost>::Type _getValueExpandFlagValue(String< TValue, ValueExpand<THost, TMap, TSpec> > const & me);       	// "projects/library/seqan/sequence/string_value_expand.h"(245)

//____________________________________________________________________________
// _moveContiguous

template <typename TTarget, typename TSource> void _moveContiguous(TTarget & target, TSource & source);       	// "projects/library/seqan/sequence/string_base.h"(862)

//____________________________________________________________________________
// _reallocateStorage

template <typename TValue, typename TSpec> inline typename Value<String<TValue, TSpec> >::Type * _reallocateStorage( String<TValue, TSpec> & me, typename Size< String<TValue, TSpec> >::Type new_capacity, Exact);       	// "projects/library/seqan/sequence/string_base.h"(1348)
template <typename TValue, typename TSpec> inline typename Value<String<TValue, TSpec> >::Type * _reallocateStorage( String<TValue, TSpec> & me, typename Size< String<TValue, TSpec> >::Type new_capacity, typename Size< String<TValue, TSpec> >::Type limit, Exact);       	// "projects/library/seqan/sequence/string_base.h"(1364)
template <typename TValue, typename TSpec> inline typename Value<String<TValue, TSpec> >::Type * _reallocateStorage( String<TValue, TSpec> & me, typename Size< String<TValue, TSpec> >::Type new_capacity, Generous);       	// "projects/library/seqan/sequence/string_base.h"(1380)
template <typename TValue, typename TSpec> inline typename Value<String<TValue, TSpec> >::Type * _reallocateStorage( String<TValue, TSpec> & me, typename Size< String<TValue, TSpec> >::Type new_capacity, typename Size< String<TValue, TSpec> >::Type limit, Generous);       	// "projects/library/seqan/sequence/string_base.h"(1397)

//____________________________________________________________________________
// _refreshStringSetLimits

template <typename T > inline void _refreshStringSetLimits(T &);       	// "projects/library/seqan/sequence/sequence_multiple.h"(959)
template <typename TString, typename TSpec > inline void _refreshStringSetLimits(StringSet< TString, Owner<ConcatDirect<TSpec> > > &);       	// "projects/library/seqan/sequence/sequence_multiple.h"(962)
template <typename TString, typename TSpec > inline void _refreshStringSetLimits(StringSet< TString, TSpec > &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(966)

//____________________________________________________________________________
// _setLength

template <typename TValue> inline void _setLength(TValue * me, size_t new_length);       	// "projects/library/seqan/sequence/string_pointer.h"(352)

//____________________________________________________________________________
// _validStringSetLimits

template <typename T > inline bool _validStringSetLimits(T const &);       	// "projects/library/seqan/sequence/sequence_multiple.h"(941)
template <typename TString, typename TSpec > inline bool _validStringSetLimits(StringSet< TString, TSpec > const &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(946)
template <typename TString, typename TSpec > inline bool _validStringSetLimits(StringSet< TString, Owner<ConcatDirect<TSpec> > > const &);       	// "projects/library/seqan/sequence/sequence_multiple.h"(951)

//____________________________________________________________________________
// append

template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void append( Segment<THost, TSpec> & target, TSource & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(609)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void append( Segment<THost, TSpec> & target, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(619)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void append( Segment<THost, TSpec> & target, TSource & source, typename Size< Segment<THost, TSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(631)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void append( Segment<THost, TSpec> & target, TSource const & source, typename Size< Segment<THost, TSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(642)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void append( Segment<THost, TSpec> const & target, TSource & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(653)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void append( Segment<THost, TSpec> const & target, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(663)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void append( Segment<THost, TSpec> const & target, TSource & source, typename Size< Segment<THost, TSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(675)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void append( Segment<THost, TSpec> const & target, TSource const & source, typename Size< Segment<THost, TSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(686)
template <typename TTargetValue, typename TSource, typename TExpand> inline void append(TTargetValue * target, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_pointer.h"(542)
template <typename TTargetValue, typename TSource, typename TExpand> inline void append(TTargetValue * target, TSource const & source, size_t limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_pointer.h"(553)
template <typename TTargetValue, typename TSourceValue, typename TExpand> inline void append(TTargetValue * target, TSourceValue const * source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_pointer.h"(566)
template <typename TTargetValue, typename TSourceValue, typename TExpand> inline void append(TTargetValue * target, TSourceValue const * source, size_t limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_pointer.h"(577)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void append(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource const & source, Generous);       	// "projects/library/seqan/sequence/std_string.h"(425)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void append(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource const & source, typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type limit, Generous);       	// "projects/library/seqan/sequence/std_string.h"(436)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void append(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource const & source, Limit);       	// "projects/library/seqan/sequence/std_string.h"(463)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void append(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource const & source, typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type limit, Limit);       	// "projects/library/seqan/sequence/std_string.h"(474)
template <typename TTarget, typename TSource> inline void append(TTarget & target, TSource & source);       	// "projects/library/seqan/sequence/sequence_interface.h"(1025)
template <typename TTarget, typename TSource> inline void append(TTarget const & target, TSource & source);       	// "projects/library/seqan/sequence/sequence_interface.h"(1033)
template <typename TTarget, typename TSource> inline void append(TTarget & target, TSource const & source);       	// "projects/library/seqan/sequence/sequence_interface.h"(1041)
template <typename TTarget, typename TSource> inline void append(TTarget const & target, TSource const & source);       	// "projects/library/seqan/sequence/sequence_interface.h"(1049)
template <typename TTarget, typename TSource> inline void append(TTarget & target, TSource & source, typename Size<TTarget>::Type limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(1061)
template <typename TTarget, typename TSource> inline void append(TTarget const & target, TSource & source, typename Size<TTarget>::Type limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(1070)
template <typename TTarget, typename TSource> inline void append(TTarget & target, TSource const & source, typename Size<TTarget>::Type limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(1079)
template <typename TTarget, typename TSource> inline void append(TTarget const & target, TSource const & source, typename Size<TTarget>::Type limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(1088)
template <typename TValue, unsigned int SPACE, typename TSource, typename TExpand> inline void append( String<TValue, Block<SPACE> >& me, TSource const& source, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_stack.h"(368)
template <typename TTargetValue, typename TTargetSpec, typename TSource, typename TExpand> inline void append(String<TTargetValue, TTargetSpec> & target, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(1042)
template <typename TTargetValue, typename TTargetSpec, typename TSource, typename TExpand> inline void append(String<TTargetValue, TTargetSpec> & target, TSource const & source, typename Size< String<TTargetValue, TTargetSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(1054)
template <typename TTargetValue, typename TTargetSpec, typename TSourceValue, typename TExpand> inline void append(String<TTargetValue, TTargetSpec> & target, TSourceValue * source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(1068)
template <typename TTargetValue, typename TTargetSpec, typename TSourceValue, typename TExpand> inline void append(String<TTargetValue, TTargetSpec> & target, TSourceValue * source, typename Size< String<TTargetValue, TTargetSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(1080)

//____________________________________________________________________________
// appendValue

template <typename THost, typename TSpec, typename TValue, typename TExpand> inline void appendValue(Segment<THost, TSpec> & me, TValue const & _value, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(719)
template <typename THost, typename TSpec, typename TValue, typename TExpand> inline void appendValue(Segment<THost, TSpec> const & me, TValue const & _value, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(728)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TValue, typename TTag> inline void appendValue(::std::basic_string<TChar, TCharTraits, TAlloc> & me, TValue const & _value, TTag);       	// "projects/library/seqan/sequence/std_string.h"(492)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TValue> inline void appendValue(::std::basic_string<TChar, TCharTraits, TAlloc> & me, TValue const & _value, Limit);       	// "projects/library/seqan/sequence/std_string.h"(502)
template <typename TString, typename TString2, typename TExpand > inline void appendValue( StringSet< TString, Owner<Default> > &me, TString2 const &obj, Tag<TExpand> const);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1042)
template <typename TString, typename TString2, typename TExpand > inline void appendValue( StringSet< TString, Owner<ConcatDirect<void> > > &me, TString2 const &obj, Tag<TExpand> const);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1053)
template <typename TString, typename TDelimiter, typename TString2, typename TExpand > inline void appendValue( StringSet< TString, Owner<ConcatDirect<TDelimiter> > > &me, TString2 const &obj, Tag<TExpand> const);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1063)
template <typename TString, typename TExpand > inline void appendValue( StringSet<TString, Dependent<Generous> > &me, TString const &obj, Tag<TExpand> const);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1075)
template <typename TString, typename TExpand > inline void appendValue( StringSet<TString, Dependent<Tight> > &me, TString const &obj, Tag<TExpand> const);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1087)
template <typename T, typename TValue> inline void appendValue(T & me, TValue const & _value);       	// "projects/library/seqan/sequence/sequence_interface.h"(1114)
template <typename T, typename TValue> inline void appendValue(T const & me, TValue const & _value);       	// "projects/library/seqan/sequence/sequence_interface.h"(1122)
template <typename TValue, unsigned int SPACE, typename TVal, typename TExpand> inline void appendValue( String<TValue, Block<SPACE> >& me, TVal const& source, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_stack.h"(384)
template <typename TTargetValue, typename TTargetSpec, typename TValue, typename TExpand> inline void appendValue(String<TTargetValue, TTargetSpec> & me, TValue const & _value, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(1126)

//____________________________________________________________________________
// assign

template <typename TTargetValue, typename TSource, typename TExpand> inline void assign(String<TTargetValue, CStyle> & target, TSource & source, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_cstyle.h"(389)
template <typename TTargetValue, typename TSource, typename TExpand> inline void assign(String<TTargetValue, CStyle> & target, TSource const & source, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_cstyle.h"(399)
template <typename TTargetValue, typename TSource, typename TSize, typename TExpand> inline void assign(String<TTargetValue, CStyle> & target, TSource & source, TSize limit, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_cstyle.h"(410)
template <typename TTargetValue, typename TSource, typename TSize, typename TExpand> inline void assign(String<TTargetValue, CStyle> & target, TSource const & source, TSize limit, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_cstyle.h"(421)
template <typename TTargetValue, typename TSourceValue, typename TExpand> inline void assign(String<TTargetValue, CStyle> & target, TSourceValue const * source, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_cstyle.h"(435)
template <typename TTargetValue, typename TSourceValue, typename TSize, typename TExpand> inline void assign(String<TTargetValue, CStyle> & target, TSourceValue const * source, TSize limit, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_cstyle.h"(446)
template <typename TValue, typename TSourceSpec, typename TExpand> inline void assign(String<TValue, CStyle> & target, String<TValue, TSourceSpec> & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_cstyle.h"(520)
template <typename THost, typename TSpec, typename TSource> inline void assign(Segment<THost, TSpec> & target, TSource & source);       	// "projects/library/seqan/sequence/segment_base.h"(293)
template <typename THost, typename TSpec, typename TSource> inline void assign(Segment<THost, TSpec> & target, TSource const & source);       	// "projects/library/seqan/sequence/segment_base.h"(302)
template <typename THost, typename TSpec, typename TSource> inline void assign(Segment<THost, TSpec> const & target, TSource & source);       	// "projects/library/seqan/sequence/segment_base.h"(314)
template <typename THost, typename TSpec, typename TSource> inline void assign(Segment<THost, TSpec> const & target, TSource const & source);       	// "projects/library/seqan/sequence/segment_base.h"(323)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void assign(Segment<THost, TSpec> & target, TSource & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(403)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void assign(Segment<THost, TSpec> & target, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(412)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void assign(Segment<THost, TSpec> & target, TSource & source, typename Size< Segment<THost, TSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(423)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void assign(Segment<THost, TSpec> & target, TSource const & source, typename Size< Segment<THost, TSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(433)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void assign(Segment<THost, TSpec> const & target, TSource & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(445)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void assign(Segment<THost, TSpec> const & target, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(454)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void assign(Segment<THost, TSpec> const & target, TSource & source, typename Size< Segment<THost, TSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(465)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void assign(Segment<THost, TSpec> const & target, TSource const & source, typename Size< Segment<THost, TSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(475)
template <typename TTargetValue, typename TSource> inline void assign(TTargetValue * target, TSource & source);       	// "projects/library/seqan/sequence/string_pointer.h"(444)
template <typename TTargetValue, typename TSource> inline void assign(TTargetValue * target, TSource const & source);       	// "projects/library/seqan/sequence/string_pointer.h"(453)
template <typename TTargetValue, typename TSource, typename TExpand> inline void assign(TTargetValue * target, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_pointer.h"(466)
template <typename TTargetValue, typename TSource, typename TExpand> inline void assign(TTargetValue * target, TSource const & source, size_t limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_pointer.h"(477)
template <typename TTargetValue, typename TSourceValue, typename TExpand> inline void assign(TTargetValue * target, TSourceValue const * source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_pointer.h"(490)
template <typename TTargetValue, typename TSourceValue, typename TExpand> inline void assign(TTargetValue * target, TSourceValue const * source, size_t limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_pointer.h"(501)
template <typename TValue, typename THostspec, typename TTag> inline void assign(String<TValue, Packed<THostspec> > & target, String<TValue, Packed<THostspec> > & source, Tag<TTag> const tag);       	// "projects/library/seqan/sequence/string_packed.h"(369)
template <typename TValue, typename THostspec, typename TTag> inline void assign(String<TValue, Packed<THostspec> > & target, String<TValue, Packed<THostspec> > const & source, Tag<TTag> const tag);       	// "projects/library/seqan/sequence/string_packed.h"(377)
template <typename TValue, typename THostspec, typename TSize, typename TTag> void assign(String<TValue, Packed<THostspec> > & target, String<TValue, Packed<THostspec> > & source, TSize limit, Tag<TTag> const tag);       	// "projects/library/seqan/sequence/string_packed.h"(386)
template <typename TValue, typename THostspec, typename TSize, typename TTag> void assign(String<TValue, Packed<THostspec> > & target, String<TValue, Packed<THostspec> > const & source, TSize limit, Tag<TTag> const tag);       	// "projects/library/seqan/sequence/string_packed.h"(394)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void assign(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource & source);       	// "projects/library/seqan/sequence/std_string.h"(272)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void assign(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource const & source);       	// "projects/library/seqan/sequence/std_string.h"(280)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource, typename TSize> inline void assign(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource & source, TSize limit);       	// "projects/library/seqan/sequence/std_string.h"(290)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource, typename TSize> inline void assign(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource const & source, TSize limit);       	// "projects/library/seqan/sequence/std_string.h"(299)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void assign(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource & source, Generous);       	// "projects/library/seqan/sequence/std_string.h"(311)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void assign(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource const & source, Generous);       	// "projects/library/seqan/sequence/std_string.h"(320)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void assign(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource & source, typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type limit, Generous);       	// "projects/library/seqan/sequence/std_string.h"(347)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void assign(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource const & source, typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type limit, Generous);       	// "projects/library/seqan/sequence/std_string.h"(357)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void assign(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource & source, Limit);       	// "projects/library/seqan/sequence/std_string.h"(369)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void assign(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource const & source, Limit);       	// "projects/library/seqan/sequence/std_string.h"(378)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void assign(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource & source, typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type limit, Limit);       	// "projects/library/seqan/sequence/std_string.h"(389)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void assign(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource const & source, typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type limit, Limit);       	// "projects/library/seqan/sequence/std_string.h"(404)
template <typename TTarget, typename TSource> inline void assign(TTarget & target, TSource & source, typename Size<TTarget>::Type limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(970)
template <typename TTarget, typename TSource> inline void assign(TTarget const & target, TSource & source, typename Size<TTarget>::Type limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(979)
template <typename TTarget, typename TSource> inline void assign(TTarget & target, TSource const & source, typename Size<TTarget>::Type limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(988)
template <typename TTarget, typename TSource> inline void assign(TTarget const & target, TSource const & source, typename Size<TTarget>::Type limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(997)
template <typename TValue, unsigned int SPACE, typename TSource> inline void assign( String<TValue, Block<SPACE> >& target, TSource const& source);       	// "projects/library/seqan/sequence/string_stack.h"(226)
template <typename TTargetValue, typename TTargetSpec, typename TSource> inline void assign(String<TTargetValue, TTargetSpec> & target, TSource & source);       	// "projects/library/seqan/sequence/string_base.h"(734)
template <typename TTargetValue, typename TTargetSpec, typename TSource> inline void assign(String<TTargetValue, TTargetSpec> & target, TSource const & source);       	// "projects/library/seqan/sequence/string_base.h"(743)
template <typename TTargetValue, typename TTargetSpec, typename TSource, typename TExpand> inline void assign(String<TTargetValue, TTargetSpec> & target, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(810)
template <typename TTargetValue, typename TTargetSpec, typename TSource, typename TSize, typename TExpand> inline void assign(String<TTargetValue, TTargetSpec> & target, TSource const & source, TSize limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(820)
template <typename TTargetValue, typename TTargetSpec, typename TSourceValue, typename TExpand> inline void assign(String<TTargetValue, TTargetSpec> & target, TSourceValue const * source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(833)
template <typename TTargetValue, typename TTargetSpec, typename TSourceValue, typename TSize, typename TExpand> inline void assign(String<TTargetValue, TTargetSpec> & target, TSourceValue const * source, TSize limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(843)

//____________________________________________________________________________
// assignValue

template <typename TContainer, typename TIterator, typename TValue> inline void assignValue(Iter<TContainer, AdaptorIterator<TIterator, ValueExpandIter> > & me, TValue const & _value);       	// "projects/library/seqan/sequence/string_value_expand.h"(453)
template <typename TContainer, typename TIterator, typename TValue> inline void assignValue(Iter<TContainer, AdaptorIterator<TIterator, ValueExpandIter> > const & me, TValue const & _value);       	// "projects/library/seqan/sequence/string_value_expand.h"(473)
template <typename TValue, typename TPos> inline void assignValue(TValue * me, TPos pos, TValue const & _value);       	// "projects/library/seqan/sequence/string_pointer.h"(266)
template <typename TContainer, typename THostspec, typename TValue> inline void assignValue(Iter<TContainer, Packed<THostspec> > & me, TValue const & _value);       	// "projects/library/seqan/sequence/string_packed.h"(985)
template <typename TContainer, typename THostspec, typename TValue> inline void assignValue(Iter<TContainer, Packed<THostspec> > const & me, TValue const & _value);       	// "projects/library/seqan/sequence/string_packed.h"(995)
template <typename T, typename TValue, typename TPos> inline void assignValue(T & me, TPos pos, TValue const & _value);       	// "projects/library/seqan/sequence/sequence_interface.h"(775)
template <typename TValue, typename TSpec, typename TValue2> inline void assignValue(String<TValue, TSpec> & me, TValue2 const & _value);       	// "projects/library/seqan/sequence/string_base.h"(715)

//____________________________________________________________________________
// assignValueById

template <typename TString, typename TSpec, typename TString2> inline typename Id<StringSet<TString, TSpec> >::Type assignValueById(StringSet<TString, TSpec>& me, TString2& obj);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1366)
template <typename TString, typename TSpec, typename TId> inline typename Id<StringSet<TString, Owner<TSpec> > >::Type assignValueById(StringSet<TString, Owner<TSpec> >& me, TString& obj, TId id);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1378)
template <typename TString, typename TId> inline typename Id<StringSet<TString, Dependent<Generous> > >::Type assignValueById(StringSet<TString, Dependent<Generous> >& me, TString& obj, TId id);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1394)
template <typename TString, typename TId> inline typename Id<StringSet<TString, Dependent<Tight> > >::Type assignValueById(StringSet<TString, Dependent<Tight> >& me, TString& obj, TId id);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1413)
template <typename TString, typename TSpec1, typename TSpec2, typename TId> inline typename Id<StringSet<TString, TSpec1> >::Type assignValueById(StringSet<TString, TSpec1>& dest, StringSet<TString, TSpec2>& source, TId id);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1434)

//____________________________________________________________________________
// assign_std_string_Generous_impl

template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void assign_std_string_Generous_impl(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource & source, typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type limit);       	// "projects/library/seqan/sequence/std_string.h"(331)

//____________________________________________________________________________
// atBegin

template <typename THost> inline bool atBegin(Segment<THost, InfixSegment> & segment);       	// "projects/library/seqan/sequence/segment_infix.h"(506)
template <typename THost> inline bool atBegin(Segment<THost, InfixSegment> const & segment);       	// "projects/library/seqan/sequence/segment_infix.h"(513)
template <typename THost> inline bool atBegin(Segment<THost, PrefixSegment> const & segment);       	// "projects/library/seqan/sequence/segment_prefix.h"(415)
template <typename TSSet, typename TSpec> inline bool atBegin(Iter<TSSet, ConcatVirtual<TSpec> > &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2227)
template <typename TSSet, typename TSpec> inline bool atBegin(Iter<TSSet, ConcatVirtual<TSpec> > const &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2234)
template <typename THost> inline bool atBegin(Segment<THost, SuffixSegment> const & segment);       	// "projects/library/seqan/sequence/segment_suffix.h"(404)

//____________________________________________________________________________
// atEnd

template <typename THost> inline bool atEnd(Segment<THost, InfixSegment> & segment);       	// "projects/library/seqan/sequence/segment_infix.h"(523)
template <typename THost> inline bool atEnd(Segment<THost, InfixSegment> const & segment);       	// "projects/library/seqan/sequence/segment_infix.h"(530)
template <typename TValue> inline bool atEnd(TValue * pos);       	// "projects/library/seqan/sequence/string_pointer.h"(290)
template <typename TValue> inline bool atEnd(TValue * pos, TValue const * container);       	// "projects/library/seqan/sequence/string_pointer.h"(301)
template <typename THost> inline bool atEnd(Segment<THost, PrefixSegment> const & segment);       	// "projects/library/seqan/sequence/segment_prefix.h"(425)
template <typename TSSet, typename TSpec> inline bool atEnd(Iter<TSSet, ConcatVirtual<TSpec> > &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2245)
template <typename TSSet, typename TSpec> inline bool atEnd(Iter<TSSet, ConcatVirtual<TSpec> > const &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2252)
template <typename THost> inline bool atEnd(Segment<THost, SuffixSegment> const & segment);       	// "projects/library/seqan/sequence/segment_suffix.h"(414)
template <typename TValue, unsigned int SPACE, typename TIteratorSpec> inline bool atEnd( Iter<String<TValue, Block<SPACE> >, TIteratorSpec>& it, String<TValue, Block<SPACE> >& container);       	// "projects/library/seqan/sequence/string_stack.h"(260)

//____________________________________________________________________________
// atEndOfSequence

template <typename TIterator> inline bool atEndOfSequence(TIterator const &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2263)
template <typename TSSet, typename TSpec> inline bool atEndOfSequence(Iter<TSSet, ConcatVirtual<TSpec> > const &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2270)
template <typename TIterator> inline bool atEndOfSequence(TIterator &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2277)

//____________________________________________________________________________
// back

template <typename T> inline typename Reference<T const>::Type back(T const & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(679)
template <typename T> inline typename Reference<T>::Type back(T & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(687)

//____________________________________________________________________________
// begin

template <typename TValue, typename THost, typename TMap, typename TSpec, typename TTag> inline typename Iterator<String< TValue, ValueExpand<THost, TMap, TSpec> >, Tag<TTag> const>::Type begin(String< TValue, ValueExpand<THost, TMap, TSpec> > & me, Tag<TTag> const tag_);       	// "projects/library/seqan/sequence/string_value_expand.h"(293)
template <typename TValue, typename THost, typename TMap, typename TSpec, typename TTag> inline typename Iterator<String< TValue, ValueExpand<THost, TMap, TSpec> > const, Tag<TTag> const>::Type begin(String< TValue, ValueExpand<THost, TMap, TSpec> > const & me, Tag<TTag> const tag_);       	// "projects/library/seqan/sequence/string_value_expand.h"(301)
template <typename T> inline typename Iterator<T *, typename DefaultGetIteratorSpec<T>::Type>::Type begin(T * me);       	// "projects/library/seqan/sequence/string_pointer.h"(147)
template <typename TValue> inline typename Iterator<TValue *, Standard>::Type begin(TValue * me, Standard);       	// "projects/library/seqan/sequence/string_pointer.h"(158)
template <typename TValue> inline typename Iterator<TValue const *, Standard>::Type begin(TValue const * me, Standard);       	// "projects/library/seqan/sequence/string_pointer.h"(168)
template <typename TValue, typename TSpec> inline typename Iterator<TValue *, Tag<TSpec> const>::Type begin(TValue * me, Tag<TSpec> const);       	// "projects/library/seqan/sequence/string_pointer.h"(177)
template <typename TValue, typename TSpec> inline typename Iterator<TValue const *, Tag<TSpec> const>::Type begin(TValue const * me, Tag<TSpec> const);       	// "projects/library/seqan/sequence/string_pointer.h"(187)
template <typename TValue, typename THostspec, typename TTag> inline typename Iterator<String<TValue, Packed<THostspec> >, Tag<TTag> const>::Type begin(String<TValue, Packed<THostspec> > & me, Tag<TTag> const tag_);       	// "projects/library/seqan/sequence/string_packed.h"(440)
template <typename TValue, typename THostspec, typename TTag> inline typename Iterator<String<TValue, Packed<THostspec> > const, Tag<TTag> const>::Type begin(String<TValue, Packed<THostspec> > const & me, Tag<TTag> const tag_);       	// "projects/library/seqan/sequence/string_packed.h"(448)
template <typename TChar, typename TCharTraits, typename TAlloc> inline typename Iterator< ::std::basic_string<TChar, TCharTraits, TAlloc>, Standard>::Type begin(::std::basic_string<TChar, TCharTraits, TAlloc> & me, Standard);       	// "projects/library/seqan/sequence/std_string.h"(159)
template <typename TChar, typename TCharTraits, typename TAlloc> inline typename Iterator< ::std::basic_string<TChar, TCharTraits, TAlloc> const, Standard>::Type begin(::std::basic_string<TChar, TCharTraits, TAlloc> const & me, Standard);       	// "projects/library/seqan/sequence/std_string.h"(167)
template <typename TStringSet, typename TSpec > inline typename Iterator< ConcatenatorNto1<TStringSet const>, Tag<TSpec> const >::Type begin(ConcatenatorNto1<TStringSet const> concat, Tag<TSpec> const);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1800)
template <typename TStringSet, typename TSpec > inline typename Iterator< ConcatenatorNto1<TStringSet>, Tag<TSpec> const >::Type begin(ConcatenatorNto1<TStringSet> concat, Tag<TSpec> const);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1807)
template <typename T> inline typename Iterator<T, typename DefaultGetIteratorSpec<T>::Type>::Type begin(T & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(259)
template <typename T> inline typename Iterator<T const, typename DefaultGetIteratorSpec<T>::Type>::Type begin(T const & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(266)
template <typename T, typename TSpec> inline typename Iterator<T, Tag<TSpec> const>::Type begin(T & me, Tag<TSpec> const tag_);       	// "projects/library/seqan/sequence/sequence_interface.h"(327)
template <typename T, typename TSpec> inline typename Iterator<T const, Tag<TSpec> const>::Type begin(T const & me, Tag<TSpec> const tag_);       	// "projects/library/seqan/sequence/sequence_interface.h"(335)
template <typename TValue, unsigned int SPACE, typename TSpec> inline typename Iterator<String<TValue, Block<SPACE> >, Tag<TSpec> const >::Type begin(String<TValue, Block<SPACE> > &me, Tag<TSpec> const);       	// "projects/library/seqan/sequence/string_stack.h"(191)
template <typename TValue, unsigned int SPACE, typename TSpec> inline typename Iterator<String<TValue, Block<SPACE> > const, Tag<TSpec> const>::Type begin(String<TValue, Block<SPACE> > const &me, Tag<TSpec> const);       	// "projects/library/seqan/sequence/string_stack.h"(199)

//____________________________________________________________________________
// beginPosition

template <typename T> inline typename Position<T>::Type beginPosition(T &);       	// "projects/library/seqan/sequence/sequence_interface.h"(406)
template <typename T> inline typename Position<T>::Type beginPosition(T const &);       	// "projects/library/seqan/sequence/sequence_interface.h"(413)

//____________________________________________________________________________
// capacity

template <typename THost, typename TSpec> inline typename Size< Segment<THost, TSpec> const>::Type capacity(Segment<THost, TSpec> const & me);       	// "projects/library/seqan/sequence/segment_base.h"(270)
template <typename TValue, typename THost, typename TMap, typename TSpec> inline typename Size<String< TValue, ValueExpand<THost, TMap, TSpec> > const>::Type capacity(String< TValue, ValueExpand<THost, TMap, TSpec> > const & me);       	// "projects/library/seqan/sequence/string_value_expand.h"(361)
template <typename TValue, typename THostspec> inline typename Size<String<TValue, Packed<THostspec> > const>::Type capacity(String<TValue, Packed<THostspec> > const & me);       	// "projects/library/seqan/sequence/string_packed.h"(505)
template <typename TChar, typename TCharTraits, typename TAlloc> inline typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type capacity(::std::basic_string<TChar, TCharTraits, TAlloc> const & me);       	// "projects/library/seqan/sequence/std_string.h"(233)
template <typename T> inline typename Size<T const>::Type capacity(T const & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(856)
template <typename TValue, unsigned int SPACE> inline typename Size<String<TValue, Block<SPACE> > >::Type capacity(String<TValue, Block<SPACE> > const & me);       	// "projects/library/seqan/sequence/string_stack.h"(522)

//____________________________________________________________________________
// clear

template <typename THost, typename TSpec> inline void clear(Segment<THost, TSpec> & target);       	// "projects/library/seqan/sequence/segment_base.h"(1055)
template <typename TValue> inline void clear(TValue * me);       	// "projects/library/seqan/sequence/string_pointer.h"(364)
template <typename TValue, typename THostspec> inline void clear(String<TValue, Packed<THostspec> > & me);       	// "projects/library/seqan/sequence/string_packed.h"(520)
template <typename TChar, typename TCharTraits, typename TAlloc> inline void clear(::std::basic_string<TChar, TCharTraits, TAlloc> & me);       	// "projects/library/seqan/sequence/std_string.h"(257)
template <typename TString > inline void clear(StringSet< TString, Owner<Default> > &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1107)
template <typename TString, typename TDelimiter > inline void clear(StringSet< TString, Owner<ConcatDirect<TDelimiter> > > &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1116)
template <typename TString > inline void clear(StringSet< TString, Dependent<Generous> > & me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1124)
template <typename TString > inline void clear(StringSet<TString, Dependent<Tight> >& me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1133)
template <typename TValue, unsigned int SPACE> inline void clear(String<TValue, Block<SPACE> >& me);       	// "projects/library/seqan/sequence/string_stack.h"(271)
template <typename TValue, typename TSpec> inline void clear(String<TValue, TSpec> & me);       	// "projects/library/seqan/sequence/string_base.h"(204)

//____________________________________________________________________________
// compare

template <typename TSpec, typename TLeft, typename TRight> inline void compare(Lexical<TSpec> & lexical, TLeft const & left, TRight const & right);       	// "projects/library/seqan/sequence/lexical.h"(278)
template <typename TSpec, typename TLeftValue, typename TRight> inline void compare(Lexical<TSpec> & lexical, TLeftValue const * left, TRight const & right);       	// "projects/library/seqan/sequence/lexical.h"(288)
template <typename TSpec, typename TLeftValue, typename TRightValue> inline void compare(Lexical<TSpec> & lexical, TLeftValue const * left, TRightValue const * right);       	// "projects/library/seqan/sequence/lexical.h"(296)
template <typename TSpec, typename TLeft, typename TRightValue> inline void compare(Lexical<TSpec> & lexical, TLeft const & left, TRightValue const * right);       	// "projects/library/seqan/sequence/lexical.h"(304)

//____________________________________________________________________________
// compare_

template <typename TSpec, typename TLeft, typename TRight> inline void compare_(Lexical<TSpec> & lexical, TLeft & left, TRight & right);       	// "projects/library/seqan/sequence/lexical.h"(237)

//____________________________________________________________________________
// computeGenerousCapacity

template <typename T, typename TSize> inline TSize computeGenerousCapacity(T const & , TSize capacity);       	// "projects/library/seqan/sequence/sequence_interface.h"(927)

//____________________________________________________________________________
// concat

template <typename TString> inline typename Concatenator<TString>::Type & concat(TString &string);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1848)
template <typename TString, typename TSpec> inline typename Concatenator< StringSet<TString, TSpec> >::Type & concat(StringSet<TString, TSpec> &set);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1854)
template <typename TString, typename TSpec> inline typename Concatenator< StringSet<TString, TSpec> const>::Type & concat(StringSet<TString, TSpec> const &set);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1860)

//____________________________________________________________________________
// container

template <typename TSSet, typename TSpec> inline typename Concatenator<TSSet>::Type container(Iter<TSSet, ConcatVirtual<TSpec> > &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2209)
template <typename TSSet, typename TSpec> inline typename Concatenator<TSSet>::Type container(Iter<TSSet, ConcatVirtual<TSpec> > const &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2216)

//____________________________________________________________________________
// countSequences

template <typename TString> inline unsigned countSequences(TString const &);       	// "projects/library/seqan/sequence/sequence_multiple.h"(620)
template <typename TString, typename TSpec> inline typename Size<StringSet<TString, TSpec> >::Type countSequences(StringSet<TString, TSpec> const &stringSet);       	// "projects/library/seqan/sequence/sequence_multiple.h"(626)

//____________________________________________________________________________
// create

template <typename TTargetValue, typename TSource> inline void create(String<TTargetValue, CStyle> & target, TSource & source);       	// "projects/library/seqan/sequence/string_cstyle.h"(693)
template <typename TTargetValue, typename TSource, typename TSize> inline void create(String<TTargetValue, CStyle> & target, TSource & source, TSize limit);       	// "projects/library/seqan/sequence/string_cstyle.h"(704)
template <typename TTargetValue, typename TSource, typename TExpand> inline void create(String<TTargetValue, CStyle> & target, TSource & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_cstyle.h"(717)
template <typename TTargetValue, typename TSource, typename TSize, typename TExpand> inline void create(String<TTargetValue, CStyle> & target, TSource & source, TSize limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_cstyle.h"(728)
template <typename TTargetValue, typename TSource, typename TExpand> inline void create(String<TTargetValue, CStyle> & target, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_cstyle.h"(738)
template <typename TTargetValue, typename TSource, typename TSize, typename TExpand> inline void create(String<TTargetValue, CStyle> & target, TSource const & source, TSize limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_cstyle.h"(749)
template <typename TTargetValue, typename TSourceValue, typename TExpand> inline void create(String<TTargetValue, CStyle> & target, TSourceValue const * source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_cstyle.h"(762)
template <typename TTargetValue, typename TSourceValue, typename TSize, typename TExpand> inline void create(String<TTargetValue, CStyle> & target, TSourceValue const * source, TSize limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_cstyle.h"(773)

//____________________________________________________________________________
// empty

template <typename TValue> inline bool empty(TValue * me);       	// "projects/library/seqan/sequence/string_pointer.h"(377)
template <typename TChar, typename TCharTraits, typename TAlloc> inline bool empty(::std::basic_string<TChar, TCharTraits, TAlloc> const & me);       	// "projects/library/seqan/sequence/std_string.h"(245)
template <typename T> inline bool empty(T const & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(879)
template <typename TValue, unsigned int SPACE> inline bool empty(String<TValue, Block<SPACE> > const& me);       	// "projects/library/seqan/sequence/string_stack.h"(503)

//____________________________________________________________________________
// end

template <typename TValue, typename THost, typename TMap, typename TSpec, typename TTag> inline typename Iterator<String< TValue, ValueExpand<THost, TMap, TSpec> >, Tag<TTag> const>::Type end(String< TValue, ValueExpand<THost, TMap, TSpec> > & me, Tag<TTag> const tag_);       	// "projects/library/seqan/sequence/string_value_expand.h"(312)
template <typename TValue, typename THost, typename TMap, typename TSpec, typename TTag> inline typename Iterator<String< TValue, ValueExpand<THost, TMap, TSpec> > const, Tag<TTag> const>::Type end(String< TValue, ValueExpand<THost, TMap, TSpec> > const & me, Tag<TTag> const tag_);       	// "projects/library/seqan/sequence/string_value_expand.h"(320)
template <typename TValue> inline typename Iterator<TValue *, Standard>::Type end(TValue * me, Standard);       	// "projects/library/seqan/sequence/string_pointer.h"(201)
template <typename TValue> inline typename Iterator<TValue const *, Standard>::Type end(TValue const * me, Standard);       	// "projects/library/seqan/sequence/string_pointer.h"(211)
template <typename TValue, typename TSpec> inline typename Iterator<TValue *, Tag<TSpec> const>::Type end(TValue * me, Tag<TSpec> const tag_);       	// "projects/library/seqan/sequence/string_pointer.h"(220)
template <typename TValue, typename TSpec> inline typename Iterator<TValue const *, Tag<TSpec> const>::Type end(TValue const * me, Tag<TSpec> const tag_);       	// "projects/library/seqan/sequence/string_pointer.h"(229)
template <typename TValue, typename THostspec, typename TTag> inline typename Iterator<String<TValue, Packed<THostspec> >, Tag<TTag> const>::Type end(String<TValue, Packed<THostspec> > & me, Tag<TTag> const tag_);       	// "projects/library/seqan/sequence/string_packed.h"(461)
template <typename TValue, typename THostspec, typename TTag> inline typename Iterator<String<TValue, Packed<THostspec> > const, Tag<TTag> const>::Type end(String<TValue, Packed<THostspec> > const & me, Tag<TTag> const tag_);       	// "projects/library/seqan/sequence/string_packed.h"(469)
template <typename TChar, typename TCharTraits, typename TAlloc> inline typename Iterator< ::std::basic_string<TChar, TCharTraits, TAlloc>, Standard>::Type end(::std::basic_string<TChar, TCharTraits, TAlloc> & me, Standard);       	// "projects/library/seqan/sequence/std_string.h"(180)
template <typename TChar, typename TCharTraits, typename TAlloc> inline typename Iterator< ::std::basic_string<TChar, TCharTraits, TAlloc> const, Standard>::Type end(::std::basic_string<TChar, TCharTraits, TAlloc> const & me, Standard);       	// "projects/library/seqan/sequence/std_string.h"(188)
template <typename TStringSet, typename TSpec > inline typename Iterator< ConcatenatorNto1<TStringSet const>, Tag<TSpec> const >::Type end(ConcatenatorNto1<TStringSet const> concat, Tag<TSpec> const);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1817)
template <typename TStringSet, typename TSpec > inline typename Iterator< ConcatenatorNto1<TStringSet>, Tag<TSpec> const >::Type end(ConcatenatorNto1<TStringSet> concat, Tag<TSpec> const);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1825)
template <typename T> inline typename Iterator<T, typename DefaultGetIteratorSpec<T>::Type>::Type end(T & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(442)
template <typename T> inline typename Iterator<T const, typename DefaultGetIteratorSpec<T>::Type>::Type end(T const & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(449)
template <typename T, typename TSpec> inline typename Iterator<T, Tag<TSpec> const>::Type end(T & me, Tag<TSpec> const tag_);       	// "projects/library/seqan/sequence/sequence_interface.h"(502)
template <typename T, typename TSpec> inline typename Iterator<T const, Tag<TSpec> const>::Type end(T const & me, Tag<TSpec> const tag_);       	// "projects/library/seqan/sequence/sequence_interface.h"(510)
template <typename TValue, unsigned int SPACE, typename TSpec> inline typename Iterator<String<TValue, Block<SPACE> >, Tag<TSpec> const >::Type end(String<TValue, Block<SPACE> > &me, Tag<TSpec> const);       	// "projects/library/seqan/sequence/string_stack.h"(208)
template <typename TValue, unsigned int SPACE, typename TSpec> inline typename Iterator<String<TValue, Block<SPACE> > const, Tag<TSpec> const>::Type end(String<TValue, Block<SPACE> > const &me, Tag<TSpec> const);       	// "projects/library/seqan/sequence/string_stack.h"(216)

//____________________________________________________________________________
// endPosition

template <typename T> inline typename Position<T>::Type endPosition(T & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(535)
template <typename T> inline typename Position<T>::Type endPosition(T const & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(542)

//____________________________________________________________________________
// erase

template <typename T, typename TPosition> inline void erase(T & me, TPosition pos, TPosition pos_end);       	// "projects/library/seqan/sequence/sequence_interface.h"(1433)
template <typename T, typename TPosition> inline void erase(T & me, TPosition pos);       	// "projects/library/seqan/sequence/sequence_interface.h"(1442)

//____________________________________________________________________________
// fill

template <typename TValue, typename TExpand> inline size_t fill( TValue * me, size_t new_length, TValue const & val, Tag<TExpand> const &);       	// "projects/library/seqan/sequence/string_pointer.h"(690)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSize, typename TExpand> inline typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type fill( ::std::basic_string<TChar, TCharTraits, TAlloc> & me, TSize new_length, TChar const & val, Tag<TExpand> const &);       	// "projects/library/seqan/sequence/std_string.h"(667)
template <typename T, typename TSize, typename TValue> inline typename Size<T>::Type fill( T & me, TSize new_length, TValue const & val);       	// "projects/library/seqan/sequence/sequence_interface.h"(1483)
template <typename TValue, typename TSpec, typename TSize, typename TValue2, typename TExpand> inline TSize fill(String<TValue, TSpec> & me, TSize new_length, TValue2 const & val, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(1508)

//____________________________________________________________________________
// front

template <typename T> inline typename Reference<T>::Type front(T & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(645)
template <typename T> inline typename Reference<T const>::Type front(T const & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(652)

//____________________________________________________________________________
// getSeqNo

template <typename TPosition> inline TPosition getSeqNo(TPosition const &, Nothing const &);       	// "projects/library/seqan/sequence/sequence_multiple.h"(214)
template <typename TPosition> inline TPosition getSeqNo(TPosition const &);       	// "projects/library/seqan/sequence/sequence_multiple.h"(225)
template <typename T1, typename T2, typename TCompression, typename TLimitsString> inline T1 getSeqNo(Pair<T1, T2, TCompression> const &pos, TLimitsString const &);       	// "projects/library/seqan/sequence/sequence_multiple.h"(239)
template <typename T1, typename T2, typename TCompression> inline T1 getSeqNo(Pair<T1, T2, TCompression> const &pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(244)
template <typename TPos, typename TLimitsString> inline TPos getSeqNo(TPos const &pos, TLimitsString const &limits);       	// "projects/library/seqan/sequence/sequence_multiple.h"(264)

//____________________________________________________________________________
// getSeqOffset

template <typename TPosition> inline TPosition getSeqOffset(TPosition const &pos, Nothing const &);       	// "projects/library/seqan/sequence/sequence_multiple.h"(219)
template <typename TPosition> inline TPosition getSeqOffset(TPosition const &pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(230)
template <typename T1, typename T2, typename TCompression, typename TLimitsString> inline T2 getSeqOffset(Pair<T1, T2, TCompression> const &pos, TLimitsString const &);       	// "projects/library/seqan/sequence/sequence_multiple.h"(250)
template <typename T1, typename T2, typename TCompression> inline T1 getSeqOffset(Pair<T1, T2, TCompression> const &pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(255)
template <typename TPos, typename TLimitsString> inline TPos getSeqOffset(TPos const &pos, TLimitsString const &limits);       	// "projects/library/seqan/sequence/sequence_multiple.h"(273)

//____________________________________________________________________________
// getValue

template <typename TContainer, typename TIterator> inline typename Value<TContainer>::Type getValue(Iter<TContainer, AdaptorIterator<TIterator, ValueExpandIter> > & me);       	// "projects/library/seqan/sequence/string_value_expand.h"(396)
template <typename TContainer, typename TIterator> inline void getValue(Iter<TContainer, AdaptorIterator<TIterator, ValueExpandIter> > const & me);       	// "projects/library/seqan/sequence/string_value_expand.h"(413)
template <typename TContainer, typename THostspec> inline typename GetValue<Iter<TContainer, Packed<THostspec> > >::Type getValue(Iter<TContainer, Packed<THostspec> > & me);       	// "projects/library/seqan/sequence/string_packed.h"(949)
template <typename TContainer, typename THostspec> inline typename GetValue<Iter<TContainer, Packed<THostspec> > const>::Type getValue(Iter<TContainer, Packed<THostspec> > const & me);       	// "projects/library/seqan/sequence/string_packed.h"(956)
template <typename T, typename TPos> inline typename GetValue<T>::Type getValue(T & me, TPos pos);       	// "projects/library/seqan/sequence/sequence_interface.h"(610)
template <typename T, typename TPos> inline typename GetValue<T const>::Type getValue(T const & me, TPos pos);       	// "projects/library/seqan/sequence/sequence_interface.h"(618)

//____________________________________________________________________________
// getValueById

template <typename TString, typename TSpec, typename TId> inline typename Reference<StringSet<TString, Owner<TSpec> > >::Type getValueById(StringSet<TString, Owner<TSpec> >& me, TId const id);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1279)
template <typename TString, typename TId> inline typename Reference<StringSet<TString, Dependent<Generous> > >::Type getValueById(StringSet<TString, Dependent<Generous> >& me, TId const id);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1290)
template <typename TString, typename TId> inline typename Reference<StringSet<TString, Dependent<Tight> > >::Type getValueById(StringSet<TString, Dependent<Tight> >&me, TId const id);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1302)

//____________________________________________________________________________
// goBegin

template <typename THost> inline void goBegin(Segment<THost, InfixSegment> & segment);       	// "projects/library/seqan/sequence/segment_infix.h"(541)
template <typename THost, typename THost2> inline void goBegin(Segment<THost, InfixSegment> & segment, THost2 &);       	// "projects/library/seqan/sequence/segment_infix.h"(550)
template <typename THost, typename THost2> inline void goBegin(Segment<THost, InfixSegment> & segment, THost2 const &);       	// "projects/library/seqan/sequence/segment_infix.h"(557)
template <typename THost> inline void goBegin(Segment<THost, PrefixSegment> & segment, THost &);       	// "projects/library/seqan/sequence/segment_prefix.h"(436)
template <typename THost> inline void goBegin(Segment<THost, PrefixSegment> & segment);       	// "projects/library/seqan/sequence/segment_prefix.h"(444)
template <typename THost> inline void goBegin(Segment<THost, SuffixSegment> & segment, THost &);       	// "projects/library/seqan/sequence/segment_suffix.h"(425)
template <typename THost> inline void goBegin(Segment<THost, SuffixSegment> & segment);       	// "projects/library/seqan/sequence/segment_suffix.h"(433)

//____________________________________________________________________________
// goEnd

template <typename THost> inline void goEnd(Segment<THost, InfixSegment> & segment);       	// "projects/library/seqan/sequence/segment_infix.h"(567)
template <typename THost, typename THost2> inline void goEnd(Segment<THost, InfixSegment> & segment, THost2 &);       	// "projects/library/seqan/sequence/segment_infix.h"(576)
template <typename THost, typename THost2> inline void goEnd(Segment<THost, InfixSegment> & segment, THost2 const &);       	// "projects/library/seqan/sequence/segment_infix.h"(583)
template <typename THost> inline void goEnd(Segment<THost, PrefixSegment> & segment, THost &);       	// "projects/library/seqan/sequence/segment_prefix.h"(454)
template <typename THost> inline void goEnd(Segment<THost, PrefixSegment> & segment);       	// "projects/library/seqan/sequence/segment_prefix.h"(462)
template <typename THost> inline void goEnd(Segment<THost, SuffixSegment> & segment, THost &);       	// "projects/library/seqan/sequence/segment_suffix.h"(443)
template <typename THost> inline void goEnd(Segment<THost, SuffixSegment> & segment);       	// "projects/library/seqan/sequence/segment_suffix.h"(451)

//____________________________________________________________________________
// goNext

template <typename TContainer, typename THostspec> inline void goNext(Iter<TContainer, Packed<THostspec> > & me);       	// "projects/library/seqan/sequence/string_packed.h"(1144)
template <typename TStringSet, typename TSpec> inline void goNext(Iter<TStringSet, ConcatVirtual<TSpec> > & me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2067)

//____________________________________________________________________________
// goPrevious

template <typename TContainer, typename THostspec> inline void goPrevious(Iter<TContainer, Packed<THostspec> > & me);       	// "projects/library/seqan/sequence/string_packed.h"(1165)
template <typename TStringSet, typename TSpec> inline void goPrevious(Iter<TStringSet, ConcatVirtual<TSpec> > & me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2093)

//____________________________________________________________________________
// hasPrefix

template <typename TLeft, typename TRight > inline bool hasPrefix(TLeft const & left, TRight const & right);       	// "projects/library/seqan/sequence/lexical.h"(707)
template <typename TSpec> inline bool hasPrefix(Lexical<TSpec> const & _lex);       	// "projects/library/seqan/sequence/lexical.h"(715)

//____________________________________________________________________________
// id

template <typename THost, typename TSpec> inline void const * id(Segment<THost, TSpec> const & me);       	// "projects/library/seqan/sequence/segment_base.h"(246)
template <typename TValue, typename THost, typename TMap, typename TSpec> inline void const * id(String< TValue, ValueExpand<THost, TMap, TSpec> > const & me);       	// "projects/library/seqan/sequence/string_value_expand.h"(257)
template <typename TValue, typename THostspec> inline void const * id(String<TValue, Packed<THostspec> > const & me);       	// "projects/library/seqan/sequence/string_packed.h"(406)
template <typename TChar, typename TCharTraits, typename TAlloc> inline void const * id(::std::basic_string<TChar, TCharTraits, TAlloc> const & me);       	// "projects/library/seqan/sequence/std_string.h"(147)
template <typename T> inline void const * id(T const & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(208)

//____________________________________________________________________________
// idToPosition

template <typename TString, typename TSpec, typename TId> inline typename Id<StringSet<TString, Owner<TSpec> > >::Type idToPosition(StringSet<TString, Owner<TSpec> >&, TId const id);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1578)
template <typename TString, typename TId> inline typename Id<StringSet<TString, Dependent<Generous> > >::Type idToPosition(StringSet<TString, Dependent<Generous> >& me, TId const id);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1587)
template <typename TString, typename TId> inline typename Id<StringSet<TString, Dependent<Tight> > >::Type idToPosition(StringSet<TString, Dependent<Tight> >&me, TId const id);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1596)

//____________________________________________________________________________
// infix

template <typename T, typename TPosBegin, typename TPosEnd> inline typename Infix<T>::Type infix(T & t, TPosBegin pos_begin, TPosEnd pos_end);       	// "projects/library/seqan/sequence/segment_infix.h"(673)
template <typename T, typename TPosBegin, typename TPosEnd> inline typename Infix<T *>::Type infix(T * t, TPosBegin pos_begin, TPosEnd pos_end);       	// "projects/library/seqan/sequence/segment_infix.h"(681)
template <typename T, typename TSpec, typename TPosBegin, typename TPosEnd> inline typename Infix<Segment<T, TSpec> >::Type infix(Segment<T, TSpec> & t, TPosBegin pos_begin, TPosEnd pos_end);       	// "projects/library/seqan/sequence/segment_infix.h"(689)
template <typename T, typename TSpec, typename TPosBegin, typename TPosEnd> inline typename Infix<Segment<T, TSpec> const>::Type infix(Segment<T, TSpec> const & t, TPosBegin pos_begin, TPosEnd pos_end);       	// "projects/library/seqan/sequence/segment_infix.h"(700)

//____________________________________________________________________________
// infixWithLength

template <typename T, typename TPosBegin, typename TSize> inline typename Infix<T>::Type infixWithLength(T & t, TPosBegin pos_begin, TSize length);       	// "projects/library/seqan/sequence/segment_infix.h"(731)
template <typename T, typename TPosBegin, typename TSize> inline typename Infix<T *>::Type infixWithLength(T * t, TPosBegin pos_begin, TSize length);       	// "projects/library/seqan/sequence/segment_infix.h"(739)
template <typename T, typename TSpec, typename TPosBegin, typename TSize> inline typename Infix<Segment<T, TSpec> >::Type infixWithLength(Segment<T, TSpec> & t, TPosBegin pos_begin, TSize length);       	// "projects/library/seqan/sequence/segment_infix.h"(747)
template <typename T, typename TSpec, typename TPosBegin, typename TSize> inline typename Infix<Segment<T, TSpec> const>::Type infixWithLength(Segment<T, TSpec> const & t, TPosBegin pos_begin, TSize length);       	// "projects/library/seqan/sequence/segment_infix.h"(758)
template <typename TString, typename TSpec, typename TPosition, typename TSize > inline typename Infix<TString>::Type infixWithLength(StringSet< TString, TSpec > &me, TPosition pos, TSize length);       	// "projects/library/seqan/sequence/sequence_multiple.h"(468)
template <typename TString, typename TSpec, typename TPosition, typename TSize > inline typename Infix<TString const>::Type infixWithLength(StringSet< TString, TSpec > const &me, TPosition pos, TSize length);       	// "projects/library/seqan/sequence/sequence_multiple.h"(482)
template <typename TString, typename TDelimiter, typename TPosition, typename TSize > inline typename Infix<TString>::Type infixWithLength(StringSet< TString, Owner<ConcatDirect<TDelimiter> > > &me, TPosition pos, TSize length);       	// "projects/library/seqan/sequence/sequence_multiple.h"(496)
template <typename TString, typename TDelimiter, typename TPosition, typename TSize > inline typename Infix<TString const>::Type infixWithLength(StringSet< TString, Owner<ConcatDirect<TDelimiter> > > const &me, TPosition pos, TSize length);       	// "projects/library/seqan/sequence/sequence_multiple.h"(503)

//____________________________________________________________________________
// insertValue

template <typename THost, typename TSpec, typename TPosition, typename TValue, typename TExpand> inline void insertValue(Segment<THost, TSpec> & me, TPosition pos, TValue const & _value, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(763)
template <typename THost, typename TSpec, typename TPosition, typename TValue, typename TExpand> inline void insertValue(Segment<THost, TSpec> const & me, TPosition pos, TValue const & _value, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(773)
template <typename T, typename TPosition, typename TValue> inline void insertValue(T & me, TPosition pos, TValue const & _value);       	// "projects/library/seqan/sequence/sequence_interface.h"(1149)
template <typename T, typename TPosition, typename TValue> inline void insertValue(T const & me, TPosition pos, TValue const & _value);       	// "projects/library/seqan/sequence/sequence_interface.h"(1158)
template <typename TTargetValue, typename TTargetSpec, typename TPosition, typename TValue, typename TExpand> inline void insertValue(String<TTargetValue, TTargetSpec> & me, TPosition pos, TValue const & _value, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(1165)

//____________________________________________________________________________
// isEqual

template <typename TLeftValue, typename TRight > inline bool isEqual(TLeftValue * left, TRight const & right);       	// "projects/library/seqan/sequence/string_pointer.h"(715)
template <typename TLeft, typename TRight > inline bool isEqual(TLeft const & left, TRight const & right);       	// "projects/library/seqan/sequence/lexical.h"(329)
template <typename TSpec> inline bool isEqual(Lexical<TSpec> const & _lex);       	// "projects/library/seqan/sequence/lexical.h"(337)

//____________________________________________________________________________
// isGreater

template <typename TLeftValue, typename TRight> inline bool isGreater(TLeftValue * left, TRight const & right);       	// "projects/library/seqan/sequence/string_pointer.h"(800)
template <typename TLeft, typename TRight, typename TPrefixOrder > inline bool isGreater(TLeft const & left, TRight const & right, Tag<TPrefixOrder> const tag);       	// "projects/library/seqan/sequence/lexical.h"(540)
template <typename TLeft, typename TRight> inline bool isGreater(TLeft const & left, TRight const & right);       	// "projects/library/seqan/sequence/lexical.h"(549)
template <typename TSpec> inline bool isGreater(Lexical<TSpec> const & _lex, TagPrefixLess);       	// "projects/library/seqan/sequence/lexical.h"(558)
template <typename TSpec> inline bool isGreater(Lexical<TSpec> const & _lex, TagPrefixGreater);       	// "projects/library/seqan/sequence/lexical.h"(566)
template <typename TSpec> inline bool isGreater(Lexical<TSpec> const & _lex);       	// "projects/library/seqan/sequence/lexical.h"(573)

//____________________________________________________________________________
// isGreaterOrEqual

template <typename TLeftValue, typename TRight> inline bool isGreaterOrEqual(TLeftValue * left, TRight const & right);       	// "projects/library/seqan/sequence/string_pointer.h"(820)
template <typename TLeft, typename TRight, typename TPrefixOrder > inline bool isGreaterOrEqual(TLeft const & left, TRight const & right, Tag<TPrefixOrder> const tag);       	// "projects/library/seqan/sequence/lexical.h"(608)
template <typename TLeft, typename TRight> inline bool isGreaterOrEqual(TLeft const & left, TRight const & right);       	// "projects/library/seqan/sequence/lexical.h"(617)
template <typename TSpec> inline bool isGreaterOrEqual(Lexical<TSpec> const & _lex, TagPrefixLess);       	// "projects/library/seqan/sequence/lexical.h"(626)
template <typename TSpec> inline bool isGreaterOrEqual(Lexical<TSpec> const & _lex, TagPrefixGreater);       	// "projects/library/seqan/sequence/lexical.h"(634)
template <typename TSpec> inline bool isGreaterOrEqual(Lexical<TSpec> const & _lex);       	// "projects/library/seqan/sequence/lexical.h"(641)

//____________________________________________________________________________
// isLess

template <typename TLeftValue, typename TRight> inline bool isLess(TLeftValue * left, TRight const & right);       	// "projects/library/seqan/sequence/string_pointer.h"(760)
template <typename TLeft, typename TRight, typename TPrefixOrder > inline bool isLess(TLeft const & left, TRight const & right, Tag<TPrefixOrder> const tag);       	// "projects/library/seqan/sequence/lexical.h"(405)
template <typename TLeft, typename TRight> inline bool isLess(TLeft const & left, TRight const & right);       	// "projects/library/seqan/sequence/lexical.h"(414)
template <typename TSpec> inline bool isLess(Lexical<TSpec> const & _lex, TagPrefixLess);       	// "projects/library/seqan/sequence/lexical.h"(423)
template <typename TSpec> inline bool isLess(Lexical<TSpec> const & _lex, TagPrefixGreater);       	// "projects/library/seqan/sequence/lexical.h"(431)
template <typename TSpec> inline bool isLess(Lexical<TSpec> const & _lex);       	// "projects/library/seqan/sequence/lexical.h"(438)

//____________________________________________________________________________
// isLessOrEqual

template <typename TLeftValue, typename TRight> inline bool isLessOrEqual(TLeftValue * left, TRight const & right);       	// "projects/library/seqan/sequence/string_pointer.h"(780)
template <typename TLeft, typename TRight, typename TPrefixOrder > inline bool isLessOrEqual(TLeft const & left, TRight const & right, Tag<TPrefixOrder> const tag);       	// "projects/library/seqan/sequence/lexical.h"(473)
template <typename TLeft, typename TRight> inline bool isLessOrEqual(TLeft const & left, TRight const & right);       	// "projects/library/seqan/sequence/lexical.h"(482)
template <typename TSpec> inline bool isLessOrEqual(Lexical<TSpec> const & _lex, TagPrefixLess);       	// "projects/library/seqan/sequence/lexical.h"(491)
template <typename TSpec> inline bool isLessOrEqual(Lexical<TSpec> const & _lex, TagPrefixGreater);       	// "projects/library/seqan/sequence/lexical.h"(499)
template <typename TSpec> inline bool isLessOrEqual(Lexical<TSpec> const & _lex);       	// "projects/library/seqan/sequence/lexical.h"(506)

//____________________________________________________________________________
// isNotEqual

template <typename TLeftValue, typename TRight > inline bool isNotEqual(TLeftValue * left, TRight const & right);       	// "projects/library/seqan/sequence/string_pointer.h"(737)
template <typename TLeft, typename TRight > inline bool isNotEqual(TLeft const & left, TRight const & right);       	// "projects/library/seqan/sequence/lexical.h"(363)
template <typename TSpec> inline bool isNotEqual(Lexical<TSpec> const & _lex);       	// "projects/library/seqan/sequence/lexical.h"(371)

//____________________________________________________________________________
// isPrefix

template <typename TLeft, typename TRight > inline bool isPrefix(TLeft const & left, TRight const & right);       	// "projects/library/seqan/sequence/lexical.h"(669)
template <typename TSpec> inline bool isPrefix(Lexical<TSpec> const & _lex);       	// "projects/library/seqan/sequence/lexical.h"(677)

//____________________________________________________________________________
// iter

template <typename TValue, typename THost, typename TMap, typename TPos, typename TSpec, typename TTag> inline typename Iterator<String< TValue, ValueExpand<THost, TMap, TSpec> >, Tag<TTag> const>::Type iter(String< TValue, ValueExpand<THost, TMap, TSpec> > & me, TPos pos_, Tag<TTag> const tag_);       	// "projects/library/seqan/sequence/string_value_expand.h"(269)
template <typename TValue, typename THost, typename TMap, typename TPos, typename TSpec, typename TTag> inline typename Iterator<String< TValue, ValueExpand<THost, TMap, TSpec> > const, Tag<TTag> const>::Type iter(String< TValue, ValueExpand<THost, TMap, TSpec> > const & me, TPos pos_, Tag<TTag> const tag_ );       	// "projects/library/seqan/sequence/string_value_expand.h"(280)
template <typename TValue, typename THostspec, typename TPos, typename TTag> inline typename Iterator<String<TValue, Packed<THostspec> >, Tag<TTag> const>::Type iter(String<TValue, Packed<THostspec> > & me, TPos pos_, Tag<TTag> const);       	// "projects/library/seqan/sequence/string_packed.h"(418)
template <typename TValue, typename THostspec, typename TPos, typename TTag> inline typename Iterator<String<TValue, Packed<THostspec> > const, Tag<TTag> const>::Type iter(String<TValue, Packed<THostspec> > const & me, TPos pos_, Tag<TTag> const);       	// "projects/library/seqan/sequence/string_packed.h"(428)
template <typename T, typename TPos> inline typename Iterator<T, typename DefaultGetIteratorSpec<T>::Type>::Type iter(T & me, TPos pos);       	// "projects/library/seqan/sequence/sequence_interface.h"(720)
template <typename T, typename TPos> inline typename Iterator<T const, typename DefaultGetIteratorSpec<T>::Type>::Type iter(T const & me, TPos pos);       	// "projects/library/seqan/sequence/sequence_interface.h"(728)
template <typename T, typename TPos, typename TTag> inline typename Iterator<T, Tag<TTag> const>::Type iter(T & me, TPos pos, Tag<TTag> const tag_);       	// "projects/library/seqan/sequence/sequence_interface.h"(739)
template <typename T, typename TPos, typename TTag> inline typename Iterator<T const, Tag<TTag> const>::Type iter(T const & me, TPos pos, Tag<TTag> const tag_);       	// "projects/library/seqan/sequence/sequence_interface.h"(748)

//____________________________________________________________________________
// lcpLength

template <typename TLeft, typename TRight > inline typename Size<TLeft>::Type lcpLength(TLeft const & left, TRight const & right);       	// "projects/library/seqan/sequence/lexical.h"(739)
template <typename TSpec> inline typename Size< Lexical<TSpec> >::Type lcpLength(Lexical<TSpec> const & _lex);       	// "projects/library/seqan/sequence/lexical.h"(748)

//____________________________________________________________________________
// length

template <typename THost, typename TSpec> inline typename Size<Segment<THost, TSpec> const>::Type length(Segment<THost, TSpec> const & me);       	// "projects/library/seqan/sequence/segment_base.h"(258)
template <typename TValue, typename THost, typename TMap, typename TSpec> inline typename Size<String< TValue, ValueExpand<THost, TMap, TSpec> > const>::Type length(String< TValue, ValueExpand<THost, TMap, TSpec> > const & me);       	// "projects/library/seqan/sequence/string_value_expand.h"(351)
template <typename TValue> inline size_t length(TValue * me);       	// "projects/library/seqan/sequence/string_pointer.h"(313)
template <typename TValue> inline size_t length(TValue const * me);       	// "projects/library/seqan/sequence/string_pointer.h"(324)
inline size_t length(char * me);       	// "projects/library/seqan/sequence/string_pointer.h"(334)
inline size_t length(char const * me);       	// "projects/library/seqan/sequence/string_pointer.h"(341)
template <typename TChar, typename TCharTraits, typename TAlloc> inline typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type length(::std::basic_string<TChar, TCharTraits, TAlloc> const & me);       	// "projects/library/seqan/sequence/std_string.h"(221)
template <typename TString, typename TSpec > inline typename Size< StringSet< TString, TSpec > >::Type length(StringSet< TString, TSpec > const &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1148)
template <typename TString> inline typename Size<StringSet<TString, Dependent<Tight> > >::Type length(StringSet<TString, Dependent<Tight> > const &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1155)
template <typename TStringSet > inline typename Size< ConcatenatorNto1<TStringSet> >::Type length(ConcatenatorNto1<TStringSet> const &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1790)
template <typename T> inline typename Size<T const>::Type length(T const & );       	// "projects/library/seqan/sequence/sequence_interface.h"(829)
template <typename TValue, unsigned int SPACE> inline typename Size<String<TValue, Block<SPACE> > >::Type length(String<TValue, Block<SPACE> > const & me);       	// "projects/library/seqan/sequence/string_stack.h"(511)
template <typename TValue, typename TSpec> inline typename Size< String<TValue, TSpec> const>::Type length(String<TValue, TSpec> const & me);       	// "projects/library/seqan/sequence/string_base.h"(179)

//____________________________________________________________________________
// lengthSum

template <typename TString > inline typename Size<TString>::Type lengthSum(TString const &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1023)
template <typename TString, typename TSpec > inline typename Size<TString>::Type lengthSum(StringSet< TString, TSpec > const &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1028)

//____________________________________________________________________________
// move

template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void move(Segment<THost, TSpec> & target, TSource & source);       	// "projects/library/seqan/sequence/segment_base.h"(490)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void move(Segment<THost, TSpec> & target, TSource const & source);       	// "projects/library/seqan/sequence/segment_base.h"(499)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void move(Segment<THost, TSpec> const & target, TSource & source);       	// "projects/library/seqan/sequence/segment_base.h"(511)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void move(Segment<THost, TSpec> const & target, TSource const & source);       	// "projects/library/seqan/sequence/segment_base.h"(520)
template <typename TTargetValue, typename TSource> inline void move(TTargetValue * & target, TSource & source);       	// "projects/library/seqan/sequence/string_pointer.h"(516)
template <typename TTargetValue, typename TSource> inline void move(TTargetValue * & target, TSource const & source);       	// "projects/library/seqan/sequence/string_pointer.h"(524)
template <typename TTargetValue, typename TSourceValue, typename TSpec> inline void move(String<TTargetValue, Alloc<TSpec> > & target, String<TSourceValue, Alloc<TSpec> > & source);       	// "projects/library/seqan/sequence/string_alloc.h"(360)
template <typename TTargetValue, typename TSourceValue, typename TSpec> inline void move(String<TTargetValue, Alloc<TSpec> > & target, String<TSourceValue, Alloc<TSpec> > const & source);       	// "projects/library/seqan/sequence/string_alloc.h"(367)
template <typename TValue, typename TSpec> inline void move(String<TValue, Alloc<TSpec> > & target, String<TValue, Alloc<TSpec> > & source);       	// "projects/library/seqan/sequence/string_alloc.h"(375)
template <typename TValue, typename TSpec> inline void move(String<TValue, Alloc<TSpec> > & target, String<TValue, Alloc<TSpec> > const & source);       	// "projects/library/seqan/sequence/string_alloc.h"(389)
template <typename TTargetValue, typename TTargetSpec, typename TSource> inline void move(String<TTargetValue, TTargetSpec> & target, TSource & source);       	// "projects/library/seqan/sequence/string_base.h"(915)
template <typename TTargetValue, typename TTargetSpec, typename TSource> inline void move(String<TTargetValue, TTargetSpec> & target, TSource const & source);       	// "projects/library/seqan/sequence/string_base.h"(924)
template <typename TTargetValue, typename TTargetSpec, typename TSource, typename TTag> inline void move(String<TTargetValue, TTargetSpec> & target, TSource & source, Tag<TTag> const tag);       	// "projects/library/seqan/sequence/string_base.h"(937)
template <typename TTargetValue, typename TTargetSpec, typename TSource, typename TTag> inline void move(String<TTargetValue, TTargetSpec> & target, TSource const & source, Tag<TTag> const tag);       	// "projects/library/seqan/sequence/string_base.h"(947)

//____________________________________________________________________________
// moveValue

template <typename TContainer, typename TIterator, typename TValue> inline void moveValue(Iter<TContainer, AdaptorIterator<TIterator, ValueExpandIter> > & me, TValue const & _value);       	// "projects/library/seqan/sequence/string_value_expand.h"(496)
template <typename TContainer, typename TIterator, typename TValue> inline void moveValue(Iter<TContainer, AdaptorIterator<TIterator, ValueExpandIter> > const & me, TValue const & _value);       	// "projects/library/seqan/sequence/string_value_expand.h"(504)
template <typename TValue, typename TPos> inline void moveValue(TValue * me, TPos pos, TValue const & _value);       	// "projects/library/seqan/sequence/string_pointer.h"(280)
template <typename TContainer, typename THostspec, typename TValue> inline void moveValue(Iter<TContainer, Packed<THostspec> > & me, TValue const & _value);       	// "projects/library/seqan/sequence/string_packed.h"(1010)
template <typename TContainer, typename THostspec, typename TValue> inline void moveValue(Iter<TContainer, Packed<THostspec> > const & me, TValue const & _value);       	// "projects/library/seqan/sequence/string_packed.h"(1018)
template <typename T, typename TValue, typename TPos> inline void moveValue(T & me, TPos pos, TValue const & _value);       	// "projects/library/seqan/sequence/sequence_interface.h"(804)

//____________________________________________________________________________
// operator!=

template <typename TLeftHost, typename TLeftSpec, typename TRight > inline bool operator!= (Segment<TLeftHost, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/sequence/segment_base.h"(1091)
template <typename TContainer, typename THostspec> inline bool operator!= (Iter<TContainer, Packed<THostspec> > const & left, Iter<TContainer, Packed<THostspec> > const & right);       	// "projects/library/seqan/sequence/string_packed.h"(1080)
template <typename TSSetL, typename TSpecL, typename TSSetR, typename TSpecR> inline bool operator!= ( Iter<TSSetL, ConcatVirtual<TSpecL> > const &L, Iter<TSSetR, ConcatVirtual<TSpecR> > const &R);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2173)
template <typename TLeftValue, typename TLeftSpec, typename TRight > inline bool operator!=(String<TLeftValue, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/sequence/string_base.h"(1572)

//____________________________________________________________________________
// operator*

template <typename TStringSet, typename TSpec> inline typename Reference< Iter< TStringSet, ConcatVirtual<TSpec> > const>::Type operator* (Iter<TStringSet, ConcatVirtual<TSpec> > const & me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2051)
template <typename TStringSet, typename TSpec> inline typename Reference< Iter< TStringSet, ConcatVirtual<TSpec> > >::Type operator* (Iter<TStringSet, ConcatVirtual<TSpec> > & me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2057)

//____________________________________________________________________________
// operator+

template <typename TContainer, typename THostspec, typename TIntegral> inline Iter<TContainer, Packed<THostspec> > operator+ (Iter<TContainer, Packed<THostspec> > const & left, TIntegral right);       	// "projects/library/seqan/sequence/string_packed.h"(1189)
template <typename TContainer, typename THostspec, typename TIntegral> inline Iter<TContainer, Packed<THostspec> > operator+ (TIntegral left, Iter<TContainer, Packed<THostspec> > const & right);       	// "projects/library/seqan/sequence/string_packed.h"(1197)
template <typename TStringSet, typename TSpec, typename TDelta> inline Iter<TStringSet, ConcatVirtual<TSpec> > operator+ (Iter<TStringSet, ConcatVirtual<TSpec> > const & me, TDelta delta);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2119)
template <typename TStringSet, typename TSpec, typename T1, typename T2, typename TCompression> inline Iter<TStringSet, ConcatVirtual<TSpec> > operator+ (Iter<TStringSet, ConcatVirtual<TSpec> > const & me, Pair<T1, T2, TCompression> delta);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2127)

//____________________________________________________________________________
// operator++

template <typename THost> inline Segment<THost, InfixSegment> & operator++(Segment<THost, InfixSegment> & segment);       	// "projects/library/seqan/sequence/segment_infix.h"(592)
template <typename THost> inline Segment<THost, PrefixSegment> & operator++(Segment<THost, PrefixSegment> & segment);       	// "projects/library/seqan/sequence/segment_prefix.h"(471)
template <typename TStringSet, typename TSpec> inline Iter<TStringSet, ConcatVirtual<TSpec> > const & operator++ (Iter<TStringSet, ConcatVirtual<TSpec> > & me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2074)
template <typename TStringSet, typename TSpec> inline Iter<TStringSet, ConcatVirtual<TSpec> > const & operator++ (Iter<TStringSet, ConcatVirtual<TSpec> > & me, int);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2081)
template <typename THost> inline Segment<THost, SuffixSegment> & operator++(Segment<THost, SuffixSegment> & segment);       	// "projects/library/seqan/sequence/segment_suffix.h"(460)

//____________________________________________________________________________
// operator+=

template <typename TLeftValue, typename TLeftSpec, typename TRight> Segment<TLeftValue, TLeftSpec> const & operator+= (Segment<TLeftValue, TLeftSpec> & left, TRight const & right);       	// "projects/library/seqan/sequence/segment_base.h"(1066)
template <typename TContainer, typename THostspec, typename TIntegral> inline Iter<TContainer, Packed<THostspec> > & operator+= (Iter<TContainer, Packed<THostspec> > & left, TIntegral right);       	// "projects/library/seqan/sequence/string_packed.h"(1210)
template <typename TLeftValue, typename TLeftSpec, typename TRight > String<TLeftValue, TLeftSpec> const & operator+= (String<TLeftValue, TLeftSpec> & left, TRight const & right);       	// "projects/library/seqan/sequence/string_base.h"(1548)

//____________________________________________________________________________
// operator-

template <typename TContainer, typename THostspec, typename TIntegral> inline Iter<TContainer, Packed<THostspec> > operator- (Iter<TContainer, Packed<THostspec> > const & left, TIntegral right);       	// "projects/library/seqan/sequence/string_packed.h"(1224)
template <typename TContainer, typename THostspec> inline typename Difference<Iter<TContainer, Packed<THostspec> > >::Type operator- (Iter<TContainer, Packed<THostspec> > const & left, Iter<TContainer, Packed<THostspec> > const & right);       	// "projects/library/seqan/sequence/string_packed.h"(1235)
template <typename TSSetL, typename TSpecL, typename TSSetR, typename TSpecR> typename Difference<Iter<TSSetL, ConcatVirtual<TSpecL> > >::Type operator- ( Iter<TSSetL, ConcatVirtual<TSpecL> > const &L, Iter<TSSetR, ConcatVirtual<TSpecR> > const &R);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2142)
template <typename TStringSet, typename TSpec, typename TDelta> inline Iter<TStringSet, ConcatVirtual<TSpec> > operator- (Iter<TStringSet, ConcatVirtual<TSpec> > const & me, TDelta delta);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2148)

//____________________________________________________________________________
// operator--

template <typename THost> inline Segment<THost, InfixSegment> & operator--(Segment<THost, InfixSegment> & segment);       	// "projects/library/seqan/sequence/segment_infix.h"(612)
template <typename THost> inline Segment<THost, PrefixSegment> & operator--(Segment<THost, PrefixSegment> & segment);       	// "projects/library/seqan/sequence/segment_prefix.h"(481)
template <typename TStringSet, typename TSpec> inline Iter<TStringSet, ConcatVirtual<TSpec> > const & operator-- (Iter<TStringSet, ConcatVirtual<TSpec> > & me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2100)
template <typename TStringSet, typename TSpec> inline Iter<TStringSet, ConcatVirtual<TSpec> > const & operator-- (Iter<TStringSet, ConcatVirtual<TSpec> > & me, int);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2107)
template <typename THost> inline Segment<THost, SuffixSegment> & operator--(Segment<THost, SuffixSegment> & segment);       	// "projects/library/seqan/sequence/segment_suffix.h"(470)

//____________________________________________________________________________
// operator-=

template <typename TContainer, typename THostspec, typename TIntegral> inline Iter<TContainer, Packed<THostspec> > & operator-= (Iter<TContainer, Packed<THostspec> > & left, TIntegral right);       	// "projects/library/seqan/sequence/string_packed.h"(1248)

//____________________________________________________________________________
// operator<

template <typename TLeftHost, typename TLeftSpec, typename TRight> inline bool operator< (Segment<TLeftHost, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/sequence/segment_base.h"(1103)
template <typename TContainer, typename THostspec> inline bool operator< (Iter<TContainer, Packed<THostspec> > const & left, Iter<TContainer, Packed<THostspec> > const & right);       	// "projects/library/seqan/sequence/string_packed.h"(1119)
template <typename TSSetL, typename TSpecL, typename TSSetR, typename TSpecR> inline bool operator< ( Iter<TSSetL, ConcatVirtual<TSpecL> > const &L, Iter<TSSetR, ConcatVirtual<TSpecR> > const &R);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2187)
template <typename TLeftValue, typename TLeftSpec, typename TRight> inline bool operator< (String<TLeftValue, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/sequence/string_base.h"(1584)

//____________________________________________________________________________
// operator<<

template <typename TStream, typename THost, typename TSpec> inline TStream & operator<< (TStream & target, Segment<THost, TSpec> const & source);       	// "projects/library/seqan/sequence/segment_base.h"(1149)
template <typename TStream, typename TValue, typename TSpec> inline TStream & operator<< (TStream & target, String<TValue, TSpec> const & source);       	// "projects/library/seqan/sequence/string_base.h"(1629)

//____________________________________________________________________________
// operator<=

template <typename TLeftHost, typename TLeftSpec, typename TRight> inline bool operator<= (Segment<TLeftHost, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/sequence/segment_base.h"(1114)
template <typename TContainer, typename THostspec> inline bool operator<= (Iter<TContainer, Packed<THostspec> > const & left, Iter<TContainer, Packed<THostspec> > const & right);       	// "projects/library/seqan/sequence/string_packed.h"(1132)
template <typename TLeftValue, typename TLeftSpec, typename TRight> inline bool operator<= (String<TLeftValue, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/sequence/string_base.h"(1595)

//____________________________________________________________________________
// operator==

template <typename TLeftHost, typename TLeftSpec, typename TRight > inline bool operator== (Segment<TLeftHost, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/sequence/segment_base.h"(1079)
template <typename TContainer, typename THostspec> inline bool operator== (Iter<TContainer, Packed<THostspec> > const & left, Iter<TContainer, Packed<THostspec> > const & right);       	// "projects/library/seqan/sequence/string_packed.h"(1067)
template <typename TSSetL, typename TSpecL, typename TSSetR, typename TSpecR> inline bool operator== ( Iter<TSSetL, ConcatVirtual<TSpecL> > const &L, Iter<TSSetR, ConcatVirtual<TSpecR> > const &R);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2163)
template <typename TLeftValue, typename TLeftSpec, typename TRight > inline bool operator== (String<TLeftValue, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/sequence/string_base.h"(1560)

//____________________________________________________________________________
// operator>

template <typename TLeftHost, typename TLeftSpec, typename TRight> inline bool operator> (Segment<TLeftHost, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/sequence/segment_base.h"(1124)
template <typename TContainer, typename THostspec> inline bool operator> (Iter<TContainer, Packed<THostspec> > const & left, Iter<TContainer, Packed<THostspec> > const & right);       	// "projects/library/seqan/sequence/string_packed.h"(1093)
template <typename TSSetL, typename TSpecL, typename TSSetR, typename TSpecR> inline bool operator> ( Iter<TSSetL, ConcatVirtual<TSpecL> > const &L, Iter<TSSetR, ConcatVirtual<TSpecR> > const &R);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2197)
template <typename TLeftValue, typename TLeftSpec, typename TRight> inline bool operator> (String<TLeftValue, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/sequence/string_base.h"(1605)

//____________________________________________________________________________
// operator>=

template <typename TLeftHost, typename TLeftSpec, typename TRight> inline bool operator>= (Segment<TLeftHost, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/sequence/segment_base.h"(1135)
template <typename TContainer, typename THostspec> inline bool operator>= (Iter<TContainer, Packed<THostspec> > const & left, Iter<TContainer, Packed<THostspec> > const & right);       	// "projects/library/seqan/sequence/string_packed.h"(1106)
template <typename TLeftValue, typename TLeftSpec, typename TRight> inline bool operator>= (String<TLeftValue, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/sequence/string_base.h"(1616)

//____________________________________________________________________________
// operator>>

template <typename TStream, typename THost, typename TSpec> inline TStream & operator>> (TStream & source, Segment<THost, TSpec> & target);       	// "projects/library/seqan/sequence/segment_base.h"(1161)
template <typename TStream, typename THost, typename TSpec> inline TStream & operator>> (TStream & source, Segment<THost, TSpec> const & target);       	// "projects/library/seqan/sequence/segment_base.h"(1170)
template <typename TStream, typename TValue, typename TSpec> inline TStream & operator>> (TStream & source, String<TValue, TSpec> & target);       	// "projects/library/seqan/sequence/string_base.h"(1641)

//____________________________________________________________________________
// ordValue

template <typename TValue> inline unsigned ordValue(TValue const &c);       	// "projects/library/seqan/sequence/lexical.h"(770)
template <typename TValue, typename TSpec> inline unsigned ordValue(SimpleType<TValue,TSpec> const &c);       	// "projects/library/seqan/sequence/lexical.h"(776)

//____________________________________________________________________________
// pop

template <typename TValue, unsigned int SPACE> inline void pop(String<TValue, Block<SPACE> >& me);       	// "projects/library/seqan/sequence/string_stack.h"(474)

//____________________________________________________________________________
// pop_back

template <typename TValue, unsigned int SPACE> inline void pop_back(String<TValue, Block<SPACE> >& me);       	// "projects/library/seqan/sequence/string_stack.h"(496)

//____________________________________________________________________________
// posAdd

template <typename TPos, typename TDelta> inline TPos posAdd(TPos pos, TDelta delta);       	// "projects/library/seqan/sequence/sequence_multiple.h"(547)
template <typename T1, typename T2, typename TCompression, typename TDelta> inline Pair<T1, T2, TCompression> posAdd(Pair<T1, T2, TCompression> const &pos, TDelta delta);       	// "projects/library/seqan/sequence/sequence_multiple.h"(553)

//____________________________________________________________________________
// posAtFirstLocal

template <typename TPos, typename TLimitsString> inline bool posAtFirstLocal(TPos pos, TLimitsString const &limits);       	// "projects/library/seqan/sequence/sequence_multiple.h"(513)
template <typename TPos> inline bool posAtFirstLocal(TPos pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(517)

//____________________________________________________________________________
// posCompare

template <typename TPos> inline int posCompare(TPos const &a, TPos const &b);       	// "projects/library/seqan/sequence/sequence_multiple.h"(589)
template <typename T1, typename T2, typename TCompression> inline int posCompare(Pair<T1, T2, TCompression> const &a, Pair<T1, T2, TCompression> const &b);       	// "projects/library/seqan/sequence/sequence_multiple.h"(596)

//____________________________________________________________________________
// posGlobalize

template <typename TPosition> inline TPosition posGlobalize(TPosition const &pos, Nothing const &);       	// "projects/library/seqan/sequence/sequence_multiple.h"(300)
template <typename T1, typename T2, typename TCompression> inline T2 posGlobalize(Pair<T1, T2, TCompression> const &pos, Nothing const &);       	// "projects/library/seqan/sequence/sequence_multiple.h"(306)
template <typename TLimitsString, typename TPosition> inline TPosition posGlobalize(TPosition const &pos, TLimitsString const &);       	// "projects/library/seqan/sequence/sequence_multiple.h"(312)
template <typename TLimitsString, typename T1, typename T2, typename TCompression> inline typename Value<TLimitsString>::Type posGlobalize(Pair<T1, T2, TCompression> const &pos, TLimitsString const &limits);       	// "projects/library/seqan/sequence/sequence_multiple.h"(319)

//____________________________________________________________________________
// posLess

template <typename TPos> inline bool posLess(TPos const &a, TPos const &b);       	// "projects/library/seqan/sequence/sequence_multiple.h"(577)
template <typename T1, typename T2, typename TCompression> inline bool posLess(Pair<T1, T2, TCompression> const &a, Pair<T1, T2, TCompression> const &b);       	// "projects/library/seqan/sequence/sequence_multiple.h"(582)

//____________________________________________________________________________
// posLocalize

template <typename TResult, typename TPosition> inline void posLocalize(TResult &result, TPosition const &pos, Nothing const &);       	// "projects/library/seqan/sequence/sequence_multiple.h"(343)
template <typename T1, typename T2, typename TCompression, typename TPosition> inline void posLocalize(Pair<T1, T2, TCompression> &result, TPosition const &pos, Nothing const &);       	// "projects/library/seqan/sequence/sequence_multiple.h"(348)
template <typename TResult, typename TSize, typename TSpec, typename TPosition> inline void posLocalize(TResult &result, TPosition const &pos, String<TSize, TSpec> const &limits);       	// "projects/library/seqan/sequence/sequence_multiple.h"(355)
template <typename TResult, typename TSize, typename TSpec, typename T1, typename T2, typename TCompression> inline void posLocalize(TResult &result, Pair<T1, T2, TCompression> const &pos, String<TSize, TSpec> const & );       	// "projects/library/seqan/sequence/sequence_multiple.h"(365)

//____________________________________________________________________________
// posNext

template <typename TPos> inline TPos posNext(TPos pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(535)
template <typename T1, typename T2, typename TCompression> inline Pair<T1, T2, TCompression> posNext(Pair<T1, T2, TCompression> const &pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(541)

//____________________________________________________________________________
// posPrev

template <typename TPos> inline TPos posPrev(TPos pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(524)
template <typename T1, typename T2, typename TCompression> inline Pair<T1, T2, TCompression> posPrev(Pair<T1, T2, TCompression> const &pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(529)

//____________________________________________________________________________
// posSub

template <typename TA, typename TB> inline TA posSub(TA a, TB b);       	// "projects/library/seqan/sequence/sequence_multiple.h"(559)
template <typename TA1, typename TA2, typename TACompression, typename TB1, typename TB2, typename TBCompression > inline TA2 posSub(Pair<TA1, TA2, TACompression> const &a, Pair<TB1, TB2, TBCompression> const &b);       	// "projects/library/seqan/sequence/sequence_multiple.h"(568)

//____________________________________________________________________________
// position

template <typename TContainer, typename THostspec> inline typename Position<Iter<TContainer, Packed<THostspec> > const>::Type position(Iter<TContainer, Packed<THostspec> > const & me);       	// "projects/library/seqan/sequence/string_packed.h"(902)

//____________________________________________________________________________
// positionToId

template <typename TString, typename TSpec, typename TPos> inline typename Id<StringSet<TString, Owner<TSpec> > >::Type positionToId(StringSet<TString, Owner<TSpec> >&, TPos const pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1518)
template <typename TString, typename TPos> inline typename Id<StringSet<TString, Dependent<Generous> > >::Type positionToId(StringSet<TString, Dependent<Generous> >& me, TPos const pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1527)
template <typename TString, typename TPos> inline typename Id<StringSet<TString, Dependent<Generous> > >::Type positionToId(StringSet<TString, Dependent<Generous> > const& me, TPos const pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1536)
template <typename TString, typename TPos> inline typename Id<StringSet<TString, Dependent<Tight> > >::Type positionToId(StringSet<TString, Dependent<Tight> >&me, TPos const pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1545)
template <typename TString, typename TPos> inline typename Id<StringSet<TString, Dependent<Tight> > >::Type positionToId(StringSet<TString, Dependent<Tight> > const&me, TPos const pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1554)

//____________________________________________________________________________
// prefix

template <typename T, typename TPosEnd> inline typename Prefix<T>::Type prefix(T & t, TPosEnd pos_end);       	// "projects/library/seqan/sequence/segment_prefix.h"(510)
template <typename T, typename TPosEnd> inline typename Prefix<T *>::Type prefix(T * t, TPosEnd pos_end);       	// "projects/library/seqan/sequence/segment_prefix.h"(518)
template <typename T, typename TPosEnd> inline typename Prefix<Segment<T, PrefixSegment> >::Type prefix(Segment<T, PrefixSegment> & t, TPosEnd pos_end);       	// "projects/library/seqan/sequence/segment_prefix.h"(528)
template <typename T, typename TPosEnd> inline typename Prefix<Segment<T, PrefixSegment> const>::Type prefix(Segment<T, PrefixSegment> const & t, TPosEnd pos_end);       	// "projects/library/seqan/sequence/segment_prefix.h"(537)
template <typename T, typename TPosEnd> inline typename Prefix<Segment<T, InfixSegment> >::Type prefix(Segment<T, InfixSegment> & t, TPosEnd pos_end);       	// "projects/library/seqan/sequence/segment_prefix.h"(549)
template <typename T, typename TPosEnd> inline typename Prefix<Segment<T, InfixSegment> const>::Type prefix(Segment<T, InfixSegment> const & t, TPosEnd pos_end);       	// "projects/library/seqan/sequence/segment_prefix.h"(559)
template <typename T, typename TPosEnd> inline typename Prefix<Segment<T, SuffixSegment> >::Type prefix(Segment<T, SuffixSegment> & t, TPosEnd pos_end);       	// "projects/library/seqan/sequence/segment_prefix.h"(573)
template <typename T, typename TPosEnd> inline typename Prefix<Segment<T, SuffixSegment> const>::Type prefix(Segment<T, SuffixSegment> const & t, TPosEnd pos_end);       	// "projects/library/seqan/sequence/segment_prefix.h"(583)
template <typename TString, typename TSpec, typename TPosition > inline typename Prefix<TString>::Type prefix(StringSet< TString, TSpec > &me, TPosition pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(376)
template <typename TString, typename TSpec, typename TPosition > inline typename Prefix<TString const>::Type prefix(StringSet< TString, TSpec > const &me, TPosition pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(390)
template <typename TString, typename TDelimiter, typename TPosition > inline typename Infix<TString>::Type prefix(StringSet< TString, Owner<ConcatDirect<TDelimiter> > > &me, TPosition pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(404)
template <typename TString, typename TDelimiter, typename TPosition > inline typename Infix<TString const>::Type prefix(StringSet< TString, Owner<ConcatDirect<TDelimiter> > > const &me, TPosition pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(411)

//____________________________________________________________________________
// push

template <typename TValue, unsigned int SPACE, typename TVal> inline void push( String<TValue, Block<SPACE> >& me, TVal const& source);       	// "projects/library/seqan/sequence/string_stack.h"(403)
template <typename TValue, unsigned int SPACE> inline void push(String<TValue, Block<SPACE> >& me);       	// "projects/library/seqan/sequence/string_stack.h"(410)

//____________________________________________________________________________
// push_back

template <typename TValue, unsigned int SPACE, typename TVal> inline void push_back( String<TValue, Block<SPACE> >& me, TVal const& source);       	// "projects/library/seqan/sequence/string_stack.h"(429)

//____________________________________________________________________________
// removeValueById

template <typename TString, typename TSpec, typename TId> inline void removeValueById(StringSet<TString, Owner<TSpec> >& me, TId const id);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1458)
template <typename TString, typename TId> inline void removeValueById(StringSet<TString, Dependent<Generous> >& me, TId const id);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1468)
template <typename TString, typename TId> inline void removeValueById(StringSet<TString, Dependent<Tight> >& me, TId const id);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1482)

//____________________________________________________________________________
// replace

template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void replace( Segment<THost, TSpec> & target, typename Position< Segment<THost, TSpec> >::Type pos_begin, typename Position< Segment<THost, TSpec> >::Type pos_end, TSource & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(869)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void replace( Segment<THost, TSpec> & target, typename Position< Segment<THost, TSpec> >::Type pos_begin, typename Position< Segment<THost, TSpec> >::Type pos_end, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(881)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void replace( Segment<THost, TSpec> & target, typename Position< Segment<THost, TSpec> >::Type pos_begin, typename Position< Segment<THost, TSpec> >::Type pos_end, TSource & source, typename Size< Segment<THost, TSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(895)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void replace( Segment<THost, TSpec> & target, typename Position< Segment<THost, TSpec> >::Type pos_begin, typename Position< Segment<THost, TSpec> >::Type pos_end, TSource const & source, typename Size< Segment<THost, TSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(908)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void replace( Segment<THost, TSpec> const & target, typename Position< Segment<THost, TSpec> const>::Type pos_begin, typename Position< Segment<THost, TSpec> const>::Type pos_end, TSource & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(921)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void replace( Segment<THost, TSpec> const & target, typename Position< Segment<THost, TSpec> const>::Type pos_begin, typename Position< Segment<THost, TSpec> const>::Type pos_end, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(933)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void replace( Segment<THost, TSpec> const & target, typename Position< Segment<THost, TSpec> const>::Type pos_begin, typename Position< Segment<THost, TSpec> const>::Type pos_end, TSource & source, typename Size< Segment<THost, TSpec> >::Type limit, Tag<TExpand> const );       	// "projects/library/seqan/sequence/segment_base.h"(947)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void replace( Segment<THost, TSpec> const & target, typename Position< Segment<THost, TSpec> const>::Type pos_begin, typename Position< Segment<THost, TSpec> const>::Type pos_end, TSource const & source, typename Size< Segment<THost, TSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(960)
template <typename TTargetValue, typename TSource, typename TExpand> inline void replace(TTargetValue * target, size_t pos_begin, size_t pos_end, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_pointer.h"(596)
template <typename TTargetValue, typename TSource, typename TExpand> inline void replace(TTargetValue * target, size_t pos_begin, size_t pos_end, TSource const & source, size_t limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_pointer.h"(609)
template <typename TTargetValue, typename TSourceValue, typename TExpand> inline void replace(TTargetValue * target, size_t pos_begin, size_t pos_end, TSourceValue const * source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_pointer.h"(623)
template <typename TTargetValue, typename TSourceValue, typename TExpand> inline void replace(TTargetValue * target, size_t pos_begin, size_t pos_end, TSourceValue const * source, size_t limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_pointer.h"(636)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void replace(::std::basic_string<TChar, TCharTraits, TAlloc> & target, typename Position< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type pos_begin, typename Position< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type pos_end, TSource const & source, Generous);       	// "projects/library/seqan/sequence/std_string.h"(520)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void replace(::std::basic_string<TChar, TCharTraits, TAlloc> & target, typename Position< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type pos_begin, typename Position< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type pos_end, TSource const & source, typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type limit, Generous);       	// "projects/library/seqan/sequence/std_string.h"(533)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void replace(::std::basic_string<TChar, TCharTraits, TAlloc> & target, typename Position< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type pos_begin, typename Position< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type pos_end, TSource const & source, Limit);       	// "projects/library/seqan/sequence/std_string.h"(569)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void replace(::std::basic_string<TChar, TCharTraits, TAlloc> & target, typename Position< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type pos_begin, typename Position< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type pos_end, TSource const & source, typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type limit, Limit);       	// "projects/library/seqan/sequence/std_string.h"(582)
template <typename TTarget, typename TPositionBegin, typename TPositionEnd, typename TSource> inline void replace(TTarget & target, TPositionBegin pos_begin, TPositionEnd pos_end, TSource & source);       	// "projects/library/seqan/sequence/sequence_interface.h"(1195)
template <typename TTarget, typename TPositionBegin, typename TPositionEnd, typename TSource> inline void replace(TTarget const & target, TPositionBegin pos_begin, TPositionEnd pos_end, TSource & source);       	// "projects/library/seqan/sequence/sequence_interface.h"(1204)
template <typename TTarget, typename TPositionBegin, typename TPositionEnd, typename TSource> inline void replace(TTarget & target, TPositionBegin pos_begin, TPositionEnd pos_end, TSource const & source);       	// "projects/library/seqan/sequence/sequence_interface.h"(1213)
template <typename TTarget, typename TPositionBegin, typename TPositionEnd, typename TSource> inline void replace(TTarget const & target, TPositionBegin pos_begin, TPositionEnd pos_end, TSource const & source);       	// "projects/library/seqan/sequence/sequence_interface.h"(1222)
template <typename TTarget, typename TPositionBegin, typename TPositionEnd, typename TSource> inline void replace(TTarget & target, TPositionBegin pos_begin, TPositionEnd pos_end, TSource & source, typename Size<TTarget>::Type limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(1235)
template <typename TTarget, typename TPositionBegin, typename TPositionEnd, typename TSource> inline void replace(TTarget const & target, TPositionBegin pos_begin, TPositionEnd pos_end, TSource & source, typename Size<TTarget>::Type limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(1245)
template <typename TTarget, typename TPositionBegin, typename TPositionEnd, typename TSource> inline void replace(TTarget & target, TPositionBegin pos_begin, TPositionEnd pos_end, TSource const & source, typename Size<TTarget>::Type limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(1255)
template <typename TTarget, typename TPositionBegin, typename TPositionEnd, typename TSource> inline void replace(TTarget const & target, TPositionBegin pos_begin, TPositionEnd pos_end, TSource const & source, typename Size<TTarget>::Type limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(1265)
template <typename TTargetValue, typename TTargetSpec, typename TSource, typename TExpand> inline void replace(String<TTargetValue, TTargetSpec> & target, typename Size< String<TTargetValue, TTargetSpec> >::Type pos_begin, typename Size< String<TTargetValue, TTargetSpec> >::Type pos_end, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(1247)
template <typename TTargetValue, typename TTargetSpec, typename TSource, typename TExpand> inline void replace(String<TTargetValue, TTargetSpec> & target, typename Size< String<TTargetValue, TTargetSpec> >::Type pos_begin, typename Size< String<TTargetValue, TTargetSpec> >::Type pos_end, TSource const & source, typename Size< String<TTargetValue, TTargetSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(1261)
template <typename TTargetValue, typename TTargetSpec, typename TSourceValue, typename TExpand> inline void replace(String<TTargetValue, TTargetSpec> & target, typename Size< String<TTargetValue, TTargetSpec> >::Type pos_begin, typename Size< String<TTargetValue, TTargetSpec> >::Type pos_end, TSourceValue const * source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(1277)
template <typename TTargetValue, typename TTargetSpec, typename TSourceValue, typename TExpand> inline void replace(String<TTargetValue, TTargetSpec> & target, typename Size< String<TTargetValue, TTargetSpec> >::Type pos_begin, typename Size< String<TTargetValue, TTargetSpec> >::Type pos_end, TSourceValue const * source, typename Size< String<TTargetValue, TTargetSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(1291)

//____________________________________________________________________________
// reserve

template <typename TValue, typename THost, typename TMap, typename TSpec, typename TSize, typename TExpand> inline TSize reserve(String< TValue, ValueExpand<THost, TMap, TSpec> > & me, TSize new_length, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_value_expand.h"(384)
template <typename TValue, typename TSpec, typename _TSize, typename TExpand> inline typename Size< String<TValue, Packed<TSpec> > >::Type reserve( String<TValue, Packed<TSpec> > & seq, _TSize new_capacity, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_packed.h"(726)
template <typename TValue, typename TSpec, typename _TSize> inline typename Size< String<TValue, Alloc<TSpec> > >::Type reserve( String<TValue, Packed<TSpec> > & me, _TSize new_capacity, Limit);       	// "projects/library/seqan/sequence/string_packed.h"(741)
template <typename TValue, typename TSpec, typename _TSize> inline typename Size< String<TValue, Alloc<TSpec> > >::Type reserve( String<TValue, Packed<TSpec> > & me, _TSize new_capacity, Insist);       	// "projects/library/seqan/sequence/string_packed.h"(756)
template <typename TValue, typename TSpec, typename _TSize, typename TExpand> inline typename Size< String<TValue, Alloc<TSpec> > >::Type reserve( String<TValue, Alloc<TSpec> > & seq, _TSize new_capacity, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_alloc.h"(410)
template <typename TValue, typename TSpec, typename _TSize> inline typename Size< String<TValue, Alloc<TSpec> > >::Type reserve( String<TValue, Alloc<TSpec> > & me, _TSize new_capacity, Limit);       	// "projects/library/seqan/sequence/string_alloc.h"(439)
template <typename TValue, typename TSpec, typename _TSize> inline typename Size< String<TValue, Alloc<TSpec> > >::Type reserve( String<TValue, Alloc<TSpec> > & , _TSize new_capacity, Insist);       	// "projects/library/seqan/sequence/string_alloc.h"(454)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TExpand> inline typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type reserve( ::std::basic_string<TChar, TCharTraits, TAlloc> & seq, typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type new_capacity, Tag<TExpand> const &);       	// "projects/library/seqan/sequence/std_string.h"(630)
template <typename T, typename TSize> inline typename Size<T>::Type reserve( T & , TSize new_capacity, Insist);       	// "projects/library/seqan/sequence/sequence_interface.h"(1300)
template <typename T, typename TSize> inline typename Size<T>::Type reserve( T & me, TSize new_capacity, Limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(1311)
template <typename T, typename TSize> inline typename Size<T>::Type reserve( T & me, TSize new_capacity);       	// "projects/library/seqan/sequence/sequence_interface.h"(1323)
template <typename TValue, unsigned int SPACE, typename TSize, typename TExpand> inline typename Size< String<TValue, Block<SPACE> > >::Type reserve(String<TValue, Block<SPACE> > & me, TSize new_capacity, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_stack.h"(356)

//____________________________________________________________________________
// resize

template <typename THost, typename TSpec, typename TExpand> inline typename Size< Segment<THost, TSpec> >::Type resize( Segment<THost, TSpec> & me, typename Size< Segment<THost, TSpec> >::Type new_length, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/segment_base.h"(1029)
template <typename TValue, typename THost, typename TMap, typename TSpec, typename TSize> inline TSize resize(String< TValue, ValueExpand<THost, TMap, TSpec> > & me, TSize new_length);       	// "projects/library/seqan/sequence/string_value_expand.h"(372)
template <typename TValue, typename TExpand> inline size_t resize( TValue * me, size_t new_length, Tag<TExpand> const &);       	// "projects/library/seqan/sequence/string_pointer.h"(675)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSize, typename TExpand> inline typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type resize( ::std::basic_string<TChar, TCharTraits, TAlloc> & me, TSize new_length, Tag<TExpand> const &);       	// "projects/library/seqan/sequence/std_string.h"(650)
template <typename TString, typename TSpec, typename TSize > inline typename Size< StringSet< TString, TSpec > >::Type resize(StringSet< TString, TSpec > &me, TSize new_size);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1165)
template <typename TString, typename TSpec, typename TSize > inline typename Size< StringSet< TString, Owner<ConcatDirect<TSpec> > > >::Type resize(StringSet< TString, Owner<ConcatDirect<TSpec> > > &me, TSize new_size);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1173)
template <typename T, typename TSize> inline typename Size<T>::Type resize( T & me, TSize new_length);       	// "projects/library/seqan/sequence/sequence_interface.h"(1358)
template <typename TValue, unsigned int SPACE, typename TSize2, typename TExpand> inline typename Size< String<TValue, Block<SPACE> > >::Type resize(String<TValue, Block<SPACE> > & me, TSize2 new_length, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_stack.h"(308)
template <typename TValue, unsigned int SPACE, typename TSize2> inline typename Size< String<TValue, Block<SPACE> > >::Type resize(String<TValue, Block<SPACE> > & me, TSize2 new_length, Limit);       	// "projects/library/seqan/sequence/string_stack.h"(329)
template <typename TValue, typename TSpec, typename TSize, typename TExpand> inline typename Size< String<TValue, TSpec> >::Type resize( String<TValue, TSpec> & me, TSize new_length, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(1457)

//____________________________________________________________________________
// resizeSpace

template <typename T, typename TSize, typename TPosition> inline TSize resizeSpace(T & me, TSize size, TPosition pos_begin, TPosition pos_end);       	// "projects/library/seqan/sequence/sequence_interface.h"(1393)
template <typename T, typename TSize, typename TPosition> inline TSize resizeSpace(T & me, TSize size, TPosition pos_begin, TPosition pos_end, TSize limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(1405)
template <typename TValue, typename TSpec, typename TPosition, typename TExpand> inline typename Size< String<TValue, TSpec> >::Type resizeSpace(String<TValue, TSpec> & me, typename Size< String<TValue, TSpec> >::Type size, TPosition pos_begin, TPosition pos_end, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_base.h"(685)
template <typename TValue, typename TSpec, typename TPosition, typename TExpand> inline typename Size< String<TValue, TSpec> >::Type resizeSpace(String<TValue, TSpec> & me, typename Size< String<TValue, TSpec> >::Type size, TPosition pos_begin, TPosition pos_end, typename Size< String<TValue, TSpec> >::Type limit, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_base.h"(700)

//____________________________________________________________________________
// sequenceLength

template <typename TSeqNo, typename TString> inline typename Size<TString>::Type sequenceLength(TSeqNo , TString const &string);       	// "projects/library/seqan/sequence/sequence_multiple.h"(634)
template <typename TSeqNo, typename TString, typename TSpec> inline typename Size<StringSet<TString, TSpec> >::Type sequenceLength(TSeqNo seqNo, StringSet<TString, TSpec> const &stringSet);       	// "projects/library/seqan/sequence/sequence_multiple.h"(640)

//____________________________________________________________________________
// set

template <typename THost, typename TPosition1, typename TPosition2> inline void set(Segment<THost, InfixSegment> & me, THost & host_, TPosition1 begin_, TPosition2 end_);       	// "projects/library/seqan/sequence/segment_infix.h"(449)
template <typename THost> inline void set(Segment<THost, InfixSegment> & me, THost & host_);       	// "projects/library/seqan/sequence/segment_infix.h"(461)
template <typename THost> inline void set(Segment<THost, InfixSegment> & me, THost const & host_);       	// "projects/library/seqan/sequence/segment_infix.h"(471)
template <typename THost, typename TSpec> inline void set(Segment<THost, InfixSegment> & me, Segment<THost, TSpec> & source);       	// "projects/library/seqan/sequence/segment_infix.h"(484)
template <typename THost, typename TSpec> inline void set(Segment<THost, InfixSegment> & me, Segment<THost, TSpec> const & source);       	// "projects/library/seqan/sequence/segment_infix.h"(494)
template <typename THost, typename TPosition> inline void set(Segment<THost, PrefixSegment> & me, THost & host_, TPosition end_);       	// "projects/library/seqan/sequence/segment_prefix.h"(371)
template <typename THost> inline void set(Segment<THost, PrefixSegment> & me, THost & host_);       	// "projects/library/seqan/sequence/segment_prefix.h"(382)
template <typename THost, typename TSpec> inline void set(Segment<THost, PrefixSegment> & me, Segment<THost, TSpec> & source);       	// "projects/library/seqan/sequence/segment_prefix.h"(394)
template <typename THost, typename TSpec> inline void set(Segment<THost, PrefixSegment> & me, Segment<THost, TSpec> const & source);       	// "projects/library/seqan/sequence/segment_prefix.h"(404)
template <typename THost, typename TPosition> inline void set(Segment<THost, SuffixSegment> & me, THost & host_, TPosition begin_);       	// "projects/library/seqan/sequence/segment_suffix.h"(360)
template <typename THost> inline void set(Segment<THost, SuffixSegment> & me, THost & host_);       	// "projects/library/seqan/sequence/segment_suffix.h"(371)
template <typename THost, typename TSpec> inline void set(Segment<THost, SuffixSegment> & me, Segment<THost, TSpec> & source);       	// "projects/library/seqan/sequence/segment_suffix.h"(383)
template <typename THost, typename TSpec> inline void set(Segment<THost, SuffixSegment> & me, Segment<THost, TSpec> const & source);       	// "projects/library/seqan/sequence/segment_suffix.h"(393)

//____________________________________________________________________________
// setBegin

template <typename TIterator> inline void setBegin(TIterator new_begin);       	// "projects/library/seqan/sequence/segment_infix.h"(773)

//____________________________________________________________________________
// setEnd

template <typename TIterator> inline void setEnd(TIterator new_end);       	// "projects/library/seqan/sequence/segment_infix.h"(785)

//____________________________________________________________________________
// setPosition

template <typename TContainer, typename THostspec, typename TPosition> inline void setPosition(Iter<TContainer, Packed<THostspec> > & me, TPosition pos_);       	// "projects/library/seqan/sequence/string_packed.h"(917)

//____________________________________________________________________________
// shareResources

template <typename T1, typename T2> inline bool shareResources(T1 const & obj1, T2 const & obj2);       	// "projects/library/seqan/sequence/sequence_interface.h"(230)
template <typename TValue, typename TSpec> inline bool shareResources(String<TValue, TSpec> const & obj1, TValue const & obj2);       	// "projects/library/seqan/sequence/string_base.h"(132)
template <typename TValue, typename TSpec> inline bool shareResources(TValue const & obj1, String<TValue, TSpec> const & obj2);       	// "projects/library/seqan/sequence/string_base.h"(141)

//____________________________________________________________________________
// shrinkToFit

template <typename T, typename TSize, typename TValue> inline void shrinkToFit(T & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(1508)

//____________________________________________________________________________
// stringSetLimits

template <typename TStringSet> inline typename StringSetLimits<TStringSet>::Type stringSetLimits(TStringSet &);       	// "projects/library/seqan/sequence/sequence_multiple.h"(157)
template <typename TString, typename TSpec> inline typename StringSetLimits< StringSet<TString, TSpec> >::Type & stringSetLimits(StringSet<TString, TSpec> &stringSet);       	// "projects/library/seqan/sequence/sequence_multiple.h"(163)
template <typename TString, typename TSpec> inline typename StringSetLimits< StringSet<TString, TSpec> const>::Type & stringSetLimits(StringSet<TString, TSpec> const &stringSet);       	// "projects/library/seqan/sequence/sequence_multiple.h"(171)

//____________________________________________________________________________
// subset

template <typename TString, typename TSpec, typename TDestSpec, typename TIds, typename TLength> inline void subset(StringSet<TString, Owner<TSpec> >& source, StringSet<TString, TDestSpec>& dest, TIds ids, TLength len);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1631)
template <typename TString, typename TIds, typename TLength> inline void subset(StringSet<TString, Dependent<Generous> >& source, StringSet<TString, Dependent<Generous> >& dest, TIds ids, TLength len);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1641)
template <typename TString, typename TIds, typename TLength> inline void subset(StringSet<TString, Dependent<Tight> >& source, StringSet<TString, Dependent<Tight> >& dest, TIds ids, TLength len);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1661)
template <typename TString, typename TSpec, typename TIds> inline void subset(StringSet<TString, TSpec>& source, StringSet<TString, TSpec>& dest, TIds ids);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1696)

//____________________________________________________________________________
// suffix

template <typename TString, typename TSpec, typename TPosition > inline typename Suffix<TString>::Type suffix(StringSet< TString, TSpec > &me, TPosition pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(422)
template <typename TString, typename TSpec, typename TPosition > inline typename Suffix<TString const>::Type suffix(StringSet< TString, TSpec > const &me, TPosition pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(436)
template <typename TString, typename TDelimiter, typename TPosition > inline typename Infix<TString>::Type suffix(StringSet< TString, Owner<ConcatDirect<TDelimiter> > > &me, TPosition pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(450)
template <typename TString, typename TDelimiter, typename TPosition > inline typename Infix<TString const>::Type suffix(StringSet< TString, Owner<ConcatDirect<TDelimiter> > > const &me, TPosition pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(457)
template <typename T, typename TPosBegin> inline typename Suffix<T>::Type suffix(T & t, TPosBegin pos_begin);       	// "projects/library/seqan/sequence/segment_suffix.h"(498)
template <typename T, typename TPosBegin> inline typename Suffix<T *>::Type suffix(T * t, TPosBegin pos_begin);       	// "projects/library/seqan/sequence/segment_suffix.h"(506)
template <typename T, typename TPosBegin> inline typename Suffix<Segment<T, PrefixSegment> >::Type suffix(Segment<T, PrefixSegment> & t, TPosBegin pos_begin);       	// "projects/library/seqan/sequence/segment_suffix.h"(516)
template <typename T, typename TPosBegin> inline typename Suffix<Segment<T, PrefixSegment> const>::Type suffix(Segment<T, PrefixSegment> const & t, TPosBegin pos_begin);       	// "projects/library/seqan/sequence/segment_suffix.h"(526)
template <typename T, typename TPosBegin> inline typename Suffix<Segment<T, InfixSegment> >::Type suffix(Segment<T, InfixSegment> & t, TPosBegin pos_begin);       	// "projects/library/seqan/sequence/segment_suffix.h"(539)
template <typename T, typename TPosBegin> inline typename Suffix<Segment<T, InfixSegment> const>::Type suffix(Segment<T, InfixSegment> const & t, TPosBegin pos_begin);       	// "projects/library/seqan/sequence/segment_suffix.h"(549)
template <typename T, typename TPosBegin> inline typename Suffix<Segment<T, SuffixSegment> >::Type suffix(Segment<T, SuffixSegment> & t, TPosBegin pos_begin);       	// "projects/library/seqan/sequence/segment_suffix.h"(563)
template <typename T, typename TPosBegin> inline typename Suffix<Segment<T, SuffixSegment> const>::Type suffix(Segment<T, SuffixSegment> const & t, TPosBegin pos_begin);       	// "projects/library/seqan/sequence/segment_suffix.h"(572)

//____________________________________________________________________________
// suffixLength

template <typename TPos, typename TString> inline typename Size<TString>::Type suffixLength(TPos pos, TString const &string);       	// "projects/library/seqan/sequence/sequence_multiple.h"(606)
template <typename TPos, typename TString, typename TSpec> inline typename Size<TString>::Type suffixLength(TPos pos, StringSet<TString, TSpec> const &stringSet);       	// "projects/library/seqan/sequence/sequence_multiple.h"(612)

//____________________________________________________________________________
// toCString

template <typename T> inline typename Value<T>::Type * toCString(T & me);       	// "projects/library/seqan/sequence/string_cstyle.h"(796)

//____________________________________________________________________________
// top

template <typename TValue, unsigned int SPACE> inline TValue & top(String<TValue, Block<SPACE> > & me);       	// "projects/library/seqan/sequence/string_stack.h"(436)
template <typename TValue, unsigned int SPACE> inline TValue const & top(String<TValue, Block<SPACE> > const& me);       	// "projects/library/seqan/sequence/string_stack.h"(444)

//____________________________________________________________________________
// topPrev

template <typename TValue, unsigned int SPACE> inline TValue & topPrev(String<TValue, Block<SPACE> > & me);       	// "projects/library/seqan/sequence/string_stack.h"(452)
template <typename TValue, unsigned int SPACE> inline TValue const & topPrev(String<TValue, Block<SPACE> > const& me);       	// "projects/library/seqan/sequence/string_stack.h"(463)

//____________________________________________________________________________
// value

template <typename THost, typename TSpec, typename TPos> inline typename Reference< Segment<THost, TSpec> >::Type value(Segment<THost, TSpec> & me, TPos pos);       	// "projects/library/seqan/sequence/segment_infix.h"(635)
template <typename THost, typename TSpec, typename TPos> inline typename Reference< Segment<THost, TSpec> const >::Type value(Segment<THost, TSpec> const & me, TPos pos);       	// "projects/library/seqan/sequence/segment_infix.h"(644)
template <typename TValue, typename THost, typename TMap, typename TSpec, typename TPos> inline typename Reference<String< TValue, ValueExpand<THost, TMap, TSpec> > >::Type value(String< TValue, ValueExpand<THost, TMap, TSpec> > & me, TPos pos);       	// "projects/library/seqan/sequence/string_value_expand.h"(331)
template <typename TValue, typename THost, typename TMap, typename TSpec, typename TPos> inline typename Reference<String< TValue, ValueExpand<THost, TMap, TSpec> > const>::Type value(String< TValue, ValueExpand<THost, TMap, TSpec> > const & me, TPos pos);       	// "projects/library/seqan/sequence/string_value_expand.h"(340)
template <typename TContainer, typename TIterator> inline typename Reference<Iter<TContainer, AdaptorIterator<TIterator, ValueExpandIter> > >::Type value(Iter<TContainer, AdaptorIterator<TIterator, ValueExpandIter> > & me);       	// "projects/library/seqan/sequence/string_value_expand.h"(433)
template <typename TContainer, typename TIterator> inline typename Reference<Iter<TContainer, AdaptorIterator<TIterator, ValueExpandIter> > >::Type value(Iter<TContainer, AdaptorIterator<TIterator, ValueExpandIter> > const & me);       	// "projects/library/seqan/sequence/string_value_expand.h"(441)
template <typename TValue, typename TPos> inline TValue & value(TValue * me, TPos pos);       	// "projects/library/seqan/sequence/string_pointer.h"(243)
template <typename TValue, typename TPos> inline TValue const & value(TValue const * me, TPos pos);       	// "projects/library/seqan/sequence/string_pointer.h"(252)
template <typename TValue, typename THostspec, typename TPos> inline typename Reference<String<TValue, Packed<THostspec> > >::Type value(String<TValue, Packed<THostspec> > & me, TPos pos);       	// "projects/library/seqan/sequence/string_packed.h"(482)
template <typename TValue, typename THostspec, typename TPos> inline typename Reference<String<TValue, Packed<THostspec> > const>::Type value(String<TValue, Packed<THostspec> > const & me, TPos pos);       	// "projects/library/seqan/sequence/string_packed.h"(491)
template <typename TContainer, typename THostspec> inline typename Reference<Iter<TContainer, Packed<THostspec> > >::Type value(Iter<TContainer, Packed<THostspec> > & me);       	// "projects/library/seqan/sequence/string_packed.h"(930)
template <typename TContainer, typename THostspec> inline typename Reference<Iter<TContainer, Packed<THostspec> > const>::Type value(Iter<TContainer, Packed<THostspec> > const & me);       	// "projects/library/seqan/sequence/string_packed.h"(937)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TPos> inline typename GetValue< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type value(::std::basic_string<TChar, TCharTraits, TAlloc> & me, TPos pos);       	// "projects/library/seqan/sequence/std_string.h"(201)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TPos> inline typename GetValue< ::std::basic_string<TChar, TCharTraits, TAlloc> const>::Type value(::std::basic_string<TChar, TCharTraits, TAlloc> const & me, TPos pos);       	// "projects/library/seqan/sequence/std_string.h"(209)
template <typename TString, typename TPos > inline typename Reference< StringSet< TString, Owner<Default> > >::Type value(StringSet< TString, Owner<Default> > & me, TPos pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1185)
template <typename TString, typename TPos > inline typename Reference< StringSet< TString, Owner<Default> > const >::Type value(StringSet< TString, Owner<Default> > const & me, TPos pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1192)
template <typename TString, typename TSpec, typename TPos > inline typename Infix<TString>::Type value(StringSet< TString, Owner<ConcatDirect<TSpec> > > & me, TPos pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1200)
template <typename TString, typename TSpec, typename TPos > inline typename Infix<TString const>::Type value(StringSet< TString, Owner<ConcatDirect<TSpec> > > const & me, TPos pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1207)
template <typename TString, typename TPos > inline typename Reference<StringSet< TString, Dependent<Tight> > >::Type value(StringSet< TString, Dependent<Tight> >& me, TPos pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1215)
template <typename TString, typename TPos > inline typename Reference<StringSet< TString, Dependent<Tight> > const >::Type value(StringSet< TString, Dependent<Tight> >const & me, TPos pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1226)
template <typename TString, typename TPos > inline typename Reference<StringSet< TString, Dependent<Generous> > >::Type value(StringSet< TString, Dependent<Generous> >& me, TPos pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1237)
template <typename TString, typename TPos > inline typename Reference< StringSet< TString, Dependent<Generous> > const >::Type value(StringSet< TString, Dependent<Generous> > const & me, TPos pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1249)
template <typename TStringSet, typename TPos > inline typename Reference< ConcatenatorNto1<TStringSet> >::Type value(ConcatenatorNto1<TStringSet> &me, TPos globalPos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1769)
template <typename TStringSet, typename TPos > inline typename Reference< ConcatenatorNto1<TStringSet> const >::Type value(ConcatenatorNto1<TStringSet> const &me, TPos globalPos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1778)
template <typename TStringSet, typename TSpec> inline typename Reference< Iter< TStringSet, ConcatVirtual<TSpec> > const>::Type value(Iter<TStringSet, ConcatVirtual<TSpec> > const & me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2039)
template <typename TStringSet, typename TSpec> inline typename Reference< Iter< TStringSet, ConcatVirtual<TSpec> > >::Type value(Iter<TStringSet, ConcatVirtual<TSpec> > & me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2045)
template <typename T, typename TPos> inline typename Reference<T>::Type value(T & me, TPos );       	// "projects/library/seqan/sequence/sequence_interface.h"(568)
template <typename T, typename TPos> inline typename Reference<T const>::Type value(T const & me, TPos );       	// "projects/library/seqan/sequence/sequence_interface.h"(576)
template <typename TValue, unsigned int SPACE, typename TPos> inline typename Reference<String<TValue, Block<SPACE> > >::Type value( String<TValue, Block<SPACE> >& stack, TPos const pos);       	// "projects/library/seqan/sequence/string_stack.h"(240)
template <typename TValue, unsigned int SPACE, typename TPos> inline typename Reference<String<TValue, Block<SPACE> > >::Type value( String<TValue, Block<SPACE> > const& stack, TPos const pos);       	// "projects/library/seqan/sequence/string_stack.h"(250)
template <typename TValue, typename TSpec, typename TPos> inline typename Reference< String<TValue, TSpec> >::Type value(String<TValue, TSpec> & me, TPos pos);       	// "projects/library/seqan/sequence/string_base.h"(158)
template <typename TValue, typename TSpec, typename TPos> inline typename Reference< String<TValue, TSpec> const >::Type value(String<TValue, TSpec> const & me, TPos pos);       	// "projects/library/seqan/sequence/string_base.h"(167)

//____________________________________________________________________________
// valueById

template <typename TString, typename TSpec, typename TId> inline typename Reference<StringSet<TString, TSpec> >::Type valueById(StringSet<TString, TSpec>& me, TId const id);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1333)

//____________________________________________________________________________
// valueConstruct

template <typename TContainer, typename THostspec> inline void valueConstruct(Iter<TContainer, Packed<THostspec> > const & );       	// "projects/library/seqan/sequence/string_packed.h"(1031)
template <typename TContainer, typename THostspec, typename TParam> inline void valueConstruct(Iter<TContainer, Packed<THostspec> > const & it, TParam const & param_);       	// "projects/library/seqan/sequence/string_packed.h"(1037)
template <typename TContainer, typename THostspec, typename TParam> inline void valueConstruct(Iter<TContainer, Packed<THostspec> > const & it, TParam const & param_, Move tag);       	// "projects/library/seqan/sequence/string_packed.h"(1045)

//____________________________________________________________________________
// valueDestruct

template <typename TContainer, typename THostspec> inline void valueDestruct(Iter<TContainer, Packed<THostspec> > const & );       	// "projects/library/seqan/sequence/string_packed.h"(1056)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

