from _typeshed import Incomplete
from collections.abc import Callable
from re import Pattern

from fpdf.drawing import PaintedPath

from ._fonttools_shims import BasePen, _TTGlyphSet

__pdoc__: dict[str, bool]

def force_nodocument(item): ...

NUMBER_SPLIT: Pattern[str]
TRANSFORM_GETTER: Pattern[str]

class Percent(float): ...

unit_splitter: Pattern[str]
relative_length_units: set[str]
absolute_length_units: dict[str, int]
angle_units: dict[str, float]

def resolve_length(length_str, default_unit: str = "pt"): ...
def resolve_angle(angle_str, default_unit: str = "deg"): ...
def xmlns(space, name): ...
def xmlns_lookup(space, *names): ...

shape_tags: Incomplete

def svgcolor(colorstr): ...
def convert_stroke_width(incoming): ...
def convert_miterlimit(incoming): ...
def clamp_float(min_val, max_val): ...
def inheritable(value, converter=...): ...
def optional(value, converter=...): ...

svg_attr_map: dict[str, Callable[[Incomplete], tuple[str, Incomplete]]]

def parse_style(svg_element) -> None: ...
def apply_styles(stylable, svg_element) -> None: ...

class ShapeBuilder:
    @staticmethod
    def new_path(tag): ...
    @classmethod
    def rect(cls, tag): ...
    @classmethod
    def circle(cls, tag): ...
    @classmethod
    def ellipse(cls, tag): ...
    @classmethod
    def line(cls, tag): ...
    @classmethod
    def polyline(cls, tag): ...
    @classmethod
    def polygon(cls, tag): ...

def convert_transforms(tfstr): ...

class PathPen(BasePen):
    pdf_path: PaintedPath
    last_was_line_to: bool
    first_is_move: bool | None
    def __init__(self, pdf_path: PaintedPath, glyphSet: _TTGlyphSet | None = ...): ...
    def arcTo(self, rx, ry, rotation, arc, sweep, end) -> None: ...

def svg_path_converter(pdf_path: PaintedPath, svg_path: str) -> None: ...

class SVGObject:
    @classmethod
    def from_file(cls, filename, *args, encoding: str = "utf-8", **kwargs): ...
    cross_references: Incomplete
    def __init__(self, svg_text) -> None: ...
    preserve_ar: Incomplete
    width: Incomplete
    height: Incomplete
    viewbox: Incomplete
    def extract_shape_info(self, root_tag) -> None: ...
    base_group: Incomplete
    def convert_graphics(self, root_tag) -> None: ...
    def transform_to_page_viewport(self, pdf, align_viewbox: bool = True): ...
    def transform_to_rect_viewport(
        self, scale, width, height, align_viewbox: bool = True, ignore_svg_top_attrs: bool = False
    ): ...
    def draw_to_page(
        self, pdf, x: Incomplete | None = None, y: Incomplete | None = None, debug_stream: Incomplete | None = None
    ) -> None: ...
    def handle_defs(self, defs) -> None: ...
    def build_xref(self, xref): ...
    def build_group(self, group, pdf_group: Incomplete | None = None): ...
    def build_path(self, path): ...
