/*******************************************************************************
 * Copyright (c) 2012, 2013 SAP SE and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    SAP SE - initial API and implementation
 *******************************************************************************/
package org.eclipse.tycho.plugins.p2.publisher.persistence;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.sisu.equinox.EquinoxServiceFactory;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.plugins.p2.publisher.AbstractP2Mojo;
import org.eclipse.tycho.repository.registry.facade.PublishingRepositoryFacade;
import org.eclipse.tycho.repository.registry.facade.ReactorRepositoryManagerFacade;

/**
 * <p>
 * Attaches p2 metadata and extra artifacts produced by the publishers to the project. In this way,
 * the full build results are available in the local Maven repository, e.g. for builds of parts of a
 * reactor.
 * </p>
 */
@Mojo(name = "attach-artifacts")
public class AttachPublishedArtifactsMojo extends AbstractP2Mojo {

    @Component
    private MavenProjectHelper projectHelper;

    @Component
    private EquinoxServiceFactory osgiServices;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {

        ReactorRepositoryManagerFacade reactorRepoManager = osgiServices
                .getService(ReactorRepositoryManagerFacade.class);
        PublishingRepositoryFacade publishingRepo = reactorRepoManager.getPublishingRepository(getProjectIdentities());
        Map<String, File> artifacts = publishingRepo.getArtifactLocations();

        for (Entry<String, File> entry : artifacts.entrySet()) {
            String classifier = entry.getKey();
            File artifactLocation = entry.getValue();
            if (classifier == null) {
                getProject().getArtifact().setFile(artifactLocation);

            } else {
                String type = getExtension(artifactLocation);
                projectHelper.attachArtifact(getProject(), type, classifier, artifactLocation);
            }
        }

        ReactorProject reactorProject = getReactorProject();
        reactorProject.setDependencyMetadata(true, publishingRepo.getInstallableUnits());
        reactorProject.setDependencyMetadata(false, Collections.emptySet());
    }

    private static String getExtension(File file) {
        String fileName = file.getName();
        int separator = fileName.lastIndexOf('.');
        if (separator < 0) {
            throw new IllegalArgumentException("No file extension in \"" + fileName + "\"");
        }
        return fileName.substring(separator + 1);
    }

}
