/* log.c -- Eat Log a line at a time.
 *
 * This file is part of TUA.
 * 
 *   Copyright (C) 1991,96  Lele Gaifax
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the license, or (at
 *   your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#include    "tua_4_taylor.h"

#if TAYLOR_UUCP

int
DEFUN (GetLog, (fp, lentry),
       FILE * fp AND struct log * lentry)

{
  char line[LINE_BUFFER_SIZE], * datebuffer;
  extern int EXFUN(atoi, (CONST char *));
  extern double EXFUN (atof, (CONST char *));
  CONST char * command;
  CONST char * process_id;
  char * new_line_char;

 read_line:
  debug_newline();
  
  if (fgets (line, LINE_BUFFER_SIZE, fp) == NULL)
    return (EOF);

  /* Each line in the Log file begins with the owner, i.e. "uux", "uucico", ...
     if this doesn't, it's a continued line. */
  
  if (line[0] != 'u' || line[1] != 'u')
    {
      debug_printf ("skipping continued line '%15.15s...'", line);
      goto read_line;
    }

  xfree (lentry->Owner);
  xfree (lentry->System);
  xfree (lentry->User);
  xfree (lentry->PortName);
  xfree (lentry->Command);

  lentry->PortName = lentry->Command = 0;
  
  lentry->Owner = savestring (strtok (line, " "));
  lentry->System = savestring (strtok (NULL, " "));
  lentry->User = savestring (strtok (NULL, " "));

  datebuffer = strtok (NULL, ")") + 1;
  lentry->TimeStamp = parse_date (datebuffer);

  process_id = strrchr (datebuffer, ' ');
  lentry->ProcessId = atoi (process_id);
  
  command = strrchr (datebuffer, 0) + 2; /* ie two char after the ')' */

  if (strbegcmp (command, "Queuing") == 0)
    command += sizeof ("Queuing");

  if ((new_line_char = strrchr (command, '\n')))
    *new_line_char = 0;
  
  lentry->Command = savestring (command);

  if (strbegcmp (command, "Calling system") == 0)
    {
      strtok (NULL, "(");
      if (strcmp ("alternate", strtok (NULL, " ")) == 0)
	{
	  strtok (NULL, ", ");
	  strtok (NULL, " ");
	}
      lentry->PortName = savestring (strtok (NULL, ")"));
    }
  else if (strbegcmp (command, "Incoming call") == 0)
    {
      strtok (NULL, "(");
      strtok (NULL, " "); /* "login" */
      strtok (NULL, " "); /* login name */
      strtok (NULL, " "); /* "port" */
      lentry->PortName = savestring (strtok (NULL, ")"));
    }
  return OK;
}

#endif /* TAYLOR_UUCP */

  
  
