---
myst:
  html_meta:
      keywords: LaTeX, domaines spécialisés, sciences, chimie, 
                tableau, tableau d’avancement, 
---

# Comment représenter un tableau d’avancement ?

Il existe de nombreuses manières de le faire mais une des plus simples est
d’utiliser l'extension <ctanpkg:tabularray>, évoquée plus en détail 
à la question "[](/3_composition/tableaux/tableau_tabularray)".

Dans l’exemple ci-dessous, nous utilisons également 
l'extension <ctanpkg:chemmacros>, illustrée à la question 
"[](/4_domaines_specialises/sciences/chimie/equation_de_reaction)".


## Un premier exemple

``` 
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{tabularray}
  \usepackage{chemmacros}

\begin{document}
\begin{tblr}{%
  vlines, hlines,
  colspec = {Q[c] Q[c] X[c] X[c] X[c] X[c]},
  vline{4} = {1}{ text = \clap{\ch{+}} },
  vline{5} = {1}{ text = \clap{\ch{->}} },
  vline{6} = {1}{ text = \clap{\ch{+}} },
}
  État          & Avancement & \ch{CH4}  & \ch{2 O2}  & \ch{CO2} & \ch{2 H2O}\\
  Initial       & $x=0$      & $n_1$     & $n_2$      & 0        & 0         \\
  Intermédiaire & $x$        & $n_1-x$   & $n_2-2x$   & $x$      & $2x$      \\
  Final         & $x_f$      & $n_1-x_f$ & $n_2-2x_f$ & $x_f$    & $2x_f$    \\
\end{tblr}
\end{document}
```

Certains filets verticaux de la première ligne du tableau sont remplacées 
par des caractères "+" ou par une flèche.

Nous utilisons ici la commande `\clap` qui permet de placer le texte 
qu’elle contient dans une boite de dimensions nulles. 


## Modifier le tableau précédent

<ctanpkg:tabularray> permet facilement de mettre en évidence une cellule 
ou de modifier la couleur d’une colonne. Cet exemple est inspiré de celui donné
page 15 de la [documentation](texdoc:tabularray) de l'extension. 

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{tabularray}
  \usepackage{chemmacros}

\begin{document}
\begin{tblr}{%
  vlines, hlines,
  colspec = {Q[c] Q[c] X[c] X[c] X[c] X[c]},
  vline{4} = {1}{ text = \clap{\ch{+}} },
  vline{5} = {1}{ text = \clap{\ch{->}} },
  vline{6} = {1}{ text = \clap{\ch{+}} },
  cell{4}{3} = {red!15},
  column{1,2} = {font=\bfseries, bg=lightgray!20}
}
  État          & Avancement & \ch{CH4}  & \ch{2 O2}  & \ch{CO2} & \ch{2 H2O}\\
  Initial       & $x=0$      & $n_1$     & $n_2$      & 0        & 0         \\
  Intermédiaire & $x$        & $n_1-x$   & $n_2-2x$   & $x$      & $2x$      \\
  Final         & $x_f$      & $n_1-x_f$ & $n_2-2x_f$ & $x_f$    & $2x_f$    \\
\end{tblr}
\end{document}
```


:::{sources}
 - [Documentation](texdoc:tabularray) de l'extension <ctanpkg:tabularray> 
:::