from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


arg_split = _Mock()

connect_qtconsole = _Mock()

display = _Mock()

encode_images = _Mock()

error = _Mock()

extract_header = _Mock()

get_connection_file = _Mock()

get_connection_info = _Mock()

install_payload_page = _Mock()

ioloop = _Mock()

json_clean = _Mock()

line_magic = _Mock()

magics_class = _Mock()

openpy = _Mock()

os = _Mock()

page = _Mock()

print_function = _Mock()

py3compat = _Mock()

skip_doctest = _Mock()

sys = _Mock()

time = _Mock()



class Any(_Mock):
  pass
  info_text = 'any value'

class CBool(_Mock):
  pass
  default_value = False
  info_text = 'a boolean'

class CBytes(_Mock):
  pass
  default_value = ''
  info_text = 'a bytes object'

class CodeMagics(_Mock):
  pass
  registered = True

class CommManager(_Mock):
  pass


class Dict(_Mock):
  pass
  info_text = 'any value'

class DisplayPublisher(_Mock):
  pass


class Instance(_Mock):
  pass
  info_text = 'any value'

class InteractiveShell(_Mock):
  pass
  default_user_namespaces = True

class InteractiveShellABC(_Mock):
  pass
  _abc_negative_cache_version = 62

class Javascript(_Mock):
  pass
  _read_flags = 'r'

class KernelMagics(_Mock):
  pass
  registered = True

class MacroToEdit(_Mock):
  pass


class Magics(_Mock):
  pass
  registered = False

class Session(_Mock):
  pass


class SocketABC(_Mock):
  pass
  _abc_negative_cache_version = 38

class Type(_Mock):
  pass
  info_text = 'any value'

class UsageError(_Mock):
  pass


class ZMQDataPublisher(_Mock):
  pass


class ZMQDisplayPublisher(_Mock):
  pass


class ZMQExitAutocall(_Mock):
  pass
  rewrite = False

class ZMQInteractiveShell(_Mock):
  pass
  default_user_namespaces = True

class ZMQShellDisplayHook(_Mock):
  pass


class unicode_type(_Mock):
  pass


