const char sql_lua[] =
"-- sql.lua (internal file)\n"
"\n"
"box.net.sql = {\n"
"    -- constructor \n"
"    -- box.net.sql.connect(\n"
"    --          'pg',                       -- @driver ('pg' or 'mysql')\n"
"    --          'my.host',                  -- @host\n"
"    --          5432,                       -- @port\n"
"    --          'user',                     -- @username\n"
"    --          'SECRET',                   -- @password\n"
"    --          'DB',                       -- @database name\n"
"    --          { raise = false },           -- @config options\n"
"    --          { sql1, var, ... var },     -- @startup SQL statements\n"
"    --          ...\n"
"    -- )\n"
"    --\n"
"    -- @return connector to database or throw error\n"
"    -- if option raise set in 'false' and an error will be happened\n"
"    -- the function will return 'nil' as the first variable and\n"
"    -- text of error as the second\n"
"\n"
"    connect = function(driver, host, port, user, password, db, cfg, ...)\n"
"\n"
"        if type(driver) == 'table' then\n"
"            driver = driver.driver\n"
"        end\n"
"\n"
"        if type(box.net.sql.connectors[driver]) ~= 'function' then\n"
"            error(string.format(\"Unknown driver '%s'\", driver))\n"
"        end\n"
"\n"
"        local self = {\n"
"            -- connection variables\n"
"            driver      = driver,\n"
"            host        = host,\n"
"            port        = port,\n"
"            user        = user,\n"
"            password    = password,\n"
"            db          = db,\n"
"\n"
"            -- private variables\n"
"            queue       = {},\n"
"            processing  = false,\n"
"\n"
"            -- throw exception if error\n"
"            raise       = true\n"
"        }\n"
"\n"
"        -- config parameters\n"
"        if type(cfg) == 'table' then\n"
"            if type(cfg.raise) == 'boolean' then\n"
"                self.raise = cfg.raise\n"
"            end\n"
"        end\n"
"\n"
"        local init      = { ... }\n"
"\n"
"        setmetatable(self, box.net.sql)\n"
"\n"
"        -- it add 'raw' field in the table\n"
"        local s, c = pcall(box.net.sql.connectors[driver], self)\n"
"        if not s then\n"
"            if self.raise then\n"
"                error(c)\n"
"            end\n"
"            return nil, c\n"
"        end\n"
"\n"
"        -- perform init statements\n"
"        for i, s in pairs(init) do\n"
"            c:execute(unpack(s))\n"
"        end\n"
"        return c\n"
"    end,\n"
"\n"
"    connectors = { },\n"
"\n"
"    __index = {\n"
"        -- base method\n"
"        -- example:\n"
"        -- local tuples, arows, txtst = db:execute(sql, args)\n"
"        --   tuples - a table of tuples (tables)\n"
"        --   arows  - count of affected rows\n"
"        --   txtst  - text status (Postgresql specific)\n"
"\n"
"        -- the method throws exception by default.\n"
"        -- user can change the behaviour by set 'connection.raise'\n"
"        -- attribute to 'false'\n"
"        -- in the case it will return negative arows if error and\n"
"        -- txtst will contain text of error\n"
"\n"
"        execute = function(self, sql, ...)\n"
"            -- waits until connection will be free\n"
"            while self.processing do\n"
"                self.queue[ box.fiber.fid ] = box.ipc.channel()\n"
"                self.queue[ box.fiber.fid ]:get()\n"
"                self.queue[ box.fiber.fid ] = nil\n"
"            end\n"
"            self.processing = true\n"
"\n"
"            local res = { pcall(self.raw.execute, self, sql, ...) }\n"
"            self.processing = false\n"
"            if not res[1] then\n"
"                if self.raise then\n"
"                    error(res[2])\n"
"                end\n"
"                return {}, -1, res[2]\n"
"            end\n"
"\n"
"            -- wakeup one waiter\n"
"            for fid, ch in pairs(self.queue) do\n"
"                ch:put(true, 0)\n"
"                self.queue[ fid ] = nil\n"
"                break\n"
"            end\n"
"            table.remove(res, 1)\n"
"            return unpack(res)\n"
"        end,\n"
"\n"
"\n"
"        -- pings database\n"
"        -- returns true if success. doesn't throw any errors\n"
"        ping = function(self)\n"
"            local pf = function()\n"
"                local res = self:execute('SELECT 1 AS code')\n"
"                if type(res) ~= 'table' then\n"
"                    return false\n"
"                end\n"
"                if type(res[1]) ~= 'table' then\n"
"                    return false\n"
"                end\n"
"\n"
"                return res[1].code == 1\n"
"            end\n"
"\n"
"            local res, code = pcall(pf)\n"
"            if res == true then\n"
"                return code\n"
"            else\n"
"                return false\n"
"            end\n"
"        end,\n"
"\n"
"\n"
"        -- select rows\n"
"        -- returns table of rows\n"
"        select = function(self, sql, ...)\n"
"            local res = self:execute(sql, ...)\n"
"            return res\n"
"        end,\n"
"\n"
"        -- select one row\n"
"        single = function(self, sql, ...)\n"
"            local res = self:execute(sql, ...)\n"
"            if #res > 1 then\n"
"                error(\"SQL request returned multiply rows\")\n"
"            end\n"
"            return res[1]\n"
"        end,\n"
"\n"
"        -- perform request. returns count of affected rows\n"
"        perform = function(self, sql, ...)\n"
"            local res, affected, status = self:execute(sql, ...)\n"
"            return affected\n"
"        end,\n"
"\n"
"\n"
"        -- quote variable\n"
"        quote = function(self, variable)\n"
"            return self.raw:quote(variable)\n"
"        end,\n"
"        \n"
"        -- quote identifier\n"
"        quote_ident = function(self, variable)\n"
"            return self.raw:quote_ident(variable)\n"
"        end,\n"
"\n"
"\n"
"        -- begin transaction\n"
"        begin_work = function(self)\n"
"            return self:perform('BEGIN')\n"
"        end,\n"
"\n"
"        -- commit transaction\n"
"        commit  = function(self)\n"
"            return self:perform('COMMIT')\n"
"        end,\n"
"\n"
"        -- rollback transaction\n"
"        rollback = function(self)\n"
"            return self:perform('ROLLBACK')\n"
"        end,\n"
"\n"
"        -- transaction\n"
"        txn = function(self, proc)\n"
"            local raise = self.raise\n"
"            self.raise = true\n"
"            self:begin_work()\n"
"            local res = { pcall(proc, self) }\n"
"\n"
"            -- commit transaction\n"
"            if res[1] then\n"
"                res = { pcall(function() self:commit() end) }\n"
"                self.raise = raise\n"
"                if res[1] then\n"
"                    return true\n"
"                end\n"
"                return res[1], res[2]\n"
"            end\n"
"\n"
"\n"
"            local res_txn = { pcall(function() self:rollback() end) }\n"
"\n"
"            if not res_txn[1] then\n"
"                res[2] = res[2] .. \"\\n\" .. res_txn[2]\n"
"            end\n"
"            self.raise = raise\n"
"            return res[1], res[2]\n"
"        end\n"
"    }\n"
"}\n"
""
;
