/*----- PROTECTED REGION ID(DataBaseClass.h) ENABLED START -----*/
//=============================================================================
//
// file :        DataBaseClass.h
//
// description : Include for the DataBaseClass root class.
//               This class is the singleton class for.
//               the DataBase device class..
//               It contains all properties and methods which the .
//               DataBase requires only once e.g. the commands.
//
// project :     TANGO.
//
// $Author: taurel $
//
// Copyright (C) :      2004,2005,2006,2007,2008,2009,2010,2011,2012,2013
//						European Synchrotron Radiation Facility
//                      BP 220, Grenoble 38043
//                      FRANCE
//
// This file is part of Tango.
//
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
//
// $Revision: 22250 $
// $Date: 2013-03-11 13:02:33 +0100 (Mon, 11 Mar 2013) $
//
// $HeadURL:$
//
//=============================================================================
//                This file is generated by POGO
//        (Program Obviously used to Generate tango Object)
//=============================================================================


#ifndef DATABASECLASS_H
#define DATABASECLASS_H

#include <tango.h>
#include <DataBase.h>

/*----- PROTECTED REGION END -----*/	//	DataBaseClass.h


namespace DataBase_ns
{
/*----- PROTECTED REGION ID(DataBaseClass::classes for dynamic creation) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBaseClass::classes for dynamic creation

//=========================================
//	Define classes for attributes
//=========================================
//	Attribute StoredProcedureRelease class definition
class StoredProcedureReleaseAttrib: public Tango::Attr
{
public:
	StoredProcedureReleaseAttrib():Attr("StoredProcedureRelease",
			Tango::DEV_STRING, Tango::READ) {};
	~StoredProcedureReleaseAttrib() {};
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<DataBase *>(dev))->read_StoredProcedureRelease(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<DataBase *>(dev))->is_StoredProcedureRelease_allowed(ty);}
};

//	Attribute Timing_average class definition
class Timing_averageAttrib: public Tango::SpectrumAttr
{
public:
	Timing_averageAttrib():SpectrumAttr("Timing_average",
			Tango::DEV_DOUBLE, Tango::READ, 64) {};
	~Timing_averageAttrib() {};
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<DataBase *>(dev))->read_Timing_average(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<DataBase *>(dev))->is_Timing_average_allowed(ty);}
};

//	Attribute Timing_minimum class definition
class Timing_minimumAttrib: public Tango::SpectrumAttr
{
public:
	Timing_minimumAttrib():SpectrumAttr("Timing_minimum",
			Tango::DEV_DOUBLE, Tango::READ, 64) {};
	~Timing_minimumAttrib() {};
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<DataBase *>(dev))->read_Timing_minimum(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<DataBase *>(dev))->is_Timing_minimum_allowed(ty);}
};

//	Attribute Timing_maximum class definition
class Timing_maximumAttrib: public Tango::SpectrumAttr
{
public:
	Timing_maximumAttrib():SpectrumAttr("Timing_maximum",
			Tango::DEV_DOUBLE, Tango::READ, 64) {};
	~Timing_maximumAttrib() {};
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<DataBase *>(dev))->read_Timing_maximum(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<DataBase *>(dev))->is_Timing_maximum_allowed(ty);}
};

//	Attribute Timing_calls class definition
class Timing_callsAttrib: public Tango::SpectrumAttr
{
public:
	Timing_callsAttrib():SpectrumAttr("Timing_calls",
			Tango::DEV_DOUBLE, Tango::READ, 64) {};
	~Timing_callsAttrib() {};
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<DataBase *>(dev))->read_Timing_calls(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<DataBase *>(dev))->is_Timing_calls_allowed(ty);}
};

//	Attribute Timing_index class definition
class Timing_indexAttrib: public Tango::SpectrumAttr
{
public:
	Timing_indexAttrib():SpectrumAttr("Timing_index",
			Tango::DEV_STRING, Tango::READ, 64) {};
	~Timing_indexAttrib() {};
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<DataBase *>(dev))->read_Timing_index(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<DataBase *>(dev))->is_Timing_index_allowed(ty);}
};

//	Attribute Timing_info class definition
class Timing_infoAttrib: public Tango::SpectrumAttr
{
public:
	Timing_infoAttrib():SpectrumAttr("Timing_info",
			Tango::DEV_STRING, Tango::READ, 64) {};
	~Timing_infoAttrib() {};
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<DataBase *>(dev))->read_Timing_info(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<DataBase *>(dev))->is_Timing_info_allowed(ty);}
};


//=========================================
//	Define classes for commands
//=========================================
//	Command DbAddDevice class definition
class DbAddDeviceClass : public Tango::Command
{
public:
	DbAddDeviceClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbAddDeviceClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbAddDeviceClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbAddDevice_allowed(any);}
};

//	Command DbAddServer class definition
class DbAddServerClass : public Tango::Command
{
public:
	DbAddServerClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbAddServerClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbAddServerClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbAddServer_allowed(any);}
};

//	Command DbDeleteAttributeAlias class definition
class DbDeleteAttributeAliasClass : public Tango::Command
{
public:
	DbDeleteAttributeAliasClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbDeleteAttributeAliasClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbDeleteAttributeAliasClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbDeleteAttributeAlias_allowed(any);}
};

//	Command DbDeleteClassAttribute class definition
class DbDeleteClassAttributeClass : public Tango::Command
{
public:
	DbDeleteClassAttributeClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbDeleteClassAttributeClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbDeleteClassAttributeClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbDeleteClassAttribute_allowed(any);}
};

//	Command DbDeleteClassAttributeProperty class definition
class DbDeleteClassAttributePropertyClass : public Tango::Command
{
public:
	DbDeleteClassAttributePropertyClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbDeleteClassAttributePropertyClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbDeleteClassAttributePropertyClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbDeleteClassAttributeProperty_allowed(any);}
};

//	Command DbDeleteClassProperty class definition
class DbDeleteClassPropertyClass : public Tango::Command
{
public:
	DbDeleteClassPropertyClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbDeleteClassPropertyClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbDeleteClassPropertyClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbDeleteClassProperty_allowed(any);}
};

//	Command DbDeleteDevice class definition
class DbDeleteDeviceClass : public Tango::Command
{
public:
	DbDeleteDeviceClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbDeleteDeviceClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbDeleteDeviceClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbDeleteDevice_allowed(any);}
};

//	Command DbDeleteDeviceAlias class definition
class DbDeleteDeviceAliasClass : public Tango::Command
{
public:
	DbDeleteDeviceAliasClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbDeleteDeviceAliasClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbDeleteDeviceAliasClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbDeleteDeviceAlias_allowed(any);}
};

//	Command DbDeleteDeviceAttribute class definition
class DbDeleteDeviceAttributeClass : public Tango::Command
{
public:
	DbDeleteDeviceAttributeClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbDeleteDeviceAttributeClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbDeleteDeviceAttributeClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbDeleteDeviceAttribute_allowed(any);}
};

//	Command DbDeleteDeviceAttributeProperty class definition
class DbDeleteDeviceAttributePropertyClass : public Tango::Command
{
public:
	DbDeleteDeviceAttributePropertyClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbDeleteDeviceAttributePropertyClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbDeleteDeviceAttributePropertyClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbDeleteDeviceAttributeProperty_allowed(any);}
};

//	Command DbDeleteDeviceProperty class definition
class DbDeleteDevicePropertyClass : public Tango::Command
{
public:
	DbDeleteDevicePropertyClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbDeleteDevicePropertyClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbDeleteDevicePropertyClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbDeleteDeviceProperty_allowed(any);}
};

//	Command DbDeleteProperty class definition
class DbDeletePropertyClass : public Tango::Command
{
public:
	DbDeletePropertyClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbDeletePropertyClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbDeletePropertyClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbDeleteProperty_allowed(any);}
};

//	Command DbDeleteServer class definition
class DbDeleteServerClass : public Tango::Command
{
public:
	DbDeleteServerClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbDeleteServerClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbDeleteServerClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbDeleteServer_allowed(any);}
};

//	Command DbDeleteServerInfo class definition
class DbDeleteServerInfoClass : public Tango::Command
{
public:
	DbDeleteServerInfoClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbDeleteServerInfoClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbDeleteServerInfoClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbDeleteServerInfo_allowed(any);}
};

//	Command DbExportDevice class definition
class DbExportDeviceClass : public Tango::Command
{
public:
	DbExportDeviceClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbExportDeviceClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbExportDeviceClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbExportDevice_allowed(any);}
};

//	Command DbExportEvent class definition
class DbExportEventClass : public Tango::Command
{
public:
	DbExportEventClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbExportEventClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbExportEventClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbExportEvent_allowed(any);}
};

//	Command DbGetAliasDevice class definition
class DbGetAliasDeviceClass : public Tango::Command
{
public:
	DbGetAliasDeviceClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetAliasDeviceClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetAliasDeviceClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetAliasDevice_allowed(any);}
};

//	Command DbGetAttributeAlias class definition
class DbGetAttributeAliasClass : public Tango::Command
{
public:
	DbGetAttributeAliasClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetAttributeAliasClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetAttributeAliasClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetAttributeAlias_allowed(any);}
};

//	Command DbGetAttributeAliasList class definition
class DbGetAttributeAliasListClass : public Tango::Command
{
public:
	DbGetAttributeAliasListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetAttributeAliasListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetAttributeAliasListClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetAttributeAliasList_allowed(any);}
};

//	Command DbGetClassAttributeList class definition
class DbGetClassAttributeListClass : public Tango::Command
{
public:
	DbGetClassAttributeListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetClassAttributeListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetClassAttributeListClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetClassAttributeList_allowed(any);}
};

//	Command DbGetClassAttributeProperty class definition
class DbGetClassAttributePropertyClass : public Tango::Command
{
public:
	DbGetClassAttributePropertyClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetClassAttributePropertyClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetClassAttributePropertyClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetClassAttributeProperty_allowed(any);}
};

//	Command DbGetClassAttributeProperty2 class definition
class DbGetClassAttributeProperty2Class : public Tango::Command
{
public:
	DbGetClassAttributeProperty2Class(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetClassAttributeProperty2Class(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetClassAttributeProperty2Class() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetClassAttributeProperty2_allowed(any);}
};

//	Command DbGetClassAttributePropertyHist class definition
class DbGetClassAttributePropertyHistClass : public Tango::Command
{
public:
	DbGetClassAttributePropertyHistClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetClassAttributePropertyHistClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetClassAttributePropertyHistClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetClassAttributePropertyHist_allowed(any);}
};

//	Command DbGetClassForDevice class definition
class DbGetClassForDeviceClass : public Tango::Command
{
public:
	DbGetClassForDeviceClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetClassForDeviceClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetClassForDeviceClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetClassForDevice_allowed(any);}
};

//	Command DbGetClassInheritanceForDevice class definition
class DbGetClassInheritanceForDeviceClass : public Tango::Command
{
public:
	DbGetClassInheritanceForDeviceClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetClassInheritanceForDeviceClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetClassInheritanceForDeviceClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetClassInheritanceForDevice_allowed(any);}
};

//	Command DbGetClassList class definition
class DbGetClassListClass : public Tango::Command
{
public:
	DbGetClassListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetClassListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetClassListClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetClassList_allowed(any);}
};

//	Command DbGetClassProperty class definition
class DbGetClassPropertyClass : public Tango::Command
{
public:
	DbGetClassPropertyClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetClassPropertyClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetClassPropertyClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetClassProperty_allowed(any);}
};

//	Command DbGetClassPropertyHist class definition
class DbGetClassPropertyHistClass : public Tango::Command
{
public:
	DbGetClassPropertyHistClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetClassPropertyHistClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetClassPropertyHistClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetClassPropertyHist_allowed(any);}
};

//	Command DbGetClassPropertyList class definition
class DbGetClassPropertyListClass : public Tango::Command
{
public:
	DbGetClassPropertyListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetClassPropertyListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetClassPropertyListClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetClassPropertyList_allowed(any);}
};

//	Command DbGetDeviceAlias class definition
class DbGetDeviceAliasClass : public Tango::Command
{
public:
	DbGetDeviceAliasClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetDeviceAliasClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetDeviceAliasClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetDeviceAlias_allowed(any);}
};

//	Command DbGetDeviceAliasList class definition
class DbGetDeviceAliasListClass : public Tango::Command
{
public:
	DbGetDeviceAliasListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetDeviceAliasListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetDeviceAliasListClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetDeviceAliasList_allowed(any);}
};

//	Command DbGetDeviceAttributeList class definition
class DbGetDeviceAttributeListClass : public Tango::Command
{
public:
	DbGetDeviceAttributeListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetDeviceAttributeListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetDeviceAttributeListClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetDeviceAttributeList_allowed(any);}
};

//	Command DbGetDeviceAttributeProperty class definition
class DbGetDeviceAttributePropertyClass : public Tango::Command
{
public:
	DbGetDeviceAttributePropertyClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetDeviceAttributePropertyClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetDeviceAttributePropertyClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetDeviceAttributeProperty_allowed(any);}
};

//	Command DbGetDeviceAttributeProperty2 class definition
class DbGetDeviceAttributeProperty2Class : public Tango::Command
{
public:
	DbGetDeviceAttributeProperty2Class(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetDeviceAttributeProperty2Class(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetDeviceAttributeProperty2Class() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetDeviceAttributeProperty2_allowed(any);}
};

//	Command DbGetDeviceAttributePropertyHist class definition
class DbGetDeviceAttributePropertyHistClass : public Tango::Command
{
public:
	DbGetDeviceAttributePropertyHistClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetDeviceAttributePropertyHistClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetDeviceAttributePropertyHistClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetDeviceAttributePropertyHist_allowed(any);}
};

//	Command DbGetDeviceClassList class definition
class DbGetDeviceClassListClass : public Tango::Command
{
public:
	DbGetDeviceClassListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetDeviceClassListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetDeviceClassListClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetDeviceClassList_allowed(any);}
};

//	Command DbGetDeviceDomainList class definition
class DbGetDeviceDomainListClass : public Tango::Command
{
public:
	DbGetDeviceDomainListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetDeviceDomainListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetDeviceDomainListClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetDeviceDomainList_allowed(any);}
};

//	Command DbGetDeviceExportedList class definition
class DbGetDeviceExportedListClass : public Tango::Command
{
public:
	DbGetDeviceExportedListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetDeviceExportedListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetDeviceExportedListClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetDeviceExportedList_allowed(any);}
};

//	Command DbGetDeviceFamilyList class definition
class DbGetDeviceFamilyListClass : public Tango::Command
{
public:
	DbGetDeviceFamilyListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetDeviceFamilyListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetDeviceFamilyListClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetDeviceFamilyList_allowed(any);}
};

//	Command DbGetDeviceInfo class definition
class DbGetDeviceInfoClass : public Tango::Command
{
public:
	DbGetDeviceInfoClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetDeviceInfoClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetDeviceInfoClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetDeviceInfo_allowed(any);}
};

//	Command DbGetDeviceList class definition
class DbGetDeviceListClass : public Tango::Command
{
public:
	DbGetDeviceListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetDeviceListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetDeviceListClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetDeviceList_allowed(any);}
};

//	Command DbGetDeviceWideList class definition
class DbGetDeviceWideListClass : public Tango::Command
{
public:
	DbGetDeviceWideListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetDeviceWideListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetDeviceWideListClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetDeviceWideList_allowed(any);}
};

//	Command DbGetDeviceMemberList class definition
class DbGetDeviceMemberListClass : public Tango::Command
{
public:
	DbGetDeviceMemberListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetDeviceMemberListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetDeviceMemberListClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetDeviceMemberList_allowed(any);}
};

//	Command DbGetDeviceProperty class definition
class DbGetDevicePropertyClass : public Tango::Command
{
public:
	DbGetDevicePropertyClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetDevicePropertyClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetDevicePropertyClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetDeviceProperty_allowed(any);}
};

//	Command DbGetDevicePropertyHist class definition
class DbGetDevicePropertyHistClass : public Tango::Command
{
public:
	DbGetDevicePropertyHistClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetDevicePropertyHistClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetDevicePropertyHistClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetDevicePropertyHist_allowed(any);}
};

//	Command DbGetDevicePropertyList class definition
class DbGetDevicePropertyListClass : public Tango::Command
{
public:
	DbGetDevicePropertyListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetDevicePropertyListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetDevicePropertyListClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetDevicePropertyList_allowed(any);}
};

//	Command DbGetDeviceServerClassList class definition
class DbGetDeviceServerClassListClass : public Tango::Command
{
public:
	DbGetDeviceServerClassListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetDeviceServerClassListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetDeviceServerClassListClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetDeviceServerClassList_allowed(any);}
};

//	Command DbGetExportdDeviceListForClass class definition
class DbGetExportdDeviceListForClassClass : public Tango::Command
{
public:
	DbGetExportdDeviceListForClassClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetExportdDeviceListForClassClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetExportdDeviceListForClassClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetExportdDeviceListForClass_allowed(any);}
};

//	Command DbGetHostList class definition
class DbGetHostListClass : public Tango::Command
{
public:
	DbGetHostListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetHostListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetHostListClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetHostList_allowed(any);}
};

//	Command DbGetHostServerList class definition
class DbGetHostServerListClass : public Tango::Command
{
public:
	DbGetHostServerListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetHostServerListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetHostServerListClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetHostServerList_allowed(any);}
};

//	Command DbGetHostServersInfo class definition
class DbGetHostServersInfoClass : public Tango::Command
{
public:
	DbGetHostServersInfoClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetHostServersInfoClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetHostServersInfoClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetHostServersInfo_allowed(any);}
};

//	Command DbGetInstanceNameList class definition
class DbGetInstanceNameListClass : public Tango::Command
{
public:
	DbGetInstanceNameListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetInstanceNameListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetInstanceNameListClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetInstanceNameList_allowed(any);}
};

//	Command DbGetObjectList class definition
class DbGetObjectListClass : public Tango::Command
{
public:
	DbGetObjectListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetObjectListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetObjectListClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetObjectList_allowed(any);}
};

//	Command DbGetProperty class definition
class DbGetPropertyClass : public Tango::Command
{
public:
	DbGetPropertyClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetPropertyClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetPropertyClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetProperty_allowed(any);}
};

//	Command DbGetPropertyHist class definition
class DbGetPropertyHistClass : public Tango::Command
{
public:
	DbGetPropertyHistClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetPropertyHistClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetPropertyHistClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetPropertyHist_allowed(any);}
};

//	Command DbGetPropertyList class definition
class DbGetPropertyListClass : public Tango::Command
{
public:
	DbGetPropertyListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetPropertyListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetPropertyListClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetPropertyList_allowed(any);}
};

//	Command DbGetServerInfo class definition
class DbGetServerInfoClass : public Tango::Command
{
public:
	DbGetServerInfoClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetServerInfoClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetServerInfoClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetServerInfo_allowed(any);}
};

//	Command DbGetServerList class definition
class DbGetServerListClass : public Tango::Command
{
public:
	DbGetServerListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetServerListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetServerListClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetServerList_allowed(any);}
};

//	Command DbGetServerNameList class definition
class DbGetServerNameListClass : public Tango::Command
{
public:
	DbGetServerNameListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetServerNameListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetServerNameListClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetServerNameList_allowed(any);}
};

//	Command DbImportDevice class definition
class DbImportDeviceClass : public Tango::Command
{
public:
	DbImportDeviceClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbImportDeviceClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbImportDeviceClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbImportDevice_allowed(any);}
};

//	Command DbImportEvent class definition
class DbImportEventClass : public Tango::Command
{
public:
	DbImportEventClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbImportEventClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbImportEventClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbImportEvent_allowed(any);}
};

//	Command DbInfo class definition
class DbInfoClass : public Tango::Command
{
public:
	DbInfoClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbInfoClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbInfoClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbInfo_allowed(any);}
};

//	Command DbPutAttributeAlias class definition
class DbPutAttributeAliasClass : public Tango::Command
{
public:
	DbPutAttributeAliasClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbPutAttributeAliasClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbPutAttributeAliasClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbPutAttributeAlias_allowed(any);}
};

//	Command DbPutClassAttributeProperty class definition
class DbPutClassAttributePropertyClass : public Tango::Command
{
public:
	DbPutClassAttributePropertyClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbPutClassAttributePropertyClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbPutClassAttributePropertyClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbPutClassAttributeProperty_allowed(any);}
};

//	Command DbPutClassAttributeProperty2 class definition
class DbPutClassAttributeProperty2Class : public Tango::Command
{
public:
	DbPutClassAttributeProperty2Class(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbPutClassAttributeProperty2Class(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbPutClassAttributeProperty2Class() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbPutClassAttributeProperty2_allowed(any);}
};

//	Command DbPutClassProperty class definition
class DbPutClassPropertyClass : public Tango::Command
{
public:
	DbPutClassPropertyClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbPutClassPropertyClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbPutClassPropertyClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbPutClassProperty_allowed(any);}
};

//	Command DbPutDeviceAlias class definition
class DbPutDeviceAliasClass : public Tango::Command
{
public:
	DbPutDeviceAliasClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbPutDeviceAliasClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbPutDeviceAliasClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbPutDeviceAlias_allowed(any);}
};

//	Command DbPutDeviceAttributeProperty class definition
class DbPutDeviceAttributePropertyClass : public Tango::Command
{
public:
	DbPutDeviceAttributePropertyClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbPutDeviceAttributePropertyClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbPutDeviceAttributePropertyClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbPutDeviceAttributeProperty_allowed(any);}
};

//	Command DbPutDeviceAttributeProperty2 class definition
class DbPutDeviceAttributeProperty2Class : public Tango::Command
{
public:
	DbPutDeviceAttributeProperty2Class(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbPutDeviceAttributeProperty2Class(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbPutDeviceAttributeProperty2Class() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbPutDeviceAttributeProperty2_allowed(any);}
};

//	Command DbPutDeviceProperty class definition
class DbPutDevicePropertyClass : public Tango::Command
{
public:
	DbPutDevicePropertyClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbPutDevicePropertyClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbPutDevicePropertyClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbPutDeviceProperty_allowed(any);}
};

//	Command DbPutProperty class definition
class DbPutPropertyClass : public Tango::Command
{
public:
	DbPutPropertyClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbPutPropertyClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbPutPropertyClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbPutProperty_allowed(any);}
};

//	Command DbPutServerInfo class definition
class DbPutServerInfoClass : public Tango::Command
{
public:
	DbPutServerInfoClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbPutServerInfoClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbPutServerInfoClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbPutServerInfo_allowed(any);}
};

//	Command DbUnExportDevice class definition
class DbUnExportDeviceClass : public Tango::Command
{
public:
	DbUnExportDeviceClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbUnExportDeviceClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbUnExportDeviceClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbUnExportDevice_allowed(any);}
};

//	Command DbUnExportEvent class definition
class DbUnExportEventClass : public Tango::Command
{
public:
	DbUnExportEventClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbUnExportEventClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbUnExportEventClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbUnExportEvent_allowed(any);}
};

//	Command DbUnExportServer class definition
class DbUnExportServerClass : public Tango::Command
{
public:
	DbUnExportServerClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbUnExportServerClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbUnExportServerClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbUnExportServer_allowed(any);}
};

//	Command ResetTimingValues class definition
class ResetTimingValuesClass : public Tango::Command
{
public:
	ResetTimingValuesClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	ResetTimingValuesClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~ResetTimingValuesClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_ResetTimingValues_allowed(any);}
};

//	Command DbGetDataForServerCache class definition
class DbGetDataForServerCacheClass : public Tango::Command
{
public:
	DbGetDataForServerCacheClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetDataForServerCacheClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetDataForServerCacheClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetDataForServerCache_allowed(any);}
};

//	Command DbDeleteAllDeviceAttributeProperty class definition
class DbDeleteAllDeviceAttributePropertyClass : public Tango::Command
{
public:
	DbDeleteAllDeviceAttributePropertyClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbDeleteAllDeviceAttributePropertyClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbDeleteAllDeviceAttributePropertyClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbDeleteAllDeviceAttributeProperty_allowed(any);}
};

//	Command DbMySqlSelect class definition
class DbMySqlSelectClass : public Tango::Command
{
public:
	DbMySqlSelectClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbMySqlSelectClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbMySqlSelectClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbMySqlSelect_allowed(any);}
};

//	Command DbGetCSDbServerList class definition
class DbGetCSDbServerListClass : public Tango::Command
{
public:
	DbGetCSDbServerListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetCSDbServerListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetCSDbServerListClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetCSDbServerList_allowed(any);}
};

//	Command DbGetAttributeAlias2 class definition
class DbGetAttributeAlias2Class : public Tango::Command
{
public:
	DbGetAttributeAlias2Class(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetAttributeAlias2Class(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetAttributeAlias2Class() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetAttributeAlias2_allowed(any);}
};

//	Command DbGetAliasAttribute class definition
class DbGetAliasAttributeClass : public Tango::Command
{
public:
	DbGetAliasAttributeClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbGetAliasAttributeClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbGetAliasAttributeClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbGetAliasAttribute_allowed(any);}
};

//	Command DbRenameServer class definition
class DbRenameServerClass : public Tango::Command
{
public:
	DbRenameServerClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DbRenameServerClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DbRenameServerClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataBase *>(dev))->is_DbRenameServer_allowed(any);}
};


/**
 *	The DataBaseClass singleton definition
 */

#ifdef _TG_WINDOWS_
class __declspec(dllexport)  DataBaseClass : public Tango::DeviceClass
#else
class DataBaseClass : public Tango::DeviceClass
#endif
{
	/*----- PROTECTED REGION ID(DataBaseClass::Additionnal DServer data members) ENABLED START -----*/
public:
	

	/*----- PROTECTED REGION END -----*/	//	DataBaseClass::Additionnal DServer data members

	public:
		//	write class properties data members
		Tango::DbData	cl_prop;
		Tango::DbData	cl_def_prop;
		Tango::DbData	dev_def_prop;
	
		//	Method prototypes
		static DataBaseClass *init(const char *);
		static DataBaseClass *instance();
		~DataBaseClass();
		Tango::DbDatum	get_class_property(string &);
		Tango::DbDatum	get_default_device_property(string &);
		Tango::DbDatum	get_default_class_property(string &);
	
	protected:
		DataBaseClass(string &);
		static DataBaseClass *_instance;
		void command_factory();
		void attribute_factory(vector<Tango::Attr *> &);
		void write_class_property();
		void set_default_property();
		void get_class_property();
		string get_cvstag();
		string get_cvsroot();
	
	private:
		void device_factory(const Tango::DevVarStringArray *);
		void create_static_attribute_list(vector<Tango::Attr *> &);
		void erase_dynamic_attributes(const Tango::DevVarStringArray *,vector<Tango::Attr *> &);
		vector<string>	defaultAttList;
		Tango::Attr *get_attr_object_by_name(vector<Tango::Attr *> &att_list, string attname);
};

}	//	End of namespace

#endif   //	DataBase_H
