#include <SyFi.h>
#include <fstream>

using namespace GiNaC; 
using namespace SyFi; 
using namespace std; 

int main() {

    initSyFi(2); 

    ReferenceTriangle triange; 
    Robust fe(triange); 
    fe.compute_basis_functions(); 

    for (unsigned int i=0; i< fe.nbf(); i++) { 

        cout <<"fe.N("<<i<<")= "<<fe.N(i)<<endl; 
        cout <<"div(fe.N("<<i<<"))= "<<(div(fe.N(i))).expand()<<endl; 

    }


    // regression test
    archive ar; 

    for (unsigned int i=0; i< fe.nbf(); i++) { 
        ar.archive_ex(fe.N(i), istr("N",i).c_str()); 
        ar.archive_ex((div(fe.N(i))).expand(), istr("divN",i).c_str()); 
    }

    ofstream vfile("robust.gar.v"); 
    vfile << ar; vfile.close(); 
    if(!compare_archives("robust.gar.v", "robust.gar.r")) { 
	    cerr << "Failure!" << endl;
	    return -1;
    }



    return 0; 

}


