#!/usr/bin/env python

import numpy as np

operations = (
    ((( 1, 0, 0),
      ( 0, 1, 0),
      ( 0, 0, 1)), "1"),

    ((( 0, 0, 1),
      ( 1, 0, 0),
      ( 0, 1, 0)), "3+ [111]"),

    ((( 0, 1, 0),
      ( 0, 0, 1),
      ( 1, 0, 0)), "3- [111]"),

    (((-1, 0, 0),
      ( 0,-1, 0),
      ( 0, 0,-1)), "-1"),

    ((( 0, 0,-1),
      (-1, 0, 0),
      ( 0,-1, 0)), "-3+ [111]"),

    ((( 0,-1, 0),
      ( 0, 0,-1),
      (-1, 0, 0)), "-3- [111]"),

    (((-1, 0, 0),
      ( 0,-1, 0),
      ( 0, 0, 1)), "2 [001]"),

    ((( 0, 0,-1),
      (-1, 0, 0),
      ( 0, 1, 0)), "3+ [1-1-1]"),

    ((( 0,-1, 0),
      ( 0, 0, 1),
      (-1, 0, 0)), "3- [1-1-1]"),

    ((( 0, 1, 0),
      ( 1, 0, 0),
      ( 0, 0,-1)), "2 [110]"),

    ((( 0,-1, 0),
      (-1, 0, 0),
      ( 0, 0,-1)), "2 [1-10]"),

    ((( 0,-1, 0),
      ( 1, 0, 0),
      ( 0, 0, 1)), "4+ [001]"),

    ((( 0, 1, 0),
      (-1, 0, 0),
      ( 0, 0, 1)), "4- [001]"),

    ((( 1, 0, 0),
      ( 0, 1, 0),
      ( 0, 0,-1)), "m [001]"),

    ((( 0, 0, 1),
      ( 1, 0, 0),
      ( 0,-1, 0)), "-3+ [1-1-1]"),

    ((( 0, 1, 0),
      ( 0, 0,-1),
      ( 1, 0, 0)), "-3- [1-1-1]"),

    ((( 0,-1, 0),
      (-1, 0, 0),
      ( 0, 0, 1)), "m [110]"),

    ((( 0, 1, 0),
      ( 1, 0, 0),
      ( 0, 0, 1)), "m [1-10]"),

    ((( 0, 1, 0),
      (-1, 0, 0),
      ( 0, 0,-1)), "-4+ [001]"),

    ((( 0,-1, 0),
      ( 1, 0, 0),
      ( 0, 0,-1)), "-4- [001]"),

    (((-1, 0, 0),
      ( 0, 1, 0),
      ( 0, 0,-1)), "2 [010]"),

    ((( 0, 0, 1),
      (-1, 0, 0),
      ( 0,-1, 0)), "3+ [-11-1]"),

    ((( 0,-1, 0),
      ( 0, 0,-1),
      ( 1, 0, 0)), "3- [-11-1]"),

    ((( 0, 0, 1),
      ( 0,-1, 0),
      ( 1, 0, 0)), "2 [101]"),

    ((( 0, 0,-1),
      ( 0,-1, 0),
      (-1, 0, 0)), "2 [-101]"),

    ((( 0, 0, 1),
      ( 0, 1, 0),
      (-1, 0, 0)), "4+ [010]"),

    ((( 0, 0,-1),
      ( 0, 1, 0),
      ( 1, 0, 0)), "4- [010]"),

    ((( 1, 0, 0),
      ( 0,-1, 0),
      ( 0, 0, 1)), "m [010]"),

    ((( 0, 0,-1),
      ( 1, 0, 0),
      ( 0, 1, 0)), "-3+ [-11-1]"),

    ((( 0, 1, 0),
      ( 0, 0, 1),
      (-1, 0, 0)), "-3- [-11-1]"),

    ((( 0, 0,-1),
      ( 0, 1, 0),
      (-1, 0, 0)), "m [101]"),

    ((( 0, 0, 1),
      ( 0, 1, 0),
      ( 1, 0, 0)), "m [-101]"),

    ((( 0, 0,-1),
      ( 0,-1, 0),
      ( 1, 0, 0)), "-4+ [010]"),

    ((( 0, 0, 1),
      ( 0,-1, 0),
      (-1, 0, 0)), "-4- [010]"),

    ((( 1, 0, 0),
      ( 0,-1, 0),
      ( 0, 0,-1)), "2 [100]"),

    ((( 0, 0,-1),
      ( 1, 0, 0),
      ( 0,-1, 0)), "3+ [-1-11]"),

    ((( 0, 1, 0),
      ( 0, 0,-1),
      (-1, 0, 0)), "3- [-1-11]"),

    (((-1, 0, 0),
      ( 0, 0, 1),
      ( 0, 1, 0)), "2 [011]"),

    (((-1, 0, 0),
      ( 0, 0,-1),
      ( 0,-1, 0)), "2 [01-1]"),

    ((( 1, 0, 0),
      ( 0, 0,-1),
      ( 0, 1, 0)), "4+ [100]"),

    ((( 1, 0, 0),
      ( 0, 0, 1),
      ( 0,-1, 0)), "4- [100]"),

    (((-1, 0, 0),
      ( 0, 1, 0),
      ( 0, 0, 1)), "m [100]"),

    ((( 0, 0, 1),
      (-1, 0, 0),
      ( 0, 1, 0)), "-3+ [-1-11]"),

    ((( 0,-1, 0),
      ( 0, 0, 1),
      ( 1, 0, 0)), "-3- [-1-11]"),

    ((( 1, 0, 0),
      ( 0, 0,-1),
      ( 0,-1, 0)), "m [011]"),

    ((( 1, 0, 0),
      ( 0, 0, 1),
      ( 0,-1, 0)), "m [01-1]"),

    (((-1, 0, 0),
      ( 0, 0, 1),
      ( 0,-1, 0)), "-4+ [100]"),

    (((-1, 0, 0),
      ( 0, 0,-1),
      ( 0, 1, 0)), "-4- [100]"))

operations_hex = (
    ((( 1, 0, 0),
      ( 0, 1, 0),
      ( 0, 0, 1)), "1"),

    (((-1, 0, 0),
      ( 0,-1, 0),
      ( 0, 0, 1)), "2 [001]"),

    ((( 0, 1, 0),
      ( 1, 0, 0),
      ( 0, 0,-1)), "2 [110]"),

    ((( 0,-1, 0),
      (-1, 0, 0),
      ( 0, 0,-1)), "2 [1-10]"),

    (((-1, 0, 0),
      ( 0,-1, 0),
      ( 0, 0,-1)), "-1"),

    ((( 1, 0, 0),
      ( 0, 1, 0),
      ( 0, 0,-1)), "m [001]"),

    ((( 0,-1, 0),
      (-1, 0, 0),
      ( 0, 0, 1)), "m [110]"),

    ((( 0, 1, 0),
      ( 1, 0, 0),
      ( 0, 0, 1)), "m [1-10]"),

    ((( 0,-1, 0),
      ( 1,-1, 0),
      ( 0, 0, 1)), "3+ [001]"),

    ((( 1,-1, 0),
      ( 1, 0, 0),
      ( 0, 0, 1)), "6+ [001]"),

    ((( 1,-1, 0),
      ( 0,-1, 0),
      ( 0, 0,-1)), "2 [100]"),

    (((-1, 1, 0),
      ( 0, 1, 0),
      ( 0, 0,-1)), "2 [120]"),

    ((( 0, 1, 0),
      (-1, 1, 0),
      ( 0, 0,-1)), "-3+ [001]"),

    (((-1, 1, 0),
      (-1, 0, 0),
      ( 0, 0,-1)), "-6+ [001]"),

    (((-1, 1, 0),
      ( 0, 1, 0),
      ( 0, 0, 1)), "m [100]"),

    ((( 1,-1, 0),
      ( 0,-1, 0),
      ( 0, 0, 1)), "m [120]"),

    (((-1, 1, 0),
      (-1, 0, 0),
      ( 0, 0, 1)), "3- [001]"),

    ((( 0, 1, 0),
      (-1, 1, 0),
      ( 0, 0, 1)), "6- [001]"),

    (((-1, 0, 0),
      (-1, 1, 0),
      ( 0, 0,-1)), "2 [010]"),

    ((( 1, 0, 0),
      ( 1,-1, 0),
      ( 0, 0,-1)), "2 [210]"),

    ((( 1,-1, 0),
      ( 1, 0, 0),
      ( 0, 0,-1)), "-3- [001]"),

    ((( 0,-1, 0),
      ( 1,-1, 0),
      ( 0, 0,-1)), "-6- [001]"),

    ((( 1, 0, 0),
      ( 1,-1, 0),
      ( 0, 0, 1)), "m [010]"),

    (((-1, 0, 0),
      (-1, 1, 0),
      ( 0, 0, 1)), "m [210]"))

prim2conv = (
    ((( 1,-1, 1),
      ( 1, 1,-1),
      (-1, 1, 1)), "cF"),

    ((( 1,-1, 0),
      (-1, 0, 1),
      (-1,-1,-1)), "hR"),

    ((( 1, 0, 0),
      ( 0, 1, 0),
      ( 0, 0, 1)), "cP"),

    ((( 1, 0, 1),
      ( 1, 1, 0),
      ( 0, 1, 1)), "cI"),

    ((( 1,-1, 0),
      (-1, 0, 1),
      (-1,-1,-1)), "hR"),

    ((( 0, 1, 1),
      ( 1, 0, 1),
      ( 1, 1, 0)), "tI"),

    ((( 1, 0, 1),
      ( 1, 1, 0),
      ( 0, 1, 1)), "tI"),

    (((-1,-1, 0),
      (-1, 0,-1),
      ( 0,-1,-1)), "oI"),

    ((( 1, 0, 0),
      (-1, 1, 0),
      (-1,-1, 3)), "hR"),

    ((( 1, 1, 0),
      ( 1,-1, 0),
      ( 0, 0,-1)), "mC"),

    ((( 1, 0, 0),
      ( 0, 1, 0),
      ( 0, 0, 1)), "tP"),

    ((( 1, 0, 0),
      ( 0, 1, 0),
      ( 0, 0, 1)), "hP"),

    ((( 1, 1, 0),
      (-1, 1, 0),
      ( 0, 0, 1)), "oC"),

    ((( 1, 0, 0),
      ( 0, 1, 0),
      ( 1, 1, 2)), "tI"),

    (((-1,-1, 0),
      ( 1,-1, 0),
      ( 1, 1, 2)), "oF"),

    ((( 1, 1, 0),
      (-1, 1, 0),
      ( 0, 0, 1)), "mC"),

    ((( 1,-1, 0),
      ( 1, 1, 0),
      (-1, 0,-1)), "mC"),

    ((( 0,-1, 1),
      ( 1,-1,-1),
      ( 1, 0, 0)), "tI"),

    (((-1, 0, 0),
      ( 0,-1, 1),
      (-1, 1, 1)), "oI"),

    ((( 0, 1, 1),
      ( 0, 1,-1),
      (-1, 0, 0)), "mC"),

    ((( 0, 1, 0),
      ( 0, 0, 1),
      ( 1, 0, 0)), "tP"),

    ((( 0, 1, 0),
      ( 0, 0, 1),
      ( 1, 0, 0)), "hP"),

    ((( 0, 1, 1),
      ( 0,-1, 1),
      ( 1, 0, 0)), "oC"),

    ((( 1, 2, 1),
      ( 0,-1, 1),
      ( 1, 0, 0)), "hR"),

    ((( 0, 1, 1),
      ( 0,-1, 1),
      ( 1, 0, 0)), "mC"),

    ((( 1, 0, 0),
      (-1, 2, 0),
      (-1, 0, 2)), "oF"),

    (((-1, 2, 0),
      (-1, 0, 0),
      ( 0,-1, 1)), "mC"),

    (((-1, 0, 0),
      (-1, 0, 2),
      ( 0, 1, 0)), "mC"),

    ((( 1, 0, 0),
      ( 1,-2, 0),
      ( 0, 0,-1)), "mC"),

    ((( 0, 1, 0),
      ( 0, 1,-2),
      (-1, 0, 0)), "mC"),

    ((( 1, 0, 0),
      ( 0, 1, 0),
      ( 0, 0, 1)), "aP"),

    ((( 1, 0, 0),
      ( 0, 1, 0),
      ( 0, 0, 1)), "oP"),

    ((( 0,-1, 0),
      ( 0, 1, 2),
      (-1, 0, 0)), "oC"),

    ((( 0,-1, 0),
      (-1, 0, 0),
      ( 0, 0,-1)), "mP"),

    ((( 1, 0, 0),
      (-1, 0,-2),
      ( 0, 1, 0)), "oC"),

    ((( 1, 0, 0),
      ( 0, 1, 0),
      ( 0, 0, 1)), "mP"),

    (((-1, 0, 0),
      ( 1, 2, 0),
      ( 0, 0,-1)), "oC"),

    (((-1, 0, 0),
      ( 0,-1, 0),
      ( 1, 1, 2)), "oI"),

    ((( 0,-1,-2),
      ( 0,-1, 0),
      (-1, 0, 0)), "mC"),

    ((( 1, 0, 2),
      ( 1, 0, 0),
      ( 0, 1, 0)), "mC"),

    (((-1,-2, 0),
      (-1, 0, 0),
      ( 0, 0,-1)), "mC"),

    (((-1, 0, 0),
      (-1,-1,-2),
      ( 0,-1, 0)), "mI"),

    ((( 1, 0, 0),
      ( 0, 1, 0),
      ( 0, 0, 1)), "aP"))


def print_matrix(m):
    for v in m:
        print "[%4.1f %4.1f %4.1f]" % tuple(v)

for (tmat, bravais) in prim2conv:
    if bravais[0] == "h":
        ops = operations_hex
    else:
        ops = operations
    for (op, symbol) in ops:
        op_prim = np.dot(np.dot(np.array(tmat).T, op), np.linalg.inv(np.array(tmat).T))
        print bravais, symbol,
        if (abs(op_prim) > 1.5).any():
            print "*"
        else:
            print
        print_matrix(op_prim)
        print
