<!--
	Stylesheet to extract the "class" or "role" attribute
	from a DocBook article.

	Please refer to this stylesheet using the following public ID:

		-//Alcove//DOCUMENT DocBook DocumentClass Stylesheet//EN
-->

<!DOCTYPE style-sheet PUBLIC "-//James Clark//DTD DSSSL Style Sheet//EN">
<style-sheet>
  <style-specification id="print">
    <style-specification-body>

(root
    (let* ((root-element (node-property 'document-element
					(current-node) ))
	   (role (or (attribute-string (general-name-normalize "class"
							       root-element)
				       root-element)
		     (attribute-string (general-name-normalize "role"
							       root-element)
				       root-element) )))
      (literal (if role
		   role
		   ""))))

    </style-specification-body>
  </style-specification>
</style-sheet>
