#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-05-22 16:31:11 
# install.sh
# shell main install entry point

# R U N   A S   R O O T   C H E C K
who=`id -u`
if [ "${who}" != "0" ]; then
	echo "must be run as root"
	exit 1
fi

# P A R S E   C O M M A N D   L I N E
hasfile=
oprev=
for o ;do
	# if the previous option needs an argument, assign it.
  	if [ -n "${oprev}" ]; then
		eval "${oprev}=\${o}"
		oprev=
 		continue
 	fi

  	case "${o}" in
		-f) 
			oprev=file 
			hasfile=true 
		;;
	esac
done
if [ ! -z "${hasfile}" ]; then
	[ -n "${file}" ] || file="sadms.settings"
	i=0
	while read line; do
		name=`echo ${line} | awk 'BEGIN{FS="="}{print $1}'`
		value=`echo ${line} | awk 'BEGIN{FS="="}{print $2}'`
		#echo "+${line} = ${name} + ${value}"
		case ${name} in
			realm) MYREALM="${value}" ; i=$(( i + 1 )) ;;
			dns) MYDNS="${value}" ; i=$(( i + 1 )) ;;
			kdc) MYKDC="${value}" ; i=$(( i + 1 )) ;;
			domain) MYDOMAIN="${value}" ; i=$(( i + 1 )) ;;
			server) MYSERVER="${value}" ; i=$(( i + 1 )) ;;
			hostOu)MYOU="${value}" ; i=$(( i + 1 )) ;;
			users) MYUSERS="${value}" ; i=$(( i + 1 )) ;;
			hostsAllow) MYHOSTALLOW="${value}" ; i=$(( i + 1 )) ;;
			winsServer) MYWINSSERVER="${value}" ; i=$(( i + 1 )) ;;
			administrator) MYADMIN="${value}" ; i=$(( i + 1 )) ;;
			administratorPassword) MYADMINPWD="${value}" ; i=$(( i + 1 )) ;;
		esac
	MYNARGS=${i}		
	done < ${file}
	echo "+read ${MYNARGS} settings from ${file}"
	echo 
else
	# echo no file
	MYNARGS=$#
	MYREALM="$1"
	MYDNS="$2"
	MYKDC="$3"
	MYDOMAIN="$4"
	MYSERVER="$5"
	MYOU="$6"
	MYADMIN="$7"
	MYUSERS="$8"
	MYHOSTALLOW="$9"
	shift
	MYWINSSERVER="$9"
fi

echo "-------------------------------------------------------------------------------"
echo "S A D M S  `cat version | head -n 1`"
echo "Samba as Active Directory Member Server"
echo "bbou@ac-toulouse.fr"
echo "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
echo "install"
echo "-------------------------------------------------------------------------------"
if [ -z "${MYREALM}" ]; then
	read -p 'Kerberos realm (ex:LYC-CHAMPOLLION-FIGEAC.AC-TOULOUSE.FR): ' MYREALM
fi
if [ -z "${MYDNS}" ]; then
	read -p 'DNS (ex:lyc-champollion-figeac.ac-toulouse.fr): ' MYDNS
fi
if [ -z "${MYKDC}" ]; then
	read -p 'Kerberos KDC-Active Directory Controller (ex:ksi): ' MYKDC
fi
if [ -z "${MYDOMAIN}" ]; then
	read -p 'Netbios domain (ex:CHAMPOL): ' MYDOMAIN
fi
if [ -z "${MYSERVER}" ]; then
	read -p 'Netbios name for this host: ' MYSERVER
fi
if [ -z "${MYOU}" ]; then
	read -p 'Organizational Unit for this server (ex:Computers): ' MYOU
fi
if [ -z "${MYADMIN}" ]; then
	read -p 'AD admin login (ex:administrator): ' MYADMIN
fi
if [ -z "${MYUSERS}" ]; then
	read -p 'Domain Users group (ex:Domain users): ' MYUSERS
fi
if [ -z "${MYHOSTALLOW}" ]; then
	read -p 'Host allow (ex:10.): ' MYHOSTALLOW
fi
if [ -z "${MYWINSSERVER}" ]; then
	read -p 'Wins Server (ex:10.0.0.1): ' MYWINSSERVER
fi
echo
echo 'Kerberos realm: ' ${MYREALM}
echo 'DNS: ' ${MYDNS}
echo 'Kerberos KDC-Active Directory Controller: ' ${MYKDC}
echo 'Netbios domain: ' ${MYDOMAIN}
echo 'Netbios host:' ${MYSERVER}
echo 'Organizational Unit: ' ${MYOU}
echo 'Domain users group: ' ${MYUSERS}
echo 'Host allow: ' ${MYHOSTALLOW}
echo 'Wins server: ' ${MYWINSSERVER}
echo 'Admin login: ' ${MYADMIN}
echo
read -p 'Do you want to proceed (y/n) ?: ' yes

case ${yes} in
y*|Y*)
	if [ -z "${MYADMINPWD}" ]; then
		read -s -p 'AD Admin login password : ' MYADMINPWD
		echo
	fi
	./_install-core.sh "${MYREALM}" "${MYDNS}" "${MYKDC}" "${MYDOMAIN}" "${MYSERVER}" "${MYOU}" "${MYADMIN}" "${MYADMINPWD}" "${MYUSERS}" "${MYHOSTALLOW}" "${MYWINSSERVER}"
	exit $?
	;;
*)
	exit
	;;
esac
