//! DO NOT EDIT! This file is generated by `xtask`.
//! Contains tests for the `debug!` macro.
#![deny(warnings)]
#![no_implicit_prelude]

extern crate tracing;

// We call all macros in this module with `no_implicit_prelude` to ensure they do not depend on the standard prelude.
#[cfg(target_arch = "wasm32")]
extern crate wasm_bindgen_test;

struct Disp {
    val: u64,
}

impl ::std::fmt::Display for Disp {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        ::std::write!(f, "Disp.val={val}", val = self.val)
    }
}

struct Deb {
    val: u64,
}

/// Manual implementation because otherwise `val` is unused.
impl ::std::fmt::Debug for Deb {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        f.debug_struct("Deb").field("val", &self.val).finish()
    }
}

struct Sub {
    field: u64,
}
#[cfg_attr(target_arch = "wasm32", wasm_bindgen_test::wasm_bindgen_test)]
#[test]
fn debug() {
    const CONST_VAR: &str = "const-field";

    let var = true;
    let sub = Sub { field: 4, };
    let disp = Disp { val: 61, };
    let deb = Deb { val: 102, };

    tracing::debug!(ident = 3); // DEBUG:debug,-,-,-,-,"ident","3"
    tracing::debug!(foo = true, ident = 3); // DEBUG:debug,-,-,p,-,"ident","3"
    tracing::debug!(ident = 3, qux = 3); // DEBUG:debug,-,-,f,-,"ident","3"
    tracing::debug!(foo = true, ident = 3, qux = 3); // DEBUG:debug,-,-,pf,-,"ident","3"
    tracing::debug!(ident = 3, "msg without args"); // DEBUG:debug,-,-,-,m,"ident","3"
    tracing::debug!(foo = true, ident = 3, "msg without args"); // DEBUG:debug,-,-,p,m,"ident","3"
    tracing::debug!(ident = 3, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"ident","3"
    tracing::debug!(foo = true, ident = 3, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"ident","3"
    tracing::debug!({ ident = 3 }, "msg without args"); // DEBUG:debug,-,{},-,m,"ident","3"
    tracing::debug!({ foo = true, ident = 3 }, "msg without args"); // DEBUG:debug,-,{},p,m,"ident","3"
    tracing::debug!({ ident = 3, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"ident","3"
    tracing::debug!({ foo = true, ident = 3, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"ident","3"
    tracing::debug!(ident = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"ident","3"
    tracing::debug!(foo = true, ident = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"ident","3"
    tracing::debug!(ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"ident","3"
    tracing::debug!(foo = true, ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"ident","3"
    tracing::debug!({ ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"ident","3"
    tracing::debug!({ foo = true, ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"ident","3"
    tracing::debug!({ ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"ident","3"
    tracing::debug!({ foo = true, ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"ident","3"
    tracing::debug!(ident = false); // DEBUG:debug,-,-,-,-,"ident","false"
    tracing::debug!(foo = true, ident = false); // DEBUG:debug,-,-,p,-,"ident","false"
    tracing::debug!(ident = false, qux = 3); // DEBUG:debug,-,-,f,-,"ident","false"
    tracing::debug!(foo = true, ident = false, qux = 3); // DEBUG:debug,-,-,pf,-,"ident","false"
    tracing::debug!(ident = false, "msg without args"); // DEBUG:debug,-,-,-,m,"ident","false"
    tracing::debug!(foo = true, ident = false, "msg without args"); // DEBUG:debug,-,-,p,m,"ident","false"
    tracing::debug!(ident = false, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"ident","false"
    tracing::debug!(foo = true, ident = false, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"ident","false"
    tracing::debug!({ ident = false }, "msg without args"); // DEBUG:debug,-,{},-,m,"ident","false"
    tracing::debug!({ foo = true, ident = false }, "msg without args"); // DEBUG:debug,-,{},p,m,"ident","false"
    tracing::debug!({ ident = false, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"ident","false"
    tracing::debug!({ foo = true, ident = false, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"ident","false"
    tracing::debug!(ident = false, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"ident","false"
    tracing::debug!(foo = true, ident = false, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"ident","false"
    tracing::debug!(ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"ident","false"
    tracing::debug!(foo = true, ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"ident","false"
    tracing::debug!({ ident = false }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"ident","false"
    tracing::debug!({ foo = true, ident = false }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"ident","false"
    tracing::debug!({ ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"ident","false"
    tracing::debug!({ foo = true, ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"ident","false"
    tracing::debug!(ident = ?3); // DEBUG:debug,-,-,-,-,"ident","?3"
    tracing::debug!(foo = true, ident = ?3); // DEBUG:debug,-,-,p,-,"ident","?3"
    tracing::debug!(ident = ?3, qux = 3); // DEBUG:debug,-,-,f,-,"ident","?3"
    tracing::debug!(foo = true, ident = ?3, qux = 3); // DEBUG:debug,-,-,pf,-,"ident","?3"
    tracing::debug!(ident = ?3, "msg without args"); // DEBUG:debug,-,-,-,m,"ident","?3"
    tracing::debug!(foo = true, ident = ?3, "msg without args"); // DEBUG:debug,-,-,p,m,"ident","?3"
    tracing::debug!(ident = ?3, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"ident","?3"
    tracing::debug!(foo = true, ident = ?3, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"ident","?3"
    tracing::debug!({ ident = ?3 }, "msg without args"); // DEBUG:debug,-,{},-,m,"ident","?3"
    tracing::debug!({ foo = true, ident = ?3 }, "msg without args"); // DEBUG:debug,-,{},p,m,"ident","?3"
    tracing::debug!({ ident = ?3, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"ident","?3"
    tracing::debug!({ foo = true, ident = ?3, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"ident","?3"
    tracing::debug!(ident = ?3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"ident","?3"
    tracing::debug!(foo = true, ident = ?3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"ident","?3"
    tracing::debug!(ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"ident","?3"
    tracing::debug!(foo = true, ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"ident","?3"
    tracing::debug!({ ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"ident","?3"
    tracing::debug!({ foo = true, ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"ident","?3"
    tracing::debug!({ ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"ident","?3"
    tracing::debug!({ foo = true, ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"ident","?3"
    tracing::debug!(ident = %3); // DEBUG:debug,-,-,-,-,"ident","%3"
    tracing::debug!(foo = true, ident = %3); // DEBUG:debug,-,-,p,-,"ident","%3"
    tracing::debug!(ident = %3, qux = 3); // DEBUG:debug,-,-,f,-,"ident","%3"
    tracing::debug!(foo = true, ident = %3, qux = 3); // DEBUG:debug,-,-,pf,-,"ident","%3"
    tracing::debug!(ident = %3, "msg without args"); // DEBUG:debug,-,-,-,m,"ident","%3"
    tracing::debug!(foo = true, ident = %3, "msg without args"); // DEBUG:debug,-,-,p,m,"ident","%3"
    tracing::debug!(ident = %3, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"ident","%3"
    tracing::debug!(foo = true, ident = %3, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"ident","%3"
    tracing::debug!({ ident = %3 }, "msg without args"); // DEBUG:debug,-,{},-,m,"ident","%3"
    tracing::debug!({ foo = true, ident = %3 }, "msg without args"); // DEBUG:debug,-,{},p,m,"ident","%3"
    tracing::debug!({ ident = %3, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"ident","%3"
    tracing::debug!({ foo = true, ident = %3, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"ident","%3"
    tracing::debug!(ident = %3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"ident","%3"
    tracing::debug!(foo = true, ident = %3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"ident","%3"
    tracing::debug!(ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"ident","%3"
    tracing::debug!(foo = true, ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"ident","%3"
    tracing::debug!({ ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"ident","%3"
    tracing::debug!({ foo = true, ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"ident","%3"
    tracing::debug!({ ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"ident","%3"
    tracing::debug!({ foo = true, ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"ident","%3"
    tracing::debug!(ident = ?deb); // DEBUG:debug,-,-,-,-,"ident","?deb"
    tracing::debug!(foo = true, ident = ?deb); // DEBUG:debug,-,-,p,-,"ident","?deb"
    tracing::debug!(ident = ?deb, qux = 3); // DEBUG:debug,-,-,f,-,"ident","?deb"
    tracing::debug!(foo = true, ident = ?deb, qux = 3); // DEBUG:debug,-,-,pf,-,"ident","?deb"
    tracing::debug!(ident = ?deb, "msg without args"); // DEBUG:debug,-,-,-,m,"ident","?deb"
    tracing::debug!(foo = true, ident = ?deb, "msg without args"); // DEBUG:debug,-,-,p,m,"ident","?deb"
    tracing::debug!(ident = ?deb, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"ident","?deb"
    tracing::debug!(foo = true, ident = ?deb, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"ident","?deb"
    tracing::debug!({ ident = ?deb }, "msg without args"); // DEBUG:debug,-,{},-,m,"ident","?deb"
    tracing::debug!({ foo = true, ident = ?deb }, "msg without args"); // DEBUG:debug,-,{},p,m,"ident","?deb"
    tracing::debug!({ ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"ident","?deb"
    tracing::debug!({ foo = true, ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"ident","?deb"
    tracing::debug!(ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"ident","?deb"
    tracing::debug!(foo = true, ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"ident","?deb"
    tracing::debug!(ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"ident","?deb"
    tracing::debug!(foo = true, ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"ident","?deb"
    tracing::debug!({ ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"ident","?deb"
    tracing::debug!({ foo = true, ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"ident","?deb"
    tracing::debug!({ ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"ident","?deb"
    tracing::debug!({ foo = true, ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"ident","?deb"
    tracing::debug!(ident = %disp); // DEBUG:debug,-,-,-,-,"ident","%disp"
    tracing::debug!(foo = true, ident = %disp); // DEBUG:debug,-,-,p,-,"ident","%disp"
    tracing::debug!(ident = %disp, qux = 3); // DEBUG:debug,-,-,f,-,"ident","%disp"
    tracing::debug!(foo = true, ident = %disp, qux = 3); // DEBUG:debug,-,-,pf,-,"ident","%disp"
    tracing::debug!(ident = %disp, "msg without args"); // DEBUG:debug,-,-,-,m,"ident","%disp"
    tracing::debug!(foo = true, ident = %disp, "msg without args"); // DEBUG:debug,-,-,p,m,"ident","%disp"
    tracing::debug!(ident = %disp, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"ident","%disp"
    tracing::debug!(foo = true, ident = %disp, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"ident","%disp"
    tracing::debug!({ ident = %disp }, "msg without args"); // DEBUG:debug,-,{},-,m,"ident","%disp"
    tracing::debug!({ foo = true, ident = %disp }, "msg without args"); // DEBUG:debug,-,{},p,m,"ident","%disp"
    tracing::debug!({ ident = %disp, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"ident","%disp"
    tracing::debug!({ foo = true, ident = %disp, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"ident","%disp"
    tracing::debug!(ident = %disp, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"ident","%disp"
    tracing::debug!(foo = true, ident = %disp, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"ident","%disp"
    tracing::debug!(ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"ident","%disp"
    tracing::debug!(foo = true, ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"ident","%disp"
    tracing::debug!({ ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"ident","%disp"
    tracing::debug!({ foo = true, ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"ident","%disp"
    tracing::debug!({ ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"ident","%disp"
    tracing::debug!({ foo = true, ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"ident","%disp"
    tracing::debug!(ident = ?sub.field); // DEBUG:debug,-,-,-,-,"ident","?sub.field"
    tracing::debug!(foo = true, ident = ?sub.field); // DEBUG:debug,-,-,p,-,"ident","?sub.field"
    tracing::debug!(ident = ?sub.field, qux = 3); // DEBUG:debug,-,-,f,-,"ident","?sub.field"
    tracing::debug!(foo = true, ident = ?sub.field, qux = 3); // DEBUG:debug,-,-,pf,-,"ident","?sub.field"
    tracing::debug!(ident = ?sub.field, "msg without args"); // DEBUG:debug,-,-,-,m,"ident","?sub.field"
    tracing::debug!(foo = true, ident = ?sub.field, "msg without args"); // DEBUG:debug,-,-,p,m,"ident","?sub.field"
    tracing::debug!(ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"ident","?sub.field"
    tracing::debug!(foo = true, ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"ident","?sub.field"
    tracing::debug!({ ident = ?sub.field }, "msg without args"); // DEBUG:debug,-,{},-,m,"ident","?sub.field"
    tracing::debug!({ foo = true, ident = ?sub.field }, "msg without args"); // DEBUG:debug,-,{},p,m,"ident","?sub.field"
    tracing::debug!({ ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"ident","?sub.field"
    tracing::debug!({ foo = true, ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"ident","?sub.field"
    tracing::debug!(ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"ident","?sub.field"
    tracing::debug!(foo = true, ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"ident","?sub.field"
    tracing::debug!(ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"ident","?sub.field"
    tracing::debug!(foo = true, ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"ident","?sub.field"
    tracing::debug!({ ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"ident","?sub.field"
    tracing::debug!({ foo = true, ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"ident","?sub.field"
    tracing::debug!({ ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"ident","?sub.field"
    tracing::debug!({ foo = true, ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"ident","?sub.field"
    tracing::debug!(ident = %sub.field); // DEBUG:debug,-,-,-,-,"ident","%sub.field"
    tracing::debug!(foo = true, ident = %sub.field); // DEBUG:debug,-,-,p,-,"ident","%sub.field"
    tracing::debug!(ident = %sub.field, qux = 3); // DEBUG:debug,-,-,f,-,"ident","%sub.field"
    tracing::debug!(foo = true, ident = %sub.field, qux = 3); // DEBUG:debug,-,-,pf,-,"ident","%sub.field"
    tracing::debug!(ident = %sub.field, "msg without args"); // DEBUG:debug,-,-,-,m,"ident","%sub.field"
    tracing::debug!(foo = true, ident = %sub.field, "msg without args"); // DEBUG:debug,-,-,p,m,"ident","%sub.field"
    tracing::debug!(ident = %sub.field, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"ident","%sub.field"
    tracing::debug!(foo = true, ident = %sub.field, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"ident","%sub.field"
    tracing::debug!({ ident = %sub.field }, "msg without args"); // DEBUG:debug,-,{},-,m,"ident","%sub.field"
    tracing::debug!({ foo = true, ident = %sub.field }, "msg without args"); // DEBUG:debug,-,{},p,m,"ident","%sub.field"
    tracing::debug!({ ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"ident","%sub.field"
    tracing::debug!({ foo = true, ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"ident","%sub.field"
    tracing::debug!(ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"ident","%sub.field"
    tracing::debug!(foo = true, ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"ident","%sub.field"
    tracing::debug!(ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"ident","%sub.field"
    tracing::debug!(foo = true, ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"ident","%sub.field"
    tracing::debug!({ ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"ident","%sub.field"
    tracing::debug!({ foo = true, ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"ident","%sub.field"
    tracing::debug!({ ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"ident","%sub.field"
    tracing::debug!({ foo = true, ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"ident","%sub.field"
    tracing::debug!(ident = debug(&deb)); // DEBUG:debug,-,-,-,-,"ident","debug(&deb)"
    tracing::debug!(foo = true, ident = debug(&deb)); // DEBUG:debug,-,-,p,-,"ident","debug(&deb)"
    tracing::debug!(ident = debug(&deb), qux = 3); // DEBUG:debug,-,-,f,-,"ident","debug(&deb)"
    tracing::debug!(foo = true, ident = debug(&deb), qux = 3); // DEBUG:debug,-,-,pf,-,"ident","debug(&deb)"
    tracing::debug!(ident = debug(&deb), "msg without args"); // DEBUG:debug,-,-,-,m,"ident","debug(&deb)"
    tracing::debug!(foo = true, ident = debug(&deb), "msg without args"); // DEBUG:debug,-,-,p,m,"ident","debug(&deb)"
    tracing::debug!(ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"ident","debug(&deb)"
    tracing::debug!(foo = true, ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"ident","debug(&deb)"
    tracing::debug!({ ident = debug(&deb) }, "msg without args"); // DEBUG:debug,-,{},-,m,"ident","debug(&deb)"
    tracing::debug!({ foo = true, ident = debug(&deb) }, "msg without args"); // DEBUG:debug,-,{},p,m,"ident","debug(&deb)"
    tracing::debug!({ ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"ident","debug(&deb)"
    tracing::debug!({ foo = true, ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"ident","debug(&deb)"
    tracing::debug!(ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"ident","debug(&deb)"
    tracing::debug!(foo = true, ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"ident","debug(&deb)"
    tracing::debug!(ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"ident","debug(&deb)"
    tracing::debug!(foo = true, ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"ident","debug(&deb)"
    tracing::debug!({ ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"ident","debug(&deb)"
    tracing::debug!({ foo = true, ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"ident","debug(&deb)"
    tracing::debug!({ ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"ident","debug(&deb)"
    tracing::debug!({ foo = true, ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"ident","debug(&deb)"
    tracing::debug!(ident = display(&disp)); // DEBUG:debug,-,-,-,-,"ident","display(&disp)"
    tracing::debug!(foo = true, ident = display(&disp)); // DEBUG:debug,-,-,p,-,"ident","display(&disp)"
    tracing::debug!(ident = display(&disp), qux = 3); // DEBUG:debug,-,-,f,-,"ident","display(&disp)"
    tracing::debug!(foo = true, ident = display(&disp), qux = 3); // DEBUG:debug,-,-,pf,-,"ident","display(&disp)"
    tracing::debug!(ident = display(&disp), "msg without args"); // DEBUG:debug,-,-,-,m,"ident","display(&disp)"
    tracing::debug!(foo = true, ident = display(&disp), "msg without args"); // DEBUG:debug,-,-,p,m,"ident","display(&disp)"
    tracing::debug!(ident = display(&disp), qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"ident","display(&disp)"
    tracing::debug!(foo = true, ident = display(&disp), qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"ident","display(&disp)"
    tracing::debug!({ ident = display(&disp) }, "msg without args"); // DEBUG:debug,-,{},-,m,"ident","display(&disp)"
    tracing::debug!({ foo = true, ident = display(&disp) }, "msg without args"); // DEBUG:debug,-,{},p,m,"ident","display(&disp)"
    tracing::debug!({ ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"ident","display(&disp)"
    tracing::debug!({ foo = true, ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"ident","display(&disp)"
    tracing::debug!(ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"ident","display(&disp)"
    tracing::debug!(foo = true, ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"ident","display(&disp)"
    tracing::debug!(ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"ident","display(&disp)"
    tracing::debug!(foo = true, ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"ident","display(&disp)"
    tracing::debug!({ ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"ident","display(&disp)"
    tracing::debug!({ foo = true, ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"ident","display(&disp)"
    tracing::debug!({ ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"ident","display(&disp)"
    tracing::debug!({ foo = true, ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"ident","display(&disp)"
    tracing::debug!(ident = tracing::field::Empty); // DEBUG:debug,-,-,-,-,"ident","tracing::field::Empty"
    tracing::debug!(foo = true, ident = tracing::field::Empty); // DEBUG:debug,-,-,p,-,"ident","tracing::field::Empty"
    tracing::debug!(ident = tracing::field::Empty, qux = 3); // DEBUG:debug,-,-,f,-,"ident","tracing::field::Empty"
    tracing::debug!(foo = true, ident = tracing::field::Empty, qux = 3); // DEBUG:debug,-,-,pf,-,"ident","tracing::field::Empty"
    tracing::debug!(ident = tracing::field::Empty, "msg without args"); // DEBUG:debug,-,-,-,m,"ident","tracing::field::Empty"
    tracing::debug!(foo = true, ident = tracing::field::Empty, "msg without args"); // DEBUG:debug,-,-,p,m,"ident","tracing::field::Empty"
    tracing::debug!(ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"ident","tracing::field::Empty"
    tracing::debug!(foo = true, ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"ident","tracing::field::Empty"
    tracing::debug!({ ident = tracing::field::Empty }, "msg without args"); // DEBUG:debug,-,{},-,m,"ident","tracing::field::Empty"
    tracing::debug!({ foo = true, ident = tracing::field::Empty }, "msg without args"); // DEBUG:debug,-,{},p,m,"ident","tracing::field::Empty"
    tracing::debug!({ ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"ident","tracing::field::Empty"
    tracing::debug!({ foo = true, ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"ident","tracing::field::Empty"
    tracing::debug!(ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"ident","tracing::field::Empty"
    tracing::debug!(foo = true, ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"ident","tracing::field::Empty"
    tracing::debug!(ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"ident","tracing::field::Empty"
    tracing::debug!(foo = true, ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"ident","tracing::field::Empty"
    tracing::debug!({ ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"ident","tracing::field::Empty"
    tracing::debug!({ foo = true, ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"ident","tracing::field::Empty"
    tracing::debug!({ ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"ident","tracing::field::Empty"
    tracing::debug!({ foo = true, ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"ident","tracing::field::Empty"
    tracing::debug!(dotted.ident = 3); // DEBUG:debug,-,-,-,-,"dotted.ident","3"
    tracing::debug!(foo = true, dotted.ident = 3); // DEBUG:debug,-,-,p,-,"dotted.ident","3"
    tracing::debug!(dotted.ident = 3, qux = 3); // DEBUG:debug,-,-,f,-,"dotted.ident","3"
    tracing::debug!(foo = true, dotted.ident = 3, qux = 3); // DEBUG:debug,-,-,pf,-,"dotted.ident","3"
    tracing::debug!(dotted.ident = 3, "msg without args"); // DEBUG:debug,-,-,-,m,"dotted.ident","3"
    tracing::debug!(foo = true, dotted.ident = 3, "msg without args"); // DEBUG:debug,-,-,p,m,"dotted.ident","3"
    tracing::debug!(dotted.ident = 3, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"dotted.ident","3"
    tracing::debug!(foo = true, dotted.ident = 3, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"dotted.ident","3"
    tracing::debug!({ dotted.ident = 3 }, "msg without args"); // DEBUG:debug,-,{},-,m,"dotted.ident","3"
    tracing::debug!({ foo = true, dotted.ident = 3 }, "msg without args"); // DEBUG:debug,-,{},p,m,"dotted.ident","3"
    tracing::debug!({ dotted.ident = 3, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"dotted.ident","3"
    tracing::debug!({ foo = true, dotted.ident = 3, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"dotted.ident","3"
    tracing::debug!(dotted.ident = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"dotted.ident","3"
    tracing::debug!(foo = true, dotted.ident = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"dotted.ident","3"
    tracing::debug!(dotted.ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"dotted.ident","3"
    tracing::debug!(foo = true, dotted.ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"dotted.ident","3"
    tracing::debug!({ dotted.ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"dotted.ident","3"
    tracing::debug!({ foo = true, dotted.ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"dotted.ident","3"
    tracing::debug!({ dotted.ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"dotted.ident","3"
    tracing::debug!({ foo = true, dotted.ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"dotted.ident","3"
    tracing::debug!(dotted.ident = false); // DEBUG:debug,-,-,-,-,"dotted.ident","false"
    tracing::debug!(foo = true, dotted.ident = false); // DEBUG:debug,-,-,p,-,"dotted.ident","false"
    tracing::debug!(dotted.ident = false, qux = 3); // DEBUG:debug,-,-,f,-,"dotted.ident","false"
    tracing::debug!(foo = true, dotted.ident = false, qux = 3); // DEBUG:debug,-,-,pf,-,"dotted.ident","false"
    tracing::debug!(dotted.ident = false, "msg without args"); // DEBUG:debug,-,-,-,m,"dotted.ident","false"
    tracing::debug!(foo = true, dotted.ident = false, "msg without args"); // DEBUG:debug,-,-,p,m,"dotted.ident","false"
    tracing::debug!(dotted.ident = false, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"dotted.ident","false"
    tracing::debug!(foo = true, dotted.ident = false, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"dotted.ident","false"
    tracing::debug!({ dotted.ident = false }, "msg without args"); // DEBUG:debug,-,{},-,m,"dotted.ident","false"
    tracing::debug!({ foo = true, dotted.ident = false }, "msg without args"); // DEBUG:debug,-,{},p,m,"dotted.ident","false"
    tracing::debug!({ dotted.ident = false, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"dotted.ident","false"
    tracing::debug!({ foo = true, dotted.ident = false, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"dotted.ident","false"
    tracing::debug!(dotted.ident = false, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"dotted.ident","false"
    tracing::debug!(foo = true, dotted.ident = false, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"dotted.ident","false"
    tracing::debug!(dotted.ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"dotted.ident","false"
    tracing::debug!(foo = true, dotted.ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"dotted.ident","false"
    tracing::debug!({ dotted.ident = false }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"dotted.ident","false"
    tracing::debug!({ foo = true, dotted.ident = false }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"dotted.ident","false"
    tracing::debug!({ dotted.ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"dotted.ident","false"
    tracing::debug!({ foo = true, dotted.ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"dotted.ident","false"
    tracing::debug!(dotted.ident = ?3); // DEBUG:debug,-,-,-,-,"dotted.ident","?3"
    tracing::debug!(foo = true, dotted.ident = ?3); // DEBUG:debug,-,-,p,-,"dotted.ident","?3"
    tracing::debug!(dotted.ident = ?3, qux = 3); // DEBUG:debug,-,-,f,-,"dotted.ident","?3"
    tracing::debug!(foo = true, dotted.ident = ?3, qux = 3); // DEBUG:debug,-,-,pf,-,"dotted.ident","?3"
    tracing::debug!(dotted.ident = ?3, "msg without args"); // DEBUG:debug,-,-,-,m,"dotted.ident","?3"
    tracing::debug!(foo = true, dotted.ident = ?3, "msg without args"); // DEBUG:debug,-,-,p,m,"dotted.ident","?3"
    tracing::debug!(dotted.ident = ?3, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"dotted.ident","?3"
    tracing::debug!(foo = true, dotted.ident = ?3, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"dotted.ident","?3"
    tracing::debug!({ dotted.ident = ?3 }, "msg without args"); // DEBUG:debug,-,{},-,m,"dotted.ident","?3"
    tracing::debug!({ foo = true, dotted.ident = ?3 }, "msg without args"); // DEBUG:debug,-,{},p,m,"dotted.ident","?3"
    tracing::debug!({ dotted.ident = ?3, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"dotted.ident","?3"
    tracing::debug!({ foo = true, dotted.ident = ?3, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"dotted.ident","?3"
    tracing::debug!(dotted.ident = ?3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"dotted.ident","?3"
    tracing::debug!(foo = true, dotted.ident = ?3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"dotted.ident","?3"
    tracing::debug!(dotted.ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"dotted.ident","?3"
    tracing::debug!(foo = true, dotted.ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"dotted.ident","?3"
    tracing::debug!({ dotted.ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"dotted.ident","?3"
    tracing::debug!({ foo = true, dotted.ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"dotted.ident","?3"
    tracing::debug!({ dotted.ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"dotted.ident","?3"
    tracing::debug!({ foo = true, dotted.ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"dotted.ident","?3"
    tracing::debug!(dotted.ident = %3); // DEBUG:debug,-,-,-,-,"dotted.ident","%3"
    tracing::debug!(foo = true, dotted.ident = %3); // DEBUG:debug,-,-,p,-,"dotted.ident","%3"
    tracing::debug!(dotted.ident = %3, qux = 3); // DEBUG:debug,-,-,f,-,"dotted.ident","%3"
    tracing::debug!(foo = true, dotted.ident = %3, qux = 3); // DEBUG:debug,-,-,pf,-,"dotted.ident","%3"
    tracing::debug!(dotted.ident = %3, "msg without args"); // DEBUG:debug,-,-,-,m,"dotted.ident","%3"
    tracing::debug!(foo = true, dotted.ident = %3, "msg without args"); // DEBUG:debug,-,-,p,m,"dotted.ident","%3"
    tracing::debug!(dotted.ident = %3, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"dotted.ident","%3"
    tracing::debug!(foo = true, dotted.ident = %3, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"dotted.ident","%3"
    tracing::debug!({ dotted.ident = %3 }, "msg without args"); // DEBUG:debug,-,{},-,m,"dotted.ident","%3"
    tracing::debug!({ foo = true, dotted.ident = %3 }, "msg without args"); // DEBUG:debug,-,{},p,m,"dotted.ident","%3"
    tracing::debug!({ dotted.ident = %3, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"dotted.ident","%3"
    tracing::debug!({ foo = true, dotted.ident = %3, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"dotted.ident","%3"
    tracing::debug!(dotted.ident = %3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"dotted.ident","%3"
    tracing::debug!(foo = true, dotted.ident = %3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"dotted.ident","%3"
    tracing::debug!(dotted.ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"dotted.ident","%3"
    tracing::debug!(foo = true, dotted.ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"dotted.ident","%3"
    tracing::debug!({ dotted.ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"dotted.ident","%3"
    tracing::debug!({ foo = true, dotted.ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"dotted.ident","%3"
    tracing::debug!({ dotted.ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"dotted.ident","%3"
    tracing::debug!({ foo = true, dotted.ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"dotted.ident","%3"
    tracing::debug!(dotted.ident = ?deb); // DEBUG:debug,-,-,-,-,"dotted.ident","?deb"
    tracing::debug!(foo = true, dotted.ident = ?deb); // DEBUG:debug,-,-,p,-,"dotted.ident","?deb"
    tracing::debug!(dotted.ident = ?deb, qux = 3); // DEBUG:debug,-,-,f,-,"dotted.ident","?deb"
    tracing::debug!(foo = true, dotted.ident = ?deb, qux = 3); // DEBUG:debug,-,-,pf,-,"dotted.ident","?deb"
    tracing::debug!(dotted.ident = ?deb, "msg without args"); // DEBUG:debug,-,-,-,m,"dotted.ident","?deb"
    tracing::debug!(foo = true, dotted.ident = ?deb, "msg without args"); // DEBUG:debug,-,-,p,m,"dotted.ident","?deb"
    tracing::debug!(dotted.ident = ?deb, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"dotted.ident","?deb"
    tracing::debug!(foo = true, dotted.ident = ?deb, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"dotted.ident","?deb"
    tracing::debug!({ dotted.ident = ?deb }, "msg without args"); // DEBUG:debug,-,{},-,m,"dotted.ident","?deb"
    tracing::debug!({ foo = true, dotted.ident = ?deb }, "msg without args"); // DEBUG:debug,-,{},p,m,"dotted.ident","?deb"
    tracing::debug!({ dotted.ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"dotted.ident","?deb"
    tracing::debug!({ foo = true, dotted.ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"dotted.ident","?deb"
    tracing::debug!(dotted.ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"dotted.ident","?deb"
    tracing::debug!(foo = true, dotted.ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"dotted.ident","?deb"
    tracing::debug!(dotted.ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"dotted.ident","?deb"
    tracing::debug!(foo = true, dotted.ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"dotted.ident","?deb"
    tracing::debug!({ dotted.ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"dotted.ident","?deb"
    tracing::debug!({ foo = true, dotted.ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"dotted.ident","?deb"
    tracing::debug!({ dotted.ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"dotted.ident","?deb"
    tracing::debug!({ foo = true, dotted.ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"dotted.ident","?deb"
    tracing::debug!(dotted.ident = %disp); // DEBUG:debug,-,-,-,-,"dotted.ident","%disp"
    tracing::debug!(foo = true, dotted.ident = %disp); // DEBUG:debug,-,-,p,-,"dotted.ident","%disp"
    tracing::debug!(dotted.ident = %disp, qux = 3); // DEBUG:debug,-,-,f,-,"dotted.ident","%disp"
    tracing::debug!(foo = true, dotted.ident = %disp, qux = 3); // DEBUG:debug,-,-,pf,-,"dotted.ident","%disp"
    tracing::debug!(dotted.ident = %disp, "msg without args"); // DEBUG:debug,-,-,-,m,"dotted.ident","%disp"
    tracing::debug!(foo = true, dotted.ident = %disp, "msg without args"); // DEBUG:debug,-,-,p,m,"dotted.ident","%disp"
    tracing::debug!(dotted.ident = %disp, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"dotted.ident","%disp"
    tracing::debug!(foo = true, dotted.ident = %disp, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"dotted.ident","%disp"
    tracing::debug!({ dotted.ident = %disp }, "msg without args"); // DEBUG:debug,-,{},-,m,"dotted.ident","%disp"
    tracing::debug!({ foo = true, dotted.ident = %disp }, "msg without args"); // DEBUG:debug,-,{},p,m,"dotted.ident","%disp"
    tracing::debug!({ dotted.ident = %disp, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"dotted.ident","%disp"
    tracing::debug!({ foo = true, dotted.ident = %disp, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"dotted.ident","%disp"
    tracing::debug!(dotted.ident = %disp, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"dotted.ident","%disp"
    tracing::debug!(foo = true, dotted.ident = %disp, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"dotted.ident","%disp"
    tracing::debug!(dotted.ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"dotted.ident","%disp"
    tracing::debug!(foo = true, dotted.ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"dotted.ident","%disp"
    tracing::debug!({ dotted.ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"dotted.ident","%disp"
    tracing::debug!({ foo = true, dotted.ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"dotted.ident","%disp"
    tracing::debug!({ dotted.ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"dotted.ident","%disp"
    tracing::debug!({ foo = true, dotted.ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"dotted.ident","%disp"
    tracing::debug!(dotted.ident = ?sub.field); // DEBUG:debug,-,-,-,-,"dotted.ident","?sub.field"
    tracing::debug!(foo = true, dotted.ident = ?sub.field); // DEBUG:debug,-,-,p,-,"dotted.ident","?sub.field"
    tracing::debug!(dotted.ident = ?sub.field, qux = 3); // DEBUG:debug,-,-,f,-,"dotted.ident","?sub.field"
    tracing::debug!(foo = true, dotted.ident = ?sub.field, qux = 3); // DEBUG:debug,-,-,pf,-,"dotted.ident","?sub.field"
    tracing::debug!(dotted.ident = ?sub.field, "msg without args"); // DEBUG:debug,-,-,-,m,"dotted.ident","?sub.field"
    tracing::debug!(foo = true, dotted.ident = ?sub.field, "msg without args"); // DEBUG:debug,-,-,p,m,"dotted.ident","?sub.field"
    tracing::debug!(dotted.ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"dotted.ident","?sub.field"
    tracing::debug!(foo = true, dotted.ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"dotted.ident","?sub.field"
    tracing::debug!({ dotted.ident = ?sub.field }, "msg without args"); // DEBUG:debug,-,{},-,m,"dotted.ident","?sub.field"
    tracing::debug!({ foo = true, dotted.ident = ?sub.field }, "msg without args"); // DEBUG:debug,-,{},p,m,"dotted.ident","?sub.field"
    tracing::debug!({ dotted.ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"dotted.ident","?sub.field"
    tracing::debug!({ foo = true, dotted.ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"dotted.ident","?sub.field"
    tracing::debug!(dotted.ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"dotted.ident","?sub.field"
    tracing::debug!(foo = true, dotted.ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"dotted.ident","?sub.field"
    tracing::debug!(dotted.ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"dotted.ident","?sub.field"
    tracing::debug!(foo = true, dotted.ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"dotted.ident","?sub.field"
    tracing::debug!({ dotted.ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"dotted.ident","?sub.field"
    tracing::debug!({ foo = true, dotted.ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"dotted.ident","?sub.field"
    tracing::debug!({ dotted.ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"dotted.ident","?sub.field"
    tracing::debug!({ foo = true, dotted.ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"dotted.ident","?sub.field"
    tracing::debug!(dotted.ident = %sub.field); // DEBUG:debug,-,-,-,-,"dotted.ident","%sub.field"
    tracing::debug!(foo = true, dotted.ident = %sub.field); // DEBUG:debug,-,-,p,-,"dotted.ident","%sub.field"
    tracing::debug!(dotted.ident = %sub.field, qux = 3); // DEBUG:debug,-,-,f,-,"dotted.ident","%sub.field"
    tracing::debug!(foo = true, dotted.ident = %sub.field, qux = 3); // DEBUG:debug,-,-,pf,-,"dotted.ident","%sub.field"
    tracing::debug!(dotted.ident = %sub.field, "msg without args"); // DEBUG:debug,-,-,-,m,"dotted.ident","%sub.field"
    tracing::debug!(foo = true, dotted.ident = %sub.field, "msg without args"); // DEBUG:debug,-,-,p,m,"dotted.ident","%sub.field"
    tracing::debug!(dotted.ident = %sub.field, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"dotted.ident","%sub.field"
    tracing::debug!(foo = true, dotted.ident = %sub.field, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"dotted.ident","%sub.field"
    tracing::debug!({ dotted.ident = %sub.field }, "msg without args"); // DEBUG:debug,-,{},-,m,"dotted.ident","%sub.field"
    tracing::debug!({ foo = true, dotted.ident = %sub.field }, "msg without args"); // DEBUG:debug,-,{},p,m,"dotted.ident","%sub.field"
    tracing::debug!({ dotted.ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"dotted.ident","%sub.field"
    tracing::debug!({ foo = true, dotted.ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"dotted.ident","%sub.field"
    tracing::debug!(dotted.ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"dotted.ident","%sub.field"
    tracing::debug!(foo = true, dotted.ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"dotted.ident","%sub.field"
    tracing::debug!(dotted.ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"dotted.ident","%sub.field"
    tracing::debug!(foo = true, dotted.ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"dotted.ident","%sub.field"
    tracing::debug!({ dotted.ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"dotted.ident","%sub.field"
    tracing::debug!({ foo = true, dotted.ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"dotted.ident","%sub.field"
    tracing::debug!({ dotted.ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"dotted.ident","%sub.field"
    tracing::debug!({ foo = true, dotted.ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"dotted.ident","%sub.field"
    tracing::debug!(dotted.ident = debug(&deb)); // DEBUG:debug,-,-,-,-,"dotted.ident","debug(&deb)"
    tracing::debug!(foo = true, dotted.ident = debug(&deb)); // DEBUG:debug,-,-,p,-,"dotted.ident","debug(&deb)"
    tracing::debug!(dotted.ident = debug(&deb), qux = 3); // DEBUG:debug,-,-,f,-,"dotted.ident","debug(&deb)"
    tracing::debug!(foo = true, dotted.ident = debug(&deb), qux = 3); // DEBUG:debug,-,-,pf,-,"dotted.ident","debug(&deb)"
    tracing::debug!(dotted.ident = debug(&deb), "msg without args"); // DEBUG:debug,-,-,-,m,"dotted.ident","debug(&deb)"
    tracing::debug!(foo = true, dotted.ident = debug(&deb), "msg without args"); // DEBUG:debug,-,-,p,m,"dotted.ident","debug(&deb)"
    tracing::debug!(dotted.ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"dotted.ident","debug(&deb)"
    tracing::debug!(foo = true, dotted.ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"dotted.ident","debug(&deb)"
    tracing::debug!({ dotted.ident = debug(&deb) }, "msg without args"); // DEBUG:debug,-,{},-,m,"dotted.ident","debug(&deb)"
    tracing::debug!({ foo = true, dotted.ident = debug(&deb) }, "msg without args"); // DEBUG:debug,-,{},p,m,"dotted.ident","debug(&deb)"
    tracing::debug!({ dotted.ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"dotted.ident","debug(&deb)"
    tracing::debug!({ foo = true, dotted.ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"dotted.ident","debug(&deb)"
    tracing::debug!(dotted.ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"dotted.ident","debug(&deb)"
    tracing::debug!(foo = true, dotted.ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"dotted.ident","debug(&deb)"
    tracing::debug!(dotted.ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"dotted.ident","debug(&deb)"
    tracing::debug!(foo = true, dotted.ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"dotted.ident","debug(&deb)"
    tracing::debug!({ dotted.ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"dotted.ident","debug(&deb)"
    tracing::debug!({ foo = true, dotted.ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"dotted.ident","debug(&deb)"
    tracing::debug!({ dotted.ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"dotted.ident","debug(&deb)"
    tracing::debug!({ foo = true, dotted.ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"dotted.ident","debug(&deb)"
    tracing::debug!(dotted.ident = display(&disp)); // DEBUG:debug,-,-,-,-,"dotted.ident","display(&disp)"
    tracing::debug!(foo = true, dotted.ident = display(&disp)); // DEBUG:debug,-,-,p,-,"dotted.ident","display(&disp)"
    tracing::debug!(dotted.ident = display(&disp), qux = 3); // DEBUG:debug,-,-,f,-,"dotted.ident","display(&disp)"
    tracing::debug!(foo = true, dotted.ident = display(&disp), qux = 3); // DEBUG:debug,-,-,pf,-,"dotted.ident","display(&disp)"
    tracing::debug!(dotted.ident = display(&disp), "msg without args"); // DEBUG:debug,-,-,-,m,"dotted.ident","display(&disp)"
    tracing::debug!(foo = true, dotted.ident = display(&disp), "msg without args"); // DEBUG:debug,-,-,p,m,"dotted.ident","display(&disp)"
    tracing::debug!(dotted.ident = display(&disp), qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"dotted.ident","display(&disp)"
    tracing::debug!(foo = true, dotted.ident = display(&disp), qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"dotted.ident","display(&disp)"
    tracing::debug!({ dotted.ident = display(&disp) }, "msg without args"); // DEBUG:debug,-,{},-,m,"dotted.ident","display(&disp)"
    tracing::debug!({ foo = true, dotted.ident = display(&disp) }, "msg without args"); // DEBUG:debug,-,{},p,m,"dotted.ident","display(&disp)"
    tracing::debug!({ dotted.ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"dotted.ident","display(&disp)"
    tracing::debug!({ foo = true, dotted.ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"dotted.ident","display(&disp)"
    tracing::debug!(dotted.ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"dotted.ident","display(&disp)"
    tracing::debug!(foo = true, dotted.ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"dotted.ident","display(&disp)"
    tracing::debug!(dotted.ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"dotted.ident","display(&disp)"
    tracing::debug!(foo = true, dotted.ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"dotted.ident","display(&disp)"
    tracing::debug!({ dotted.ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"dotted.ident","display(&disp)"
    tracing::debug!({ foo = true, dotted.ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"dotted.ident","display(&disp)"
    tracing::debug!({ dotted.ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"dotted.ident","display(&disp)"
    tracing::debug!({ foo = true, dotted.ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"dotted.ident","display(&disp)"
    tracing::debug!(dotted.ident = tracing::field::Empty); // DEBUG:debug,-,-,-,-,"dotted.ident","tracing::field::Empty"
    tracing::debug!(foo = true, dotted.ident = tracing::field::Empty); // DEBUG:debug,-,-,p,-,"dotted.ident","tracing::field::Empty"
    tracing::debug!(dotted.ident = tracing::field::Empty, qux = 3); // DEBUG:debug,-,-,f,-,"dotted.ident","tracing::field::Empty"
    tracing::debug!(foo = true, dotted.ident = tracing::field::Empty, qux = 3); // DEBUG:debug,-,-,pf,-,"dotted.ident","tracing::field::Empty"
    tracing::debug!(dotted.ident = tracing::field::Empty, "msg without args"); // DEBUG:debug,-,-,-,m,"dotted.ident","tracing::field::Empty"
    tracing::debug!(foo = true, dotted.ident = tracing::field::Empty, "msg without args"); // DEBUG:debug,-,-,p,m,"dotted.ident","tracing::field::Empty"
    tracing::debug!(dotted.ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"dotted.ident","tracing::field::Empty"
    tracing::debug!(foo = true, dotted.ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"dotted.ident","tracing::field::Empty"
    tracing::debug!({ dotted.ident = tracing::field::Empty }, "msg without args"); // DEBUG:debug,-,{},-,m,"dotted.ident","tracing::field::Empty"
    tracing::debug!({ foo = true, dotted.ident = tracing::field::Empty }, "msg without args"); // DEBUG:debug,-,{},p,m,"dotted.ident","tracing::field::Empty"
    tracing::debug!({ dotted.ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"dotted.ident","tracing::field::Empty"
    tracing::debug!({ foo = true, dotted.ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"dotted.ident","tracing::field::Empty"
    tracing::debug!(dotted.ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"dotted.ident","tracing::field::Empty"
    tracing::debug!(foo = true, dotted.ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"dotted.ident","tracing::field::Empty"
    tracing::debug!(dotted.ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"dotted.ident","tracing::field::Empty"
    tracing::debug!(foo = true, dotted.ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"dotted.ident","tracing::field::Empty"
    tracing::debug!({ dotted.ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"dotted.ident","tracing::field::Empty"
    tracing::debug!({ foo = true, dotted.ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"dotted.ident","tracing::field::Empty"
    tracing::debug!({ dotted.ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"dotted.ident","tracing::field::Empty"
    tracing::debug!({ foo = true, dotted.ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"dotted.ident","tracing::field::Empty"
    tracing::debug!("literal" = 3); // DEBUG:debug,-,-,-,-,"\"literal\"","3"
    tracing::debug!(foo = true, "literal" = 3); // DEBUG:debug,-,-,p,-,"\"literal\"","3"
    tracing::debug!("literal" = 3, qux = 3); // DEBUG:debug,-,-,f,-,"\"literal\"","3"
    tracing::debug!(foo = true, "literal" = 3, qux = 3); // DEBUG:debug,-,-,pf,-,"\"literal\"","3"
    tracing::debug!("literal" = 3, "msg without args"); // DEBUG:debug,-,-,-,m,"\"literal\"","3"
    tracing::debug!(foo = true, "literal" = 3, "msg without args"); // DEBUG:debug,-,-,p,m,"\"literal\"","3"
    tracing::debug!("literal" = 3, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"\"literal\"","3"
    tracing::debug!(foo = true, "literal" = 3, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"\"literal\"","3"
    tracing::debug!({ "literal" = 3 }, "msg without args"); // DEBUG:debug,-,{},-,m,"\"literal\"","3"
    tracing::debug!({ foo = true, "literal" = 3 }, "msg without args"); // DEBUG:debug,-,{},p,m,"\"literal\"","3"
    tracing::debug!({ "literal" = 3, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"\"literal\"","3"
    tracing::debug!({ foo = true, "literal" = 3, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"\"literal\"","3"
    tracing::debug!("literal" = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"\"literal\"","3"
    tracing::debug!(foo = true, "literal" = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"\"literal\"","3"
    tracing::debug!("literal" = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"\"literal\"","3"
    tracing::debug!(foo = true, "literal" = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"\"literal\"","3"
    tracing::debug!({ "literal" = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"\"literal\"","3"
    tracing::debug!({ foo = true, "literal" = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"\"literal\"","3"
    tracing::debug!({ "literal" = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"\"literal\"","3"
    tracing::debug!({ foo = true, "literal" = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"\"literal\"","3"
    tracing::debug!("literal" = false); // DEBUG:debug,-,-,-,-,"\"literal\"","false"
    tracing::debug!(foo = true, "literal" = false); // DEBUG:debug,-,-,p,-,"\"literal\"","false"
    tracing::debug!("literal" = false, qux = 3); // DEBUG:debug,-,-,f,-,"\"literal\"","false"
    tracing::debug!(foo = true, "literal" = false, qux = 3); // DEBUG:debug,-,-,pf,-,"\"literal\"","false"
    tracing::debug!("literal" = false, "msg without args"); // DEBUG:debug,-,-,-,m,"\"literal\"","false"
    tracing::debug!(foo = true, "literal" = false, "msg without args"); // DEBUG:debug,-,-,p,m,"\"literal\"","false"
    tracing::debug!("literal" = false, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"\"literal\"","false"
    tracing::debug!(foo = true, "literal" = false, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"\"literal\"","false"
    tracing::debug!({ "literal" = false }, "msg without args"); // DEBUG:debug,-,{},-,m,"\"literal\"","false"
    tracing::debug!({ foo = true, "literal" = false }, "msg without args"); // DEBUG:debug,-,{},p,m,"\"literal\"","false"
    tracing::debug!({ "literal" = false, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"\"literal\"","false"
    tracing::debug!({ foo = true, "literal" = false, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"\"literal\"","false"
    tracing::debug!("literal" = false, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"\"literal\"","false"
    tracing::debug!(foo = true, "literal" = false, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"\"literal\"","false"
    tracing::debug!("literal" = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"\"literal\"","false"
    tracing::debug!(foo = true, "literal" = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"\"literal\"","false"
    tracing::debug!({ "literal" = false }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"\"literal\"","false"
    tracing::debug!({ foo = true, "literal" = false }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"\"literal\"","false"
    tracing::debug!({ "literal" = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"\"literal\"","false"
    tracing::debug!({ foo = true, "literal" = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"\"literal\"","false"
    tracing::debug!("literal" = ?3); // DEBUG:debug,-,-,-,-,"\"literal\"","?3"
    tracing::debug!(foo = true, "literal" = ?3); // DEBUG:debug,-,-,p,-,"\"literal\"","?3"
    tracing::debug!("literal" = ?3, qux = 3); // DEBUG:debug,-,-,f,-,"\"literal\"","?3"
    tracing::debug!(foo = true, "literal" = ?3, qux = 3); // DEBUG:debug,-,-,pf,-,"\"literal\"","?3"
    tracing::debug!("literal" = ?3, "msg without args"); // DEBUG:debug,-,-,-,m,"\"literal\"","?3"
    tracing::debug!(foo = true, "literal" = ?3, "msg without args"); // DEBUG:debug,-,-,p,m,"\"literal\"","?3"
    tracing::debug!("literal" = ?3, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"\"literal\"","?3"
    tracing::debug!(foo = true, "literal" = ?3, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"\"literal\"","?3"
    tracing::debug!({ "literal" = ?3 }, "msg without args"); // DEBUG:debug,-,{},-,m,"\"literal\"","?3"
    tracing::debug!({ foo = true, "literal" = ?3 }, "msg without args"); // DEBUG:debug,-,{},p,m,"\"literal\"","?3"
    tracing::debug!({ "literal" = ?3, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"\"literal\"","?3"
    tracing::debug!({ foo = true, "literal" = ?3, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"\"literal\"","?3"
    tracing::debug!("literal" = ?3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"\"literal\"","?3"
    tracing::debug!(foo = true, "literal" = ?3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"\"literal\"","?3"
    tracing::debug!("literal" = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"\"literal\"","?3"
    tracing::debug!(foo = true, "literal" = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"\"literal\"","?3"
    tracing::debug!({ "literal" = ?3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"\"literal\"","?3"
    tracing::debug!({ foo = true, "literal" = ?3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"\"literal\"","?3"
    tracing::debug!({ "literal" = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"\"literal\"","?3"
    tracing::debug!({ foo = true, "literal" = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"\"literal\"","?3"
    tracing::debug!("literal" = %3); // DEBUG:debug,-,-,-,-,"\"literal\"","%3"
    tracing::debug!(foo = true, "literal" = %3); // DEBUG:debug,-,-,p,-,"\"literal\"","%3"
    tracing::debug!("literal" = %3, qux = 3); // DEBUG:debug,-,-,f,-,"\"literal\"","%3"
    tracing::debug!(foo = true, "literal" = %3, qux = 3); // DEBUG:debug,-,-,pf,-,"\"literal\"","%3"
    tracing::debug!("literal" = %3, "msg without args"); // DEBUG:debug,-,-,-,m,"\"literal\"","%3"
    tracing::debug!(foo = true, "literal" = %3, "msg without args"); // DEBUG:debug,-,-,p,m,"\"literal\"","%3"
    tracing::debug!("literal" = %3, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"\"literal\"","%3"
    tracing::debug!(foo = true, "literal" = %3, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"\"literal\"","%3"
    tracing::debug!({ "literal" = %3 }, "msg without args"); // DEBUG:debug,-,{},-,m,"\"literal\"","%3"
    tracing::debug!({ foo = true, "literal" = %3 }, "msg without args"); // DEBUG:debug,-,{},p,m,"\"literal\"","%3"
    tracing::debug!({ "literal" = %3, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"\"literal\"","%3"
    tracing::debug!({ foo = true, "literal" = %3, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"\"literal\"","%3"
    tracing::debug!("literal" = %3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"\"literal\"","%3"
    tracing::debug!(foo = true, "literal" = %3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"\"literal\"","%3"
    tracing::debug!("literal" = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"\"literal\"","%3"
    tracing::debug!(foo = true, "literal" = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"\"literal\"","%3"
    tracing::debug!({ "literal" = %3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"\"literal\"","%3"
    tracing::debug!({ foo = true, "literal" = %3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"\"literal\"","%3"
    tracing::debug!({ "literal" = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"\"literal\"","%3"
    tracing::debug!({ foo = true, "literal" = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"\"literal\"","%3"
    tracing::debug!("literal" = ?deb); // DEBUG:debug,-,-,-,-,"\"literal\"","?deb"
    tracing::debug!(foo = true, "literal" = ?deb); // DEBUG:debug,-,-,p,-,"\"literal\"","?deb"
    tracing::debug!("literal" = ?deb, qux = 3); // DEBUG:debug,-,-,f,-,"\"literal\"","?deb"
    tracing::debug!(foo = true, "literal" = ?deb, qux = 3); // DEBUG:debug,-,-,pf,-,"\"literal\"","?deb"
    tracing::debug!("literal" = ?deb, "msg without args"); // DEBUG:debug,-,-,-,m,"\"literal\"","?deb"
    tracing::debug!(foo = true, "literal" = ?deb, "msg without args"); // DEBUG:debug,-,-,p,m,"\"literal\"","?deb"
    tracing::debug!("literal" = ?deb, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"\"literal\"","?deb"
    tracing::debug!(foo = true, "literal" = ?deb, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"\"literal\"","?deb"
    tracing::debug!({ "literal" = ?deb }, "msg without args"); // DEBUG:debug,-,{},-,m,"\"literal\"","?deb"
    tracing::debug!({ foo = true, "literal" = ?deb }, "msg without args"); // DEBUG:debug,-,{},p,m,"\"literal\"","?deb"
    tracing::debug!({ "literal" = ?deb, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"\"literal\"","?deb"
    tracing::debug!({ foo = true, "literal" = ?deb, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"\"literal\"","?deb"
    tracing::debug!("literal" = ?deb, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"\"literal\"","?deb"
    tracing::debug!(foo = true, "literal" = ?deb, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"\"literal\"","?deb"
    tracing::debug!("literal" = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"\"literal\"","?deb"
    tracing::debug!(foo = true, "literal" = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"\"literal\"","?deb"
    tracing::debug!({ "literal" = ?deb }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"\"literal\"","?deb"
    tracing::debug!({ foo = true, "literal" = ?deb }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"\"literal\"","?deb"
    tracing::debug!({ "literal" = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"\"literal\"","?deb"
    tracing::debug!({ foo = true, "literal" = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"\"literal\"","?deb"
    tracing::debug!("literal" = %disp); // DEBUG:debug,-,-,-,-,"\"literal\"","%disp"
    tracing::debug!(foo = true, "literal" = %disp); // DEBUG:debug,-,-,p,-,"\"literal\"","%disp"
    tracing::debug!("literal" = %disp, qux = 3); // DEBUG:debug,-,-,f,-,"\"literal\"","%disp"
    tracing::debug!(foo = true, "literal" = %disp, qux = 3); // DEBUG:debug,-,-,pf,-,"\"literal\"","%disp"
    tracing::debug!("literal" = %disp, "msg without args"); // DEBUG:debug,-,-,-,m,"\"literal\"","%disp"
    tracing::debug!(foo = true, "literal" = %disp, "msg without args"); // DEBUG:debug,-,-,p,m,"\"literal\"","%disp"
    tracing::debug!("literal" = %disp, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"\"literal\"","%disp"
    tracing::debug!(foo = true, "literal" = %disp, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"\"literal\"","%disp"
    tracing::debug!({ "literal" = %disp }, "msg without args"); // DEBUG:debug,-,{},-,m,"\"literal\"","%disp"
    tracing::debug!({ foo = true, "literal" = %disp }, "msg without args"); // DEBUG:debug,-,{},p,m,"\"literal\"","%disp"
    tracing::debug!({ "literal" = %disp, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"\"literal\"","%disp"
    tracing::debug!({ foo = true, "literal" = %disp, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"\"literal\"","%disp"
    tracing::debug!("literal" = %disp, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"\"literal\"","%disp"
    tracing::debug!(foo = true, "literal" = %disp, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"\"literal\"","%disp"
    tracing::debug!("literal" = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"\"literal\"","%disp"
    tracing::debug!(foo = true, "literal" = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"\"literal\"","%disp"
    tracing::debug!({ "literal" = %disp }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"\"literal\"","%disp"
    tracing::debug!({ foo = true, "literal" = %disp }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"\"literal\"","%disp"
    tracing::debug!({ "literal" = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"\"literal\"","%disp"
    tracing::debug!({ foo = true, "literal" = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"\"literal\"","%disp"
    tracing::debug!("literal" = ?sub.field); // DEBUG:debug,-,-,-,-,"\"literal\"","?sub.field"
    tracing::debug!(foo = true, "literal" = ?sub.field); // DEBUG:debug,-,-,p,-,"\"literal\"","?sub.field"
    tracing::debug!("literal" = ?sub.field, qux = 3); // DEBUG:debug,-,-,f,-,"\"literal\"","?sub.field"
    tracing::debug!(foo = true, "literal" = ?sub.field, qux = 3); // DEBUG:debug,-,-,pf,-,"\"literal\"","?sub.field"
    tracing::debug!("literal" = ?sub.field, "msg without args"); // DEBUG:debug,-,-,-,m,"\"literal\"","?sub.field"
    tracing::debug!(foo = true, "literal" = ?sub.field, "msg without args"); // DEBUG:debug,-,-,p,m,"\"literal\"","?sub.field"
    tracing::debug!("literal" = ?sub.field, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"\"literal\"","?sub.field"
    tracing::debug!(foo = true, "literal" = ?sub.field, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"\"literal\"","?sub.field"
    tracing::debug!({ "literal" = ?sub.field }, "msg without args"); // DEBUG:debug,-,{},-,m,"\"literal\"","?sub.field"
    tracing::debug!({ foo = true, "literal" = ?sub.field }, "msg without args"); // DEBUG:debug,-,{},p,m,"\"literal\"","?sub.field"
    tracing::debug!({ "literal" = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"\"literal\"","?sub.field"
    tracing::debug!({ foo = true, "literal" = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"\"literal\"","?sub.field"
    tracing::debug!("literal" = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"\"literal\"","?sub.field"
    tracing::debug!(foo = true, "literal" = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"\"literal\"","?sub.field"
    tracing::debug!("literal" = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"\"literal\"","?sub.field"
    tracing::debug!(foo = true, "literal" = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"\"literal\"","?sub.field"
    tracing::debug!({ "literal" = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"\"literal\"","?sub.field"
    tracing::debug!({ foo = true, "literal" = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"\"literal\"","?sub.field"
    tracing::debug!({ "literal" = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"\"literal\"","?sub.field"
    tracing::debug!({ foo = true, "literal" = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"\"literal\"","?sub.field"
    tracing::debug!("literal" = %sub.field); // DEBUG:debug,-,-,-,-,"\"literal\"","%sub.field"
    tracing::debug!(foo = true, "literal" = %sub.field); // DEBUG:debug,-,-,p,-,"\"literal\"","%sub.field"
    tracing::debug!("literal" = %sub.field, qux = 3); // DEBUG:debug,-,-,f,-,"\"literal\"","%sub.field"
    tracing::debug!(foo = true, "literal" = %sub.field, qux = 3); // DEBUG:debug,-,-,pf,-,"\"literal\"","%sub.field"
    tracing::debug!("literal" = %sub.field, "msg without args"); // DEBUG:debug,-,-,-,m,"\"literal\"","%sub.field"
    tracing::debug!(foo = true, "literal" = %sub.field, "msg without args"); // DEBUG:debug,-,-,p,m,"\"literal\"","%sub.field"
    tracing::debug!("literal" = %sub.field, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"\"literal\"","%sub.field"
    tracing::debug!(foo = true, "literal" = %sub.field, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"\"literal\"","%sub.field"
    tracing::debug!({ "literal" = %sub.field }, "msg without args"); // DEBUG:debug,-,{},-,m,"\"literal\"","%sub.field"
    tracing::debug!({ foo = true, "literal" = %sub.field }, "msg without args"); // DEBUG:debug,-,{},p,m,"\"literal\"","%sub.field"
    tracing::debug!({ "literal" = %sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"\"literal\"","%sub.field"
    tracing::debug!({ foo = true, "literal" = %sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"\"literal\"","%sub.field"
    tracing::debug!("literal" = %sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"\"literal\"","%sub.field"
    tracing::debug!(foo = true, "literal" = %sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"\"literal\"","%sub.field"
    tracing::debug!("literal" = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"\"literal\"","%sub.field"
    tracing::debug!(foo = true, "literal" = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"\"literal\"","%sub.field"
    tracing::debug!({ "literal" = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"\"literal\"","%sub.field"
    tracing::debug!({ foo = true, "literal" = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"\"literal\"","%sub.field"
    tracing::debug!({ "literal" = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"\"literal\"","%sub.field"
    tracing::debug!({ foo = true, "literal" = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"\"literal\"","%sub.field"
    tracing::debug!("literal" = debug(&deb)); // DEBUG:debug,-,-,-,-,"\"literal\"","debug(&deb)"
    tracing::debug!(foo = true, "literal" = debug(&deb)); // DEBUG:debug,-,-,p,-,"\"literal\"","debug(&deb)"
    tracing::debug!("literal" = debug(&deb), qux = 3); // DEBUG:debug,-,-,f,-,"\"literal\"","debug(&deb)"
    tracing::debug!(foo = true, "literal" = debug(&deb), qux = 3); // DEBUG:debug,-,-,pf,-,"\"literal\"","debug(&deb)"
    tracing::debug!("literal" = debug(&deb), "msg without args"); // DEBUG:debug,-,-,-,m,"\"literal\"","debug(&deb)"
    tracing::debug!(foo = true, "literal" = debug(&deb), "msg without args"); // DEBUG:debug,-,-,p,m,"\"literal\"","debug(&deb)"
    tracing::debug!("literal" = debug(&deb), qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"\"literal\"","debug(&deb)"
    tracing::debug!(foo = true, "literal" = debug(&deb), qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"\"literal\"","debug(&deb)"
    tracing::debug!({ "literal" = debug(&deb) }, "msg without args"); // DEBUG:debug,-,{},-,m,"\"literal\"","debug(&deb)"
    tracing::debug!({ foo = true, "literal" = debug(&deb) }, "msg without args"); // DEBUG:debug,-,{},p,m,"\"literal\"","debug(&deb)"
    tracing::debug!({ "literal" = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"\"literal\"","debug(&deb)"
    tracing::debug!({ foo = true, "literal" = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"\"literal\"","debug(&deb)"
    tracing::debug!("literal" = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"\"literal\"","debug(&deb)"
    tracing::debug!(foo = true, "literal" = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"\"literal\"","debug(&deb)"
    tracing::debug!("literal" = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"\"literal\"","debug(&deb)"
    tracing::debug!(foo = true, "literal" = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"\"literal\"","debug(&deb)"
    tracing::debug!({ "literal" = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"\"literal\"","debug(&deb)"
    tracing::debug!({ foo = true, "literal" = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"\"literal\"","debug(&deb)"
    tracing::debug!({ "literal" = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"\"literal\"","debug(&deb)"
    tracing::debug!({ foo = true, "literal" = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"\"literal\"","debug(&deb)"
    tracing::debug!("literal" = display(&disp)); // DEBUG:debug,-,-,-,-,"\"literal\"","display(&disp)"
    tracing::debug!(foo = true, "literal" = display(&disp)); // DEBUG:debug,-,-,p,-,"\"literal\"","display(&disp)"
    tracing::debug!("literal" = display(&disp), qux = 3); // DEBUG:debug,-,-,f,-,"\"literal\"","display(&disp)"
    tracing::debug!(foo = true, "literal" = display(&disp), qux = 3); // DEBUG:debug,-,-,pf,-,"\"literal\"","display(&disp)"
    tracing::debug!("literal" = display(&disp), "msg without args"); // DEBUG:debug,-,-,-,m,"\"literal\"","display(&disp)"
    tracing::debug!(foo = true, "literal" = display(&disp), "msg without args"); // DEBUG:debug,-,-,p,m,"\"literal\"","display(&disp)"
    tracing::debug!("literal" = display(&disp), qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"\"literal\"","display(&disp)"
    tracing::debug!(foo = true, "literal" = display(&disp), qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"\"literal\"","display(&disp)"
    tracing::debug!({ "literal" = display(&disp) }, "msg without args"); // DEBUG:debug,-,{},-,m,"\"literal\"","display(&disp)"
    tracing::debug!({ foo = true, "literal" = display(&disp) }, "msg without args"); // DEBUG:debug,-,{},p,m,"\"literal\"","display(&disp)"
    tracing::debug!({ "literal" = display(&disp), qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"\"literal\"","display(&disp)"
    tracing::debug!({ foo = true, "literal" = display(&disp), qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"\"literal\"","display(&disp)"
    tracing::debug!("literal" = display(&disp), "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"\"literal\"","display(&disp)"
    tracing::debug!(foo = true, "literal" = display(&disp), "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"\"literal\"","display(&disp)"
    tracing::debug!("literal" = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"\"literal\"","display(&disp)"
    tracing::debug!(foo = true, "literal" = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"\"literal\"","display(&disp)"
    tracing::debug!({ "literal" = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"\"literal\"","display(&disp)"
    tracing::debug!({ foo = true, "literal" = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"\"literal\"","display(&disp)"
    tracing::debug!({ "literal" = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"\"literal\"","display(&disp)"
    tracing::debug!({ foo = true, "literal" = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"\"literal\"","display(&disp)"
    tracing::debug!("literal" = tracing::field::Empty); // DEBUG:debug,-,-,-,-,"\"literal\"","tracing::field::Empty"
    tracing::debug!(foo = true, "literal" = tracing::field::Empty); // DEBUG:debug,-,-,p,-,"\"literal\"","tracing::field::Empty"
    tracing::debug!("literal" = tracing::field::Empty, qux = 3); // DEBUG:debug,-,-,f,-,"\"literal\"","tracing::field::Empty"
    tracing::debug!(foo = true, "literal" = tracing::field::Empty, qux = 3); // DEBUG:debug,-,-,pf,-,"\"literal\"","tracing::field::Empty"
    tracing::debug!("literal" = tracing::field::Empty, "msg without args"); // DEBUG:debug,-,-,-,m,"\"literal\"","tracing::field::Empty"
    tracing::debug!(foo = true, "literal" = tracing::field::Empty, "msg without args"); // DEBUG:debug,-,-,p,m,"\"literal\"","tracing::field::Empty"
    tracing::debug!("literal" = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"\"literal\"","tracing::field::Empty"
    tracing::debug!(foo = true, "literal" = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"\"literal\"","tracing::field::Empty"
    tracing::debug!({ "literal" = tracing::field::Empty }, "msg without args"); // DEBUG:debug,-,{},-,m,"\"literal\"","tracing::field::Empty"
    tracing::debug!({ foo = true, "literal" = tracing::field::Empty }, "msg without args"); // DEBUG:debug,-,{},p,m,"\"literal\"","tracing::field::Empty"
    tracing::debug!({ "literal" = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"\"literal\"","tracing::field::Empty"
    tracing::debug!({ foo = true, "literal" = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"\"literal\"","tracing::field::Empty"
    tracing::debug!("literal" = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"\"literal\"","tracing::field::Empty"
    tracing::debug!(foo = true, "literal" = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"\"literal\"","tracing::field::Empty"
    tracing::debug!("literal" = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"\"literal\"","tracing::field::Empty"
    tracing::debug!(foo = true, "literal" = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"\"literal\"","tracing::field::Empty"
    tracing::debug!({ "literal" = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"\"literal\"","tracing::field::Empty"
    tracing::debug!({ foo = true, "literal" = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"\"literal\"","tracing::field::Empty"
    tracing::debug!({ "literal" = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"\"literal\"","tracing::field::Empty"
    tracing::debug!({ foo = true, "literal" = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"\"literal\"","tracing::field::Empty"
    tracing::debug!({ CONST_VAR } = 3); // DEBUG:debug,-,-,-,-,"{ CONST_VAR }","3"
    tracing::debug!(foo = true, { CONST_VAR } = 3); // DEBUG:debug,-,-,p,-,"{ CONST_VAR }","3"
    tracing::debug!({ CONST_VAR } = 3, qux = 3); // DEBUG:debug,-,-,f,-,"{ CONST_VAR }","3"
    tracing::debug!(foo = true, { CONST_VAR } = 3, qux = 3); // DEBUG:debug,-,-,pf,-,"{ CONST_VAR }","3"
    tracing::debug!({ CONST_VAR } = 3, "msg without args"); // DEBUG:debug,-,-,-,m,"{ CONST_VAR }","3"
    tracing::debug!(foo = true, { CONST_VAR } = 3, "msg without args"); // DEBUG:debug,-,-,p,m,"{ CONST_VAR }","3"
    tracing::debug!({ CONST_VAR } = 3, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"{ CONST_VAR }","3"
    tracing::debug!(foo = true, { CONST_VAR } = 3, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"{ CONST_VAR }","3"
    tracing::debug!({ { CONST_VAR } = 3 }, "msg without args"); // DEBUG:debug,-,{},-,m,"{ CONST_VAR }","3"
    tracing::debug!({ foo = true, { CONST_VAR } = 3 }, "msg without args"); // DEBUG:debug,-,{},p,m,"{ CONST_VAR }","3"
    tracing::debug!({ { CONST_VAR } = 3, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"{ CONST_VAR }","3"
    tracing::debug!({ foo = true, { CONST_VAR } = 3, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"{ CONST_VAR }","3"
    tracing::debug!({ CONST_VAR } = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"{ CONST_VAR }","3"
    tracing::debug!(foo = true, { CONST_VAR } = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"{ CONST_VAR }","3"
    tracing::debug!({ CONST_VAR } = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"{ CONST_VAR }","3"
    tracing::debug!(foo = true, { CONST_VAR } = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"{ CONST_VAR }","3"
    tracing::debug!({ { CONST_VAR } = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"{ CONST_VAR }","3"
    tracing::debug!({ foo = true, { CONST_VAR } = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"{ CONST_VAR }","3"
    tracing::debug!({ { CONST_VAR } = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"{ CONST_VAR }","3"
    tracing::debug!({ foo = true, { CONST_VAR } = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"{ CONST_VAR }","3"
    tracing::debug!({ CONST_VAR } = false); // DEBUG:debug,-,-,-,-,"{ CONST_VAR }","false"
    tracing::debug!(foo = true, { CONST_VAR } = false); // DEBUG:debug,-,-,p,-,"{ CONST_VAR }","false"
    tracing::debug!({ CONST_VAR } = false, qux = 3); // DEBUG:debug,-,-,f,-,"{ CONST_VAR }","false"
    tracing::debug!(foo = true, { CONST_VAR } = false, qux = 3); // DEBUG:debug,-,-,pf,-,"{ CONST_VAR }","false"
    tracing::debug!({ CONST_VAR } = false, "msg without args"); // DEBUG:debug,-,-,-,m,"{ CONST_VAR }","false"
    tracing::debug!(foo = true, { CONST_VAR } = false, "msg without args"); // DEBUG:debug,-,-,p,m,"{ CONST_VAR }","false"
    tracing::debug!({ CONST_VAR } = false, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"{ CONST_VAR }","false"
    tracing::debug!(foo = true, { CONST_VAR } = false, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"{ CONST_VAR }","false"
    tracing::debug!({ { CONST_VAR } = false }, "msg without args"); // DEBUG:debug,-,{},-,m,"{ CONST_VAR }","false"
    tracing::debug!({ foo = true, { CONST_VAR } = false }, "msg without args"); // DEBUG:debug,-,{},p,m,"{ CONST_VAR }","false"
    tracing::debug!({ { CONST_VAR } = false, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"{ CONST_VAR }","false"
    tracing::debug!({ foo = true, { CONST_VAR } = false, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"{ CONST_VAR }","false"
    tracing::debug!({ CONST_VAR } = false, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"{ CONST_VAR }","false"
    tracing::debug!(foo = true, { CONST_VAR } = false, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"{ CONST_VAR }","false"
    tracing::debug!({ CONST_VAR } = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"{ CONST_VAR }","false"
    tracing::debug!(foo = true, { CONST_VAR } = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"{ CONST_VAR }","false"
    tracing::debug!({ { CONST_VAR } = false }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"{ CONST_VAR }","false"
    tracing::debug!({ foo = true, { CONST_VAR } = false }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"{ CONST_VAR }","false"
    tracing::debug!({ { CONST_VAR } = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"{ CONST_VAR }","false"
    tracing::debug!({ foo = true, { CONST_VAR } = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"{ CONST_VAR }","false"
    tracing::debug!({ CONST_VAR } = ?3); // DEBUG:debug,-,-,-,-,"{ CONST_VAR }","?3"
    tracing::debug!(foo = true, { CONST_VAR } = ?3); // DEBUG:debug,-,-,p,-,"{ CONST_VAR }","?3"
    tracing::debug!({ CONST_VAR } = ?3, qux = 3); // DEBUG:debug,-,-,f,-,"{ CONST_VAR }","?3"
    tracing::debug!(foo = true, { CONST_VAR } = ?3, qux = 3); // DEBUG:debug,-,-,pf,-,"{ CONST_VAR }","?3"
    tracing::debug!({ CONST_VAR } = ?3, "msg without args"); // DEBUG:debug,-,-,-,m,"{ CONST_VAR }","?3"
    tracing::debug!(foo = true, { CONST_VAR } = ?3, "msg without args"); // DEBUG:debug,-,-,p,m,"{ CONST_VAR }","?3"
    tracing::debug!({ CONST_VAR } = ?3, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"{ CONST_VAR }","?3"
    tracing::debug!(foo = true, { CONST_VAR } = ?3, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"{ CONST_VAR }","?3"
    tracing::debug!({ { CONST_VAR } = ?3 }, "msg without args"); // DEBUG:debug,-,{},-,m,"{ CONST_VAR }","?3"
    tracing::debug!({ foo = true, { CONST_VAR } = ?3 }, "msg without args"); // DEBUG:debug,-,{},p,m,"{ CONST_VAR }","?3"
    tracing::debug!({ { CONST_VAR } = ?3, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"{ CONST_VAR }","?3"
    tracing::debug!({ foo = true, { CONST_VAR } = ?3, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"{ CONST_VAR }","?3"
    tracing::debug!({ CONST_VAR } = ?3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"{ CONST_VAR }","?3"
    tracing::debug!(foo = true, { CONST_VAR } = ?3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"{ CONST_VAR }","?3"
    tracing::debug!({ CONST_VAR } = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"{ CONST_VAR }","?3"
    tracing::debug!(foo = true, { CONST_VAR } = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"{ CONST_VAR }","?3"
    tracing::debug!({ { CONST_VAR } = ?3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"{ CONST_VAR }","?3"
    tracing::debug!({ foo = true, { CONST_VAR } = ?3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"{ CONST_VAR }","?3"
    tracing::debug!({ { CONST_VAR } = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"{ CONST_VAR }","?3"
    tracing::debug!({ foo = true, { CONST_VAR } = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"{ CONST_VAR }","?3"
    tracing::debug!({ CONST_VAR } = %3); // DEBUG:debug,-,-,-,-,"{ CONST_VAR }","%3"
    tracing::debug!(foo = true, { CONST_VAR } = %3); // DEBUG:debug,-,-,p,-,"{ CONST_VAR }","%3"
    tracing::debug!({ CONST_VAR } = %3, qux = 3); // DEBUG:debug,-,-,f,-,"{ CONST_VAR }","%3"
    tracing::debug!(foo = true, { CONST_VAR } = %3, qux = 3); // DEBUG:debug,-,-,pf,-,"{ CONST_VAR }","%3"
    tracing::debug!({ CONST_VAR } = %3, "msg without args"); // DEBUG:debug,-,-,-,m,"{ CONST_VAR }","%3"
    tracing::debug!(foo = true, { CONST_VAR } = %3, "msg without args"); // DEBUG:debug,-,-,p,m,"{ CONST_VAR }","%3"
    tracing::debug!({ CONST_VAR } = %3, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"{ CONST_VAR }","%3"
    tracing::debug!(foo = true, { CONST_VAR } = %3, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"{ CONST_VAR }","%3"
    tracing::debug!({ { CONST_VAR } = %3 }, "msg without args"); // DEBUG:debug,-,{},-,m,"{ CONST_VAR }","%3"
    tracing::debug!({ foo = true, { CONST_VAR } = %3 }, "msg without args"); // DEBUG:debug,-,{},p,m,"{ CONST_VAR }","%3"
    tracing::debug!({ { CONST_VAR } = %3, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"{ CONST_VAR }","%3"
    tracing::debug!({ foo = true, { CONST_VAR } = %3, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"{ CONST_VAR }","%3"
    tracing::debug!({ CONST_VAR } = %3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"{ CONST_VAR }","%3"
    tracing::debug!(foo = true, { CONST_VAR } = %3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"{ CONST_VAR }","%3"
    tracing::debug!({ CONST_VAR } = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"{ CONST_VAR }","%3"
    tracing::debug!(foo = true, { CONST_VAR } = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"{ CONST_VAR }","%3"
    tracing::debug!({ { CONST_VAR } = %3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"{ CONST_VAR }","%3"
    tracing::debug!({ foo = true, { CONST_VAR } = %3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"{ CONST_VAR }","%3"
    tracing::debug!({ { CONST_VAR } = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"{ CONST_VAR }","%3"
    tracing::debug!({ foo = true, { CONST_VAR } = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"{ CONST_VAR }","%3"
    tracing::debug!({ CONST_VAR } = ?deb); // DEBUG:debug,-,-,-,-,"{ CONST_VAR }","?deb"
    tracing::debug!(foo = true, { CONST_VAR } = ?deb); // DEBUG:debug,-,-,p,-,"{ CONST_VAR }","?deb"
    tracing::debug!({ CONST_VAR } = ?deb, qux = 3); // DEBUG:debug,-,-,f,-,"{ CONST_VAR }","?deb"
    tracing::debug!(foo = true, { CONST_VAR } = ?deb, qux = 3); // DEBUG:debug,-,-,pf,-,"{ CONST_VAR }","?deb"
    tracing::debug!({ CONST_VAR } = ?deb, "msg without args"); // DEBUG:debug,-,-,-,m,"{ CONST_VAR }","?deb"
    tracing::debug!(foo = true, { CONST_VAR } = ?deb, "msg without args"); // DEBUG:debug,-,-,p,m,"{ CONST_VAR }","?deb"
    tracing::debug!({ CONST_VAR } = ?deb, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"{ CONST_VAR }","?deb"
    tracing::debug!(foo = true, { CONST_VAR } = ?deb, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"{ CONST_VAR }","?deb"
    tracing::debug!({ { CONST_VAR } = ?deb }, "msg without args"); // DEBUG:debug,-,{},-,m,"{ CONST_VAR }","?deb"
    tracing::debug!({ foo = true, { CONST_VAR } = ?deb }, "msg without args"); // DEBUG:debug,-,{},p,m,"{ CONST_VAR }","?deb"
    tracing::debug!({ { CONST_VAR } = ?deb, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"{ CONST_VAR }","?deb"
    tracing::debug!({ foo = true, { CONST_VAR } = ?deb, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"{ CONST_VAR }","?deb"
    tracing::debug!({ CONST_VAR } = ?deb, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"{ CONST_VAR }","?deb"
    tracing::debug!(foo = true, { CONST_VAR } = ?deb, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"{ CONST_VAR }","?deb"
    tracing::debug!({ CONST_VAR } = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"{ CONST_VAR }","?deb"
    tracing::debug!(foo = true, { CONST_VAR } = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"{ CONST_VAR }","?deb"
    tracing::debug!({ { CONST_VAR } = ?deb }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"{ CONST_VAR }","?deb"
    tracing::debug!({ foo = true, { CONST_VAR } = ?deb }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"{ CONST_VAR }","?deb"
    tracing::debug!({ { CONST_VAR } = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"{ CONST_VAR }","?deb"
    tracing::debug!({ foo = true, { CONST_VAR } = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"{ CONST_VAR }","?deb"
    tracing::debug!({ CONST_VAR } = %disp); // DEBUG:debug,-,-,-,-,"{ CONST_VAR }","%disp"
    tracing::debug!(foo = true, { CONST_VAR } = %disp); // DEBUG:debug,-,-,p,-,"{ CONST_VAR }","%disp"
    tracing::debug!({ CONST_VAR } = %disp, qux = 3); // DEBUG:debug,-,-,f,-,"{ CONST_VAR }","%disp"
    tracing::debug!(foo = true, { CONST_VAR } = %disp, qux = 3); // DEBUG:debug,-,-,pf,-,"{ CONST_VAR }","%disp"
    tracing::debug!({ CONST_VAR } = %disp, "msg without args"); // DEBUG:debug,-,-,-,m,"{ CONST_VAR }","%disp"
    tracing::debug!(foo = true, { CONST_VAR } = %disp, "msg without args"); // DEBUG:debug,-,-,p,m,"{ CONST_VAR }","%disp"
    tracing::debug!({ CONST_VAR } = %disp, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"{ CONST_VAR }","%disp"
    tracing::debug!(foo = true, { CONST_VAR } = %disp, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"{ CONST_VAR }","%disp"
    tracing::debug!({ { CONST_VAR } = %disp }, "msg without args"); // DEBUG:debug,-,{},-,m,"{ CONST_VAR }","%disp"
    tracing::debug!({ foo = true, { CONST_VAR } = %disp }, "msg without args"); // DEBUG:debug,-,{},p,m,"{ CONST_VAR }","%disp"
    tracing::debug!({ { CONST_VAR } = %disp, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"{ CONST_VAR }","%disp"
    tracing::debug!({ foo = true, { CONST_VAR } = %disp, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"{ CONST_VAR }","%disp"
    tracing::debug!({ CONST_VAR } = %disp, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"{ CONST_VAR }","%disp"
    tracing::debug!(foo = true, { CONST_VAR } = %disp, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"{ CONST_VAR }","%disp"
    tracing::debug!({ CONST_VAR } = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"{ CONST_VAR }","%disp"
    tracing::debug!(foo = true, { CONST_VAR } = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"{ CONST_VAR }","%disp"
    tracing::debug!({ { CONST_VAR } = %disp }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"{ CONST_VAR }","%disp"
    tracing::debug!({ foo = true, { CONST_VAR } = %disp }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"{ CONST_VAR }","%disp"
    tracing::debug!({ { CONST_VAR } = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"{ CONST_VAR }","%disp"
    tracing::debug!({ foo = true, { CONST_VAR } = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"{ CONST_VAR }","%disp"
    tracing::debug!({ CONST_VAR } = ?sub.field); // DEBUG:debug,-,-,-,-,"{ CONST_VAR }","?sub.field"
    tracing::debug!(foo = true, { CONST_VAR } = ?sub.field); // DEBUG:debug,-,-,p,-,"{ CONST_VAR }","?sub.field"
    tracing::debug!({ CONST_VAR } = ?sub.field, qux = 3); // DEBUG:debug,-,-,f,-,"{ CONST_VAR }","?sub.field"
    tracing::debug!(foo = true, { CONST_VAR } = ?sub.field, qux = 3); // DEBUG:debug,-,-,pf,-,"{ CONST_VAR }","?sub.field"
    tracing::debug!({ CONST_VAR } = ?sub.field, "msg without args"); // DEBUG:debug,-,-,-,m,"{ CONST_VAR }","?sub.field"
    tracing::debug!(foo = true, { CONST_VAR } = ?sub.field, "msg without args"); // DEBUG:debug,-,-,p,m,"{ CONST_VAR }","?sub.field"
    tracing::debug!({ CONST_VAR } = ?sub.field, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"{ CONST_VAR }","?sub.field"
    tracing::debug!(foo = true, { CONST_VAR } = ?sub.field, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"{ CONST_VAR }","?sub.field"
    tracing::debug!({ { CONST_VAR } = ?sub.field }, "msg without args"); // DEBUG:debug,-,{},-,m,"{ CONST_VAR }","?sub.field"
    tracing::debug!({ foo = true, { CONST_VAR } = ?sub.field }, "msg without args"); // DEBUG:debug,-,{},p,m,"{ CONST_VAR }","?sub.field"
    tracing::debug!({ { CONST_VAR } = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"{ CONST_VAR }","?sub.field"
    tracing::debug!({ foo = true, { CONST_VAR } = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"{ CONST_VAR }","?sub.field"
    tracing::debug!({ CONST_VAR } = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"{ CONST_VAR }","?sub.field"
    tracing::debug!(foo = true, { CONST_VAR } = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"{ CONST_VAR }","?sub.field"
    tracing::debug!({ CONST_VAR } = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"{ CONST_VAR }","?sub.field"
    tracing::debug!(foo = true, { CONST_VAR } = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"{ CONST_VAR }","?sub.field"
    tracing::debug!({ { CONST_VAR } = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"{ CONST_VAR }","?sub.field"
    tracing::debug!({ foo = true, { CONST_VAR } = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"{ CONST_VAR }","?sub.field"
    tracing::debug!({ { CONST_VAR } = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"{ CONST_VAR }","?sub.field"
    tracing::debug!({ foo = true, { CONST_VAR } = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"{ CONST_VAR }","?sub.field"
    tracing::debug!({ CONST_VAR } = %sub.field); // DEBUG:debug,-,-,-,-,"{ CONST_VAR }","%sub.field"
    tracing::debug!(foo = true, { CONST_VAR } = %sub.field); // DEBUG:debug,-,-,p,-,"{ CONST_VAR }","%sub.field"
    tracing::debug!({ CONST_VAR } = %sub.field, qux = 3); // DEBUG:debug,-,-,f,-,"{ CONST_VAR }","%sub.field"
    tracing::debug!(foo = true, { CONST_VAR } = %sub.field, qux = 3); // DEBUG:debug,-,-,pf,-,"{ CONST_VAR }","%sub.field"
    tracing::debug!({ CONST_VAR } = %sub.field, "msg without args"); // DEBUG:debug,-,-,-,m,"{ CONST_VAR }","%sub.field"
    tracing::debug!(foo = true, { CONST_VAR } = %sub.field, "msg without args"); // DEBUG:debug,-,-,p,m,"{ CONST_VAR }","%sub.field"
    tracing::debug!({ CONST_VAR } = %sub.field, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"{ CONST_VAR }","%sub.field"
    tracing::debug!(foo = true, { CONST_VAR } = %sub.field, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"{ CONST_VAR }","%sub.field"
    tracing::debug!({ { CONST_VAR } = %sub.field }, "msg without args"); // DEBUG:debug,-,{},-,m,"{ CONST_VAR }","%sub.field"
    tracing::debug!({ foo = true, { CONST_VAR } = %sub.field }, "msg without args"); // DEBUG:debug,-,{},p,m,"{ CONST_VAR }","%sub.field"
    tracing::debug!({ { CONST_VAR } = %sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"{ CONST_VAR }","%sub.field"
    tracing::debug!({ foo = true, { CONST_VAR } = %sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"{ CONST_VAR }","%sub.field"
    tracing::debug!({ CONST_VAR } = %sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"{ CONST_VAR }","%sub.field"
    tracing::debug!(foo = true, { CONST_VAR } = %sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"{ CONST_VAR }","%sub.field"
    tracing::debug!({ CONST_VAR } = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"{ CONST_VAR }","%sub.field"
    tracing::debug!(foo = true, { CONST_VAR } = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"{ CONST_VAR }","%sub.field"
    tracing::debug!({ { CONST_VAR } = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"{ CONST_VAR }","%sub.field"
    tracing::debug!({ foo = true, { CONST_VAR } = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"{ CONST_VAR }","%sub.field"
    tracing::debug!({ { CONST_VAR } = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"{ CONST_VAR }","%sub.field"
    tracing::debug!({ foo = true, { CONST_VAR } = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"{ CONST_VAR }","%sub.field"
    tracing::debug!({ CONST_VAR } = debug(&deb)); // DEBUG:debug,-,-,-,-,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!(foo = true, { CONST_VAR } = debug(&deb)); // DEBUG:debug,-,-,p,-,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!({ CONST_VAR } = debug(&deb), qux = 3); // DEBUG:debug,-,-,f,-,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!(foo = true, { CONST_VAR } = debug(&deb), qux = 3); // DEBUG:debug,-,-,pf,-,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!({ CONST_VAR } = debug(&deb), "msg without args"); // DEBUG:debug,-,-,-,m,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!(foo = true, { CONST_VAR } = debug(&deb), "msg without args"); // DEBUG:debug,-,-,p,m,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!({ CONST_VAR } = debug(&deb), qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!(foo = true, { CONST_VAR } = debug(&deb), qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!({ { CONST_VAR } = debug(&deb) }, "msg without args"); // DEBUG:debug,-,{},-,m,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!({ foo = true, { CONST_VAR } = debug(&deb) }, "msg without args"); // DEBUG:debug,-,{},p,m,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!({ { CONST_VAR } = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!({ foo = true, { CONST_VAR } = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!({ CONST_VAR } = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!(foo = true, { CONST_VAR } = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!({ CONST_VAR } = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!(foo = true, { CONST_VAR } = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!({ { CONST_VAR } = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!({ foo = true, { CONST_VAR } = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!({ { CONST_VAR } = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!({ foo = true, { CONST_VAR } = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!({ CONST_VAR } = display(&disp)); // DEBUG:debug,-,-,-,-,"{ CONST_VAR }","display(&disp)"
    tracing::debug!(foo = true, { CONST_VAR } = display(&disp)); // DEBUG:debug,-,-,p,-,"{ CONST_VAR }","display(&disp)"
    tracing::debug!({ CONST_VAR } = display(&disp), qux = 3); // DEBUG:debug,-,-,f,-,"{ CONST_VAR }","display(&disp)"
    tracing::debug!(foo = true, { CONST_VAR } = display(&disp), qux = 3); // DEBUG:debug,-,-,pf,-,"{ CONST_VAR }","display(&disp)"
    tracing::debug!({ CONST_VAR } = display(&disp), "msg without args"); // DEBUG:debug,-,-,-,m,"{ CONST_VAR }","display(&disp)"
    tracing::debug!(foo = true, { CONST_VAR } = display(&disp), "msg without args"); // DEBUG:debug,-,-,p,m,"{ CONST_VAR }","display(&disp)"
    tracing::debug!({ CONST_VAR } = display(&disp), qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"{ CONST_VAR }","display(&disp)"
    tracing::debug!(foo = true, { CONST_VAR } = display(&disp), qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"{ CONST_VAR }","display(&disp)"
    tracing::debug!({ { CONST_VAR } = display(&disp) }, "msg without args"); // DEBUG:debug,-,{},-,m,"{ CONST_VAR }","display(&disp)"
    tracing::debug!({ foo = true, { CONST_VAR } = display(&disp) }, "msg without args"); // DEBUG:debug,-,{},p,m,"{ CONST_VAR }","display(&disp)"
    tracing::debug!({ { CONST_VAR } = display(&disp), qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"{ CONST_VAR }","display(&disp)"
    tracing::debug!({ foo = true, { CONST_VAR } = display(&disp), qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"{ CONST_VAR }","display(&disp)"
    tracing::debug!({ CONST_VAR } = display(&disp), "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"{ CONST_VAR }","display(&disp)"
    tracing::debug!(foo = true, { CONST_VAR } = display(&disp), "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"{ CONST_VAR }","display(&disp)"
    tracing::debug!({ CONST_VAR } = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"{ CONST_VAR }","display(&disp)"
    tracing::debug!(foo = true, { CONST_VAR } = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"{ CONST_VAR }","display(&disp)"
    tracing::debug!({ { CONST_VAR } = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"{ CONST_VAR }","display(&disp)"
    tracing::debug!({ foo = true, { CONST_VAR } = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"{ CONST_VAR }","display(&disp)"
    tracing::debug!({ { CONST_VAR } = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"{ CONST_VAR }","display(&disp)"
    tracing::debug!({ foo = true, { CONST_VAR } = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"{ CONST_VAR }","display(&disp)"
    tracing::debug!({ CONST_VAR } = tracing::field::Empty); // DEBUG:debug,-,-,-,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!(foo = true, { CONST_VAR } = tracing::field::Empty); // DEBUG:debug,-,-,p,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!({ CONST_VAR } = tracing::field::Empty, qux = 3); // DEBUG:debug,-,-,f,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!(foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3); // DEBUG:debug,-,-,pf,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!({ CONST_VAR } = tracing::field::Empty, "msg without args"); // DEBUG:debug,-,-,-,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!(foo = true, { CONST_VAR } = tracing::field::Empty, "msg without args"); // DEBUG:debug,-,-,p,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!({ CONST_VAR } = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!(foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!({ { CONST_VAR } = tracing::field::Empty }, "msg without args"); // DEBUG:debug,-,{},-,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!({ foo = true, { CONST_VAR } = tracing::field::Empty }, "msg without args"); // DEBUG:debug,-,{},p,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!({ { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!({ foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!({ CONST_VAR } = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!(foo = true, { CONST_VAR } = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!({ CONST_VAR } = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!(foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!({ { CONST_VAR } = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!({ foo = true, { CONST_VAR } = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!({ { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!({ foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!(r#type = 3); // DEBUG:debug,-,-,-,-,"r#type","3"
    tracing::debug!(foo = true, r#type = 3); // DEBUG:debug,-,-,p,-,"r#type","3"
    tracing::debug!(r#type = 3, qux = 3); // DEBUG:debug,-,-,f,-,"r#type","3"
    tracing::debug!(foo = true, r#type = 3, qux = 3); // DEBUG:debug,-,-,pf,-,"r#type","3"
    tracing::debug!(r#type = 3, "msg without args"); // DEBUG:debug,-,-,-,m,"r#type","3"
    tracing::debug!(foo = true, r#type = 3, "msg without args"); // DEBUG:debug,-,-,p,m,"r#type","3"
    tracing::debug!(r#type = 3, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"r#type","3"
    tracing::debug!(foo = true, r#type = 3, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"r#type","3"
    tracing::debug!({ r#type = 3 }, "msg without args"); // DEBUG:debug,-,{},-,m,"r#type","3"
    tracing::debug!({ foo = true, r#type = 3 }, "msg without args"); // DEBUG:debug,-,{},p,m,"r#type","3"
    tracing::debug!({ r#type = 3, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"r#type","3"
    tracing::debug!({ foo = true, r#type = 3, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"r#type","3"
    tracing::debug!(r#type = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"r#type","3"
    tracing::debug!(foo = true, r#type = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"r#type","3"
    tracing::debug!(r#type = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"r#type","3"
    tracing::debug!(foo = true, r#type = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"r#type","3"
    tracing::debug!({ r#type = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"r#type","3"
    tracing::debug!({ foo = true, r#type = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"r#type","3"
    tracing::debug!({ r#type = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"r#type","3"
    tracing::debug!({ foo = true, r#type = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"r#type","3"
    tracing::debug!(r#type = false); // DEBUG:debug,-,-,-,-,"r#type","false"
    tracing::debug!(foo = true, r#type = false); // DEBUG:debug,-,-,p,-,"r#type","false"
    tracing::debug!(r#type = false, qux = 3); // DEBUG:debug,-,-,f,-,"r#type","false"
    tracing::debug!(foo = true, r#type = false, qux = 3); // DEBUG:debug,-,-,pf,-,"r#type","false"
    tracing::debug!(r#type = false, "msg without args"); // DEBUG:debug,-,-,-,m,"r#type","false"
    tracing::debug!(foo = true, r#type = false, "msg without args"); // DEBUG:debug,-,-,p,m,"r#type","false"
    tracing::debug!(r#type = false, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"r#type","false"
    tracing::debug!(foo = true, r#type = false, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"r#type","false"
    tracing::debug!({ r#type = false }, "msg without args"); // DEBUG:debug,-,{},-,m,"r#type","false"
    tracing::debug!({ foo = true, r#type = false }, "msg without args"); // DEBUG:debug,-,{},p,m,"r#type","false"
    tracing::debug!({ r#type = false, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"r#type","false"
    tracing::debug!({ foo = true, r#type = false, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"r#type","false"
    tracing::debug!(r#type = false, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"r#type","false"
    tracing::debug!(foo = true, r#type = false, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"r#type","false"
    tracing::debug!(r#type = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"r#type","false"
    tracing::debug!(foo = true, r#type = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"r#type","false"
    tracing::debug!({ r#type = false }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"r#type","false"
    tracing::debug!({ foo = true, r#type = false }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"r#type","false"
    tracing::debug!({ r#type = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"r#type","false"
    tracing::debug!({ foo = true, r#type = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"r#type","false"
    tracing::debug!(r#type = ?3); // DEBUG:debug,-,-,-,-,"r#type","?3"
    tracing::debug!(foo = true, r#type = ?3); // DEBUG:debug,-,-,p,-,"r#type","?3"
    tracing::debug!(r#type = ?3, qux = 3); // DEBUG:debug,-,-,f,-,"r#type","?3"
    tracing::debug!(foo = true, r#type = ?3, qux = 3); // DEBUG:debug,-,-,pf,-,"r#type","?3"
    tracing::debug!(r#type = ?3, "msg without args"); // DEBUG:debug,-,-,-,m,"r#type","?3"
    tracing::debug!(foo = true, r#type = ?3, "msg without args"); // DEBUG:debug,-,-,p,m,"r#type","?3"
    tracing::debug!(r#type = ?3, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"r#type","?3"
    tracing::debug!(foo = true, r#type = ?3, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"r#type","?3"
    tracing::debug!({ r#type = ?3 }, "msg without args"); // DEBUG:debug,-,{},-,m,"r#type","?3"
    tracing::debug!({ foo = true, r#type = ?3 }, "msg without args"); // DEBUG:debug,-,{},p,m,"r#type","?3"
    tracing::debug!({ r#type = ?3, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"r#type","?3"
    tracing::debug!({ foo = true, r#type = ?3, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"r#type","?3"
    tracing::debug!(r#type = ?3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"r#type","?3"
    tracing::debug!(foo = true, r#type = ?3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"r#type","?3"
    tracing::debug!(r#type = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"r#type","?3"
    tracing::debug!(foo = true, r#type = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"r#type","?3"
    tracing::debug!({ r#type = ?3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"r#type","?3"
    tracing::debug!({ foo = true, r#type = ?3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"r#type","?3"
    tracing::debug!({ r#type = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"r#type","?3"
    tracing::debug!({ foo = true, r#type = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"r#type","?3"
    tracing::debug!(r#type = %3); // DEBUG:debug,-,-,-,-,"r#type","%3"
    tracing::debug!(foo = true, r#type = %3); // DEBUG:debug,-,-,p,-,"r#type","%3"
    tracing::debug!(r#type = %3, qux = 3); // DEBUG:debug,-,-,f,-,"r#type","%3"
    tracing::debug!(foo = true, r#type = %3, qux = 3); // DEBUG:debug,-,-,pf,-,"r#type","%3"
    tracing::debug!(r#type = %3, "msg without args"); // DEBUG:debug,-,-,-,m,"r#type","%3"
    tracing::debug!(foo = true, r#type = %3, "msg without args"); // DEBUG:debug,-,-,p,m,"r#type","%3"
    tracing::debug!(r#type = %3, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"r#type","%3"
    tracing::debug!(foo = true, r#type = %3, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"r#type","%3"
    tracing::debug!({ r#type = %3 }, "msg without args"); // DEBUG:debug,-,{},-,m,"r#type","%3"
    tracing::debug!({ foo = true, r#type = %3 }, "msg without args"); // DEBUG:debug,-,{},p,m,"r#type","%3"
    tracing::debug!({ r#type = %3, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"r#type","%3"
    tracing::debug!({ foo = true, r#type = %3, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"r#type","%3"
    tracing::debug!(r#type = %3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"r#type","%3"
    tracing::debug!(foo = true, r#type = %3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"r#type","%3"
    tracing::debug!(r#type = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"r#type","%3"
    tracing::debug!(foo = true, r#type = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"r#type","%3"
    tracing::debug!({ r#type = %3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"r#type","%3"
    tracing::debug!({ foo = true, r#type = %3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"r#type","%3"
    tracing::debug!({ r#type = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"r#type","%3"
    tracing::debug!({ foo = true, r#type = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"r#type","%3"
    tracing::debug!(r#type = ?deb); // DEBUG:debug,-,-,-,-,"r#type","?deb"
    tracing::debug!(foo = true, r#type = ?deb); // DEBUG:debug,-,-,p,-,"r#type","?deb"
    tracing::debug!(r#type = ?deb, qux = 3); // DEBUG:debug,-,-,f,-,"r#type","?deb"
    tracing::debug!(foo = true, r#type = ?deb, qux = 3); // DEBUG:debug,-,-,pf,-,"r#type","?deb"
    tracing::debug!(r#type = ?deb, "msg without args"); // DEBUG:debug,-,-,-,m,"r#type","?deb"
    tracing::debug!(foo = true, r#type = ?deb, "msg without args"); // DEBUG:debug,-,-,p,m,"r#type","?deb"
    tracing::debug!(r#type = ?deb, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"r#type","?deb"
    tracing::debug!(foo = true, r#type = ?deb, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"r#type","?deb"
    tracing::debug!({ r#type = ?deb }, "msg without args"); // DEBUG:debug,-,{},-,m,"r#type","?deb"
    tracing::debug!({ foo = true, r#type = ?deb }, "msg without args"); // DEBUG:debug,-,{},p,m,"r#type","?deb"
    tracing::debug!({ r#type = ?deb, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"r#type","?deb"
    tracing::debug!({ foo = true, r#type = ?deb, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"r#type","?deb"
    tracing::debug!(r#type = ?deb, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"r#type","?deb"
    tracing::debug!(foo = true, r#type = ?deb, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"r#type","?deb"
    tracing::debug!(r#type = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"r#type","?deb"
    tracing::debug!(foo = true, r#type = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"r#type","?deb"
    tracing::debug!({ r#type = ?deb }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"r#type","?deb"
    tracing::debug!({ foo = true, r#type = ?deb }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"r#type","?deb"
    tracing::debug!({ r#type = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"r#type","?deb"
    tracing::debug!({ foo = true, r#type = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"r#type","?deb"
    tracing::debug!(r#type = %disp); // DEBUG:debug,-,-,-,-,"r#type","%disp"
    tracing::debug!(foo = true, r#type = %disp); // DEBUG:debug,-,-,p,-,"r#type","%disp"
    tracing::debug!(r#type = %disp, qux = 3); // DEBUG:debug,-,-,f,-,"r#type","%disp"
    tracing::debug!(foo = true, r#type = %disp, qux = 3); // DEBUG:debug,-,-,pf,-,"r#type","%disp"
    tracing::debug!(r#type = %disp, "msg without args"); // DEBUG:debug,-,-,-,m,"r#type","%disp"
    tracing::debug!(foo = true, r#type = %disp, "msg without args"); // DEBUG:debug,-,-,p,m,"r#type","%disp"
    tracing::debug!(r#type = %disp, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"r#type","%disp"
    tracing::debug!(foo = true, r#type = %disp, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"r#type","%disp"
    tracing::debug!({ r#type = %disp }, "msg without args"); // DEBUG:debug,-,{},-,m,"r#type","%disp"
    tracing::debug!({ foo = true, r#type = %disp }, "msg without args"); // DEBUG:debug,-,{},p,m,"r#type","%disp"
    tracing::debug!({ r#type = %disp, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"r#type","%disp"
    tracing::debug!({ foo = true, r#type = %disp, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"r#type","%disp"
    tracing::debug!(r#type = %disp, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"r#type","%disp"
    tracing::debug!(foo = true, r#type = %disp, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"r#type","%disp"
    tracing::debug!(r#type = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"r#type","%disp"
    tracing::debug!(foo = true, r#type = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"r#type","%disp"
    tracing::debug!({ r#type = %disp }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"r#type","%disp"
    tracing::debug!({ foo = true, r#type = %disp }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"r#type","%disp"
    tracing::debug!({ r#type = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"r#type","%disp"
    tracing::debug!({ foo = true, r#type = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"r#type","%disp"
    tracing::debug!(r#type = ?sub.field); // DEBUG:debug,-,-,-,-,"r#type","?sub.field"
    tracing::debug!(foo = true, r#type = ?sub.field); // DEBUG:debug,-,-,p,-,"r#type","?sub.field"
    tracing::debug!(r#type = ?sub.field, qux = 3); // DEBUG:debug,-,-,f,-,"r#type","?sub.field"
    tracing::debug!(foo = true, r#type = ?sub.field, qux = 3); // DEBUG:debug,-,-,pf,-,"r#type","?sub.field"
    tracing::debug!(r#type = ?sub.field, "msg without args"); // DEBUG:debug,-,-,-,m,"r#type","?sub.field"
    tracing::debug!(foo = true, r#type = ?sub.field, "msg without args"); // DEBUG:debug,-,-,p,m,"r#type","?sub.field"
    tracing::debug!(r#type = ?sub.field, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"r#type","?sub.field"
    tracing::debug!(foo = true, r#type = ?sub.field, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"r#type","?sub.field"
    tracing::debug!({ r#type = ?sub.field }, "msg without args"); // DEBUG:debug,-,{},-,m,"r#type","?sub.field"
    tracing::debug!({ foo = true, r#type = ?sub.field }, "msg without args"); // DEBUG:debug,-,{},p,m,"r#type","?sub.field"
    tracing::debug!({ r#type = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"r#type","?sub.field"
    tracing::debug!({ foo = true, r#type = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"r#type","?sub.field"
    tracing::debug!(r#type = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"r#type","?sub.field"
    tracing::debug!(foo = true, r#type = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"r#type","?sub.field"
    tracing::debug!(r#type = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"r#type","?sub.field"
    tracing::debug!(foo = true, r#type = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"r#type","?sub.field"
    tracing::debug!({ r#type = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"r#type","?sub.field"
    tracing::debug!({ foo = true, r#type = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"r#type","?sub.field"
    tracing::debug!({ r#type = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"r#type","?sub.field"
    tracing::debug!({ foo = true, r#type = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"r#type","?sub.field"
    tracing::debug!(r#type = %sub.field); // DEBUG:debug,-,-,-,-,"r#type","%sub.field"
    tracing::debug!(foo = true, r#type = %sub.field); // DEBUG:debug,-,-,p,-,"r#type","%sub.field"
    tracing::debug!(r#type = %sub.field, qux = 3); // DEBUG:debug,-,-,f,-,"r#type","%sub.field"
    tracing::debug!(foo = true, r#type = %sub.field, qux = 3); // DEBUG:debug,-,-,pf,-,"r#type","%sub.field"
    tracing::debug!(r#type = %sub.field, "msg without args"); // DEBUG:debug,-,-,-,m,"r#type","%sub.field"
    tracing::debug!(foo = true, r#type = %sub.field, "msg without args"); // DEBUG:debug,-,-,p,m,"r#type","%sub.field"
    tracing::debug!(r#type = %sub.field, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"r#type","%sub.field"
    tracing::debug!(foo = true, r#type = %sub.field, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"r#type","%sub.field"
    tracing::debug!({ r#type = %sub.field }, "msg without args"); // DEBUG:debug,-,{},-,m,"r#type","%sub.field"
    tracing::debug!({ foo = true, r#type = %sub.field }, "msg without args"); // DEBUG:debug,-,{},p,m,"r#type","%sub.field"
    tracing::debug!({ r#type = %sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"r#type","%sub.field"
    tracing::debug!({ foo = true, r#type = %sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"r#type","%sub.field"
    tracing::debug!(r#type = %sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"r#type","%sub.field"
    tracing::debug!(foo = true, r#type = %sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"r#type","%sub.field"
    tracing::debug!(r#type = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"r#type","%sub.field"
    tracing::debug!(foo = true, r#type = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"r#type","%sub.field"
    tracing::debug!({ r#type = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"r#type","%sub.field"
    tracing::debug!({ foo = true, r#type = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"r#type","%sub.field"
    tracing::debug!({ r#type = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"r#type","%sub.field"
    tracing::debug!({ foo = true, r#type = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"r#type","%sub.field"
    tracing::debug!(r#type = debug(&deb)); // DEBUG:debug,-,-,-,-,"r#type","debug(&deb)"
    tracing::debug!(foo = true, r#type = debug(&deb)); // DEBUG:debug,-,-,p,-,"r#type","debug(&deb)"
    tracing::debug!(r#type = debug(&deb), qux = 3); // DEBUG:debug,-,-,f,-,"r#type","debug(&deb)"
    tracing::debug!(foo = true, r#type = debug(&deb), qux = 3); // DEBUG:debug,-,-,pf,-,"r#type","debug(&deb)"
    tracing::debug!(r#type = debug(&deb), "msg without args"); // DEBUG:debug,-,-,-,m,"r#type","debug(&deb)"
    tracing::debug!(foo = true, r#type = debug(&deb), "msg without args"); // DEBUG:debug,-,-,p,m,"r#type","debug(&deb)"
    tracing::debug!(r#type = debug(&deb), qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"r#type","debug(&deb)"
    tracing::debug!(foo = true, r#type = debug(&deb), qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"r#type","debug(&deb)"
    tracing::debug!({ r#type = debug(&deb) }, "msg without args"); // DEBUG:debug,-,{},-,m,"r#type","debug(&deb)"
    tracing::debug!({ foo = true, r#type = debug(&deb) }, "msg without args"); // DEBUG:debug,-,{},p,m,"r#type","debug(&deb)"
    tracing::debug!({ r#type = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"r#type","debug(&deb)"
    tracing::debug!({ foo = true, r#type = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"r#type","debug(&deb)"
    tracing::debug!(r#type = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"r#type","debug(&deb)"
    tracing::debug!(foo = true, r#type = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"r#type","debug(&deb)"
    tracing::debug!(r#type = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"r#type","debug(&deb)"
    tracing::debug!(foo = true, r#type = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"r#type","debug(&deb)"
    tracing::debug!({ r#type = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"r#type","debug(&deb)"
    tracing::debug!({ foo = true, r#type = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"r#type","debug(&deb)"
    tracing::debug!({ r#type = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"r#type","debug(&deb)"
    tracing::debug!({ foo = true, r#type = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"r#type","debug(&deb)"
    tracing::debug!(r#type = display(&disp)); // DEBUG:debug,-,-,-,-,"r#type","display(&disp)"
    tracing::debug!(foo = true, r#type = display(&disp)); // DEBUG:debug,-,-,p,-,"r#type","display(&disp)"
    tracing::debug!(r#type = display(&disp), qux = 3); // DEBUG:debug,-,-,f,-,"r#type","display(&disp)"
    tracing::debug!(foo = true, r#type = display(&disp), qux = 3); // DEBUG:debug,-,-,pf,-,"r#type","display(&disp)"
    tracing::debug!(r#type = display(&disp), "msg without args"); // DEBUG:debug,-,-,-,m,"r#type","display(&disp)"
    tracing::debug!(foo = true, r#type = display(&disp), "msg without args"); // DEBUG:debug,-,-,p,m,"r#type","display(&disp)"
    tracing::debug!(r#type = display(&disp), qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"r#type","display(&disp)"
    tracing::debug!(foo = true, r#type = display(&disp), qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"r#type","display(&disp)"
    tracing::debug!({ r#type = display(&disp) }, "msg without args"); // DEBUG:debug,-,{},-,m,"r#type","display(&disp)"
    tracing::debug!({ foo = true, r#type = display(&disp) }, "msg without args"); // DEBUG:debug,-,{},p,m,"r#type","display(&disp)"
    tracing::debug!({ r#type = display(&disp), qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"r#type","display(&disp)"
    tracing::debug!({ foo = true, r#type = display(&disp), qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"r#type","display(&disp)"
    tracing::debug!(r#type = display(&disp), "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"r#type","display(&disp)"
    tracing::debug!(foo = true, r#type = display(&disp), "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"r#type","display(&disp)"
    tracing::debug!(r#type = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"r#type","display(&disp)"
    tracing::debug!(foo = true, r#type = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"r#type","display(&disp)"
    tracing::debug!({ r#type = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"r#type","display(&disp)"
    tracing::debug!({ foo = true, r#type = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"r#type","display(&disp)"
    tracing::debug!({ r#type = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"r#type","display(&disp)"
    tracing::debug!({ foo = true, r#type = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"r#type","display(&disp)"
    tracing::debug!(r#type = tracing::field::Empty); // DEBUG:debug,-,-,-,-,"r#type","tracing::field::Empty"
    tracing::debug!(foo = true, r#type = tracing::field::Empty); // DEBUG:debug,-,-,p,-,"r#type","tracing::field::Empty"
    tracing::debug!(r#type = tracing::field::Empty, qux = 3); // DEBUG:debug,-,-,f,-,"r#type","tracing::field::Empty"
    tracing::debug!(foo = true, r#type = tracing::field::Empty, qux = 3); // DEBUG:debug,-,-,pf,-,"r#type","tracing::field::Empty"
    tracing::debug!(r#type = tracing::field::Empty, "msg without args"); // DEBUG:debug,-,-,-,m,"r#type","tracing::field::Empty"
    tracing::debug!(foo = true, r#type = tracing::field::Empty, "msg without args"); // DEBUG:debug,-,-,p,m,"r#type","tracing::field::Empty"
    tracing::debug!(r#type = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,"r#type","tracing::field::Empty"
    tracing::debug!(foo = true, r#type = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,"r#type","tracing::field::Empty"
    tracing::debug!({ r#type = tracing::field::Empty }, "msg without args"); // DEBUG:debug,-,{},-,m,"r#type","tracing::field::Empty"
    tracing::debug!({ foo = true, r#type = tracing::field::Empty }, "msg without args"); // DEBUG:debug,-,{},p,m,"r#type","tracing::field::Empty"
    tracing::debug!({ r#type = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,"r#type","tracing::field::Empty"
    tracing::debug!({ foo = true, r#type = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,"r#type","tracing::field::Empty"
    tracing::debug!(r#type = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,"r#type","tracing::field::Empty"
    tracing::debug!(foo = true, r#type = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,"r#type","tracing::field::Empty"
    tracing::debug!(r#type = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,"r#type","tracing::field::Empty"
    tracing::debug!(foo = true, r#type = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,"r#type","tracing::field::Empty"
    tracing::debug!({ r#type = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,"r#type","tracing::field::Empty"
    tracing::debug!({ foo = true, r#type = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,"r#type","tracing::field::Empty"
    tracing::debug!({ r#type = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,"r#type","tracing::field::Empty"
    tracing::debug!({ foo = true, r#type = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,"r#type","tracing::field::Empty"
    tracing::debug!(var); // DEBUG:debug,-,-,-,-,-,"var"
    tracing::debug!(foo = true, var); // DEBUG:debug,-,-,p,-,-,"var"
    tracing::debug!(var, qux = 3); // DEBUG:debug,-,-,f,-,-,"var"
    tracing::debug!(foo = true, var, qux = 3); // DEBUG:debug,-,-,pf,-,-,"var"
    tracing::debug!(var, "msg without args"); // DEBUG:debug,-,-,-,m,-,"var"
    tracing::debug!(foo = true, var, "msg without args"); // DEBUG:debug,-,-,p,m,-,"var"
    tracing::debug!(var, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,-,"var"
    tracing::debug!(foo = true, var, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,-,"var"
    tracing::debug!({ var }, "msg without args"); // DEBUG:debug,-,{},-,m,-,"var"
    tracing::debug!({ foo = true, var }, "msg without args"); // DEBUG:debug,-,{},p,m,-,"var"
    tracing::debug!({ var, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,-,"var"
    tracing::debug!({ foo = true, var, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,-,"var"
    tracing::debug!(var, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,-,"var"
    tracing::debug!(foo = true, var, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,-,"var"
    tracing::debug!(var, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,-,"var"
    tracing::debug!(foo = true, var, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,-,"var"
    tracing::debug!({ var }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,-,"var"
    tracing::debug!({ foo = true, var }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,-,"var"
    tracing::debug!({ var, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,-,"var"
    tracing::debug!({ foo = true, var, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,-,"var"
    tracing::debug!(sub.field); // DEBUG:debug,-,-,-,-,-,"sub.field"
    tracing::debug!(foo = true, sub.field); // DEBUG:debug,-,-,p,-,-,"sub.field"
    tracing::debug!(sub.field, qux = 3); // DEBUG:debug,-,-,f,-,-,"sub.field"
    tracing::debug!(foo = true, sub.field, qux = 3); // DEBUG:debug,-,-,pf,-,-,"sub.field"
    tracing::debug!(sub.field, "msg without args"); // DEBUG:debug,-,-,-,m,-,"sub.field"
    tracing::debug!(foo = true, sub.field, "msg without args"); // DEBUG:debug,-,-,p,m,-,"sub.field"
    tracing::debug!(sub.field, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,-,"sub.field"
    tracing::debug!(foo = true, sub.field, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,-,"sub.field"
    tracing::debug!({ sub.field }, "msg without args"); // DEBUG:debug,-,{},-,m,-,"sub.field"
    tracing::debug!({ foo = true, sub.field }, "msg without args"); // DEBUG:debug,-,{},p,m,-,"sub.field"
    tracing::debug!({ sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,-,"sub.field"
    tracing::debug!({ foo = true, sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,-,"sub.field"
    tracing::debug!(sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,-,"sub.field"
    tracing::debug!(foo = true, sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,-,"sub.field"
    tracing::debug!(sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,-,"sub.field"
    tracing::debug!(foo = true, sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,-,"sub.field"
    tracing::debug!({ sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,-,"sub.field"
    tracing::debug!({ foo = true, sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,-,"sub.field"
    tracing::debug!({ sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,-,"sub.field"
    tracing::debug!({ foo = true, sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,-,"sub.field"
    tracing::debug!(%disp); // DEBUG:debug,-,-,-,-,-,"%disp"
    tracing::debug!(foo = true, %disp); // DEBUG:debug,-,-,p,-,-,"%disp"
    tracing::debug!(%disp, qux = 3); // DEBUG:debug,-,-,f,-,-,"%disp"
    tracing::debug!(foo = true, %disp, qux = 3); // DEBUG:debug,-,-,pf,-,-,"%disp"
    tracing::debug!(%disp, "msg without args"); // DEBUG:debug,-,-,-,m,-,"%disp"
    tracing::debug!(foo = true, %disp, "msg without args"); // DEBUG:debug,-,-,p,m,-,"%disp"
    tracing::debug!(%disp, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,-,"%disp"
    tracing::debug!(foo = true, %disp, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,-,"%disp"
    tracing::debug!({ %disp }, "msg without args"); // DEBUG:debug,-,{},-,m,-,"%disp"
    tracing::debug!({ foo = true, %disp }, "msg without args"); // DEBUG:debug,-,{},p,m,-,"%disp"
    tracing::debug!({ %disp, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,-,"%disp"
    tracing::debug!({ foo = true, %disp, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,-,"%disp"
    tracing::debug!(%disp, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,-,"%disp"
    tracing::debug!(foo = true, %disp, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,-,"%disp"
    tracing::debug!(%disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,-,"%disp"
    tracing::debug!(foo = true, %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,-,"%disp"
    tracing::debug!({ %disp }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,-,"%disp"
    tracing::debug!({ foo = true, %disp }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,-,"%disp"
    tracing::debug!({ %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,-,"%disp"
    tracing::debug!({ foo = true, %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,-,"%disp"
    tracing::debug!(?deb); // DEBUG:debug,-,-,-,-,-,"?deb"
    tracing::debug!(foo = true, ?deb); // DEBUG:debug,-,-,p,-,-,"?deb"
    tracing::debug!(?deb, qux = 3); // DEBUG:debug,-,-,f,-,-,"?deb"
    tracing::debug!(foo = true, ?deb, qux = 3); // DEBUG:debug,-,-,pf,-,-,"?deb"
    tracing::debug!(?deb, "msg without args"); // DEBUG:debug,-,-,-,m,-,"?deb"
    tracing::debug!(foo = true, ?deb, "msg without args"); // DEBUG:debug,-,-,p,m,-,"?deb"
    tracing::debug!(?deb, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,-,"?deb"
    tracing::debug!(foo = true, ?deb, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,-,"?deb"
    tracing::debug!({ ?deb }, "msg without args"); // DEBUG:debug,-,{},-,m,-,"?deb"
    tracing::debug!({ foo = true, ?deb }, "msg without args"); // DEBUG:debug,-,{},p,m,-,"?deb"
    tracing::debug!({ ?deb, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,-,"?deb"
    tracing::debug!({ foo = true, ?deb, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,-,"?deb"
    tracing::debug!(?deb, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,-,"?deb"
    tracing::debug!(foo = true, ?deb, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,-,"?deb"
    tracing::debug!(?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,-,"?deb"
    tracing::debug!(foo = true, ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,-,"?deb"
    tracing::debug!({ ?deb }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,-,"?deb"
    tracing::debug!({ foo = true, ?deb }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,-,"?deb"
    tracing::debug!({ ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,-,"?deb"
    tracing::debug!({ foo = true, ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,-,"?deb"
    tracing::debug!(%sub.field); // DEBUG:debug,-,-,-,-,-,"%sub.field"
    tracing::debug!(foo = true, %sub.field); // DEBUG:debug,-,-,p,-,-,"%sub.field"
    tracing::debug!(%sub.field, qux = 3); // DEBUG:debug,-,-,f,-,-,"%sub.field"
    tracing::debug!(foo = true, %sub.field, qux = 3); // DEBUG:debug,-,-,pf,-,-,"%sub.field"
    tracing::debug!(%sub.field, "msg without args"); // DEBUG:debug,-,-,-,m,-,"%sub.field"
    tracing::debug!(foo = true, %sub.field, "msg without args"); // DEBUG:debug,-,-,p,m,-,"%sub.field"
    tracing::debug!(%sub.field, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,-,"%sub.field"
    tracing::debug!(foo = true, %sub.field, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,-,"%sub.field"
    tracing::debug!({ %sub.field }, "msg without args"); // DEBUG:debug,-,{},-,m,-,"%sub.field"
    tracing::debug!({ foo = true, %sub.field }, "msg without args"); // DEBUG:debug,-,{},p,m,-,"%sub.field"
    tracing::debug!({ %sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,-,"%sub.field"
    tracing::debug!({ foo = true, %sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,-,"%sub.field"
    tracing::debug!(%sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,-,"%sub.field"
    tracing::debug!(foo = true, %sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,-,"%sub.field"
    tracing::debug!(%sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,-,"%sub.field"
    tracing::debug!(foo = true, %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,-,"%sub.field"
    tracing::debug!({ %sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,-,"%sub.field"
    tracing::debug!({ foo = true, %sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,-,"%sub.field"
    tracing::debug!({ %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,-,"%sub.field"
    tracing::debug!({ foo = true, %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,-,"%sub.field"
    tracing::debug!(?sub.field); // DEBUG:debug,-,-,-,-,-,"?sub.field"
    tracing::debug!(foo = true, ?sub.field); // DEBUG:debug,-,-,p,-,-,"?sub.field"
    tracing::debug!(?sub.field, qux = 3); // DEBUG:debug,-,-,f,-,-,"?sub.field"
    tracing::debug!(foo = true, ?sub.field, qux = 3); // DEBUG:debug,-,-,pf,-,-,"?sub.field"
    tracing::debug!(?sub.field, "msg without args"); // DEBUG:debug,-,-,-,m,-,"?sub.field"
    tracing::debug!(foo = true, ?sub.field, "msg without args"); // DEBUG:debug,-,-,p,m,-,"?sub.field"
    tracing::debug!(?sub.field, qux = 3, "msg without args"); // DEBUG:debug,-,-,f,m,-,"?sub.field"
    tracing::debug!(foo = true, ?sub.field, qux = 3, "msg without args"); // DEBUG:debug,-,-,pf,m,-,"?sub.field"
    tracing::debug!({ ?sub.field }, "msg without args"); // DEBUG:debug,-,{},-,m,-,"?sub.field"
    tracing::debug!({ foo = true, ?sub.field }, "msg without args"); // DEBUG:debug,-,{},p,m,-,"?sub.field"
    tracing::debug!({ ?sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},f,m,-,"?sub.field"
    tracing::debug!({ foo = true, ?sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,-,{},pf,m,-,"?sub.field"
    tracing::debug!(?sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,-,ma,-,"?sub.field"
    tracing::debug!(foo = true, ?sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,p,ma,-,"?sub.field"
    tracing::debug!(?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,f,ma,-,"?sub.field"
    tracing::debug!(foo = true, ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,-,-,pf,ma,-,"?sub.field"
    tracing::debug!({ ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},-,ma,-,"?sub.field"
    tracing::debug!({ foo = true, ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},p,ma,-,"?sub.field"
    tracing::debug!({ ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},f,ma,-,"?sub.field"
    tracing::debug!({ foo = true, ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,-,{},pf,ma,-,"?sub.field"
}
