#!/bin/sh
set -xeu

# Create cargo config directory
CARGO_TMP_DIR=$(mktemp -d)

# Create config.toml
cat > $CARGO_TMP_DIR/config.toml << EOL
[source.crates-io]
replace-with = "vendored-sources"

[source.vendored-sources]
directory = "$(pwd)/rust-vendor"
EOL

# Run the actual test
# Exclude aom-sys and dav1d-sys features as they require additional system libraries
# and are not enabled in the default build configuration
CARGO_HOME=$CARGO_TMP_DIR cargo test --offline --manifest-path Cargo.toml --features asm,av-metrics,binaries,capi,cc,clap,clap_complete,console,fern,ivf,nasm-rs,scan_fmt,signal-hook,signal_support,threading,y4m --all-targets
rm -rf $CARGO_TMP_DIR
