= SDLSKK
* ((<Japanese input system by SDLSKK>))
* ((<SDL::SKK::Context>))
* ((<SDL::SKK::Dictionary>))
* ((<SDL::SKK::Keybind>))
* ((<SDL::SKK::RomKanaRuleTable>))
* SDLSKK methods
  * ((<SDL::SKK.encoding=>)) -- Set SDLSKK internal encoding
  * ((<SDL::SKK.encoding>)) -- Get SDLSKK internal encoding
  * ((<SDL::SKK::RomKanaRuleTable.new>)) -- Load a Romaji-Kana trasnlation table
  * ((<SDL::SKK::Dictionary.new>)) -- Create empty dictionary
  * ((<SDL::SKK::Dictionary#load>)) -- Read a dictionary file
  * ((<SDL::SKK::Dictionary#save>)) -- Save user dictionary data
  * ((<SDL::SKK::Keybind.new>)) -- Create empty keybind
  * ((<SDL::SKK::Keybind#set_key>)) -- Set keybind
  * ((<SDL::SKK::Keybind#set_default_key>)) -- Load default Emacs-like keybinds
  * ((<SDL::SKK::Keybind#unset_key>)) -- Unset keybind
  * ((<SDL::SKK::Context.new>)) -- Create new input context
  * ((<SDL::SKK::Context#input>)) -- Handle keyboard event
  * ((<SDL::SKK::Context#str>)) -- Get input string
  * ((<SDL::SKK::Context#render_str>)) -- Render input string
  * ((<SDL::SKK::Context#render_minibuffer_str>)) -- Render minibuffer string
  * ((<SDL::SKK::Context#clear>)) -- Clear context
  * ((<SDL::SKK::Context#clear_text>)) -- Creat input text
  * ((<SDL::SKK::Context#get_basic_mode>)) -- Get whether input mode is basic mode

== Japanese input system by SDLSKK
Ruby/SDL has 
((<SKK|URL:http://openlab.jp/skk/index-j.html>))-like
Japanese input system by 
((<SDLSKK|URL:http://www.kmc.gr.jp/~ohai/sdlskk.html>)).

This system enables you not only to input Japanse
but also to handle line input including 
cut and paste.

Please see sample/sdlskk.rb.

== SDL::SKK
This module has some SDLSKK-related module functions
and classes.

* ((<SDL::SKK.encoding=>)) -- Set SDLSKK internal encoding
* ((<SDL::SKK.encoding>)) -- Get SDLSKK internal encoding

== SDL::SKK::Context
This class represents input state.

* ((<SDL::SKK::Context.new>)) -- Create new input context
* ((<SDL::SKK::Context#input>)) -- Handle keyboard event
* ((<SDL::SKK::Context#str>)) -- Get input string
* ((<SDL::SKK::Context#render_str>)) -- Render input string
* ((<SDL::SKK::Context#render_minibuffer_str>)) -- Render minibuffer string
* ((<SDL::SKK::Context#clear>)) -- Clear context
* ((<SDL::SKK::Context#clear_text>)) -- Creat input text
* ((<SDL::SKK::Context#get_basic_mode>)) -- Get whether input mode is basic mode

== SDL::SKK::Dictionary
This class represents a Kana-Kanji dictionary.
Load SKK dictionary from files.

* ((<SDL::SKK::Dictionary.new>)) -- Create empty dictionary
* ((<SDL::SKK::Dictionary#load>)) -- Read a dictionary file
* ((<SDL::SKK::Dictionary#save>)) -- Save user dictionary data

== SDL::SKK::Keybind
This class represents keybind.

* ((<SDL::SKK::Keybind.new>)) -- Create empty keybind
* ((<SDL::SKK::Keybind#set_key>)) -- Set keybind
* ((<SDL::SKK::Keybind#set_default_key>)) -- Load default Emacs-like keybinds
* ((<SDL::SKK::Keybind#unset_key>)) -- Unset keybind

== SDL::SKK::RomKanaRuleTable
This class represents the translation table
from Romaji(Alphabet) to Kana.
Load text data from a file and create new table object.

* ((<SDL::SKK::RomKanaRuleTable.new>)) -- Load a Romaji-Kana trasnlation table

== SDLSKK methods

--- SDL::SKK.encoding=(encoding)

    Sets SDLSKKK internal encoding to ((|encoding|)).
    Following constants are allowed:
    * SDL::SKK::EUCJP
    * SDL::SKK::UTF8
    * SDL::SKK::SJIS
    Default is SDL::SKK::EUCJP.
    
    This encoding determines 
    the encoding of ((<dictionary files|SDL::SKK::Dictionary#load>)),
    ((<a romaji-kana translation table file|SDL::SKK::RomKanaRuleTable.new>))
    and ((<private dictionary|SDL::SKK::Dictionary#save>)).


    You need SDLSKK to use this method.
    * NOTES

      This function should call once before calling other
      SDLSKK methods.

    * See Also
      
      ((<SDL::SKK.encoding>)), ((<SDL::SKK::Dictionary#load>)), ((<SDL::SKK::Dictionary#save>)), ((<SDL::SKK::RomKanaRuleTable.new>))

--- SDL::SKK.encoding

    Returns the SDLSKK internal encoding. Please see
    ((<SDL::SKK.encoding=>)) for more detail.


    You need SDLSKK to use this method.
    * See Also
      
      ((<SDL::SKK.encoding=>))

--- SDL::SKK::RomKanaRuleTable.new(filename)

    Load a Romaji-Kana trasnlation table from ((|filename|)).
    File format is:
    * a line beginnig with ;; is comment
    * empty line is ignored
    * one entry per one line: <input alphabets><TAB><Katakana><TAB><Hiragana>
      


    You need SDLSKK to use this method.
    * NOTES

      Encoding of this file is set by ((<SDL::SKK.encoding=>))
      before loading it.

    * See Also
      
      ((<SDL::SKK::Context.new>))

--- SDL::SKK::Dictionary.new

    Creates empty dictionary object and returns it.


    You need SDLSKK to use this method.
    * See Also
      
      ((<SDL::SKK::Dictionary#load>))

--- SDL::SKK::Dictionary#load(filename, user)

    Read a dictionary data from ((|filename|)). 
    Format of dictionary is same as of SKK
    (Ruby/SDL cannot read data with annotations).
    If ((|user|)) is true, loaded data is treated as
    user dictionary data. If ((|user|)) is false,
    loaded data is treated as system dictionary data.

    Raises ((<SDL::Error>)) on failure

    You need SDLSKK to use this method.
    * NOTES

      Encoding of this file is set by ((<SDL::SKK.encoding=>))
      before loading it.

    * See Also
      
      ((<SDL::SKK::Dictionary.new>)), ((<SDL::SKK::Dictionary#save>)), ((<SDL::SKK::Context.new>))

--- SDL::SKK::Dictionary#save(filename)

    Save user dictionary data into ((|filename|)).


    You need SDLSKK to use this method.
    * See Also
      
      ((<SDL::SKK::Dictionary.new>)), ((<SDL::SKK::Dictionary#load>))

--- SDL::SKK::Keybind.new

    Creates empty keybind object and returns it.
    Add keybind to this object using
    ((<SDL::SKK::Keybind#set_key>)) and ((<SDL::SKK::Keybind#set_default_key>)).


    You need SDLSKK to use this method.
    * See Also
      
      ((<SDL::SKK::Keybind#set_key>)), ((<SDL::SKK::Keybind#set_default_key>)), ((<SDL::SKK::Context.new>))

--- SDL::SKK::Keybind#set_key(key_str, cmd_str)

    Sets keybind. ((|key_str|)) is a key-symbol string.
    ((|cmd_str|)) is command string.
    
    Following strings are allowed as ((|key_str|)):
    * Alphabet and ascii characters like "%"
    * "SPC" "TAB" "DEL" "RET" "UP" "DOWN" "RIGHT" "LEFT" "INSERT" "HOME" "END"
      "PAGEUP" "PAGEDOWN" "F1" "F2" "F3" "F4" "F5" "F6" "F7" "F8" "F9" "F10"
      "F11" "F12" "F13" "F14" "F15" "HELP"
    * key with modifiers like "C-a" and "M-C-a"
    
    Following strings is allowed as ((|cmd_str|)):
    * "backward-char",
    * "forward-char",
    * "backward-delete-char",
    * "delete-char",
    * "kakutei",
    * "kettei",
    * "space",
    * "keyboard-quit",
    * "set-mark-command",
    * "kill-region",
    * "yank",
    * "copy",
    * "graph-char",
    * "upper-char",
    * "lower-char",
    * "abbrev-input",
    * "latin-mode",
    * "previous-candidate",
    * "jisx0208-mode",
    * "toggle-kana",
    * "beginning-of-line"
    * "end-of-line"
    * "do-nothing"
    
    You shouldn't change the keybind of only one ascii character key
    like "a" and "/".
    
    ((<SDL::SKK::Keybind#set_default_key>)) is useful.


    You need SDLSKK to use this method.
    * See Also
      
      ((<SDL::SKK::Keybind#set_default_key>)), ((<SDL::SKK::Keybind#unset_key>))

--- SDL::SKK::Keybind#set_default_key

    Load default Emacs-like keybinds.


    You need SDLSKK to use this method.
    * See Also
      
      ((<SDL::SKK::Keybind#set_key>))

--- SDL::SKK::Keybind#unset_key(key_str)

    Unset keybind of ((|key_str|)).


    You need SDLSKK to use this method.
    * See Also
      
      ((<SDL::SKK::Keybind#set_key>))

--- SDL::SKK::Context.new(dict, romkama_table, bind, use_minibuffer)

    Creates input context and returns new ((<SDL::SKK::Context>)) object.
    ((|dict|)) is a ((<dictionary|SDL::SKK::Dictionary>)),
    ((|romkama_table|)) is a
    ((<Ronaji-Kana translation table|SDL::SKK::RomKanaRuleTable>))
    and ((|bind|)) is ((<keybind|SDL::SKK::Keybind>)).
    If ((|use_minibuffer|)) is true, 
    SKK-like minibuffer is enabled.


    You need SDLSKK to use this method.

    EXAMPLE
      # Create dictionary object and read data from 'jisyo'
      dict = SDL::SKK::Dictionary.new
      dict.load( 'jisyo', false )
      # Read Romaji-Kana translation table from 'rule_table'
      table = SDL::SKK::RomKanaRuleTable.new( 'rule_table' )
      # Set keybind
      bind = SDL::SKK::Keybind.new
      bind.set_default_key
      
      # Create context
      context = SDL::SKK::Context.new( dict, table, bind, use_minibuffer )

    * See Also
      
      ((<SDL::SKK::Context#input>)), ((<SDL::SKK::Context#str>))

--- SDL::SKK::Context#input(event)

    Handles keyboard event. ((|event|)) should be 
    ((<SDL::Event>)) object.
    This method handles only ((<keydown events|SDL::Event::KeyDown>))
    and ignore other events.


    You need SDLSKK to use this method.

    EXAMPLE
      while event = SDL::Event.poll do
        case event
        when SDL::Event::Quit
          exit
        when SDL::Event::KeyDown
          if event.sym == SDL::Key::ESCAPE then
            exit
          end
          if event.sym == SDL::Key::F1
            dict.save("test_user_dict")
          end
          context.input( event )      
        end
      end

--- SDL::SKK::Context#str

    Returns input string.


    You need SDLSKK to use this method.
    * NOTES

      If Ruby/SDL m17n support is enabled,
      the string with proper encoding will be returned.

    * See Also
      
      ((<SDL::SKK::Context#render_str>)), ((<SDL::SKK::Context#clear>)), ((<SDL::SKK::Context#clear_text>)), ((<SDL::SKK.encoding>))

--- SDL::SKK::Context#render_str(font, r, g, b)

    Renders input string and returns ((<SDL::Surface>)) object.


    You need SDLSKK to use this method.
    * See Also
      
      ((<SDL::SKK::Context#render_minibuffer_str>))

--- SDL::SKK::Context#render_minibuffer_str(font, r, g, b)

    Renders minibuffer string and returns ((<SDL::Surface>)) object.


    You need SDLSKK to use this method.
--- SDL::SKK::Context#clear

    Clears input context.


    You need SDLSKK to use this method.
    * See Also
      
      ((<SDL::SKK::Context#clear_text>))

--- SDL::SKK::Context#clear_text

    Clears input text, but input mode is held.
    
    If you want multi-line input, this method is better
    than ((<SDL::SKK::Context#clear>))


    You need SDLSKK to use this method.
    * See Also
      
      ((<SDL::SKK::Context#get_basic_mode>))

--- SDL::SKK::Context#get_basic_mode

    Returns true if ((|self|))'s input mode is kakutei-mode,
    latin-mode or jisx0208-latim-mode, otherwise returns
    false.


    You need SDLSKK to use this method.
    * NOTES

      Please see ((<SKK|URL:http://openlab.jp/skk/index.html>)).

    * See Also
      
      ((<SDL::SKK::Context#clear_text>))

