/*
*  RAL -- Rubrica Addressbook Library
*  file: contact.h
*  
*  Copyright (C) Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _R_CONTACT_H
#define _R_CONTACT_H

#include <glib.h>
#include <glib-object.h>

#include "utils.h"
#include "date.h" 


#define R_CONTACT_TYPE             (r_contact_get_type())

#define R_CONTACT(obj)             (G_TYPE_CHECK_INSTANCE_CAST((obj),     \
                                    R_CONTACT_TYPE, RContact))

#define R_CONTACT_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST((klass),      \
                                    R_CONTACT_TYPE, RContactClass))

#define IS_R_CONTACT(obj)          (G_TYPE_CHECK_INSTANCE_TYPE((obj),     \
                                    R_CONTACT_TYPE))

#define IS_R_CONTACT_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE((klass),      \
                                    R_CONTACT_TYPE))

#define R_CONTACT_GET_CLASS(klass) (G_TYPE_INSTANCE_GET_CLASS((klass),    \
                                    R_CONTACT_TYPE, RContactClass))



typedef struct _RContact        RContact;
typedef struct _RContactClass   RContactClass;
typedef struct _RContactPrivate RContactPrivate;


/* Contact contact data 
*/
struct _RContact
{
  GObject parent;

  RContactPrivate* priv;
};


struct _RContactClass {
  GObjectClass parent;
};


GType     r_contact_get_type        (void);


RContact* r_contact_new             (void);
void      r_contact_free            (RContact* contact);

gboolean  r_contact_search          (RContact* contact, const gchar* str);

RContact* r_contact_copy            (RContact* contact);

RDate*    r_contact_get_birthday    (RContact* contact);
void      r_contact_set_birthday    (RContact* contact, gint day,
				     gint month, gint year);


gchar*    r_contact_get_birth_day   (RContact* contact);
gchar*    r_contact_get_birth_month (RContact* contact);
gchar*    r_contact_get_birth_year  (RContact* contact);
gchar*    r_contact_get_birth_date  (RContact* contact);





#endif
