#ifndef _RHEO_BASIS_REP_H
#define _RHEO_BASIS_REP_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================

#include "rheolef/reference_element.h"
#include "rheolef/point.h"
#include "rheolef/tensor.h"
#include "rheolef/element_constant.h"
namespace rheolef { 

class basis_rep {
public:
    typedef element_constant::dof_family_type dof_family_type;
    typedef size_t size_type;
    basis_rep(std::string name, dof_family_type family) : _name(name), _family(family) {};
    virtual ~basis_rep() { }
    std::string name() const;
    dof_family_type family() const;
    virtual dof_family_type dof_family(
        reference_element hat_K,
        size_type         i_dof_local) const = 0;
    virtual size_type degree () const = 0;
    virtual size_type size (
	reference_element hat_K, dof_family_type family) const = 0;
    virtual Float eval(
        reference_element hat_K,
        size_type         i_dof_local,
        const point&      hat_x) const = 0;
    virtual point grad_eval(
        reference_element hat_K,
        size_type         i_dof_local,
        const point&      hat_x) const = 0;
    virtual tensor hessian_eval(
        reference_element hat_K,
        size_type         i_dof_local,
        const point &      hat_x) const = 0;
    virtual void eval(
        reference_element    hat_K,
        const point&         hat_x,
	std::vector<Float>&  values) const = 0;
    virtual void grad_eval(
        reference_element    hat_K,
        const point&         hat_x,
	std::vector<point>&  values) const = 0;
    virtual void hessian_eval(
        reference_element    hat_K,
        const point&         hat_x,
	std::vector<tensor >&  values) const = 0;
    virtual void hat_node(
        reference_element    hat_K,
	std::vector<point>&  hat_node) const = 0;
    static basis_rep* make_ptr (std::string name);
protected:
    std::string _name;
    dof_family_type _family;
};
inline
std::string
basis_rep::name() const
{
  return _name;
}
inline
basis_rep::dof_family_type
basis_rep::family() const
{
  return _family;
}
}// namespace rheolef
#endif // _RHEO_BASIS_REP_H
