# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2024 Raritan Inc. All rights reserved.
#
# This is an auto-generated file.

#
# Section generated by IdlC from "Diagnostics.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException

# interface
class Diagnostics(Interface):
    idlType = "net.Diagnostics:1.0.1"

    NO_ERROR = 0

    ERR_INVALID_PARAM = 1

    ERR_EXEC_FAIL = 2

    ERR_TIMEOUT = 3

    ERR_RESOLVE_FAIL = 4

    class _ping(Interface.Method):
        name = 'ping'

        @staticmethod
        def encode(hostName, count):
            typecheck.is_string(hostName, AssertionError)
            typecheck.is_int(count, AssertionError)
            args = {}
            args['hostName'] = hostName
            args['count'] = count
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            results = [x0 for x0 in rsp['results']]
            typecheck.is_int(_ret_, DecodeException)
            for x0 in results:
                typecheck.is_string(x0, DecodeException)
            return (_ret_, results)

    class _traceRoute(Interface.Method):
        name = 'traceRoute'

        @staticmethod
        def encode(hostName, timeout, useIcmp):
            typecheck.is_string(hostName, AssertionError)
            typecheck.is_int(timeout, AssertionError)
            typecheck.is_bool(useIcmp, AssertionError)
            args = {}
            args['hostName'] = hostName
            args['timeout'] = timeout
            args['useIcmp'] = useIcmp
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            results = [x0 for x0 in rsp['results']]
            typecheck.is_int(_ret_, DecodeException)
            for x0 in results:
                typecheck.is_string(x0, DecodeException)
            return (_ret_, results)

    class _listTcpConnections(Interface.Method):
        name = 'listTcpConnections'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            results = [x0 for x0 in rsp['results']]
            typecheck.is_int(_ret_, DecodeException)
            for x0 in results:
                typecheck.is_string(x0, DecodeException)
            return (_ret_, results)

    class _listTcpUdpListenSockets(Interface.Method):
        name = 'listTcpUdpListenSockets'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            results = [x0 for x0 in rsp['results']]
            typecheck.is_int(_ret_, DecodeException)
            for x0 in results:
                typecheck.is_string(x0, DecodeException)
            return (_ret_, results)

    class _resolveHostName(Interface.Method):
        name = 'resolveHostName'

        @staticmethod
        def encode(hostName):
            typecheck.is_string(hostName, AssertionError)
            args = {}
            args['hostName'] = hostName
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            results = [x0 for x0 in rsp['results']]
            for x0 in results:
                typecheck.is_string(x0, DecodeException)
            return results
    def __init__(self, target, agent):
        super(Diagnostics, self).__init__(target, agent)
        self.ping = Diagnostics._ping(self)
        self.traceRoute = Diagnostics._traceRoute(self)
        self.listTcpConnections = Diagnostics._listTcpConnections(self)
        self.listTcpUdpListenSockets = Diagnostics._listTcpUdpListenSockets(self)
        self.resolveHostName = Diagnostics._resolveHostName(self)

#
# Section generated by IdlC from "Net.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.idl

import raritan.rpc.net


# structure
class IpAddrCidr(Structure):
    idlType = "net.IpAddrCidr:1.0.0"
    elements = ["addr", "prefixLen"]

    def __init__(self, addr="", prefixLen=0):
        typecheck.is_string(addr, AssertionError)
        typecheck.is_int(prefixLen, AssertionError)

        self.addr = addr
        self.prefixLen = prefixLen

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            addr = json['addr'] if 'addr' in json or not useDefaults else "",
            prefixLen = json['prefixLen'] if 'prefixLen' in json or not useDefaults else 0,
        )
        return obj

    def encode(self):
        json = {}
        json['addr'] = self.addr
        json['prefixLen'] = self.prefixLen
        return json

# structure
class IpRoute(Structure):
    idlType = "net.IpRoute:1.0.0"
    elements = ["destNetAddrCidr", "nextHopAddr", "ifName"]

    def __init__(self, destNetAddrCidr=None, nextHopAddr="", ifName=""):
        if destNetAddrCidr is None:
            destNetAddrCidr = raritan.rpc.net.IpAddrCidr()
        typecheck.is_struct(destNetAddrCidr, raritan.rpc.net.IpAddrCidr, AssertionError)
        typecheck.is_string(nextHopAddr, AssertionError)
        typecheck.is_string(ifName, AssertionError)

        self.destNetAddrCidr = destNetAddrCidr
        self.nextHopAddr = nextHopAddr
        self.ifName = ifName

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            destNetAddrCidr = raritan.rpc.net.IpAddrCidr.decode(json['destNetAddrCidr'], agent, useDefaults=useDefaults) if 'destNetAddrCidr' in json or not useDefaults else raritan.rpc.net.IpAddrCidr(),
            nextHopAddr = json['nextHopAddr'] if 'nextHopAddr' in json or not useDefaults else "",
            ifName = json['ifName'] if 'ifName' in json or not useDefaults else "",
        )
        return obj

    def encode(self):
        json = {}
        json['destNetAddrCidr'] = raritan.rpc.net.IpAddrCidr.encode(self.destNetAddrCidr)
        json['nextHopAddr'] = self.nextHopAddr
        json['ifName'] = self.ifName
        return json

# enumeration
class PortForwardingRole(Enumeration):
    idlType = "net.PortForwardingRole:2.0.0"
    values = ["PRIMARY_UNIT", "EXPANSION_UNIT"]

PortForwardingRole.PRIMARY_UNIT = PortForwardingRole(0)
PortForwardingRole.EXPANSION_UNIT = PortForwardingRole(1)

# structure
class PortForwardingSettings(Structure):
    idlType = "net.PortForwardingSettings:3.0.0"
    elements = ["enabled", "role", "primaryUnitDownstreamIfName"]

    def __init__(self, enabled=False, role=None, primaryUnitDownstreamIfName=""):
        if role is None:
            role = raritan.rpc.net.PortForwardingRole.PRIMARY_UNIT
        typecheck.is_bool(enabled, AssertionError)
        typecheck.is_enum(role, raritan.rpc.net.PortForwardingRole, AssertionError)
        typecheck.is_string(primaryUnitDownstreamIfName, AssertionError)

        self.enabled = enabled
        self.role = role
        self.primaryUnitDownstreamIfName = primaryUnitDownstreamIfName

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            enabled = json['enabled'] if 'enabled' in json or not useDefaults else False,
            role = raritan.rpc.net.PortForwardingRole.decode(json['role']) if 'role' in json or not useDefaults else raritan.rpc.net.PortForwardingRole.PRIMARY_UNIT,
            primaryUnitDownstreamIfName = json['primaryUnitDownstreamIfName'] if 'primaryUnitDownstreamIfName' in json or not useDefaults else "",
        )
        return obj

    def encode(self):
        json = {}
        json['enabled'] = self.enabled
        json['role'] = raritan.rpc.net.PortForwardingRole.encode(self.role)
        json['primaryUnitDownstreamIfName'] = self.primaryUnitDownstreamIfName
        return json

# structure
class DnsSettings(Structure):
    idlType = "net.DnsSettings:2.0.0"
    elements = ["serverAddrs", "searchSuffixes", "resolverPrefersIPv6"]

    def __init__(self, serverAddrs=[], searchSuffixes=[], resolverPrefersIPv6=False):
        for x0 in serverAddrs:
            typecheck.is_string(x0, AssertionError)
        for x0 in searchSuffixes:
            typecheck.is_string(x0, AssertionError)
        typecheck.is_bool(resolverPrefersIPv6, AssertionError)

        self.serverAddrs = serverAddrs
        self.searchSuffixes = searchSuffixes
        self.resolverPrefersIPv6 = resolverPrefersIPv6

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            serverAddrs = [x0 for x0 in json['serverAddrs']] if 'serverAddrs' in json or not useDefaults else [],
            searchSuffixes = [x0 for x0 in json['searchSuffixes']] if 'searchSuffixes' in json or not useDefaults else [],
            resolverPrefersIPv6 = json['resolverPrefersIPv6'] if 'resolverPrefersIPv6' in json or not useDefaults else False,
        )
        return obj

    def encode(self):
        json = {}
        json['serverAddrs'] = [x0 for x0 in self.serverAddrs]
        json['searchSuffixes'] = [x0 for x0 in self.searchSuffixes]
        json['resolverPrefersIPv6'] = self.resolverPrefersIPv6
        return json

# structure
class IpRoutingSettings(Structure):
    idlType = "net.IpRoutingSettings:3.0.0"
    elements = ["staticRoutes"]

    def __init__(self, staticRoutes=[]):
        for x0 in staticRoutes:
            typecheck.is_struct(x0, raritan.rpc.net.IpRoute, AssertionError)

        self.staticRoutes = staticRoutes

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            staticRoutes = [raritan.rpc.net.IpRoute.decode(x0, agent, useDefaults=useDefaults) for x0 in json['staticRoutes']] if 'staticRoutes' in json or not useDefaults else [],
        )
        return obj

    def encode(self):
        json = {}
        json['staticRoutes'] = [raritan.rpc.net.IpRoute.encode(x0) for x0 in self.staticRoutes]
        return json

# structure
class RoutingSettings(Structure):
    idlType = "net.RoutingSettings:3.0.0"
    elements = ["ipv4", "ipv6"]

    def __init__(self, ipv4=None, ipv6=None):
        if ipv4 is None:
            ipv4 = raritan.rpc.net.IpRoutingSettings()
        if ipv6 is None:
            ipv6 = raritan.rpc.net.IpRoutingSettings()
        typecheck.is_struct(ipv4, raritan.rpc.net.IpRoutingSettings, AssertionError)
        typecheck.is_struct(ipv6, raritan.rpc.net.IpRoutingSettings, AssertionError)

        self.ipv4 = ipv4
        self.ipv6 = ipv6

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            ipv4 = raritan.rpc.net.IpRoutingSettings.decode(json['ipv4'], agent, useDefaults=useDefaults) if 'ipv4' in json or not useDefaults else raritan.rpc.net.IpRoutingSettings(),
            ipv6 = raritan.rpc.net.IpRoutingSettings.decode(json['ipv6'], agent, useDefaults=useDefaults) if 'ipv6' in json or not useDefaults else raritan.rpc.net.IpRoutingSettings(),
        )
        return obj

    def encode(self):
        json = {}
        json['ipv4'] = raritan.rpc.net.IpRoutingSettings.encode(self.ipv4)
        json['ipv6'] = raritan.rpc.net.IpRoutingSettings.encode(self.ipv6)
        return json

# structure
class CommonSettings(Structure):
    idlType = "net.CommonSettings:3.0.0"
    elements = ["dns", "routing", "portForwarding"]

    def __init__(self, dns=None, routing=None, portForwarding=None):
        if dns is None:
            dns = raritan.rpc.net.DnsSettings()
        if routing is None:
            routing = raritan.rpc.net.RoutingSettings()
        if portForwarding is None:
            portForwarding = raritan.rpc.net.PortForwardingSettings()
        typecheck.is_struct(dns, raritan.rpc.net.DnsSettings, AssertionError)
        typecheck.is_struct(routing, raritan.rpc.net.RoutingSettings, AssertionError)
        typecheck.is_struct(portForwarding, raritan.rpc.net.PortForwardingSettings, AssertionError)

        self.dns = dns
        self.routing = routing
        self.portForwarding = portForwarding

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            dns = raritan.rpc.net.DnsSettings.decode(json['dns'], agent, useDefaults=useDefaults) if 'dns' in json or not useDefaults else raritan.rpc.net.DnsSettings(),
            routing = raritan.rpc.net.RoutingSettings.decode(json['routing'], agent, useDefaults=useDefaults) if 'routing' in json or not useDefaults else raritan.rpc.net.RoutingSettings(),
            portForwarding = raritan.rpc.net.PortForwardingSettings.decode(json['portForwarding'], agent, useDefaults=useDefaults) if 'portForwarding' in json or not useDefaults else raritan.rpc.net.PortForwardingSettings(),
        )
        return obj

    def encode(self):
        json = {}
        json['dns'] = raritan.rpc.net.DnsSettings.encode(self.dns)
        json['routing'] = raritan.rpc.net.RoutingSettings.encode(self.routing)
        json['portForwarding'] = raritan.rpc.net.PortForwardingSettings.encode(self.portForwarding)
        return json

# structure
class PortForwardingPrimaryUnitAddrInfo(Structure):
    idlType = "net.PortForwardingPrimaryUnitAddrInfo:1.0.0"
    elements = ["ifName", "addr"]

    def __init__(self, ifName="", addr=""):
        typecheck.is_string(ifName, AssertionError)
        typecheck.is_string(addr, AssertionError)

        self.ifName = ifName
        self.addr = addr

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            ifName = json['ifName'] if 'ifName' in json or not useDefaults else "",
            addr = json['addr'] if 'addr' in json or not useDefaults else "",
        )
        return obj

    def encode(self):
        json = {}
        json['ifName'] = self.ifName
        json['addr'] = self.addr
        return json

# structure
class PortForwardingInfo(Structure):
    idlType = "net.PortForwardingInfo:3.0.0"
    elements = ["enabled", "nodeIndexValid", "nodeIndex", "expansionUnitConnected", "primaryUnitDownstreamIfName", "primaryUnitIPv4AddrInfos", "primaryUnitIPv6AddrInfos", "linkLocalIPv6Address"]

    def __init__(self, enabled=False, nodeIndexValid=False, nodeIndex=0, expansionUnitConnected=False, primaryUnitDownstreamIfName="", primaryUnitIPv4AddrInfos=[], primaryUnitIPv6AddrInfos=[], linkLocalIPv6Address=""):
        typecheck.is_bool(enabled, AssertionError)
        typecheck.is_bool(nodeIndexValid, AssertionError)
        typecheck.is_int(nodeIndex, AssertionError)
        typecheck.is_bool(expansionUnitConnected, AssertionError)
        typecheck.is_string(primaryUnitDownstreamIfName, AssertionError)
        for x0 in primaryUnitIPv4AddrInfos:
            typecheck.is_struct(x0, raritan.rpc.net.PortForwardingPrimaryUnitAddrInfo, AssertionError)
        for x0 in primaryUnitIPv6AddrInfos:
            typecheck.is_struct(x0, raritan.rpc.net.PortForwardingPrimaryUnitAddrInfo, AssertionError)
        typecheck.is_string(linkLocalIPv6Address, AssertionError)

        self.enabled = enabled
        self.nodeIndexValid = nodeIndexValid
        self.nodeIndex = nodeIndex
        self.expansionUnitConnected = expansionUnitConnected
        self.primaryUnitDownstreamIfName = primaryUnitDownstreamIfName
        self.primaryUnitIPv4AddrInfos = primaryUnitIPv4AddrInfos
        self.primaryUnitIPv6AddrInfos = primaryUnitIPv6AddrInfos
        self.linkLocalIPv6Address = linkLocalIPv6Address

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            enabled = json['enabled'] if 'enabled' in json or not useDefaults else False,
            nodeIndexValid = json['nodeIndexValid'] if 'nodeIndexValid' in json or not useDefaults else False,
            nodeIndex = json['nodeIndex'] if 'nodeIndex' in json or not useDefaults else 0,
            expansionUnitConnected = json['expansionUnitConnected'] if 'expansionUnitConnected' in json or not useDefaults else False,
            primaryUnitDownstreamIfName = json['primaryUnitDownstreamIfName'] if 'primaryUnitDownstreamIfName' in json or not useDefaults else "",
            primaryUnitIPv4AddrInfos = [raritan.rpc.net.PortForwardingPrimaryUnitAddrInfo.decode(x0, agent, useDefaults=useDefaults) for x0 in json['primaryUnitIPv4AddrInfos']] if 'primaryUnitIPv4AddrInfos' in json or not useDefaults else [],
            primaryUnitIPv6AddrInfos = [raritan.rpc.net.PortForwardingPrimaryUnitAddrInfo.decode(x0, agent, useDefaults=useDefaults) for x0 in json['primaryUnitIPv6AddrInfos']] if 'primaryUnitIPv6AddrInfos' in json or not useDefaults else [],
            linkLocalIPv6Address = json['linkLocalIPv6Address'] if 'linkLocalIPv6Address' in json or not useDefaults else "",
        )
        return obj

    def encode(self):
        json = {}
        json['enabled'] = self.enabled
        json['nodeIndexValid'] = self.nodeIndexValid
        json['nodeIndex'] = self.nodeIndex
        json['expansionUnitConnected'] = self.expansionUnitConnected
        json['primaryUnitDownstreamIfName'] = self.primaryUnitDownstreamIfName
        json['primaryUnitIPv4AddrInfos'] = [raritan.rpc.net.PortForwardingPrimaryUnitAddrInfo.encode(x0) for x0 in self.primaryUnitIPv4AddrInfos]
        json['primaryUnitIPv6AddrInfos'] = [raritan.rpc.net.PortForwardingPrimaryUnitAddrInfo.encode(x0) for x0 in self.primaryUnitIPv6AddrInfos]
        json['linkLocalIPv6Address'] = self.linkLocalIPv6Address
        return json

# structure
class DnsInfo(Structure):
    idlType = "net.DnsInfo:1.0.0"
    elements = ["serverAddrs", "searchSuffixes", "resolverPrefersIPv6"]

    def __init__(self, serverAddrs=[], searchSuffixes=[], resolverPrefersIPv6=False):
        for x0 in serverAddrs:
            typecheck.is_string(x0, AssertionError)
        for x0 in searchSuffixes:
            typecheck.is_string(x0, AssertionError)
        typecheck.is_bool(resolverPrefersIPv6, AssertionError)

        self.serverAddrs = serverAddrs
        self.searchSuffixes = searchSuffixes
        self.resolverPrefersIPv6 = resolverPrefersIPv6

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            serverAddrs = [x0 for x0 in json['serverAddrs']] if 'serverAddrs' in json or not useDefaults else [],
            searchSuffixes = [x0 for x0 in json['searchSuffixes']] if 'searchSuffixes' in json or not useDefaults else [],
            resolverPrefersIPv6 = json['resolverPrefersIPv6'] if 'resolverPrefersIPv6' in json or not useDefaults else False,
        )
        return obj

    def encode(self):
        json = {}
        json['serverAddrs'] = [x0 for x0 in self.serverAddrs]
        json['searchSuffixes'] = [x0 for x0 in self.searchSuffixes]
        json['resolverPrefersIPv6'] = self.resolverPrefersIPv6
        return json

# structure
class RoutingInfo(Structure):
    idlType = "net.RoutingInfo:1.0.0"
    elements = ["ipv4Routes", "ipv6Routes"]

    def __init__(self, ipv4Routes=[], ipv6Routes=[]):
        for x0 in ipv4Routes:
            typecheck.is_struct(x0, raritan.rpc.net.IpRoute, AssertionError)
        for x0 in ipv6Routes:
            typecheck.is_struct(x0, raritan.rpc.net.IpRoute, AssertionError)

        self.ipv4Routes = ipv4Routes
        self.ipv6Routes = ipv6Routes

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            ipv4Routes = [raritan.rpc.net.IpRoute.decode(x0, agent, useDefaults=useDefaults) for x0 in json['ipv4Routes']] if 'ipv4Routes' in json or not useDefaults else [],
            ipv6Routes = [raritan.rpc.net.IpRoute.decode(x0, agent, useDefaults=useDefaults) for x0 in json['ipv6Routes']] if 'ipv6Routes' in json or not useDefaults else [],
        )
        return obj

    def encode(self):
        json = {}
        json['ipv4Routes'] = [raritan.rpc.net.IpRoute.encode(x0) for x0 in self.ipv4Routes]
        json['ipv6Routes'] = [raritan.rpc.net.IpRoute.encode(x0) for x0 in self.ipv6Routes]
        return json

# structure
class CommonInfo(Structure):
    idlType = "net.CommonInfo:2.0.0"
    elements = ["dns", "routing", "portForwarding"]

    def __init__(self, dns=None, routing=None, portForwarding=None):
        if dns is None:
            dns = raritan.rpc.net.DnsInfo()
        if routing is None:
            routing = raritan.rpc.net.RoutingInfo()
        if portForwarding is None:
            portForwarding = raritan.rpc.net.PortForwardingInfo()
        typecheck.is_struct(dns, raritan.rpc.net.DnsInfo, AssertionError)
        typecheck.is_struct(routing, raritan.rpc.net.RoutingInfo, AssertionError)
        typecheck.is_struct(portForwarding, raritan.rpc.net.PortForwardingInfo, AssertionError)

        self.dns = dns
        self.routing = routing
        self.portForwarding = portForwarding

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            dns = raritan.rpc.net.DnsInfo.decode(json['dns'], agent, useDefaults=useDefaults) if 'dns' in json or not useDefaults else raritan.rpc.net.DnsInfo(),
            routing = raritan.rpc.net.RoutingInfo.decode(json['routing'], agent, useDefaults=useDefaults) if 'routing' in json or not useDefaults else raritan.rpc.net.RoutingInfo(),
            portForwarding = raritan.rpc.net.PortForwardingInfo.decode(json['portForwarding'], agent, useDefaults=useDefaults) if 'portForwarding' in json or not useDefaults else raritan.rpc.net.PortForwardingInfo(),
        )
        return obj

    def encode(self):
        json = {}
        json['dns'] = raritan.rpc.net.DnsInfo.encode(self.dns)
        json['routing'] = raritan.rpc.net.RoutingInfo.encode(self.routing)
        json['portForwarding'] = raritan.rpc.net.PortForwardingInfo.encode(self.portForwarding)
        return json

# enumeration
class IpConfigMethod(Enumeration):
    idlType = "net.IpConfigMethod:1.0.0"
    values = ["STATIC", "DHCP", "AUTO"]

IpConfigMethod.STATIC = IpConfigMethod(0)
IpConfigMethod.DHCP = IpConfigMethod(1)
IpConfigMethod.AUTO = IpConfigMethod(2)

# structure
class InterfaceIpSettings(Structure):
    idlType = "net.InterfaceIpSettings:3.0.0"
    elements = ["enabled", "configMethod", "staticAddrCidr", "staticDefaultGatewayAddr", "dhcpPreferredHostname"]

    def __init__(self, enabled=False, configMethod=None, staticAddrCidr=None, staticDefaultGatewayAddr="", dhcpPreferredHostname=""):
        if configMethod is None:
            configMethod = raritan.rpc.net.IpConfigMethod.STATIC
        if staticAddrCidr is None:
            staticAddrCidr = raritan.rpc.net.IpAddrCidr()
        typecheck.is_bool(enabled, AssertionError)
        typecheck.is_enum(configMethod, raritan.rpc.net.IpConfigMethod, AssertionError)
        typecheck.is_struct(staticAddrCidr, raritan.rpc.net.IpAddrCidr, AssertionError)
        typecheck.is_string(staticDefaultGatewayAddr, AssertionError)
        typecheck.is_string(dhcpPreferredHostname, AssertionError)

        self.enabled = enabled
        self.configMethod = configMethod
        self.staticAddrCidr = staticAddrCidr
        self.staticDefaultGatewayAddr = staticDefaultGatewayAddr
        self.dhcpPreferredHostname = dhcpPreferredHostname

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            enabled = json['enabled'] if 'enabled' in json or not useDefaults else False,
            configMethod = raritan.rpc.net.IpConfigMethod.decode(json['configMethod']) if 'configMethod' in json or not useDefaults else raritan.rpc.net.IpConfigMethod.STATIC,
            staticAddrCidr = raritan.rpc.net.IpAddrCidr.decode(json['staticAddrCidr'], agent, useDefaults=useDefaults) if 'staticAddrCidr' in json or not useDefaults else raritan.rpc.net.IpAddrCidr(),
            staticDefaultGatewayAddr = json['staticDefaultGatewayAddr'] if 'staticDefaultGatewayAddr' in json or not useDefaults else "",
            dhcpPreferredHostname = json['dhcpPreferredHostname'] if 'dhcpPreferredHostname' in json or not useDefaults else "",
        )
        return obj

    def encode(self):
        json = {}
        json['enabled'] = self.enabled
        json['configMethod'] = raritan.rpc.net.IpConfigMethod.encode(self.configMethod)
        json['staticAddrCidr'] = raritan.rpc.net.IpAddrCidr.encode(self.staticAddrCidr)
        json['staticDefaultGatewayAddr'] = self.staticDefaultGatewayAddr
        json['dhcpPreferredHostname'] = self.dhcpPreferredHostname
        return json

# structure
class InterfaceIPv4Info(Structure):
    idlType = "net.InterfaceIPv4Info:1.0.0"
    elements = ["enabled", "configMethod", "addrsCidr", "dhcpServerAddr", "dhcpPreferredHostname"]

    def __init__(self, enabled=False, configMethod=None, addrsCidr=[], dhcpServerAddr="", dhcpPreferredHostname=""):
        if configMethod is None:
            configMethod = raritan.rpc.net.IpConfigMethod.STATIC
        typecheck.is_bool(enabled, AssertionError)
        typecheck.is_enum(configMethod, raritan.rpc.net.IpConfigMethod, AssertionError)
        for x0 in addrsCidr:
            typecheck.is_struct(x0, raritan.rpc.net.IpAddrCidr, AssertionError)
        typecheck.is_string(dhcpServerAddr, AssertionError)
        typecheck.is_string(dhcpPreferredHostname, AssertionError)

        self.enabled = enabled
        self.configMethod = configMethod
        self.addrsCidr = addrsCidr
        self.dhcpServerAddr = dhcpServerAddr
        self.dhcpPreferredHostname = dhcpPreferredHostname

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            enabled = json['enabled'] if 'enabled' in json or not useDefaults else False,
            configMethod = raritan.rpc.net.IpConfigMethod.decode(json['configMethod']) if 'configMethod' in json or not useDefaults else raritan.rpc.net.IpConfigMethod.STATIC,
            addrsCidr = [raritan.rpc.net.IpAddrCidr.decode(x0, agent, useDefaults=useDefaults) for x0 in json['addrsCidr']] if 'addrsCidr' in json or not useDefaults else [],
            dhcpServerAddr = json['dhcpServerAddr'] if 'dhcpServerAddr' in json or not useDefaults else "",
            dhcpPreferredHostname = json['dhcpPreferredHostname'] if 'dhcpPreferredHostname' in json or not useDefaults else "",
        )
        return obj

    def encode(self):
        json = {}
        json['enabled'] = self.enabled
        json['configMethod'] = raritan.rpc.net.IpConfigMethod.encode(self.configMethod)
        json['addrsCidr'] = [raritan.rpc.net.IpAddrCidr.encode(x0) for x0 in self.addrsCidr]
        json['dhcpServerAddr'] = self.dhcpServerAddr
        json['dhcpPreferredHostname'] = self.dhcpPreferredHostname
        return json

# structure
class InterfaceIPv6Info(Structure):
    idlType = "net.InterfaceIPv6Info:1.0.0"
    elements = ["enabled", "configMethod", "addrsCidr", "dhcpServerId", "dhcpPreferredHostname", "raManaged", "raOtherConf"]

    def __init__(self, enabled=False, configMethod=None, addrsCidr=[], dhcpServerId="", dhcpPreferredHostname="", raManaged=False, raOtherConf=False):
        if configMethod is None:
            configMethod = raritan.rpc.net.IpConfigMethod.STATIC
        typecheck.is_bool(enabled, AssertionError)
        typecheck.is_enum(configMethod, raritan.rpc.net.IpConfigMethod, AssertionError)
        for x0 in addrsCidr:
            typecheck.is_struct(x0, raritan.rpc.net.IpAddrCidr, AssertionError)
        typecheck.is_string(dhcpServerId, AssertionError)
        typecheck.is_string(dhcpPreferredHostname, AssertionError)
        typecheck.is_bool(raManaged, AssertionError)
        typecheck.is_bool(raOtherConf, AssertionError)

        self.enabled = enabled
        self.configMethod = configMethod
        self.addrsCidr = addrsCidr
        self.dhcpServerId = dhcpServerId
        self.dhcpPreferredHostname = dhcpPreferredHostname
        self.raManaged = raManaged
        self.raOtherConf = raOtherConf

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            enabled = json['enabled'] if 'enabled' in json or not useDefaults else False,
            configMethod = raritan.rpc.net.IpConfigMethod.decode(json['configMethod']) if 'configMethod' in json or not useDefaults else raritan.rpc.net.IpConfigMethod.STATIC,
            addrsCidr = [raritan.rpc.net.IpAddrCidr.decode(x0, agent, useDefaults=useDefaults) for x0 in json['addrsCidr']] if 'addrsCidr' in json or not useDefaults else [],
            dhcpServerId = json['dhcpServerId'] if 'dhcpServerId' in json or not useDefaults else "",
            dhcpPreferredHostname = json['dhcpPreferredHostname'] if 'dhcpPreferredHostname' in json or not useDefaults else "",
            raManaged = json['raManaged'] if 'raManaged' in json or not useDefaults else False,
            raOtherConf = json['raOtherConf'] if 'raOtherConf' in json or not useDefaults else False,
        )
        return obj

    def encode(self):
        json = {}
        json['enabled'] = self.enabled
        json['configMethod'] = raritan.rpc.net.IpConfigMethod.encode(self.configMethod)
        json['addrsCidr'] = [raritan.rpc.net.IpAddrCidr.encode(x0) for x0 in self.addrsCidr]
        json['dhcpServerId'] = self.dhcpServerId
        json['dhcpPreferredHostname'] = self.dhcpPreferredHostname
        json['raManaged'] = self.raManaged
        json['raOtherConf'] = self.raOtherConf
        return json

# structure
class InterfaceSettings(Structure):
    idlType = "net.InterfaceSettings:3.0.0"
    elements = ["enabled", "ipv4", "ipv6"]

    def __init__(self, enabled=False, ipv4=None, ipv6=None):
        if ipv4 is None:
            ipv4 = raritan.rpc.net.InterfaceIpSettings()
        if ipv6 is None:
            ipv6 = raritan.rpc.net.InterfaceIpSettings()
        typecheck.is_bool(enabled, AssertionError)
        typecheck.is_struct(ipv4, raritan.rpc.net.InterfaceIpSettings, AssertionError)
        typecheck.is_struct(ipv6, raritan.rpc.net.InterfaceIpSettings, AssertionError)

        self.enabled = enabled
        self.ipv4 = ipv4
        self.ipv6 = ipv6

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            enabled = json['enabled'] if 'enabled' in json or not useDefaults else False,
            ipv4 = raritan.rpc.net.InterfaceIpSettings.decode(json['ipv4'], agent, useDefaults=useDefaults) if 'ipv4' in json or not useDefaults else raritan.rpc.net.InterfaceIpSettings(),
            ipv6 = raritan.rpc.net.InterfaceIpSettings.decode(json['ipv6'], agent, useDefaults=useDefaults) if 'ipv6' in json or not useDefaults else raritan.rpc.net.InterfaceIpSettings(),
        )
        return obj

    def encode(self):
        json = {}
        json['enabled'] = self.enabled
        json['ipv4'] = raritan.rpc.net.InterfaceIpSettings.encode(self.ipv4)
        json['ipv6'] = raritan.rpc.net.InterfaceIpSettings.encode(self.ipv6)
        return json

# enumeration
class InterfaceType(Enumeration):
    idlType = "net.InterfaceType:1.0.0"
    values = ["ETHERNET", "WLAN", "BRIDGE"]

InterfaceType.ETHERNET = InterfaceType(0)
InterfaceType.WLAN = InterfaceType(1)
InterfaceType.BRIDGE = InterfaceType(2)

# enumeration
class InterfaceOpState(Enumeration):
    idlType = "net.InterfaceOpState:1.0.0"
    values = ["NOT_PRESENT", "DOWN", "NO_LINK", "UP"]

InterfaceOpState.NOT_PRESENT = InterfaceOpState(0)
InterfaceOpState.DOWN = InterfaceOpState(1)
InterfaceOpState.NO_LINK = InterfaceOpState(2)
InterfaceOpState.UP = InterfaceOpState(3)

# structure
class InterfaceInfo(Structure):
    idlType = "net.InterfaceInfo:3.0.0"
    elements = ["name", "label", "type", "enabled", "controllingIfName", "state", "macAddr", "mtu", "ipv4", "ipv6"]

    def __init__(self, name="", label="", type=None, enabled=False, controllingIfName="", state=None, macAddr="", mtu=0, ipv4=None, ipv6=None):
        if type is None:
            type = raritan.rpc.net.InterfaceType.ETHERNET
        if state is None:
            state = raritan.rpc.net.InterfaceOpState.NOT_PRESENT
        if ipv4 is None:
            ipv4 = raritan.rpc.net.InterfaceIPv4Info()
        if ipv6 is None:
            ipv6 = raritan.rpc.net.InterfaceIPv6Info()
        typecheck.is_string(name, AssertionError)
        typecheck.is_string(label, AssertionError)
        typecheck.is_enum(type, raritan.rpc.net.InterfaceType, AssertionError)
        typecheck.is_bool(enabled, AssertionError)
        typecheck.is_string(controllingIfName, AssertionError)
        typecheck.is_enum(state, raritan.rpc.net.InterfaceOpState, AssertionError)
        typecheck.is_string(macAddr, AssertionError)
        typecheck.is_int(mtu, AssertionError)
        typecheck.is_struct(ipv4, raritan.rpc.net.InterfaceIPv4Info, AssertionError)
        typecheck.is_struct(ipv6, raritan.rpc.net.InterfaceIPv6Info, AssertionError)

        self.name = name
        self.label = label
        self.type = type
        self.enabled = enabled
        self.controllingIfName = controllingIfName
        self.state = state
        self.macAddr = macAddr
        self.mtu = mtu
        self.ipv4 = ipv4
        self.ipv6 = ipv6

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            name = json['name'] if 'name' in json or not useDefaults else "",
            label = json['label'] if 'label' in json or not useDefaults else "",
            type = raritan.rpc.net.InterfaceType.decode(json['type']) if 'type' in json or not useDefaults else raritan.rpc.net.InterfaceType.ETHERNET,
            enabled = json['enabled'] if 'enabled' in json or not useDefaults else False,
            controllingIfName = json['controllingIfName'] if 'controllingIfName' in json or not useDefaults else "",
            state = raritan.rpc.net.InterfaceOpState.decode(json['state']) if 'state' in json or not useDefaults else raritan.rpc.net.InterfaceOpState.NOT_PRESENT,
            macAddr = json['macAddr'] if 'macAddr' in json or not useDefaults else "",
            mtu = json['mtu'] if 'mtu' in json or not useDefaults else 0,
            ipv4 = raritan.rpc.net.InterfaceIPv4Info.decode(json['ipv4'], agent, useDefaults=useDefaults) if 'ipv4' in json or not useDefaults else raritan.rpc.net.InterfaceIPv4Info(),
            ipv6 = raritan.rpc.net.InterfaceIPv6Info.decode(json['ipv6'], agent, useDefaults=useDefaults) if 'ipv6' in json or not useDefaults else raritan.rpc.net.InterfaceIPv6Info(),
        )
        return obj

    def encode(self):
        json = {}
        json['name'] = self.name
        json['label'] = self.label
        json['type'] = raritan.rpc.net.InterfaceType.encode(self.type)
        json['enabled'] = self.enabled
        json['controllingIfName'] = self.controllingIfName
        json['state'] = raritan.rpc.net.InterfaceOpState.encode(self.state)
        json['macAddr'] = self.macAddr
        json['mtu'] = self.mtu
        json['ipv4'] = raritan.rpc.net.InterfaceIPv4Info.encode(self.ipv4)
        json['ipv6'] = raritan.rpc.net.InterfaceIPv6Info.encode(self.ipv6)
        return json

# enumeration
class EapOuterAuthMethod(Enumeration):
    idlType = "net.EapOuterAuthMethod:2.0.0"
    values = ["EAP_PEAP", "EAP_TLS"]

EapOuterAuthMethod.EAP_PEAP = EapOuterAuthMethod(0)
EapOuterAuthMethod.EAP_TLS = EapOuterAuthMethod(1)

# enumeration
class EapInnerAuthMethod(Enumeration):
    idlType = "net.EapInnerAuthMethod:2.0.0"
    values = ["INNER_EAP_MSCHAPv2", "INNER_EAP_TLS"]

EapInnerAuthMethod.INNER_EAP_MSCHAPv2 = EapInnerAuthMethod(0)
EapInnerAuthMethod.INNER_EAP_TLS = EapInnerAuthMethod(1)

# enumeration
class EapStatus(Enumeration):
    idlType = "net.EapStatus:1.0.0"
    values = ["EAP_STATUS_DISABLED", "EAP_STATUS_PENDING", "EAP_STATUS_FAILED", "EAP_STATUS_SUCCESS"]

EapStatus.EAP_STATUS_DISABLED = EapStatus(0)
EapStatus.EAP_STATUS_PENDING = EapStatus(1)
EapStatus.EAP_STATUS_FAILED = EapStatus(2)
EapStatus.EAP_STATUS_SUCCESS = EapStatus(3)

# structure
class EapAuthSettings(Structure):
    idlType = "net.EapAuthSettings:3.0.0"
    elements = ["identity", "password", "clearPassword", "clientCertChain", "clientPrivKey", "clearClientPrivKey", "clientPrivKeyPassword", "outerMethod", "innerMethod", "caCertChain", "forceTrustedCert", "allowOffTimeRangeCerts", "allowNotYetValidCertsIfTimeBeforeBuild", "authServerName"]

    def __init__(self, identity="", password="", clearPassword=False, clientCertChain="", clientPrivKey="", clearClientPrivKey=False, clientPrivKeyPassword="", outerMethod=None, innerMethod=None, caCertChain="", forceTrustedCert=False, allowOffTimeRangeCerts=False, allowNotYetValidCertsIfTimeBeforeBuild=False, authServerName=""):
        if outerMethod is None:
            outerMethod = raritan.rpc.net.EapOuterAuthMethod.EAP_PEAP
        if innerMethod is None:
            innerMethod = raritan.rpc.net.EapInnerAuthMethod.INNER_EAP_MSCHAPv2
        typecheck.is_string(identity, AssertionError)
        typecheck.is_string(password, AssertionError)
        typecheck.is_bool(clearPassword, AssertionError)
        typecheck.is_string(clientCertChain, AssertionError)
        typecheck.is_string(clientPrivKey, AssertionError)
        typecheck.is_bool(clearClientPrivKey, AssertionError)
        typecheck.is_string(clientPrivKeyPassword, AssertionError)
        typecheck.is_enum(outerMethod, raritan.rpc.net.EapOuterAuthMethod, AssertionError)
        typecheck.is_enum(innerMethod, raritan.rpc.net.EapInnerAuthMethod, AssertionError)
        typecheck.is_string(caCertChain, AssertionError)
        typecheck.is_bool(forceTrustedCert, AssertionError)
        typecheck.is_bool(allowOffTimeRangeCerts, AssertionError)
        typecheck.is_bool(allowNotYetValidCertsIfTimeBeforeBuild, AssertionError)
        typecheck.is_string(authServerName, AssertionError)

        self.identity = identity
        self.password = password
        self.clearPassword = clearPassword
        self.clientCertChain = clientCertChain
        self.clientPrivKey = clientPrivKey
        self.clearClientPrivKey = clearClientPrivKey
        self.clientPrivKeyPassword = clientPrivKeyPassword
        self.outerMethod = outerMethod
        self.innerMethod = innerMethod
        self.caCertChain = caCertChain
        self.forceTrustedCert = forceTrustedCert
        self.allowOffTimeRangeCerts = allowOffTimeRangeCerts
        self.allowNotYetValidCertsIfTimeBeforeBuild = allowNotYetValidCertsIfTimeBeforeBuild
        self.authServerName = authServerName

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            identity = json['identity'] if 'identity' in json or not useDefaults else "",
            password = json['password'] if 'password' in json or not useDefaults else "",
            clearPassword = json['clearPassword'] if 'clearPassword' in json or not useDefaults else False,
            clientCertChain = json['clientCertChain'] if 'clientCertChain' in json or not useDefaults else "",
            clientPrivKey = json['clientPrivKey'] if 'clientPrivKey' in json or not useDefaults else "",
            clearClientPrivKey = json['clearClientPrivKey'] if 'clearClientPrivKey' in json or not useDefaults else False,
            clientPrivKeyPassword = json['clientPrivKeyPassword'] if 'clientPrivKeyPassword' in json or not useDefaults else "",
            outerMethod = raritan.rpc.net.EapOuterAuthMethod.decode(json['outerMethod']) if 'outerMethod' in json or not useDefaults else raritan.rpc.net.EapOuterAuthMethod.EAP_PEAP,
            innerMethod = raritan.rpc.net.EapInnerAuthMethod.decode(json['innerMethod']) if 'innerMethod' in json or not useDefaults else raritan.rpc.net.EapInnerAuthMethod.INNER_EAP_MSCHAPv2,
            caCertChain = json['caCertChain'] if 'caCertChain' in json or not useDefaults else "",
            forceTrustedCert = json['forceTrustedCert'] if 'forceTrustedCert' in json or not useDefaults else False,
            allowOffTimeRangeCerts = json['allowOffTimeRangeCerts'] if 'allowOffTimeRangeCerts' in json or not useDefaults else False,
            allowNotYetValidCertsIfTimeBeforeBuild = json['allowNotYetValidCertsIfTimeBeforeBuild'] if 'allowNotYetValidCertsIfTimeBeforeBuild' in json or not useDefaults else False,
            authServerName = json['authServerName'] if 'authServerName' in json or not useDefaults else "",
        )
        return obj

    def encode(self):
        json = {}
        json['identity'] = self.identity
        json['password'] = self.password
        json['clearPassword'] = self.clearPassword
        json['clientCertChain'] = self.clientCertChain
        json['clientPrivKey'] = self.clientPrivKey
        json['clearClientPrivKey'] = self.clearClientPrivKey
        json['clientPrivKeyPassword'] = self.clientPrivKeyPassword
        json['outerMethod'] = raritan.rpc.net.EapOuterAuthMethod.encode(self.outerMethod)
        json['innerMethod'] = raritan.rpc.net.EapInnerAuthMethod.encode(self.innerMethod)
        json['caCertChain'] = self.caCertChain
        json['forceTrustedCert'] = self.forceTrustedCert
        json['allowOffTimeRangeCerts'] = self.allowOffTimeRangeCerts
        json['allowNotYetValidCertsIfTimeBeforeBuild'] = self.allowNotYetValidCertsIfTimeBeforeBuild
        json['authServerName'] = self.authServerName
        return json

# enumeration
class EthSpeed(Enumeration):
    idlType = "net.EthSpeed:1.0.0"
    values = ["SPEED_AUTO", "SPEED_MBIT_10", "SPEED_MBIT_100", "SPEED_MBIT_1000"]

EthSpeed.SPEED_AUTO = EthSpeed(0)
EthSpeed.SPEED_MBIT_10 = EthSpeed(1)
EthSpeed.SPEED_MBIT_100 = EthSpeed(2)
EthSpeed.SPEED_MBIT_1000 = EthSpeed(3)

# enumeration
class EthDuplexMode(Enumeration):
    idlType = "net.EthDuplexMode:1.0.0"
    values = ["DUPLEX_MODE_AUTO", "DUPLEX_MODE_HALF", "DUPLEX_MODE_FULL"]

EthDuplexMode.DUPLEX_MODE_AUTO = EthDuplexMode(0)
EthDuplexMode.DUPLEX_MODE_HALF = EthDuplexMode(1)
EthDuplexMode.DUPLEX_MODE_FULL = EthDuplexMode(2)

# enumeration
class EthAuthType(Enumeration):
    idlType = "net.EthAuthType:1.0.0"
    values = ["ETH_AUTH_NONE", "ETH_AUTH_EAP"]

EthAuthType.ETH_AUTH_NONE = EthAuthType(0)
EthAuthType.ETH_AUTH_EAP = EthAuthType(1)

# structure
class EthLinkMode(Structure):
    idlType = "net.EthLinkMode:1.0.0"
    elements = ["speed", "duplexMode"]

    def __init__(self, speed=None, duplexMode=None):
        if speed is None:
            speed = raritan.rpc.net.EthSpeed.SPEED_AUTO
        if duplexMode is None:
            duplexMode = raritan.rpc.net.EthDuplexMode.DUPLEX_MODE_AUTO
        typecheck.is_enum(speed, raritan.rpc.net.EthSpeed, AssertionError)
        typecheck.is_enum(duplexMode, raritan.rpc.net.EthDuplexMode, AssertionError)

        self.speed = speed
        self.duplexMode = duplexMode

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            speed = raritan.rpc.net.EthSpeed.decode(json['speed']) if 'speed' in json or not useDefaults else raritan.rpc.net.EthSpeed.SPEED_AUTO,
            duplexMode = raritan.rpc.net.EthDuplexMode.decode(json['duplexMode']) if 'duplexMode' in json or not useDefaults else raritan.rpc.net.EthDuplexMode.DUPLEX_MODE_AUTO,
        )
        return obj

    def encode(self):
        json = {}
        json['speed'] = raritan.rpc.net.EthSpeed.encode(self.speed)
        json['duplexMode'] = raritan.rpc.net.EthDuplexMode.encode(self.duplexMode)
        return json

# structure
class EthSettings(Structure):
    idlType = "net.EthSettings:4.0.0"
    elements = ["linkMode", "mtu", "authType", "eap", "lldpEnabled"]

    def __init__(self, linkMode=None, mtu=0, authType=None, eap=None, lldpEnabled=False):
        if linkMode is None:
            linkMode = raritan.rpc.net.EthLinkMode()
        if authType is None:
            authType = raritan.rpc.net.EthAuthType.ETH_AUTH_NONE
        if eap is None:
            eap = raritan.rpc.net.EapAuthSettings()
        typecheck.is_struct(linkMode, raritan.rpc.net.EthLinkMode, AssertionError)
        typecheck.is_int(mtu, AssertionError)
        typecheck.is_enum(authType, raritan.rpc.net.EthAuthType, AssertionError)
        typecheck.is_struct(eap, raritan.rpc.net.EapAuthSettings, AssertionError)
        typecheck.is_bool(lldpEnabled, AssertionError)

        self.linkMode = linkMode
        self.mtu = mtu
        self.authType = authType
        self.eap = eap
        self.lldpEnabled = lldpEnabled

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            linkMode = raritan.rpc.net.EthLinkMode.decode(json['linkMode'], agent, useDefaults=useDefaults) if 'linkMode' in json or not useDefaults else raritan.rpc.net.EthLinkMode(),
            mtu = json['mtu'] if 'mtu' in json or not useDefaults else 0,
            authType = raritan.rpc.net.EthAuthType.decode(json['authType']) if 'authType' in json or not useDefaults else raritan.rpc.net.EthAuthType.ETH_AUTH_NONE,
            eap = raritan.rpc.net.EapAuthSettings.decode(json['eap'], agent, useDefaults=useDefaults) if 'eap' in json or not useDefaults else raritan.rpc.net.EapAuthSettings(),
            lldpEnabled = json['lldpEnabled'] if 'lldpEnabled' in json or not useDefaults else False,
        )
        return obj

    def encode(self):
        json = {}
        json['linkMode'] = raritan.rpc.net.EthLinkMode.encode(self.linkMode)
        json['mtu'] = self.mtu
        json['authType'] = raritan.rpc.net.EthAuthType.encode(self.authType)
        json['eap'] = raritan.rpc.net.EapAuthSettings.encode(self.eap)
        json['lldpEnabled'] = self.lldpEnabled
        return json

# structure
class EthInfo(Structure):
    idlType = "net.EthInfo:1.0.1"
    elements = ["eapStatus", "linkMode", "linkModeValid", "autonegEnabled", "linkDetected", "supportedLinkModes"]

    def __init__(self, eapStatus=None, linkMode=None, linkModeValid=False, autonegEnabled=False, linkDetected=False, supportedLinkModes=[]):
        if eapStatus is None:
            eapStatus = raritan.rpc.net.EapStatus.EAP_STATUS_DISABLED
        if linkMode is None:
            linkMode = raritan.rpc.net.EthLinkMode()
        typecheck.is_enum(eapStatus, raritan.rpc.net.EapStatus, AssertionError)
        typecheck.is_struct(linkMode, raritan.rpc.net.EthLinkMode, AssertionError)
        typecheck.is_bool(linkModeValid, AssertionError)
        typecheck.is_bool(autonegEnabled, AssertionError)
        typecheck.is_bool(linkDetected, AssertionError)
        for x0 in supportedLinkModes:
            typecheck.is_struct(x0, raritan.rpc.net.EthLinkMode, AssertionError)

        self.eapStatus = eapStatus
        self.linkMode = linkMode
        self.linkModeValid = linkModeValid
        self.autonegEnabled = autonegEnabled
        self.linkDetected = linkDetected
        self.supportedLinkModes = supportedLinkModes

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            eapStatus = raritan.rpc.net.EapStatus.decode(json['eapStatus']) if 'eapStatus' in json or not useDefaults else raritan.rpc.net.EapStatus.EAP_STATUS_DISABLED,
            linkMode = raritan.rpc.net.EthLinkMode.decode(json['linkMode'], agent, useDefaults=useDefaults) if 'linkMode' in json or not useDefaults else raritan.rpc.net.EthLinkMode(),
            linkModeValid = json['linkModeValid'] if 'linkModeValid' in json or not useDefaults else False,
            autonegEnabled = json['autonegEnabled'] if 'autonegEnabled' in json or not useDefaults else False,
            linkDetected = json['linkDetected'] if 'linkDetected' in json or not useDefaults else False,
            supportedLinkModes = [raritan.rpc.net.EthLinkMode.decode(x0, agent, useDefaults=useDefaults) for x0 in json['supportedLinkModes']] if 'supportedLinkModes' in json or not useDefaults else [],
        )
        return obj

    def encode(self):
        json = {}
        json['eapStatus'] = raritan.rpc.net.EapStatus.encode(self.eapStatus)
        json['linkMode'] = raritan.rpc.net.EthLinkMode.encode(self.linkMode)
        json['linkModeValid'] = self.linkModeValid
        json['autonegEnabled'] = self.autonegEnabled
        json['linkDetected'] = self.linkDetected
        json['supportedLinkModes'] = [raritan.rpc.net.EthLinkMode.encode(x0) for x0 in self.supportedLinkModes]
        return json

# enumeration
class WlanSecProtocol(Enumeration):
    idlType = "net.WlanSecProtocol:1.0.0"
    values = ["WPA2"]

WlanSecProtocol.WPA2 = WlanSecProtocol(0)

# enumeration
class WlanAuthType(Enumeration):
    idlType = "net.WlanAuthType:2.0.0"
    values = ["WLAN_AUTH_NONE", "WLAN_AUTH_PSK", "WLAN_AUTH_EAP"]

WlanAuthType.WLAN_AUTH_NONE = WlanAuthType(0)
WlanAuthType.WLAN_AUTH_PSK = WlanAuthType(1)
WlanAuthType.WLAN_AUTH_EAP = WlanAuthType(2)

# structure
class WlanSettings(Structure):
    idlType = "net.WlanSettings:4.0.0"
    elements = ["enableHT", "ssid", "bssid", "mtu", "secProtocol", "authType", "psk", "clearPsk", "eap"]

    def __init__(self, enableHT=False, ssid="", bssid="", mtu=0, secProtocol=None, authType=None, psk="", clearPsk=False, eap=None):
        if secProtocol is None:
            secProtocol = raritan.rpc.net.WlanSecProtocol.WPA2
        if authType is None:
            authType = raritan.rpc.net.WlanAuthType.WLAN_AUTH_NONE
        if eap is None:
            eap = raritan.rpc.net.EapAuthSettings()
        typecheck.is_bool(enableHT, AssertionError)
        typecheck.is_string(ssid, AssertionError)
        typecheck.is_string(bssid, AssertionError)
        typecheck.is_int(mtu, AssertionError)
        typecheck.is_enum(secProtocol, raritan.rpc.net.WlanSecProtocol, AssertionError)
        typecheck.is_enum(authType, raritan.rpc.net.WlanAuthType, AssertionError)
        typecheck.is_string(psk, AssertionError)
        typecheck.is_bool(clearPsk, AssertionError)
        typecheck.is_struct(eap, raritan.rpc.net.EapAuthSettings, AssertionError)

        self.enableHT = enableHT
        self.ssid = ssid
        self.bssid = bssid
        self.mtu = mtu
        self.secProtocol = secProtocol
        self.authType = authType
        self.psk = psk
        self.clearPsk = clearPsk
        self.eap = eap

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            enableHT = json['enableHT'] if 'enableHT' in json or not useDefaults else False,
            ssid = json['ssid'] if 'ssid' in json or not useDefaults else "",
            bssid = json['bssid'] if 'bssid' in json or not useDefaults else "",
            mtu = json['mtu'] if 'mtu' in json or not useDefaults else 0,
            secProtocol = raritan.rpc.net.WlanSecProtocol.decode(json['secProtocol']) if 'secProtocol' in json or not useDefaults else raritan.rpc.net.WlanSecProtocol.WPA2,
            authType = raritan.rpc.net.WlanAuthType.decode(json['authType']) if 'authType' in json or not useDefaults else raritan.rpc.net.WlanAuthType.WLAN_AUTH_NONE,
            psk = json['psk'] if 'psk' in json or not useDefaults else "",
            clearPsk = json['clearPsk'] if 'clearPsk' in json or not useDefaults else False,
            eap = raritan.rpc.net.EapAuthSettings.decode(json['eap'], agent, useDefaults=useDefaults) if 'eap' in json or not useDefaults else raritan.rpc.net.EapAuthSettings(),
        )
        return obj

    def encode(self):
        json = {}
        json['enableHT'] = self.enableHT
        json['ssid'] = self.ssid
        json['bssid'] = self.bssid
        json['mtu'] = self.mtu
        json['secProtocol'] = raritan.rpc.net.WlanSecProtocol.encode(self.secProtocol)
        json['authType'] = raritan.rpc.net.WlanAuthType.encode(self.authType)
        json['psk'] = self.psk
        json['clearPsk'] = self.clearPsk
        json['eap'] = raritan.rpc.net.EapAuthSettings.encode(self.eap)
        return json

# enumeration
class WlanChannelWidth(Enumeration):
    idlType = "net.WlanChannelWidth:1.0.0"
    values = ["CHANNEL_WIDTH_UNKNOWN", "CHANNEL_WIDTH_20_NO_HT", "CHANNEL_WIDTH_20", "CHANNEL_WIDTH_40", "CHANNEL_WIDTH_80", "CHANNEL_WIDTH_80P80", "CHANNEL_WIDTH_160"]

WlanChannelWidth.CHANNEL_WIDTH_UNKNOWN = WlanChannelWidth(0)
WlanChannelWidth.CHANNEL_WIDTH_20_NO_HT = WlanChannelWidth(1)
WlanChannelWidth.CHANNEL_WIDTH_20 = WlanChannelWidth(2)
WlanChannelWidth.CHANNEL_WIDTH_40 = WlanChannelWidth(3)
WlanChannelWidth.CHANNEL_WIDTH_80 = WlanChannelWidth(4)
WlanChannelWidth.CHANNEL_WIDTH_80P80 = WlanChannelWidth(5)
WlanChannelWidth.CHANNEL_WIDTH_160 = WlanChannelWidth(6)

# structure
class WlanInfo(Structure):
    idlType = "net.WlanInfo:1.0.0"
    elements = ["associated", "ssid", "bssid", "channel", "channelWidth"]

    def __init__(self, associated=False, ssid="", bssid="", channel=0, channelWidth=None):
        if channelWidth is None:
            channelWidth = raritan.rpc.net.WlanChannelWidth.CHANNEL_WIDTH_UNKNOWN
        typecheck.is_bool(associated, AssertionError)
        typecheck.is_string(ssid, AssertionError)
        typecheck.is_string(bssid, AssertionError)
        typecheck.is_int(channel, AssertionError)
        typecheck.is_enum(channelWidth, raritan.rpc.net.WlanChannelWidth, AssertionError)

        self.associated = associated
        self.ssid = ssid
        self.bssid = bssid
        self.channel = channel
        self.channelWidth = channelWidth

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            associated = json['associated'] if 'associated' in json or not useDefaults else False,
            ssid = json['ssid'] if 'ssid' in json or not useDefaults else "",
            bssid = json['bssid'] if 'bssid' in json or not useDefaults else "",
            channel = json['channel'] if 'channel' in json or not useDefaults else 0,
            channelWidth = raritan.rpc.net.WlanChannelWidth.decode(json['channelWidth']) if 'channelWidth' in json or not useDefaults else raritan.rpc.net.WlanChannelWidth.CHANNEL_WIDTH_UNKNOWN,
        )
        return obj

    def encode(self):
        json = {}
        json['associated'] = self.associated
        json['ssid'] = self.ssid
        json['bssid'] = self.bssid
        json['channel'] = self.channel
        json['channelWidth'] = raritan.rpc.net.WlanChannelWidth.encode(self.channelWidth)
        return json

# structure
class Settings(Structure):
    idlType = "net.Settings:5.0.0"
    elements = ["common", "ifMap", "ethMap", "wlanMap"]

    def __init__(self, common=None, ifMap={}, ethMap={}, wlanMap={}):
        if common is None:
            common = raritan.rpc.net.CommonSettings()
        typecheck.is_struct(common, raritan.rpc.net.CommonSettings, AssertionError)

        self.common = common
        self.ifMap = ifMap
        self.ethMap = ethMap
        self.wlanMap = wlanMap

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            common = raritan.rpc.net.CommonSettings.decode(json['common'], agent, useDefaults=useDefaults) if 'common' in json or not useDefaults else raritan.rpc.net.CommonSettings(),
            ifMap = dict([(
                elem['key'],
                raritan.rpc.net.InterfaceSettings.decode(elem['value'], agent, useDefaults=useDefaults))
                for elem in json['ifMap']]) if 'ifMap' in json or not useDefaults else {},
            ethMap = dict([(
                elem['key'],
                raritan.rpc.net.EthSettings.decode(elem['value'], agent, useDefaults=useDefaults))
                for elem in json['ethMap']]) if 'ethMap' in json or not useDefaults else {},
            wlanMap = dict([(
                elem['key'],
                raritan.rpc.net.WlanSettings.decode(elem['value'], agent, useDefaults=useDefaults))
                for elem in json['wlanMap']]) if 'wlanMap' in json or not useDefaults else {},
        )
        return obj

    def encode(self):
        json = {}
        json['common'] = raritan.rpc.net.CommonSettings.encode(self.common)
        json['ifMap'] = [dict(
            key = k,
            value = raritan.rpc.net.InterfaceSettings.encode(v))
            for k, v in self.ifMap.items()]
        json['ethMap'] = [dict(
            key = k,
            value = raritan.rpc.net.EthSettings.encode(v))
            for k, v in self.ethMap.items()]
        json['wlanMap'] = [dict(
            key = k,
            value = raritan.rpc.net.WlanSettings.encode(v))
            for k, v in self.wlanMap.items()]
        return json

# structure
class Info(Structure):
    idlType = "net.Info:3.0.0"
    elements = ["common", "ifMap", "ethMap", "wlanMap"]

    def __init__(self, common=None, ifMap={}, ethMap={}, wlanMap={}):
        if common is None:
            common = raritan.rpc.net.CommonInfo()
        typecheck.is_struct(common, raritan.rpc.net.CommonInfo, AssertionError)

        self.common = common
        self.ifMap = ifMap
        self.ethMap = ethMap
        self.wlanMap = wlanMap

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            common = raritan.rpc.net.CommonInfo.decode(json['common'], agent, useDefaults=useDefaults) if 'common' in json or not useDefaults else raritan.rpc.net.CommonInfo(),
            ifMap = dict([(
                elem['key'],
                raritan.rpc.net.InterfaceInfo.decode(elem['value'], agent, useDefaults=useDefaults))
                for elem in json['ifMap']]) if 'ifMap' in json or not useDefaults else {},
            ethMap = dict([(
                elem['key'],
                raritan.rpc.net.EthInfo.decode(elem['value'], agent, useDefaults=useDefaults))
                for elem in json['ethMap']]) if 'ethMap' in json or not useDefaults else {},
            wlanMap = dict([(
                elem['key'],
                raritan.rpc.net.WlanInfo.decode(elem['value'], agent, useDefaults=useDefaults))
                for elem in json['wlanMap']]) if 'wlanMap' in json or not useDefaults else {},
        )
        return obj

    def encode(self):
        json = {}
        json['common'] = raritan.rpc.net.CommonInfo.encode(self.common)
        json['ifMap'] = [dict(
            key = k,
            value = raritan.rpc.net.InterfaceInfo.encode(v))
            for k, v in self.ifMap.items()]
        json['ethMap'] = [dict(
            key = k,
            value = raritan.rpc.net.EthInfo.encode(v))
            for k, v in self.ethMap.items()]
        json['wlanMap'] = [dict(
            key = k,
            value = raritan.rpc.net.WlanInfo.encode(v))
            for k, v in self.wlanMap.items()]
        return json

# structure
class PortForwardingProtocolMapping(Structure):
    idlType = "net.PortForwardingProtocolMapping:1.0.0"
    elements = ["appProtoId", "appProtoName", "transportProtoName"]

    def __init__(self, appProtoId=0, appProtoName="", transportProtoName=""):
        typecheck.is_int(appProtoId, AssertionError)
        typecheck.is_string(appProtoName, AssertionError)
        typecheck.is_string(transportProtoName, AssertionError)

        self.appProtoId = appProtoId
        self.appProtoName = appProtoName
        self.transportProtoName = transportProtoName

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            appProtoId = json['appProtoId'] if 'appProtoId' in json or not useDefaults else 0,
            appProtoName = json['appProtoName'] if 'appProtoName' in json or not useDefaults else "",
            transportProtoName = json['transportProtoName'] if 'transportProtoName' in json or not useDefaults else "",
        )
        return obj

    def encode(self):
        json = {}
        json['appProtoId'] = self.appProtoId
        json['appProtoName'] = self.appProtoName
        json['transportProtoName'] = self.transportProtoName
        return json

# value object
class CommonInfoChangedEvent(raritan.rpc.idl.Event):
    idlType = "net.CommonInfoChangedEvent:2.0.0"

    def __init__(self, commonInfo=None, source=None):
        super(raritan.rpc.net.CommonInfoChangedEvent, self).__init__(source)
        if commonInfo is None:
            commonInfo = raritan.rpc.net.CommonInfo()
        typecheck.is_struct(commonInfo, raritan.rpc.net.CommonInfo, AssertionError)

        self.commonInfo = commonInfo

    def encode(self):
        json = super(raritan.rpc.net.CommonInfoChangedEvent, self).encode()
        json['commonInfo'] = raritan.rpc.net.CommonInfo.encode(self.commonInfo)
        return json

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            commonInfo = raritan.rpc.net.CommonInfo.decode(json['commonInfo'], agent, useDefaults=useDefaults) if 'commonInfo' in json or not useDefaults else raritan.rpc.net.CommonInfo(),
            # for idl.Event
            source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
        )
        return obj

    def listElements(self):
        elements = ["commonInfo"]
        elements = elements + super(raritan.rpc.net.CommonInfoChangedEvent, self).listElements()
        return elements

# value object
class InterfaceInfoChangedEvent(raritan.rpc.idl.Event):
    idlType = "net.InterfaceInfoChangedEvent:2.0.0"

    def __init__(self, ifInfo=None, source=None):
        super(raritan.rpc.net.InterfaceInfoChangedEvent, self).__init__(source)
        if ifInfo is None:
            ifInfo = raritan.rpc.net.InterfaceInfo()
        typecheck.is_struct(ifInfo, raritan.rpc.net.InterfaceInfo, AssertionError)

        self.ifInfo = ifInfo

    def encode(self):
        json = super(raritan.rpc.net.InterfaceInfoChangedEvent, self).encode()
        json['ifInfo'] = raritan.rpc.net.InterfaceInfo.encode(self.ifInfo)
        return json

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            ifInfo = raritan.rpc.net.InterfaceInfo.decode(json['ifInfo'], agent, useDefaults=useDefaults) if 'ifInfo' in json or not useDefaults else raritan.rpc.net.InterfaceInfo(),
            # for idl.Event
            source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
        )
        return obj

    def listElements(self):
        elements = ["ifInfo"]
        elements = elements + super(raritan.rpc.net.InterfaceInfoChangedEvent, self).listElements()
        return elements

# value object
class EthInfoChangedEvent(raritan.rpc.idl.Event):
    idlType = "net.EthInfoChangedEvent:1.0.1"

    def __init__(self, ifName="", ifLabel="", ethInfo=None, source=None):
        super(raritan.rpc.net.EthInfoChangedEvent, self).__init__(source)
        if ethInfo is None:
            ethInfo = raritan.rpc.net.EthInfo()
        typecheck.is_string(ifName, AssertionError)
        typecheck.is_string(ifLabel, AssertionError)
        typecheck.is_struct(ethInfo, raritan.rpc.net.EthInfo, AssertionError)

        self.ifName = ifName
        self.ifLabel = ifLabel
        self.ethInfo = ethInfo

    def encode(self):
        json = super(raritan.rpc.net.EthInfoChangedEvent, self).encode()
        json['ifName'] = self.ifName
        json['ifLabel'] = self.ifLabel
        json['ethInfo'] = raritan.rpc.net.EthInfo.encode(self.ethInfo)
        return json

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            ifName = json['ifName'] if 'ifName' in json or not useDefaults else "",
            ifLabel = json['ifLabel'] if 'ifLabel' in json or not useDefaults else "",
            ethInfo = raritan.rpc.net.EthInfo.decode(json['ethInfo'], agent, useDefaults=useDefaults) if 'ethInfo' in json or not useDefaults else raritan.rpc.net.EthInfo(),
            # for idl.Event
            source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
        )
        return obj

    def listElements(self):
        elements = ["ifName", "ifLabel", "ethInfo"]
        elements = elements + super(raritan.rpc.net.EthInfoChangedEvent, self).listElements()
        return elements

# value object
class WlanInfoChangedEvent(raritan.rpc.idl.Event):
    idlType = "net.WlanInfoChangedEvent:1.0.0"

    def __init__(self, ifName="", wlanInfo=None, source=None):
        super(raritan.rpc.net.WlanInfoChangedEvent, self).__init__(source)
        if wlanInfo is None:
            wlanInfo = raritan.rpc.net.WlanInfo()
        typecheck.is_string(ifName, AssertionError)
        typecheck.is_struct(wlanInfo, raritan.rpc.net.WlanInfo, AssertionError)

        self.ifName = ifName
        self.wlanInfo = wlanInfo

    def encode(self):
        json = super(raritan.rpc.net.WlanInfoChangedEvent, self).encode()
        json['ifName'] = self.ifName
        json['wlanInfo'] = raritan.rpc.net.WlanInfo.encode(self.wlanInfo)
        return json

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            ifName = json['ifName'] if 'ifName' in json or not useDefaults else "",
            wlanInfo = raritan.rpc.net.WlanInfo.decode(json['wlanInfo'], agent, useDefaults=useDefaults) if 'wlanInfo' in json or not useDefaults else raritan.rpc.net.WlanInfo(),
            # for idl.Event
            source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
        )
        return obj

    def listElements(self):
        elements = ["ifName", "wlanInfo"]
        elements = elements + super(raritan.rpc.net.WlanInfoChangedEvent, self).listElements()
        return elements

# value object
class LinkStateChangedEvent(raritan.rpc.idl.Event):
    idlType = "net.LinkStateChangedEvent:1.0.0"

    def __init__(self, ifName="", ifLabel="", ifType=None, ifState=None, source=None):
        super(raritan.rpc.net.LinkStateChangedEvent, self).__init__(source)
        if ifType is None:
            ifType = raritan.rpc.net.InterfaceType.ETHERNET
        if ifState is None:
            ifState = raritan.rpc.net.InterfaceOpState.NOT_PRESENT
        typecheck.is_string(ifName, AssertionError)
        typecheck.is_string(ifLabel, AssertionError)
        typecheck.is_enum(ifType, raritan.rpc.net.InterfaceType, AssertionError)
        typecheck.is_enum(ifState, raritan.rpc.net.InterfaceOpState, AssertionError)

        self.ifName = ifName
        self.ifLabel = ifLabel
        self.ifType = ifType
        self.ifState = ifState

    def encode(self):
        json = super(raritan.rpc.net.LinkStateChangedEvent, self).encode()
        json['ifName'] = self.ifName
        json['ifLabel'] = self.ifLabel
        json['ifType'] = raritan.rpc.net.InterfaceType.encode(self.ifType)
        json['ifState'] = raritan.rpc.net.InterfaceOpState.encode(self.ifState)
        return json

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            ifName = json['ifName'] if 'ifName' in json or not useDefaults else "",
            ifLabel = json['ifLabel'] if 'ifLabel' in json or not useDefaults else "",
            ifType = raritan.rpc.net.InterfaceType.decode(json['ifType']) if 'ifType' in json or not useDefaults else raritan.rpc.net.InterfaceType.ETHERNET,
            ifState = raritan.rpc.net.InterfaceOpState.decode(json['ifState']) if 'ifState' in json or not useDefaults else raritan.rpc.net.InterfaceOpState.NOT_PRESENT,
            # for idl.Event
            source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
        )
        return obj

    def listElements(self):
        elements = ["ifName", "ifLabel", "ifType", "ifState"]
        elements = elements + super(raritan.rpc.net.LinkStateChangedEvent, self).listElements()
        return elements

# value object
class PortForwardingExpansionUnitPresenceStateChangedEvent(raritan.rpc.idl.Event):
    idlType = "net.PortForwardingExpansionUnitPresenceStateChangedEvent:1.0.0"

    def __init__(self, expansionUnitPresent=False, source=None):
        super(raritan.rpc.net.PortForwardingExpansionUnitPresenceStateChangedEvent, self).__init__(source)
        typecheck.is_bool(expansionUnitPresent, AssertionError)

        self.expansionUnitPresent = expansionUnitPresent

    def encode(self):
        json = super(raritan.rpc.net.PortForwardingExpansionUnitPresenceStateChangedEvent, self).encode()
        json['expansionUnitPresent'] = self.expansionUnitPresent
        return json

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            expansionUnitPresent = json['expansionUnitPresent'] if 'expansionUnitPresent' in json or not useDefaults else False,
            # for idl.Event
            source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
        )
        return obj

    def listElements(self):
        elements = ["expansionUnitPresent"]
        elements = elements + super(raritan.rpc.net.PortForwardingExpansionUnitPresenceStateChangedEvent, self).listElements()
        return elements

# interface
class Net(Interface):
    idlType = "net.Net:7.0.1"

    SUCCESS = 0

    ERR_DNS_TOO_MANY_SERVERS = 100

    ERR_DNS_INVALID_SERVER = 101

    ERR_DNS_TOO_MANY_SEARCH_SUFFIXES = 102

    ERR_DNS_INVALID_SEARCH_SUFFIX = 103

    ERR_ROUTING_IPV4_INVALID_DFLT_GATEWAY_ADDR = 200

    ERR_ROUTING_IPV6_INVALID_DFLT_GATEWAY_ADDR = 201

    ERR_ROUTING_IPV4_INVALID_DEST_ADDR = 202

    ERR_ROUTING_IPV6_INVALID_DEST_ADDR = 203

    ERR_ROUTING_IPV4_INVALID_DEST_PREFIX_LEN = 204

    ERR_ROUTING_IPV6_INVALID_DEST_PREFIX_LEN = 205

    ERR_ROUTING_IPV4_INVALID_NEXTHOP_ADDR = 206

    ERR_ROUTING_IPV6_INVALID_NEXTHOP_ADDR = 207

    ERR_ROUTING_IPV4_INVALID_INTERFACE = 208

    ERR_ROUTING_IPV6_INVALID_INTERFACE = 209

    ERR_ROUTING_IPV4_DEST_IS_NO_NETWORK_ADDR = 210

    ERR_ROUTING_IPV6_DEST_IS_NO_NETWORK_ADDR = 211

    ERR_ROUTING_IPV4_DEST_IS_DUPLICATE = 212

    ERR_ROUTING_IPV6_DEST_IS_DUPLICATE = 213

    ERR_ROUTING_IPV4_NO_NEXTHOP_OR_INTERFACE = 214

    ERR_ROUTING_IPV6_NO_NEXTHOP_OR_INTERFACE = 215

    ERR_ROUTING_IPV4_NEXTHOP_AND_INTERFACE_SET = 216

    ERR_ROUTING_IPV6_NEXTHOP_AND_INTERFACE_SET = 217

    ERR_PF_INVALID_PRIMARY_UNIT_DOWNSTREAM_INTERFACE = 300

    ERR_PF_NO_WORKING_PRIMARY_UNIT_UPSTREAM_INTERFACE = 301

    ERR_PF_NOT_SUPPORTED = 302

    ERR_IF_IPV4_INVALID_CONFIG_METHOD = 400

    ERR_IF_IPV6_INVALID_CONFIG_METHOD = 401

    ERR_IF_IPV4_INVALID_STATIC_ADDR = 402

    ERR_IF_IPV6_INVALID_STATIC_ADDR = 403

    ERR_IF_IPV4_INVALID_STATIC_PREFIX_LEN = 404

    ERR_IF_IPV6_INVALID_STATIC_PREFIX_LEN = 405

    ERR_IF_IPV4_INVALID_DHCP_PREF_HOSTNAME = 406

    ERR_IF_IPV6_INVALID_DHCP_PREF_HOSTNAME = 407

    ERR_IF_EAP_INVALID_IDENTITY = 408

    ERR_IF_EAP_INVALID_PASSWORD = 409

    ERR_IF_EAP_INVALID_CLIENT_CERT = 410

    ERR_IF_EAP_INVALID_CLIENT_PRIV_KEY_OR_PWD = 411

    ERR_IF_EAP_CLIENT_CERT_PRIV_KEY_MISMATCH = 412

    ERR_IF_EAP_INVALID_CA_CERT = 413

    ERR_IF_EAP_CA_CERT_VERIFY_FAILED = 414

    ERR_IF_EAP_INVALID_AUTH_SERVER_NAME = 415

    ERR_ETH_IF_UNSUPPORTED_LINKMODE = 500

    ERR_ETH_IF_INVALID_MTU = 501

    ERR_WLAN_IF_INVALID_SSID = 600

    ERR_WLAN_IF_INVALID_BSSID = 601

    ERR_WLAN_IF_INVALID_PSK = 602

    ERR_WLAN_IF_INVALID_MTU = 603

    ERR_WLAN_IF_NOT_SUPPORTED = 604

    ERR_BRIDGE_IF_NOT_SUPPORTED = 700

    class _getInfo(Interface.Method):
        name = 'getInfo'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.net.Info.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.net.Info, DecodeException)
            return _ret_

    class _getSettings(Interface.Method):
        name = 'getSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.net.Settings.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.net.Settings, DecodeException)
            return _ret_

    class _setSettings(Interface.Method):
        name = 'setSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.net.Settings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.net.Settings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getPortForwardingProtocolMappings(Interface.Method):
        name = 'getPortForwardingProtocolMappings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [raritan.rpc.net.PortForwardingProtocolMapping.decode(x0, agent, useDefaults=useDefaults) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.net.PortForwardingProtocolMapping, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(Net, self).__init__(target, agent)
        self.getInfo = Net._getInfo(self)
        self.getSettings = Net._getSettings(self)
        self.setSettings = Net._setSettings(self)
        self.getPortForwardingProtocolMappings = Net._getPortForwardingProtocolMappings(self)

#
# Section generated by IdlC from "Services.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.net


# structure
class ServiceSettings(Structure):
    idlType = "net.ServiceSettings:1.0.0"
    elements = ["service", "enable", "port"]

    def __init__(self, service="", enable=False, port=0):
        typecheck.is_string(service, AssertionError)
        typecheck.is_bool(enable, AssertionError)
        typecheck.is_int(port, AssertionError)

        self.service = service
        self.enable = enable
        self.port = port

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            service = json['service'] if 'service' in json or not useDefaults else "",
            enable = json['enable'] if 'enable' in json or not useDefaults else False,
            port = json['port'] if 'port' in json or not useDefaults else 0,
        )
        return obj

    def encode(self):
        json = {}
        json['service'] = self.service
        json['enable'] = self.enable
        json['port'] = self.port
        return json

# interface
class Services(Interface):
    idlType = "net.Services:1.0.0"

    ERR_INVALID_PARAMS = 1

    class _getSettings(Interface.Method):
        name = 'getSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            servicesSettings = [raritan.rpc.net.ServiceSettings.decode(x0, agent, useDefaults=useDefaults) for x0 in rsp['servicesSettings']]
            for x0 in servicesSettings:
                typecheck.is_struct(x0, raritan.rpc.net.ServiceSettings, DecodeException)
            return servicesSettings

    class _setSettings(Interface.Method):
        name = 'setSettings'

        @staticmethod
        def encode(servicesSettings):
            for x0 in servicesSettings:
                typecheck.is_struct(x0, raritan.rpc.net.ServiceSettings, AssertionError)
            args = {}
            args['servicesSettings'] = [raritan.rpc.net.ServiceSettings.encode(x0) for x0 in servicesSettings]
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(Services, self).__init__(target, agent)
        self.getSettings = Services._getSettings(self)
        self.setSettings = Services._setSettings(self)
