// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2023 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from AssetStripConfig.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.assetmgrmodel {
  public class AssetStripConfig : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("assetmgrmodel.AssetStripConfig:1.0.0", null);

    public AssetStripConfig(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public AssetStripConfig(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new AssetStripConfig StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new AssetStripConfig(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public enum Events {
      EVT_KEY_SETTINGS_CHANGED,
    }

    public enum ScanMode {
      SCANMODE_DISABLED,
      SCANMODE_BOTH,
    }

    public enum NumberingMode {
      TOP_DOWN,
      BOTTOM_UP,
    }

    public enum Orientation {
      TOP_CONNECTOR,
      BOTTOM_CONNECTOR,
    }

    public enum LEDOperationMode {
      LED_OPERATION_MANUAL,
      LED_OPERATION_AUTO,
    }

    public enum LEDMode {
      LED_MODE_ON,
      LED_MODE_OFF,
      LED_MODE_BLINK_FAST,
      LED_MODE_BLINK_SLOW,
    }

    public class LEDColor : ICloneable {
      public object Clone() {
        LEDColor copy = new LEDColor();
        copy.r = this.r;
        copy.g = this.g;
        copy.b = this.b;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["r"] = this.r;
        json["g"] = this.g;
        json["b"] = this.b;
        return json;
      }

      public static LEDColor Decode(LightJson.JsonObject json, Agent agent) {
        LEDColor inst = new LEDColor();
        inst.r = (int)json["r"];
        inst.g = (int)json["g"];
        inst.b = (int)json["b"];
        return inst;
      }

      public int r = 0;
      public int g = 0;
      public int b = 0;
    }

    public class StripSettings : ICloneable {
      public object Clone() {
        StripSettings copy = new StripSettings();
        copy.rackUnitCount = this.rackUnitCount;
        copy.name = this.name;
        copy.scanMode = this.scanMode;
        copy.defaultColorConnected = this.defaultColorConnected;
        copy.defaultColorDisconnected = this.defaultColorDisconnected;
        copy.numberingMode = this.numberingMode;
        copy.numberingOffset = this.numberingOffset;
        copy.orientation = this.orientation;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["rackUnitCount"] = this.rackUnitCount;
        json["name"] = this.name;
        json["scanMode"] = (int)this.scanMode;
        json["defaultColorConnected"] = this.defaultColorConnected.Encode();
        json["defaultColorDisconnected"] = this.defaultColorDisconnected.Encode();
        json["numberingMode"] = (int)this.numberingMode;
        json["numberingOffset"] = this.numberingOffset;
        json["orientation"] = (int)this.orientation;
        return json;
      }

      public static StripSettings Decode(LightJson.JsonObject json, Agent agent) {
        StripSettings inst = new StripSettings();
        inst.rackUnitCount = (int)json["rackUnitCount"];
        inst.name = (string)json["name"];
        inst.scanMode = (Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.ScanMode)(int)json["scanMode"];
        inst.defaultColorConnected = Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.LEDColor.Decode(json["defaultColorConnected"], agent);
        inst.defaultColorDisconnected = Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.LEDColor.Decode(json["defaultColorDisconnected"], agent);
        inst.numberingMode = (Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.NumberingMode)(int)json["numberingMode"];
        inst.numberingOffset = (int)json["numberingOffset"];
        inst.orientation = (Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.Orientation)(int)json["orientation"];
        return inst;
      }

      public int rackUnitCount = 0;
      public string name = "";
      public Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.ScanMode scanMode = Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.ScanMode.SCANMODE_DISABLED;
      public Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.LEDColor defaultColorConnected = new Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.LEDColor();
      public Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.LEDColor defaultColorDisconnected = new Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.LEDColor();
      public Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.NumberingMode numberingMode = Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.NumberingMode.TOP_DOWN;
      public int numberingOffset = 0;
      public Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.Orientation orientation = Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.Orientation.TOP_CONNECTOR;
    }

    public class RackUnitSettings : ICloneable {
      public object Clone() {
        RackUnitSettings copy = new RackUnitSettings();
        copy.opmode = this.opmode;
        copy.mode = this.mode;
        copy.color = this.color;
        copy.name = this.name;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["opmode"] = (int)this.opmode;
        json["mode"] = (int)this.mode;
        json["color"] = this.color.Encode();
        json["name"] = this.name;
        return json;
      }

      public static RackUnitSettings Decode(LightJson.JsonObject json, Agent agent) {
        RackUnitSettings inst = new RackUnitSettings();
        inst.opmode = (Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.LEDOperationMode)(int)json["opmode"];
        inst.mode = (Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.LEDMode)(int)json["mode"];
        inst.color = Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.LEDColor.Decode(json["color"], agent);
        inst.name = (string)json["name"];
        return inst;
      }

      public Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.LEDOperationMode opmode = Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.LEDOperationMode.LED_OPERATION_MANUAL;
      public Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.LEDMode mode = Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.LEDMode.LED_MODE_ON;
      public Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.LEDColor color = new Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.LEDColor();
      public string name = "";
    }

    public class GetStripSettingsResult {
      public Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.StripSettings _ret_;
    }

    public GetStripSettingsResult getStripSettings() {
      JsonObject _parameters = null;
      var _result = RpcCall("getStripSettings", _parameters);
      var _ret = new GetStripSettingsResult();
      _ret._ret_ = Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.StripSettings.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getStripSettings(AsyncRpcResponse<GetStripSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getStripSettings(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getStripSettings(AsyncRpcResponse<GetStripSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getStripSettings", _parameters,
        _result => {
          try {
            var _ret = new GetStripSettingsResult();
            _ret._ret_ = Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.StripSettings.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetStripSettingsResult {
      public int _ret_;
    }

    public SetStripSettingsResult setStripSettings(Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.StripSettings settings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["settings"] = settings.Encode();

      var _result = RpcCall("setStripSettings", _parameters);
      var _ret = new SetStripSettingsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setStripSettings(Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.StripSettings settings, AsyncRpcResponse<SetStripSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setStripSettings(settings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setStripSettings(Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.StripSettings settings, AsyncRpcResponse<SetStripSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["settings"] = settings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setStripSettings", _parameters,
        _result => {
          try {
            var _ret = new SetStripSettingsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetRackUnitSettingsResult {
      public int _ret_;
      public Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.RackUnitSettings settings;
    }

    public GetRackUnitSettingsResult getRackUnitSettings(int rackUnitNumber) {
      var _parameters = new LightJson.JsonObject();
      _parameters["rackUnitNumber"] = rackUnitNumber;

      var _result = RpcCall("getRackUnitSettings", _parameters);
      var _ret = new GetRackUnitSettingsResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.settings = Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.RackUnitSettings.Decode(_result["settings"], agent);
      return _ret;
    }

    public AsyncRequest getRackUnitSettings(int rackUnitNumber, AsyncRpcResponse<GetRackUnitSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getRackUnitSettings(rackUnitNumber, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getRackUnitSettings(int rackUnitNumber, AsyncRpcResponse<GetRackUnitSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["rackUnitNumber"] = rackUnitNumber;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("getRackUnitSettings", _parameters,
        _result => {
          try {
            var _ret = new GetRackUnitSettingsResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.settings = Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.RackUnitSettings.Decode(_result["settings"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetAllRackUnitSettingsResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.RackUnitSettings> _ret_;
    }

    public GetAllRackUnitSettingsResult getAllRackUnitSettings() {
      JsonObject _parameters = null;
      var _result = RpcCall("getAllRackUnitSettings", _parameters);
      var _ret = new GetAllRackUnitSettingsResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.RackUnitSettings>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.RackUnitSettings.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest getAllRackUnitSettings(AsyncRpcResponse<GetAllRackUnitSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getAllRackUnitSettings(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getAllRackUnitSettings(AsyncRpcResponse<GetAllRackUnitSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getAllRackUnitSettings", _parameters,
        _result => {
          try {
            var _ret = new GetAllRackUnitSettingsResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.RackUnitSettings>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.RackUnitSettings.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetRackUnitSettingsResult {
      public int _ret_;
    }

    public SetRackUnitSettingsResult setRackUnitSettings(int rackUnitNumber, Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.RackUnitSettings settings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["rackUnitNumber"] = rackUnitNumber;
      _parameters["settings"] = settings.Encode();

      var _result = RpcCall("setRackUnitSettings", _parameters);
      var _ret = new SetRackUnitSettingsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setRackUnitSettings(int rackUnitNumber, Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.RackUnitSettings settings, AsyncRpcResponse<SetRackUnitSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setRackUnitSettings(rackUnitNumber, settings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setRackUnitSettings(int rackUnitNumber, Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.RackUnitSettings settings, AsyncRpcResponse<SetRackUnitSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["rackUnitNumber"] = rackUnitNumber;
        _parameters["settings"] = settings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setRackUnitSettings", _parameters,
        _result => {
          try {
            var _ret = new SetRackUnitSettingsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetMultipleRackUnitSettingsResult {
      public int _ret_;
    }

    public SetMultipleRackUnitSettingsResult setMultipleRackUnitSettings(System.Collections.Generic.IDictionary<int, Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.RackUnitSettings> settings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["settings"] = new JsonArray(settings.Select(_entry => (JsonValue) new JsonObject(new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<string, LightJson.JsonValue>> {
        new System.Collections.Generic.KeyValuePair<string, JsonValue>("key", _entry.Key),
        new System.Collections.Generic.KeyValuePair<string, JsonValue>("value", _entry.Value.Encode())
      })));

      var _result = RpcCall("setMultipleRackUnitSettings", _parameters);
      var _ret = new SetMultipleRackUnitSettingsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setMultipleRackUnitSettings(System.Collections.Generic.IDictionary<int, Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.RackUnitSettings> settings, AsyncRpcResponse<SetMultipleRackUnitSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setMultipleRackUnitSettings(settings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setMultipleRackUnitSettings(System.Collections.Generic.IDictionary<int, Com.Raritan.Idl.assetmgrmodel.AssetStripConfig.RackUnitSettings> settings, AsyncRpcResponse<SetMultipleRackUnitSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["settings"] = new JsonArray(settings.Select(_entry => (JsonValue) new JsonObject(new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<string, LightJson.JsonValue>> {
          new System.Collections.Generic.KeyValuePair<string, JsonValue>("key", _entry.Key),
          new System.Collections.Generic.KeyValuePair<string, JsonValue>("value", _entry.Value.Encode())
        })));
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setMultipleRackUnitSettings", _parameters,
        _result => {
          try {
            var _ret = new SetMultipleRackUnitSettingsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
