% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update-input.R
\name{updateActionButton}
\alias{updateActionButton}
\title{Change the label or icon of an action button on the client}
\usage{
updateActionButton(session, inputId, label = NULL, icon = NULL)
}
\arguments{
\item{session}{The \code{session} object passed to function given to
\code{shinyServer}.}

\item{inputId}{The id of the input object.}

\item{label}{The label to set for the input object.}

\item{icon}{The icon to set for the input object. To remove the
current icon, use \code{icon=character(0)}.}
}
\description{
Change the label or icon of an action button on the client
}
\details{
The input updater functions send a message to the client, telling it to
change the settings of an input object. The messages are collected and sent
after all the observers (including outputs) have finished running.

The syntax of these functions is similar to the functions that created the
inputs in the first place. For example, \code{\link{numericInput}()} and
\code{updateNumericInput()} take a similar set of arguments.

Any arguments with NULL values will be ignored; they will not result in any
changes to the input object on the client.

For \code{\link{radioButtons}()}, \code{\link{checkboxGroupInput}()} and
\code{\link{selectInput}()}, the set of choices can be cleared by using
\code{choices=character(0)}. Similarly, for these inputs, the selected item
can be cleared by using \code{selected=character(0)}.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

ui <- fluidPage(
  actionButton("update", "Update other buttons"),
  br(),
  actionButton("goButton", "Go"),
  br(),
  actionButton("goButton2", "Go 2", icon = icon("area-chart")),
  br(),
  actionButton("goButton3", "Go 3")
)

server <- function(input, output, session) {
  observe({
    req(input$update)

    # Updates goButton's label and icon
    updateActionButton(session, "goButton",
      label = "New label",
      icon = icon("calendar"))

    # Leaves goButton2's label unchaged and
    # removes its icon
    updateActionButton(session, "goButton2",
      icon = character(0))

    # Leaves goButton3's icon, if it exists,
    # unchaged and changes its label
    updateActionButton(session, "goButton3",
      label = "New label 3")
  })
}

shinyApp(ui, server)
}
}
\seealso{
\code{\link[=actionButton]{actionButton()}}
}
