% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{methods}
\name{dbIsValid}
\alias{dbIsValid}
\alias{dbIsValid,SQLiteConnection-method}
\alias{dbIsValid,SQLiteDriver-method}
\alias{dbIsValid,SQLiteResult-method}
\alias{isIdCurrent}
\title{Check whether an SQLite object is valid or not.}
\usage{
\S4method{dbIsValid}{SQLiteDriver}(dbObj)

\S4method{dbIsValid}{SQLiteConnection}(dbObj)

\S4method{dbIsValid}{SQLiteResult}(dbObj)

isIdCurrent(obj)
}
\arguments{
\item{dbObj,obj}{A driver, connection or result.}
}
\value{
A logical scalar.
}
\description{
Support function that verifies that the holding a reference to a
foreign object is still valid for communicating with the RDBMS
}
\examples{
dbIsValid(SQLite())

con <- dbConnect(SQLite())
dbIsValid(con)

dbDisconnect(con)
dbIsValid(con)
}

