% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ids_with_token.R, R/with_id.R
\name{ids_with_token}
\alias{ids_with_token}
\alias{with_id}
\title{Get parsed IDs by token}
\usage{
ids_with_token(source_expression, value, fun = `==`)

with_id(source_expression, id)
}
\arguments{
\item{source_expression}{A list of source expressions, the result of a call to \code{\link[=get_source_expressions]{get_source_expressions()}},
for the desired filename.}

\item{value}{Character. String corresponding to the token to search for.
For example:
\itemize{
\item "SYMBOL"
\item "FUNCTION"
\item "EQ_FORMALS"
\item "$"
\item "("
}}

\item{fun}{For additional flexibility, a function to search for in
the \code{token} column of \code{parsed_content}. Typically \code{==} or \code{\%in\%}.}

\item{id}{Integer. The index corresponding to the desired row
of \code{parsed_content}.}
}
\value{
\code{ids_with_token}: The indices of the \code{parsed_content} data frame
entry of the list of source expressions. Indices correspond to the
\emph{rows} where \code{fun} evaluates to \code{TRUE} for the \code{value} in the \emph{token} column.

\code{with_id}: A data frame corresponding to the row(s) specified in \code{id}.
}
\description{
Gets the source IDs (row indices) corresponding to given token.
}
\section{Functions}{
\itemize{
\item \code{with_id()}: Return the row of the \code{parsed_content} entry of the \verb{[get_source_expressions]()} object. Typically used in
conjunction with \code{ids_with_token} to iterate over rows containing desired tokens.

}}
\examples{
tmp <- tempfile()
writeLines(c("x <- 1", "y <- x + 1"), tmp)
source_exprs <- get_source_expressions(tmp)
ids_with_token(source_exprs$expressions[[1L]], value = "SYMBOL")
with_id(source_exprs$expressions[[1L]], 2L)
unlink(tmp)

}
