% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgr.R
\name{cgr}
\alias{cgr}
\title{Chaos Game Representation Object}
\usage{
cgr(data, seq.base = row.names(table(data)), sf = F, res = 100)
}
\arguments{
\item{data}{Input as list/vector of characters from fasta file or similar}

\item{seq.base}{By default the included unique elements in data will be used
   in alphabetical order. It is also possible to define the alphabet
   explicitly.\cr
   Predefined alphabets can be used as well:\cr
\itemize{
   \item "digits": numbers from 0 to 9
   \item "AMINO": alphabetical order of the amino acids in capital letters
   \item "amino": alphabetical order of the amino acids in lowercase letters
   \item "DNA": the four bases of DNA ("A","G","T","C") in capital letters
   \item "dna": the four bases of DNA ("a","g","t","c") in lowercase letters
   \item "LETTERS": The alphabetical order of capital letters from A to Z
   \item "letters": The alphabetical order of lowercase Letters from a to z
}}

\item{sf}{By default, the scaling factor for fractal polygons is used; the
scaling factor can also explicitly set to values between 0 and 1.}

\item{res}{resolution of the frequency matrix}
}
\value{
CGR object as list of:
\itemize{
    \item matrix: frequency matrix with given resolution
    \item x: x-coordinates for the CGR
    \item y: y-coordinates for the CGR
    \item sf: applied scaling factor for the CGR
    \item res: applied resolution to calculate the FCGR
    \item base.seq: chars or letters to build the edges of the CGR
}
}
\description{
Chaos Game Representation Object
}
\details{
This function produces a chaos game representation (CGR)
   object from a sequence (data)
}
\examples{
###HIV data
data("HIV")

### encoding the sequence
HIV.cgr = cgr(HIV, res = 100)

###plot the sequence
cgr.plot(HIV.cgr, mode = "points")

###plot the FCGR
cgr.plot(HIV.cgr, mode = "matrix")

###change the resolution of matrix from 100x100 to 200x200
cgr.res(HIV.cgr, 200)

### get the FCGR encoded vector
vectorize(HIV.cgr)


}
