% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/httpuv.R
\docType{data}
\name{WebSocket}
\alias{WebSocket}
\title{WebSocket class}
\description{
A \code{WebSocket} object represents a single WebSocket connection. The
object can be used to send messages and close the connection, and to receive
notifications when messages are received or the connection is closed.
}
\details{
Note that this WebSocket class is different from the one provided by the
package named websocket. This class is meant to be used on the server side,
whereas the one in the websocket package is to be used as a client. The
WebSocket class in httpuv has an older API than the one in the websocket
package.

WebSocket objects should never be created directly. They are obtained by
passing an \code{onWSOpen} function to \code{\link{startServer}}.
}
\section{Fields}{


  \describe{
    \item{\code{request}}{
      The Rook request environment that opened the connection. This can be
      used to inspect HTTP headers, for example.
    }
  }
}

\section{Methods}{


  \describe{
    \item{\code{onMessage(func)}}{
      Registers a callback function that will be invoked whenever a message
      is received on this connection. The callback function will be invoked
      with two arguments. The first argument is \code{TRUE} if the message
      is binary and \code{FALSE} if it is text. The second argument is either
      a raw vector (if the message is binary) or a character vector.
    }
    \item{\code{onClose(func)}}{
      Registers a callback function that will be invoked when the connection
      is closed.
    }
    \item{\code{send(message)}}{
      Begins sending the given message over the websocket. The message must
      be either a raw vector, or a single-element character vector that is
      encoded in UTF-8.
    }
    \item{\code{close()}}{
      Closes the websocket connection.
    }
  }
}

\keyword{datasets}
