% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide-axis-logticks.R
\name{guide_axis_logticks}
\alias{guide_axis_logticks}
\title{Axis with logarithmic tick marks}
\usage{
guide_axis_logticks(
  long = 2.25,
  mid = 1.5,
  short = 0.75,
  prescale.base = NULL,
  negative.small = 0.1,
  short.theme = element_line(),
  expanded = TRUE,
  cap = "none",
  theme = NULL,
  prescale_base = deprecated(),
  negative_small = deprecated(),
  short_theme = deprecated(),
  ...
)
}
\arguments{
\item{long, mid, short}{A \code{\link[grid:unit]{grid::unit()}} object or \code{\link[=rel]{rel()}} object setting
the (relative) length of the long, middle and short ticks. Numeric values
are interpreted as \code{\link[=rel]{rel()}} objects. The \code{\link[=rel]{rel()}} values are used to multiply
values of the \code{axis.ticks.length} theme setting.}

\item{prescale.base}{Base of logarithm used to transform data manually. The
default, \code{NULL}, will use the scale transformation to calculate positions.
Only set \code{prescale.base} if the data has already been log-transformed.
When using a log-transform in the position scale or in \code{coord_trans()},
keep the default \code{NULL} argument.}

\item{negative.small}{When the scale limits include 0 or negative numbers,
what should be the smallest absolute value that is marked with a tick?}

\item{short.theme}{A theme \link[=element_line]{element} for customising the
display of the shortest ticks. Must be a line or blank element, and
it inherits from the \code{axis.minor.ticks} setting for the relevant position.}

\item{expanded}{Whether the ticks should cover the range after scale
expansion (\code{TRUE}, default), or be restricted to the scale limits
(\code{FALSE}).}

\item{cap}{A \code{character} to cut the axis line back to the last breaks. Can
be \code{"none"} (default) to draw the axis line along the whole panel, or
\code{"upper"} and \code{"lower"} to draw the axis to the upper or lower break, or
\code{"both"} to only draw the line in between the most extreme breaks. \code{TRUE}
and \code{FALSE} are shorthand for \code{"both"} and \code{"none"} respectively.}

\item{theme}{A \code{\link[=theme]{theme}} object to style the guide individually or
differently from the plot's theme settings. The \code{theme} argument in the
guide overrides, and is combined with, the plot's theme.}

\item{prescale_base, negative_small, short_theme}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{...}{
  Arguments passed on to \code{\link[=guide_axis]{guide_axis}}
  \describe{
    \item{\code{check.overlap}}{silently remove overlapping labels,
(recursively) prioritizing the first, last, and middle labels.}
    \item{\code{angle}}{Compared to setting the angle in \code{\link[=theme]{theme()}} / \code{\link[=element_text]{element_text()}},
this also uses some heuristics to automatically pick the \code{hjust} and \code{vjust} that
you probably want. Can be one of the following:
\itemize{
\item \code{NULL} to take the angles and \code{hjust}/\code{vjust} directly from the theme.
\item \code{waiver()} to allow reasonable defaults in special cases.
\item A number representing the text angle in degrees.
}}
    \item{\code{n.dodge}}{The number of rows (for vertical axes) or columns (for
horizontal axes) that should be used to render the labels. This is
useful for displaying labels that would otherwise overlap.}
    \item{\code{order}}{A positive \code{integer} of length 1 that specifies the order of
this guide among multiple guides. This controls in which order guides are
merged if there are multiple guides for the same position. If 0 (default),
the order is determined by a secret algorithm.}
    \item{\code{position}}{Where this guide should be drawn: one of top, bottom,
left, or right.}
    \item{\code{title}}{A character string or expression indicating a title of guide.
If \code{NULL}, the title is not shown. By default
(\code{\link[=waiver]{waiver()}}), the name of the scale object or the name
specified in \code{\link[=labs]{labs()}} is used for the title.}
  }}
}
\description{
This axis guide replaces the placement of ticks marks at intervals in
log10 space.
}
\examples{
# A standard plot
p <- ggplot(msleep, aes(bodywt, brainwt)) +
  geom_point(na.rm = TRUE)

# The logticks axis works well with log scales
p + scale_x_log10(guide = "axis_logticks") +
  scale_y_log10(guide = "axis_logticks")

# Or with log-transformed coordinates
p + coord_trans(x = "log10", y = "log10") +
  guides(x = "axis_logticks", y = "axis_logticks")

# When data is transformed manually, one should provide `prescale.base`
# Keep in mind that this axis uses log10 space for placement, not log2
p + aes(x = log2(bodywt), y = log10(brainwt)) +
  guides(
    x = guide_axis_logticks(prescale.base = 2),
    y = guide_axis_logticks(prescale.base = 10)
  )

# A plot with both positive and negative extremes, pseudo-log transformed
set.seed(42)
p2 <- ggplot(data.frame(x = rcauchy(1000)), aes(x = x)) +
  geom_density() +
  scale_x_continuous(
    breaks = c(-10^(4:0), 0, 10^(0:4)),
    transform = "pseudo_log"
  )

# The log ticks are mirrored when 0 is included
p2 + guides(x = "axis_logticks")

# To control the tick density around 0, one can set `negative.small`
p2 + guides(x = guide_axis_logticks(negative.small = 1))
}
