% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verbs.R
\name{verb-PATCH}
\alias{verb-PATCH}
\title{HTTP verb info: PATCH}
\description{
The PATCH method is used to apply partial modifications to a resource.
}
\section{The PATCH method}{

The PATCH method requests that a set of changes described in the
request entity be applied to the resource identified by the Request-
URI.  The set of changes is represented in a format called a "patch
document" identified by a media type.  If the Request-URI does not
point to an existing resource, the server MAY create a new resource,
depending on the patch document type (whether it can logically modify
a null resource) and permissions, etc.
}

\examples{
\dontrun{
x <- HttpClient$new(url = "https://hb.opencpu.org")
x$patch(path = 'patch', body = list(hello = "mars"))
}

}
\references{
\url{https://datatracker.ietf.org/doc/html/rfc5789}
}
\seealso{
\link{crul-package}

Other verbs: 
\code{\link{verb-DELETE}},
\code{\link{verb-GET}},
\code{\link{verb-HEAD}},
\code{\link{verb-POST}},
\code{\link{verb-PUT}}
}
\concept{verbs}
