% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchQuery.R
\name{batchQuery}
\alias{batchQuery}
\title{Manually query the BatchJobs database}
\usage{
batchQuery(reg, query, flags = "ro")
}
\arguments{
\item{reg}{[\code{\link{Registry}}]\cr
Registry.}

\item{query}{[\code{character(1)}]\cr
SQL query to send to the database.}

\item{flags}{[\code{character(1)}]\cr
One of \dQuote{ro}, \dQuote{rw} or \dQuote{rwc} which is translated
to \code{SQLITE_RO}, \code{SQLITE_RW} or \code{SQLITE_RWC}, respectively.
See \link[RSQLite]{SQLITE_RO} for more info.}
}
\value{
[\code{data.frame}] Result of the query.
}
\description{
Manually query the BatchJobs database
}
\examples{
reg = makeRegistry("test", file.dir = tempfile())
batchMap(reg, identity, i = 1:10)
batchQuery(reg, "SELECT * FROM test_job_status")
}
