% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-profiles.R
\name{pivot_wider_profile}
\alias{pivot_wider_profile}
\title{Pivot a data frame to wider and convert it to matrix}
\usage{
pivot_wider_profile(
  data,
  id_cols,
  names_from,
  values_from,
  values_fill = NA,
  to_matrix = FALSE,
  to_sparse = FALSE,
  ...
)
}
\arguments{
\item{data}{A data frame to pivot.}

\item{id_cols}{<\code{\link[tidyr:tidyr_tidy_select]{tidy-select}}> A set of columns that
uniquely identify each observation. Typically used when you have
redundant variables, i.e. variables whose values are perfectly correlated
with existing variables.

Defaults to all columns in \code{data} except for the columns specified through
\code{names_from} and \code{values_from}. If a tidyselect expression is supplied, it
will be evaluated on \code{data} after removing the columns specified through
\code{names_from} and \code{values_from}.}

\item{names_from, values_from}{<\code{\link[tidyr:tidyr_tidy_select]{tidy-select}}> A pair of
arguments describing which column (or columns) to get the name of the
output column (\code{names_from}), and which column (or columns) to get the
cell values from (\code{values_from}).

If \code{values_from} contains multiple values, the value will be added to the
front of the output column.}

\item{values_fill}{Optionally, a (scalar) value that specifies what each
\code{value} should be filled in with when missing.

This can be a named list if you want to apply different fill values to
different value columns.}

\item{to_matrix}{Logical value indicating if the result should be a matrix.
Parameter is ignored in case \code{sparse} is \code{TRUE}.}

\item{to_sparse}{Logical value indicating whether the resulting matrix
should be sparse or not.}

\item{...}{Additional arguments passed on to methods.}
}
\value{
"widened" data; it is increasing the number of columns and
decreasing the number of rows.
}
\description{
Generates a kind of table where the rows come from \code{id_cols},
the columns from \code{names_from} and the values from \code{values_from}.
}
\details{
In the current state of the function, to ensure its operation,
the \code{id_cols} parameter is a single selector.
}
\examples{
\dontrun{
df <- tibble::tibble(
    tf = c("tf_1", "tf_1", "tf_2", "tf_2"),
    gene = c("gene_1", "gene_2", "gene_1", "gene_2"),
    mor = c(1, -1, 1, -1)
)

# Return a tibble
pivot_wider_profile(
    data = df,
    id_cols = tf,
    names_from = gene,
    values_from = mor
)

# Return a matrix
pivot_wider_profile(
    data = df,
    id_cols = tf,
    names_from = gene,
    values_from = mor,
    to_matrix = TRUE
)
# Return a sparse Matrix of class "dgCMatrix"
pivot_wider_profile(
    data = df,
    id_cols = tf,
    names_from = gene,
    values_from = mor,
    to_sparse = TRUE
)
}
}
\keyword{internal}
