/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.haha.trove;

import com.squareup.haha.trove.PrimeFinder;

public abstract class THash
implements Cloneable {
    private transient int _size;
    private transient int _free;
    private transient int _deadkeys;
    private float _loadFactor = 0.8f;
    private int _maxSize;

    public THash() {
        this(4, 0.8f);
    }

    private THash(int initialCapacity, float loadFactor) {
        this.setUp(6);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean isEmpty() {
        return this._size == 0;
    }

    public int size() {
        return this._size;
    }

    protected abstract int capacity();

    public final void ensureCapacity(int desiredCapacity) {
        if (desiredCapacity > this._maxSize - this.size()) {
            this.rehash(PrimeFinder.nextPrime((int)((float)desiredCapacity + (float)this.size() / this._loadFactor) + 2));
            this.computeMaxSize(this.capacity());
        }
    }

    protected void removeAt(int index) {
        --this._size;
        ++this._deadkeys;
        THash tHash = this;
        if (tHash._deadkeys > tHash._size && tHash.capacity() > 42) {
            THash tHash2 = tHash;
            tHash2.rehash(PrimeFinder.nextPrime((int)((float)tHash2.size() / tHash2._loadFactor) + 2));
            tHash2.computeMaxSize(tHash2.capacity());
        }
    }

    public final void stopCompactingOnRemove() {
        if (this._deadkeys < 0) {
            throw new IllegalStateException("Unpaired stop/startCompactingOnRemove");
        }
        this._deadkeys -= this.capacity();
    }

    public final void startCompactingOnRemove(boolean compact) {
        if (this._deadkeys >= 0) {
            throw new IllegalStateException("Unpaired stop/startCompactingOnRemove");
        }
        this._deadkeys += this.capacity();
    }

    public void clear() {
        this._size = 0;
        this._free = this.capacity();
        this._deadkeys = 0;
    }

    protected int setUp(int initialCapacity) {
        int capacity = PrimeFinder.nextPrime(initialCapacity);
        this.computeMaxSize(capacity);
        return capacity;
    }

    protected abstract void rehash(int var1);

    private void computeMaxSize(int capacity) {
        this._maxSize = Math.min(capacity - 1, (int)((float)capacity * this._loadFactor));
        this._free = capacity - this._size;
        this._deadkeys = 0;
    }

    protected final void postInsertHook(boolean usedFreeSlot) {
        if (usedFreeSlot) {
            --this._free;
        } else {
            --this._deadkeys;
        }
        if (++this._size > this._maxSize || this._free == 0) {
            THash tHash = this;
            this.rehash(PrimeFinder.nextPrime(tHash.capacity() << 1));
            this.computeMaxSize(this.capacity());
        }
    }
}

