/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.haha.guava.collect;

import com.squareup.haha.guava.base.Ascii;
import com.squareup.haha.guava.collect.DescendingImmutableSortedSet;
import com.squareup.haha.guava.collect.EmptyImmutableSortedSet;
import com.squareup.haha.guava.collect.ImmutableSortedSetFauxverideShim;
import com.squareup.haha.guava.collect.Iterators;
import com.squareup.haha.guava.collect.Ordering;
import com.squareup.haha.guava.collect.SortedIterable;
import com.squareup.haha.guava.collect.UnmodifiableIterator;
import java.util.Comparator;
import java.util.NavigableSet;

public abstract class ImmutableSortedSet<E>
extends ImmutableSortedSetFauxverideShim<E>
implements SortedIterable<E>,
NavigableSet<E> {
    private static final Comparator<Comparable> NATURAL_ORDER = Ordering.natural();
    private static final ImmutableSortedSet<Comparable> NATURAL_EMPTY_SET = new EmptyImmutableSortedSet<Comparable>(NATURAL_ORDER);
    final transient Comparator<? super E> comparator;
    private transient ImmutableSortedSet<E> descendingSet;

    static <E> ImmutableSortedSet<E> emptySet(Comparator<? super E> comparator) {
        if (NATURAL_ORDER.equals(comparator)) {
            return NATURAL_EMPTY_SET;
        }
        return new EmptyImmutableSortedSet<E>(comparator);
    }

    ImmutableSortedSet(Comparator<? super E> comparator) {
        this.comparator = comparator;
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    @Override
    public final ImmutableSortedSet<E> headSet(E toElement, boolean inclusive) {
        return this.headSetImpl(Ascii.checkNotNull(toElement), inclusive);
    }

    @Override
    public final ImmutableSortedSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        Ascii.checkNotNull(fromElement);
        Ascii.checkNotNull(toElement);
        Ascii.checkArgument(this.comparator.compare(fromElement, toElement) <= 0);
        return this.subSetImpl(fromElement, fromInclusive, toElement, toInclusive);
    }

    @Override
    public final ImmutableSortedSet<E> tailSet(E fromElement, boolean inclusive) {
        return this.tailSetImpl(Ascii.checkNotNull(fromElement), inclusive);
    }

    abstract ImmutableSortedSet<E> headSetImpl(E var1, boolean var2);

    abstract ImmutableSortedSet<E> subSetImpl(E var1, boolean var2, E var3, boolean var4);

    abstract ImmutableSortedSet<E> tailSetImpl(E var1, boolean var2);

    @Override
    public E lower(E e) {
        return Iterators.getNext(((ImmutableSortedSet)this.headSet((Object)e, false)).descendingIterator(), null);
    }

    @Override
    public E floor(E e) {
        return Iterators.getNext(((ImmutableSortedSet)this.headSet((Object)e, true)).descendingIterator(), null);
    }

    @Override
    public E ceiling(E e) {
        return Ascii.getFirst(this.tailSet((Object)e, true), null);
    }

    @Override
    public E higher(E e) {
        return Ascii.getFirst(this.tailSet((Object)e, false), null);
    }

    @Override
    public E first() {
        return this.iterator().next();
    }

    @Override
    public E last() {
        return this.descendingIterator().next();
    }

    @Override
    @Deprecated
    public final E pollFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final E pollLast() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImmutableSortedSet<E> descendingSet() {
        ImmutableSortedSet<E> result = this.descendingSet;
        if (result == null) {
            result = this.descendingSet = this.createDescendingSet();
            this.descendingSet.descendingSet = this;
        }
        return result;
    }

    ImmutableSortedSet<E> createDescendingSet() {
        return new DescendingImmutableSortedSet(this);
    }

    @Override
    public abstract UnmodifiableIterator<E> descendingIterator();
}

