///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#include <core/Core.h>
#include "XFormSystemChooser.h"

namespace Core {

/******************************************************************************
* Initializes the combo box.
******************************************************************************/
XFormSystemChooser::XFormSystemChooser() : Action(ACTION_XFORM_SYSTEM), comboBox(NULL)
{
}

/******************************************************************************
* This is called by the system after the action object has been bound to its ActionProxy.
******************************************************************************/
void XFormSystemChooser::initializeAction(ActionProxy* proxy) 
{
	Action::initializeAction(proxy);

	proxy->setText(tr("Transformation System"));
	if(APPLICATION_MANAGER.guiMode()) {
		comboBox = new QComboBox();
		comboBox->setToolTip(proxy->text());

		// Populate combox box.
		comboBox->addItem(tr("Grid"));
		comboBox->addItem(tr("World"));
		comboBox->addItem(tr("Local"));
		comboBox->addItem(tr("Screen"));

		connect(comboBox, SIGNAL(activated(int)), this, SLOT(onSelectionChanged(int)));
		proxy->setDefaultWidget(comboBox);
	}
	connect(&XFORM_MANAGER, SIGNAL(xformSystemChanged()), this, SLOT(onXFormSystemChanged()));
}

/******************************************************************************
* Is called when the user has choosen an item from the list.
******************************************************************************/
void XFormSystemChooser::onSelectionChanged(int index)
{
	XFormManager::XFormSystem sys = (XFormManager::XFormSystem)(XFormManager::CONSTRUCTION_GRID_SYS + index);
	OVITO_ASSERT(sys >= XFormManager::CONSTRUCTION_GRID_SYS && sys <= XFormManager::SCREEN_SYS);
	XFORM_MANAGER.setXFormSystem(sys);
}

/******************************************************************************
* Is called when the xform system has been changed.
******************************************************************************/
void XFormSystemChooser::onXFormSystemChanged()
{
	// Update current item.
	if(comboBox)
		comboBox->setCurrentIndex(XFORM_MANAGER.xformSystem() - XFormManager::CONSTRUCTION_GRID_SYS);
}

};
