#####################################################################################
#
# This script was written by Carsten Koch-Mauthe <c.koch-mauthe at dn-systems.de>
#
# This script is released under the GNU GPLv2
#
# $Revision: 03 $
#
# Updated By Antu Sanadi <santu@secpod.com> on 16/09/2009
#
#
####################################################################################

if(description)
{

  script_id(90030);
  script_version ("$Revision: 03 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2008-2152");
  script_bugtraq_id(29622);
  script_name("OpenOffice.org <= 2.4.1 vulnerability (Win)");
  desc = "The remote host is probably affected by the vulnerabilities described in
  CVE-2008-2152 or CVE-2008-3282 on 64-bit platform's

  Impact
   CVE-2008-2152
     Integer overflow in the rtl_allocateMemory function in
     sal/rtl/source/alloc_global.c in OpenOffice.org (OOo)
     2.0 through 2.4 allows remote attackers to execute
     arbitrary code via a crafted file that triggers a
     heap-based buffer overflow.
   CVE-2008-3282
     Integer overflow in the rtl_allocateMemory function
     in sal/rtl/source/alloc_global.c in the memory allocator
     in OpenOffice.org (OOo) 2.4.1, on 64-bit platforms, allows
     remote attackers to cause a denial of service (application
     crash) or possibly execute arbitrary code via a crafted
     document, related to a 'numeric truncation error,' a
     different vulnerability than CVE-2008-2152.

  References:
    http://www.cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-2152
    http://www.cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-3282

  Solution:
    All OpenOffice.org users should upgrade to the latest version:

  Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of OpenOffice");
  script_category(ACT_GATHER_INFO);
  script_copyright("This script is under GPLv2");
  script_family("Buffer overflow");
  script_dependencies("secpod_openoffice_detect_win.nasl");
  script_require_keys("OpenOffice/Win/Ver");
  exit(0);
}


include("version_func.inc");

openVer = get_kb_item("OpenOffice/Win/Ver");
if(openVer != NULL)
{
  if(version_is_less_equal(version:openVer, test_version:"2.4.1")){
    security_hole(0);
  }
}
