#
#
# Copyright 2005 DN Systems GmbH
#
# License: GNU GPLv2 or any later version
#
function slad_ssh_login () {
  slad_key_passphrase = get_kb_item ("Secret/SLAD/passphrase");
  slad_login_name = get_kb_item ("SLAD/login");
  slad_public_key = get_kb_item ("SLAD/publickey");
  slad_private_key = get_kb_item ("SLAD/privatekey");

  if (debug) {
    display ("slad_run: n: <", slad_login_name, 
	     "> pp: <", slad_key_passphrase, ">\n");
    display ("pub: ", slad_public_key, "\n");
    display ("priv: ", slad_private_key, "\n");
  }

  port = kb_ssh_transport();
  if (!port) port = 22;
  else port = int (port);
  
  if (!slad_login_name) {
    security_note (port: port, data: "no username given for SLAD checks. SLAD checks will be disabled.");
    exit (0);
  }
  if (!slad_private_key) {
    security_note (port: port, data: "no key given for SLAD checks. SLAD checks will be disabled.");
    exit (0);
  }
  
  # Connect via SSH
  sock = open_sock_tcp (port);
  if (!sock || sock < 1) {
    security_warning (port: port, data: "could not get socket");
    exit (0);
  }
  if (ssh_login (socket:sock, login: slad_login_name, password: NULL,
		 pub: slad_public_key, priv: slad_private_key, 
		 passphrase: slad_key_passphrase) != 0) {
    msg = "SSH login failed: " + get_ssh_error();
    security_warning (port: port, data: msg);
    close (sock);
    exit (0);
  }

  return sock;
}
