###############################################################################
# OpenVAS Vulnerability Test Support File
#
# Support functions for SLAD queries
#
# Authors:
# Dirk Jagdmann
# Michael Wiegand
#
# Copyright:
# Copyright (c) 2005 DN-Systems GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
################################################################################

function init_add_preferences () {
  script_add_preference (name: "Execute Tripwire HIDS to check system's file integrity (Linux only)", type: "checkbox", value: "no");
  script_add_preference (name: "Execute ClamAV to search for virus-infected files (Linux only)", type: "checkbox", value: "no");
  script_add_preference (name: "ClamAV level", type: "radio", value: "Move infected files to quarantine;Remove infected files;Move infected files to quarantine exclude archives (.zip, .tgz, etc);Remove infected files exclude archives (.zip, .tgz, etc)");
  script_add_preference (name: "Execute LSOF to retrieve a list of open files (Linux only)", type: "checkbox", value: "no");
  script_add_preference (name: "Execute Tiger for various checks (Linux only)", type: "checkbox", value: "no");
  script_add_preference (name: "tiger level", type: "radio", value: "Checks user and passwd on local system;Check Filesystem Permissions;Check Systems Configuration and applications;Check running System and Processes;Perform all Tiger checks on system");
  script_add_preference (name: "Analyse Syslog-Files for security incidents (Linux only)", type: "checkbox", value: "no");
  script_add_preference (name: "syslogwatch level", type: "radio", value: "Analyse SysLogs low detail;Analyse SysLogs medium detail;Analyse SysLogs high detail");
  script_add_preference (name: "fetch hardware MB sensors (Linux only)", type: "checkbox", value: "no");
  script_add_preference (name: "Execute John-the-Ripper to find weak user passwords", type: "checkbox", value: "no");
  script_add_preference (name: "john level", type: "radio", value: "Fast-Crack;Dictionary Mode (slow);Full-Crack (very slow)");
  script_add_preference (name: "Execute ovaldi for scanning OVAL described issues", type: "checkbox", value: "no");
  script_add_preference (name: "ovaldi report format", type: "radio", value: "Text;HTML");
  script_add_preference (name: "Analyse SNMP-Traps collected by snmptrapd (Linux only)", type: "checkbox", value: "no");
  script_add_preference (name: "Fetch Snort-Events from the Snort MYSQL Database (Linux only)", type: "checkbox", value: "no");
  script_add_preference (name: "Execute ssh vulnkey to detect unsecure SSH RSA and DSA keys from broken Debian OpenSSL pkt (Linux only)", type: "checkbox", value: "no");
  script_add_preference (name: "Execute ChkRootKit to find installed rootkits (Linux only)", type: "checkbox", value: "no");
}

function run_slad (sock, slad_exe) {
  # tripwire
  run = script_get_preference ("Execute Tripwire HIDS to check system's file integrity (Linux only)");
  slad_cmd = slad_exe + " -r tripwire:tripwire";
  if (run == "yes") results += ssh_cmd (socket: sock, cmd: slad_cmd, timeout: 60);
  # ClamAV
  run = script_get_preference ("Execute ClamAV to search for virus-infected files (Linux only)");
  level = script_get_preference ("ClamAV level");
  if (level == "Move infected files to quarantine") slad_cmd = slad_exe + " -r ClamAV:ClamAVQua";
  else if (level == "Remove infected files") slad_cmd = slad_exe + " -r ClamAV:ClamAVDel";
  else if (level == "Move infected files to quarantine exclude archives (.zip, .tgz, etc)") slad_cmd = slad_exe + " -r ClamAV:ClamAVNoArch";
  else if (level == "Remove infected files exclude archives (.zip, .tgz, etc)") slad_cmd = slad_exe + " -r ClamAV:ClamAVDelNoArch";
  if (run == "yes") results += ssh_cmd (socket: sock, cmd: slad_cmd, timeout: 60);
  # lsof
  run = script_get_preference ("Execute LSOF to retrieve a list of open files (Linux only)");
  slad_cmd = slad_exe + " -r lsof:lsof";
  if (run == "yes") results += ssh_cmd (socket: sock, cmd: slad_cmd, timeout: 60);
  # tiger
  run = script_get_preference ("Execute Tiger for various checks (Linux only)");
  level = script_get_preference ("tiger level");
  if (level == "Checks user and passwd on local system") slad_cmd = slad_exe + " -r tiger:tigeruser";
  else if (level == "Check Filesystem Permissions") slad_cmd = slad_exe + " -r tiger:tigerperm";
  else if (level == "Check Systems Configuration and applications") slad_cmd = slad_exe + " -r tiger:tigerconfig";
  else if (level == "Check running System and Processes") slad_cmd = slad_exe + " -r tiger:tigersystem";
  else if (level == "Perform all Tiger checks on system") slad_cmd = slad_exe + " -r tiger:fulltiger";
  if (run == "yes") results += ssh_cmd (socket: sock, cmd: slad_cmd, timeout: 60);
  # syslogwatch
  run = script_get_preference ("Analyse Syslog-Files for security incidents (Linux only)");
  level = script_get_preference ("syslogwatch level");
  if (level == "Analyse SysLogs low detail") slad_cmd = slad_exe + " -r syslogwatch:logwatchlow";
  else if (level == "Analyse SysLogs medium detail") slad_cmd = slad_exe + " -r syslogwatch:logwatchmed";
  else if (level == "Analyse SysLogs high detail") slad_cmd = slad_exe + " -r syslogwatch:logwatchhigh";
  if (run == "yes") results += ssh_cmd (socket: sock, cmd: slad_cmd, timeout: 60);
  # sensors
  run = script_get_preference ("fetch hardware MB sensors (Linux only)");
  slad_cmd = slad_exe + " -r sensors:sensors";
  if (run == "yes") results += ssh_cmd (socket: sock, cmd: slad_cmd, timeout: 60);
  # john
  run = script_get_preference ("Execute John-the-Ripper to find weak user passwords");
  level = script_get_preference ("john level");
  if (level == "Fast-Crack") slad_cmd = slad_exe + " -r john:fastjohn";
  else if (level == "Dictionary Mode (slow)") slad_cmd = slad_exe + " -r john:dictjohn";
  else if (level == "Full-Crack (very slow)") slad_cmd = slad_exe + " -r john:fulljohn";
  if (run == "yes") results += ssh_cmd (socket: sock, cmd: slad_cmd, timeout: 60);
  # ovaldi
  run = script_get_preference ("Execute ovaldi for scanning OVAL described issues");
  report_format = script_get_preference("ovaldi report format");
  if (report_format == "Text") slad_cmd = slad_exe + " -r ovaldi:short";
  else if (report_format == "Text") slad_cmd = slad_exe + " -r ovaldi:html";
  if (run == "yes") results += ssh_cmd (socket: sock, cmd: slad_cmd, timeout: 60);
  # snmptrapwatch
  run = script_get_preference ("Analyse SNMP-Traps collected by snmptrapd (Linux only)");
  slad_cmd = slad_exe + " -r snmptrapwatch:snmptrapwatch";
  if (run == "yes") results += ssh_cmd (socket: sock, cmd: slad_cmd, timeout: 60);
  # snort
  run = script_get_preference ("Fetch Snort-Events from the Snort MYSQL Database (Linux only)");
  slad_cmd = slad_exe + " -r snort:snort";
  if (run == "yes") results += ssh_cmd (socket: sock, cmd: slad_cmd, timeout: 60);
  # sshvulnkey
  run = script_get_preference ("Execute ssh vulnkey to detect unsecure SSH RSA and DSA keys from broken Debian OpenSSL pkt (Linux only)");
  slad_cmd = slad_exe + " -r sshvulnkey:sshvuln";
  if (run == "yes") results += ssh_cmd (socket: sock, cmd: slad_cmd, timeout: 60);
  # chkrootkit
  run = script_get_preference ("Execute ChkRootKit to find installed rootkits (Linux only)");
  slad_cmd = slad_exe + " -r chkrootkit:chkrootkit";
  if (run == "yes") results += ssh_cmd (socket: sock, cmd: slad_cmd, timeout: 60);
  if (results) security_warning (data: results);
}

function get_slad_description (entry) {
  if (entry == "tripwire:tripwire:tripwire") return "Execute Tripwire HIDS to check system's file integrity";
  else if (entry == "ClamAV:ClamAVQua:QuarantClamAV") return "Execute ClamAV to search for virus-infected files: Move infected files to quarantine";
  else if (entry == "ClamAV:ClamAVDel:DeleteClamAV") return "Execute ClamAV to search for virus-infected files: Remove infected files";
  else if (entry == "ClamAV:ClamAVNoArch:QuarantClamAVNoArch") return "Execute ClamAV to search for virus-infected files: Move infected files to quarantine exclude archives (.zip, .tgz, etc)";
  else if (entry == "ClamAV:ClamAVDelNoArch:DeleteClamAVNoArch") return "Execute ClamAV to search for virus-infected files: Remove infected files exclude archives (.zip, .tgz, etc)";
  else if (entry == "lsof:lsof:lsof") return "Execute LSOF to retrieve a list of open files";
  else if (entry == "tiger:tigeruser:tigeruser") return "Execute Tiger for various checks: Checks user and passwd on local system";
  else if (entry == "tiger:tigerperm:tigerperm") return "Execute Tiger for various checks: Check Filesystem Permissions";
  else if (entry == "tiger:tigerconfig:tigerconfig") return "Execute Tiger for various checks: Check Systems Configuration and applications";
  else if (entry == "tiger:tigersystem:tigersystem") return "Execute Tiger for various checks: Check running System and Processes";
  else if (entry == "tiger:fulltiger:fulltiger") return "Execute Tiger for various checks: Perform all Tiger checks on system";
  else if (entry == "syslogwatch:logwatchlow:logwatchlow") return "Analyse Syslog-Files for security incidents: Analyse SysLogs low detail";
  else if (entry == "syslogwatch:logwatchmed:logwatchmed") return "Analyse Syslog-Files for security incidents: Analyse SysLogs medium detail";
  else if (entry == "syslogwatch:logwatchhigh:logwatchhigh") return "Analyse Syslog-Files for security incidents: Analyse SysLogs high detail";
  else if (entry == "sensors:sensors:sensors") return "fetch hardware MB sensors";
  else if (entry == "john:fastjohn:fastjohn") return "Execute John-the-Ripper to find weak user passwords: Fast-Crack";
  else if (entry == "john:dictjohn:dictjohn") return "Execute John-the-Ripper to find weak user passwords: Dictionary Mode (slow)";
  else if (entry == "john:fulljohn:fulljohn") return "Execute John-the-Ripper to find weak user passwords: Full-Crack (very slow)";
  else if (entry == "ovaldi:short:short") return "Execute ovaldi for scanning OVAL described issues: Text Report";
  else if (entry == "ovaldi:html:html") return "Execute ovaldi for scanning OVAL described issues: HTML Report";
  else if (entry == "snmptrapwatch:snmptrapwatch:trapwatch") return "Analyse SNMP-Traps collected by snmptrapd: SNMP Traps in the daemon.log";
  else if (entry == "snort:snort:snort") return "Fetch Snort-Events from the Snort MYSQL Database";
  else if (entry == "sshvulnkey:sshvuln:normal") return "Execute ssh vulnkey to detect unsecure SSH RSA and DSA keys from broken Debian OpenSSL pkt";
  else if (entry == "chkrootkit:chkrootkit:normal") return "Execute ChkRootKit to find installed rootkits";
}

function dump_preferences () {
  display ("tripwire: ", script_get_preference ("Execute Tripwire HIDS to check system's file integrity (Linux only)"), "\n");
  display ("ClamAV: ", script_get_preference ("Execute ClamAV to search for virus-infected files (Linux only)"), "\n");
  display ("  level: ", script_get_preference ("ClamAV level"), "\n");
  display ("lsof: ", script_get_preference ("Execute LSOF to retrieve a list of open files (Linux only)"), "\n");
  display ("tiger: ", script_get_preference ("Execute Tiger for various checks (Linux only)"), "\n");
  display ("  level: ", script_get_preference ("tiger level"), "\n");
  display ("syslogwatch: ", script_get_preference ("Analyse Syslog-Files for security incidents (Linux only)"), "\n");
  display ("  level: ", script_get_preference ("syslogwatch level"), "\n");
  display ("sensors: ", script_get_preference ("fetch hardware MB sensors"), "\n");
  display ("john: ", script_get_preference ("Execute John-the-Ripper to find weak user passwords (Linux only)"), "\n");
  display ("  level: ", script_get_preference ("john level"), "\n");
  display ("ovaldi: ", script_get_preference ("Execute ovaldi for scanning OVAL described issues (Linux only)"), "\n");
  display ("snmptrapwatch: ", script_get_preference ("Analyse SNMP-Traps collected by snmptrapd (Linux only)"), "\n");
  display ("snort: ", script_get_preference ("Fetch Snort-Events from the Snort MYSQL Database (Linux only)"), "\n");
  display ("sshvulnkey: ", script_get_preference ("Execute ssh vulnkey to detect unsecure SSH RSA and DSA keys from broken Debian OpenSSL pkt (Linux only)"), "\n");
  display ("chkrootkit: ", script_get_preference ("Execute ChkRootKit to find installed rootkits (Linux only)"), "\n");
}
