###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for apache2 vulnerabilities USN-575-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840304);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_xref(name: "USN", value: "575-1");
  script_cve_id("CVE-2006-3918", "CVE-2007-3847", "CVE-2007-4465", "CVE-2007-5000", "CVE-2007-6388", "CVE-2007-6421", "CVE-2007-6422", "CVE-2008-0005");
  script_name( "Ubuntu Update for apache2 vulnerabilities USN-575-1");
  desc = "

  Vulnerability Insight:

  It was discovered that Apache did not sanitize the Expect header from
  an HTTP request when it is reflected back in an error message, which
  could result in browsers becoming vulnerable to cross-site scripting
  attacks when processing the output. With cross-site scripting
  vulnerabilities, if a user were tricked into viewing server output
  during a crafted server request, a remote attacker could exploit this
  to modify the contents, or steal confidential data (such as passwords),
  within the same domain. This was only vulnerable in Ubuntu 6.06.
  (CVE-2006-3918)
  
  It was discovered that when configured as a proxy server and using a
  threaded MPM, Apache did not properly sanitize its input. A remote
  attacker could send Apache crafted date headers and cause a denial of
  service via application crash. By default, mod_proxy is disabled in
  Ubuntu. (CVE-2007-3847)
  
  It was discovered that mod_autoindex did not force a character set,
  which could result in browsers becoming vulnerable to cross-site
  scripting attacks when processing the output. (CVE-2007-4465)
  
  It was discovered that mod_imap/mod_imagemap did not force a
  character set, which could result in browsers becoming vulnerable
  to cross-site scripting attacks when processing the output. By
  default, mod_imap/mod_imagemap is disabled in Ubuntu. (CVE-2007-5000)
  
  It was discovered that mod_status when status pages were available,
  allowed for cross-site scripting attacks. By default, mod_status is
  disabled in Ubuntu. (CVE-2007-6388)
  
  It was discovered that mod_proxy_balancer did not sanitize its input,
  which could result in browsers becoming vulnerable to cross-site
  scripting attacks when processing the output. By default,
  mod_proxy_balancer is disabled in Ubuntu. This was only vulnerable
  in Ubuntu 7.04 and 7.10. (CVE-2007-6421)
  
  It was discovered that mod_proxy_balancer could be made to
  dereference a NULL pointer. A remote attacker could send a crafted
  request and cause a denial of service via application crash. By
  default, mod_proxy_balancer is disabled in Ubuntu. This was only
  vulnerable in Ubuntu 7.04 and 7.10. (CVE-2007-6422)
  
  It was discovered that mod_proxy_ftp did not force a character set,
  which could result in browsers becoming vulnerable to cross-site
  scripting attacks when processing the output. By default,
  mod_proxy_ftp is disabled in Ubuntu. (CVE-2008-0005)

  Affected Software/OS:
  apache2 vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 6.10 ,
  Ubuntu 7.04 ,
  Ubuntu 7.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-February/000662.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of apache2 vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"apache2-mpm-event", ver:"2.2.3-3.2ubuntu2.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-mpm-prefork", ver:"2.2.3-3.2ubuntu2.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-mpm-worker", ver:"2.2.3-3.2ubuntu2.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-prefork-dev", ver:"2.2.3-3.2ubuntu2.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-threaded-dev", ver:"2.2.3-3.2ubuntu2.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-utils", ver:"2.2.3-3.2ubuntu2.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2.2-common", ver:"2.2.3-3.2ubuntu2.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-doc", ver:"2.2.3-3.2ubuntu2.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-mpm-perchild", ver:"2.2.3-3.2ubuntu2.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-src", ver:"2.2.3-3.2ubuntu2.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2", ver:"2.2.3-3.2ubuntu2.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"apache2-common", ver:"2.0.55-4ubuntu2.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-mpm-perchild", ver:"2.0.55-4ubuntu2.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-mpm-prefork", ver:"2.0.55-4ubuntu2.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-mpm-worker", ver:"2.0.55-4ubuntu2.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-prefork-dev", ver:"2.0.55-4ubuntu2.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-threaded-dev", ver:"2.0.55-4ubuntu2.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-utils", ver:"2.0.55-4ubuntu2.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2", ver:"2.0.55-4ubuntu2.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libapr0-dev", ver:"2.0.55-4ubuntu2.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libapr0", ver:"2.0.55-4ubuntu2.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-doc", ver:"2.0.55-4ubuntu2.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"apache2-common", ver:"2.0.55-4ubuntu4.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-mpm-perchild", ver:"2.0.55-4ubuntu4.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-mpm-prefork", ver:"2.0.55-4ubuntu4.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-mpm-worker", ver:"2.0.55-4ubuntu4.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-prefork-dev", ver:"2.0.55-4ubuntu4.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-threaded-dev", ver:"2.0.55-4ubuntu4.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-utils", ver:"2.0.55-4ubuntu4.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2", ver:"2.0.55-4ubuntu4.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libapr0-dev", ver:"2.0.55-4ubuntu4.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libapr0", ver:"2.0.55-4ubuntu4.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-doc", ver:"2.0.55-4ubuntu4.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"apache2-mpm-event", ver:"2.2.4-3ubuntu0.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-mpm-prefork", ver:"2.2.4-3ubuntu0.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-mpm-worker", ver:"2.2.4-3ubuntu0.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-prefork-dev", ver:"2.2.4-3ubuntu0.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-threaded-dev", ver:"2.2.4-3ubuntu0.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-utils", ver:"2.2.4-3ubuntu0.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2.2-common", ver:"2.2.4-3ubuntu0.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-doc", ver:"2.2.4-3ubuntu0.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-mpm-perchild", ver:"2.2.4-3ubuntu0.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-src", ver:"2.2.4-3ubuntu0.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2", ver:"2.2.4-3ubuntu0.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}