###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for dar FEDORA-2007-0904
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861531);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_xref(name: "FEDORA", value: "2007-0904");
  script_cve_id("CVE-2007-3528");
  script_name( "Fedora Update for dar FEDORA-2007-0904");
  desc = "

  Vulnerability Insight:
  DAR is a command line tool to backup a directory tree and files. DAR is
  able to make differential backups, split them over a set of disks or files
  of a given size, use compression, filter files or subtrees to be saved or
  not saved, directly access and restore given files. DAR is also able
  to handle extented attributes, and can make remote backups through an
  ssh session for example. Finally, DAR handles save and restore of hard
  and symbolic links.


  Affected Software/OS:
  dar on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-July/msg00139.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of dar");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"dar", rpm:"dar~2.3.4~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"dar", rpm:"dar~2.3.4~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libdar-devel", rpm:"libdar-devel~2.3.4~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libdar", rpm:"libdar~2.3.4~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"dar-debuginfo", rpm:"dar-debuginfo~2.3.4~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"dar-debuginfo", rpm:"dar-debuginfo~2.3.4~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libdar", rpm:"libdar~2.3.4~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"dar", rpm:"dar~2.3.4~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libdar-devel", rpm:"libdar-devel~2.3.4~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}