###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_adobe_flash_player_sec_bypass_vuln_win.nasl 320 2008-10-16 15:06:02Z oct $
#
# Adobe Flash Player Multiple Security Bypass Vulnerabilities (Win)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800027);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.8");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2007-6243", "CVE-2008-3873", "CVE-2007-4324",
                "CVE-2008-4401", "CVE-2008-4503");
  script_bugtraq_id(31117);
  script_name("Adobe Flash Player Multiple Security Bypass Vulnerabilities (Win)");
  desc = "
  Overview: This host has Adobe Flash Player installed and is prone to
  multiple security bypass vulnerabilities.

  Vulnerability Insight: The flaws are due to,
  - a design error in the application allows access to the system's
    camera and microphone by tricking the user into clicking Flash Player
    access control dialogs disguised as normal graphical elements.
  - FileReference.browse() and FileReference.download() methods can be
    called without user interaction and can potentially be used
    to trick a user into downloading or uploading files.

  Impact: Successful attack could allow malicious people to bypass certain
  security restrictions or manipulate certain data.

  Impact Level: Application

  Affected Software/OS:
  Adobe Flash Player 9.x - 9.0.124.0 on Windows.

  Fix: Upgrade to Adobe Flash Player 10.0.12.36,
  http://www.adobe.com/downloads/

  References:
  http://secunia.com/advisories/32163/
  http://www.adobe.com/support/security/bulletins/apsb08-18.html
  http://www.adobe.com/support/security/advisories/apsa08-08.html
  http://blogs.adobe.com/psirt/2008/10/clickjacking_security_advisory.html

  CVSS Score:
    CVSS Base Score     : 5.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:N)
    CVSS Temporal Score : 4.3
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the version of Adobe Flash Player");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("General");
  script_dependencies("gb_adobe_flash_player_detect_win.nasl");
  exit(0);
}


include("version_func.inc");

adobeVer = get_kb_item("AdobeFlashPlayer/Win/Ver");
if(!adobeVer){
  exit(0);
}

# Grep for versions 9.0.124.0 and prior
if(version_in_range(version:adobeVer, test_version:"9.0",
                    test_version2:"9.0.124.0")){
  security_warning(0);
}
