#
#
# (C) Noam Rathaus GPLv2
#

# SoulBlack Group <soulblacktm@gmail.com>
# 2005-05-09 00:59
# Easy Message Board Directory Traversal and Remote Command

 desc = '
The remote host is running Easy Message Board, a bulletin board system
written in perl.

The remote version of this script contains an input validation flaw which
may be used by an attacker to perform a directory traversal attack
or execute arbitrary commands on the remote host with the privileges of
the web server.

Solution : Upgrade to the newest version of this CGI or disable it
Risk factor : High';

if(description)
{
 script_id(18211);
 script_version ("$Revision: 7287 $");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");

 script_cve_id("CAN-2005-1549", "CAN-2005-1550");
 script_bugtraq_id(13555, 13551);
 
 name = "Easy Message Board Command Execution";
 script_name(name);
 
 script_description(desc);
 
 summary = "Checks for Easy Message Board";
 
 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright("This script is Copyright (C) 2005 Noam Rathaus");
 family = "Web application abuses";
 script_family(family);
 script_dependencie("http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");


http_check_remote_code (
			check_request:"/easymsgb.pl?print=|id|",
			extra_check:"<fint color=Blue>uid=[0-9]+.*gid=[0-9]+.*</b></font>",
			check_result:"uid=[0-9]+.*gid=[0-9]+.*",
			command:"id",
			description:desc
			);
