# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1860-1 (ruby1.8, ruby1.9)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64639);
 script_cve_id("CVE-2009-0642", "CVE-2009-1904");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"6.8");
 script_tag(name:"risk_factor", value:"High");
 script_name("Debian Security Advisory DSA 1860-1 (ruby1.8, ruby1.9)");

 desc = "The remote host is missing an update to ruby1.8, ruby1.9
announced via advisory DSA 1860-1.

Several vulnerabilities have been discovered in Ruby.  The Common
Vulnerabilities and Exposures project identifies the following
problems:

CVE-2009-0642

The return value from the OCSP_basic_verify function was not checked
properly, allowing continued use of a revoked certificate.

CVE-2009-1904

An issue in parsing BigDecimal numbers can result in a
denial-of-service condition (crash).

The following matrix identifies fixed versions:

ruby1.8           ruby1.9
oldstable (etch)    1.8.5-4etch5      1.9.0+20060609-1etch5
stable (lenny)      1.8.7.72-3lenny1  1.9.0.2-9lenny1
unstable (sid)      1.8.7.173-1       (soon)

We recommend that you upgrade your Ruby packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201860-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1860-1 (ruby1.8, ruby1.9)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ri1.8", ver:"1.8.5-4etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.9-elisp", ver:"1.9.0+20060609-1etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"rdoc1.9", ver:"1.9.0+20060609-1etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"irb1.9", ver:"1.9.0+20060609-1etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.9-examples", ver:"1.9.0+20060609-1etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.8-examples", ver:"1.8.5-4etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"irb1.8", ver:"1.8.5-4etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.8-elisp", ver:"1.8.5-4etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ri1.9", ver:"1.9.0+20060609-1etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"rdoc1.8", ver:"1.8.5-4etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libopenssl-ruby1.9", ver:"1.9.0+20060609-1etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.9", ver:"1.9.0+20060609-1etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libdbm-ruby1.9", ver:"1.9.0+20060609-1etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.8-dev", ver:"1.8.5-4etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtcltk-ruby1.8", ver:"1.8.5-4etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgdbm-ruby1.8", ver:"1.8.5-4etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgdbm-ruby1.9", ver:"1.9.0+20060609-1etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libruby1.9", ver:"1.9.0+20060609-1etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libruby1.8", ver:"1.8.5-4etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libruby1.9-dbg", ver:"1.9.0+20060609-1etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.8", ver:"1.8.5-4etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libreadline-ruby1.8", ver:"1.8.5-4etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtcltk-ruby1.9", ver:"1.9.0+20060609-1etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libreadline-ruby1.9", ver:"1.9.0+20060609-1etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libdbm-ruby1.8", ver:"1.8.5-4etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libruby1.8-dbg", ver:"1.8.5-4etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libopenssl-ruby1.8", ver:"1.8.5-4etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.9-dev", ver:"1.9.0+20060609-1etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"irb1.9", ver:"1.9.0.2-9lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ri1.9", ver:"1.9.0.2-9lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.9-examples", ver:"1.9.0.2-9lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.9-elisp", ver:"1.9.0.2-9lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"rdoc1.8", ver:"1.8.7.72-3lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"irb1.8", ver:"1.8.7.72-3lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ri1.8", ver:"1.8.7.72-3lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.8-examples", ver:"1.8.7.72-3lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"rdoc1.9", ver:"1.9.0.2-9lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.8-elisp", ver:"1.8.7.72-3lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtcltk-ruby1.9", ver:"1.9.0.2-9lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgdbm-ruby1.9", ver:"1.9.0.2-9lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.8-dev", ver:"1.8.7.72-3lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtcltk-ruby1.8", ver:"1.8.7.72-3lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgdbm-ruby1.8", ver:"1.8.7.72-3lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.9", ver:"1.9.0.2-9lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.9-dev", ver:"1.9.0.2-9lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.8", ver:"1.8.7.72-3lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libdbm-ruby1.8", ver:"1.8.7.72-3lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libopenssl-ruby1.8", ver:"1.8.7.72-3lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libreadline-ruby1.8", ver:"1.8.7.72-3lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libopenssl-ruby1.9", ver:"1.9.0.2-9lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libreadline-ruby1.9", ver:"1.9.0.2-9lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libruby1.8", ver:"1.8.7.72-3lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libruby1.9", ver:"1.9.0.2-9lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libruby1.8-dbg", ver:"1.8.7.72-3lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libdbm-ruby1.9", ver:"1.9.0.2-9lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libruby1.9-dbg", ver:"1.9.0.2-9lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
