# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1853-1 (memcached)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64630);
 script_cve_id("CVE-2009-2415");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 script_name("Debian Security Advisory DSA 1853-1 (memcached)");

 desc = "The remote host is missing an update to memcached
announced via advisory DSA 1853-1.

Ronald Volgers discovered that memcached, a high-performance memory object
caching system, is vulnerable to several heap-based buffer overflows due
to integer conversions when parsing certain length attributes. An
attacker can use this to execute arbitrary code on the system running
memcached (on etch with root privileges).

For the oldstable distribution (etch), this problem has been fixed in
version 1.1.12-1+etch1.

For the stable distribution (lenny), this problem has been fixed in
version 1.2.2-1+lenny1.

For the testing (squeeze) and unstable (sid) distribution , this problem
will be fixed soon.


We recommend that you upgrade your memcached packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201853-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1853-1 (memcached)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"memcached", ver:"1.1.12-1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"memcached", ver:"1.2.2-1+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
