/* NessusClient -- the Nessus Client
 * Copyright (C) 1998 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * In addition, as a special exception, Renaud Deraison
 * gives permission to link the code of this program with any
 * version of the OpenSSL library which is distributed under a
 * license identical to that listed in the included COPYING.OpenSSL
 * file, and distribute linked combinations including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * this file, you may extend this exception to your version of the
 * file, but you are not obligated to do so.  If you do not wish to
 * do so, delete this exception statement from your version.
 */
 
#ifndef _NESSUSC_PARSER_H
#define _NESSUSC_PARSER_H

#include "context.h"

#define MSG_ERROR 1
#define MSG_PORT 2
#define MSG_HOLE 3
#define MSG_BYE 4
#define MSG_INFO 5
#define MSG_STAT 6
#define MSG_FINISHED 9
#define MSG_STAT2 10
#define MSG_NOTE 11
#define MSG_TIME 12
#define MSG_LOG 13
#define MSG_DEBUG 14
#define MSG_FALSE 15

#define MSG_ERROR_STR "ERROR"
#define MSG_PORT_STR "PORT"
#define MSG_HOLE_STR "HOLE"
#define MSG_INFO_STR "INFO"
#define MSG_NOTE_STR "NOTE"
#define MSG_STAT_STR "STATUS"
#define MSG_BYE_STR "BYE"
#define MSG_FINISHED_STR "FINISHED"
#define MSG_TIME_STR "TIME"
#define MSG_LOG_STR "LOG"
#define MSG_DEBUG_STR "DEBUG"
#define MSG_FALSE_STR "FALSE"

char * priority_type_to_str (int type);
int priority_name_to_type (char *name);
int parse_server_message(struct context * , char *,  int,  char *);
void parse_host_add_port(int, char *, char *);
void parse_host_add_data(int, struct context *, char *, int);
char * parse_plugin_symbol(char *);
char * parse_separator(char *);
char * parse_symbol(char *);
void parse_nessusd_status(char *, char **, char **, char  **, int *);
void parse_nessusd_short_status(char *, char **, char **, char  **, int *);

#endif
