/*
 *  Copyright (c) 2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "Wrapper_p.h"

#include <GTLCore/Debug.h>
#include <GTLCore/Function.h>
#include <GTLCore/ModuleData_p.h>
#include <GTLCore/Type.h>
#include <GTLCore/TypesManager.h>
#include <GTLCore/TypesManager_p.h>
#include <GTLCore/Macros_p.h>

#include "Library.h"
#include <GTLCore/Function_p.h>
#include <llvm/Module.h>
#include <GTLCore/Type_p.h>

using namespace GTLFragment;

struct Wrapper::Private {
  GTLCore::ModuleData* moduleData;
  int channels;
  llvm::Module* llvmModule;
};

Wrapper::Wrapper(GTLCore::ModuleData* _moduleData, llvm::Module* _llvmModule, int _channels) : d(new Private)
{
  d->moduleData =_moduleData;
  d->channels = _channels;
  d->llvmModule = _llvmModule;
}

Wrapper::~Wrapper()
{
}

GTLCore::ModuleData* Wrapper::moduleData() const
{
  return d->moduleData;
}

int Wrapper::channels() const
{
  return d->channels;
}

llvm::Module* Wrapper::llvmModule()
{
  return d->llvmModule;
}

const GTLCore::Type* Wrapper::createColorType(GTLCore::TypesManager* _typesManager, GTLCore::ConvertCenter* _convertCenter)
{
  //---------------------- WARNING ----------------------//
  // Whenever the following structure is edited,         //
  // its llvm declaration must be changed too in         //
  // struct ColorWrap !                                  //
  //---------------------- WARNING ----------------------//
  std::vector<GTLCore::Type::StructDataMember> regionDataMembers;
  regionDataMembers.push_back( GTLCore::Type::StructDataMember( "red", GTLCore::Type::Float32 ) );
  regionDataMembers.push_back( GTLCore::Type::StructDataMember( "green", GTLCore::Type::Float32) );
  regionDataMembers.push_back( GTLCore::Type::StructDataMember( "blue", GTLCore::Type::Float32 ) );
  regionDataMembers.push_back( GTLCore::Type::StructDataMember( "opacity", GTLCore::Type::Float32 ) );
  const GTLCore::Type* type = _typesManager->d->createStructure( "color", regionDataMembers);
  
  return type;
}


void Wrapper::addFunctionFromModuleToType(const GTLCore::Type* type, GTLFragment::Library* library, const GTLCore::ScopedName& name)
{
  const std::list<GTLCore::Function*>* functions = library->data()->function(name);
  GTL_ASSERT(functions);
  foreach(GTLCore::Function* function, *functions)
  {
    GTLCore::Function* newFunction = GTLCore::Function::Private::createExternalFunction( moduleData(), llvmModule(), llvmModule()->getContext(), function );
    type->d->addFunctionMember( GTLCore::Type::StructFunctionMember(newFunction) );
  }
}
